﻿var copyToClipboard = {
    init: function (targetarea, documentElement = null) {
        /*documentElement apply for copy to clipboard in modal where appending the element inside the modal*/
        let textarea;
        let result;

        try {

            textarea = document.createElement('textarea');
            textarea.setAttribute('readonly', true);
            textarea.setAttribute('contenteditable', true);
            textarea.style.position = 'fixed'; // prevent scroll from jumping to the bottom when focus is set.
            textarea.value = $(targetarea).val();

            if (documentElement != null) {
                document.getElementById("modalOnboarding").appendChild(textarea);
            }
            else {
                document.body.appendChild(textarea);
            }

            textarea.focus();
            textarea.select();

            const range = document.createRange();
            range.selectNodeContents(textarea);

            const sel = window.getSelection();
            sel.removeAllRanges();
            sel.addRange(range);

            textarea.setSelectionRange(0, textarea.value.length);
            result = document.execCommand('copy');
        } catch (err) {
            console.error(err);
            result = null;
        } finally {
            if (documentElement != null) {
                document.getElementById("modalOnboarding").removeChild(textarea);
            }
            else {
                document.body.removeChild(textarea);
            }
        }

        /*manual copy fallback using prompt*/
        if (!result) {
            const isMac = navigator.platform.toUpperCase().indexOf('MAC') >= 0;
            const copyHotkey = isMac ? '⌘C' : 'CTRL+C';
            result = prompt(`Press ${copyHotkey}`, $(targetarea).val()); // eslint-disable-line no-alert
            if (!result) {
                return false;
            }
        }
        $.toast({
            heading: 'DONE',
            text: 'Copy to clipboard success.',
            position: 'bottom-right',
            loaderBg: 'fff',
            icon: 'info',
            hideAfter: 5000,
            stack: 6
        });
        return true;
    },
    copyToClipboardFF: function () {
        window.prompt("Copy to clipboard: Ctrl C, Enter", text);
    }
};