﻿var fxcNotification = fxcNotification || {};

$(function () {
	fxcNotification.requestPermission = function () {
		if (Notification && Notification.permission === 'default') {
			Notification.requestPermission(function (permission) {
				if (!('permission' in Notification)) {
					Notification.permission = permission;
				}
			});
		}
	};

	fxcNotification.notify = function (message, refreshPage, mid) {
		if (Notification.permission === 'granted') {
			sendNotification(message, refreshPage, mid);
			return true;
		}
		return false;
	};

	var sendNotification = function (message, refreshPage, mid) {
		refreshPage = refreshPage || false;

		var notification = new Notification('FaxCore', {
			icon: '/content/icons/android-chrome-144x144.png',
			body: message
		});

		notification.onclick = function () {
			this.close();
			if (refreshPage) {
				window.location.reload();
            }

            notification.close.bind(notification),
            fxcNotificationStorage.view(mid);
		};
		setTimeout(function () { notification.close.bind(notification); }, 5000);
	};
});