﻿var gridcustomization = gridcustomization || {};

gridcustomization.grid = {};
gridcustomization.customize = function (e) {
    gridcustomization.grid = e;
    /* switching the pager views from left to right*/
    var divpagers = $('#' + gridcustomization.grid.target.id + ' tfoot tr[data-role="pager"] th div[data-role="display"]');
    $(divpagers[0]).addClass('align-right');
    $(divpagers[1]).addClass('align-left');
    /* move pager to first child*/
    var pager = $('#' + gridcustomization.grid.target.id + ' button[role="presenter"]').parent();
    $(pager).css('margin-right', '30px');
    var pagerParent = $('#' + gridcustomization.grid.target.id + ' button[role="presenter"]').parent().parent();
    pager.detach().prependTo(pagerParent);
    /* hide refresh button*/
    $('#' + gridcustomization.grid.target.id + ' button[data-role="page-refresh"]').addClass('hide');
    var pagesizetext = $(divpagers[0]).children()[3];
    $(pagesizetext).html('Page Size');
    $(pagesizetext).detach().prependTo($(divpagers[0]).first());

    /* changing the text of left pager div*/
    $($(divpagers[1]).children()[0]).html('Showing');
    $($(divpagers[1]).children()[2]).html('to');
    $($(divpagers[1]).children()[4]).html('out of');
    $('<div> Entries</div>').appendTo($(divpagers[1]).last());
};
gridcustomization.resize = function () {
    gridcustomization.resizehandler();
    $(window).resize(gridcustomization.resizehandler);
};
gridcustomization.resizehandler = function () {
    console.log(gridcustomization.initHeight());
    $('div.fxc-grid-wrapper').css('height', gridcustomization.initHeight());
};
gridcustomization.initWidth = function () {
    return $('div.card-body div.row').width();
};
gridcustomization.initHeight = function () {
    return $('.scroll-sidebar').height() - $('#main-wrapper header nav div.navbar-collapse').height() - $('div.row.page-titles.navbar-fixed-top').height() - 75;
};

gridcustomization.clearNoRecords = function (e) {
    var item = "#" + e["0"].id + " tr[data-role='empty']";
    $(item).remove();
};

gridcustomization.init = function (id, dataSource,
                                    mapping, columns,
                                    primaryKey,
                                    selectionMethod, selectionType)
{
    var $grid;
    var bind = false;

    primaryKey = primaryKey || "Id";
    selectionMethod = selectionMethod || "checkbox";
    selectionType = selectionType || "multiple";
    if (!jQuery.isEmptyObject($(id).data())) {
        $(id).grid().destroy();
        bind = false;
    }
    $grid = $(id).grid({
        primaryKey: primaryKey,
        dataSource: dataSource,
        selectionMethod: selectionMethod,
        selectionType: selectionType,
        mapping: mapping,
        uiLibrary: 'bootstrap4',
        iconsLibrary: 'materialicons',
        responsive: true,
        columns: columns,
        defaultColumnSettings: { width: 500 },
        pager: {
            limit: 15,
            sizes: [15, 25, 50, 100, 200, 500]
        }
    });
    $grid.on('dataBound', function (e, records, totalRecords) {
        $('div' + id + ' tbody tr').addClass('clickable-row');
        $(id).on('click', '.clickable-row', function (event) {
            var elementid = $(event.target).parent().children()[1];
            var value = parseInt($(elementid).text());
            /*if (value >= 101 && value <= 106) {
            } else {*/
            if (value < 101 || value > 106) {
                $grid.setSelected(value);
            }
        });
        if (!bind) {
            gridcustomization.customize(e);
            bind = true;
        }
    });
    $(id).removeClass('table-bordered');
    $(id).addClass('table-striped');
    $grid.makeResponsive();
    gridcustomization.clearNoRecords($grid);
    $grid.reload();

    return $grid;
};
