﻿var kendogridcustomization = kendogridcustomization || {};
var obj = obj || {};
var $grid;

kendogridcustomization.init = function (id, dataSource, columns, obj) {
	$(id).attr("setScroll", false);
	if ($(id).closest("html[dir]").length > 0 && $(id).closest("html[dir]").attr("dir") === "rtl" ){
		$(id).addClass("k-" + $(id).closest("html[dir]").attr("dir"));
		$(id).attr("setScroll", true);
	}
	/*id or class of grid Eg: $("#grid") */
	var newBind = true;
	var tempGrid;
	obj = obj || {};

	var resizable = obj.resizable || false;                              /* Set Resizabe gridview  */
	var sortable = obj.sortable || true;                                /* If set to true the user can click the column header and sort the grid by the column field when sorting is enabled  */
	var scrollable = obj.scrollable || true;                            /* Set grid scrollable  */
	var pageSize = obj.pageSize || 20;                                  /* The number of data items which will be displayed in the grid.  Set default value to 15 since minimum value in general settings is 15*/
	var buttonCount = obj.buttonCount || 6;                             /* The maximum number of buttons displayed in the numeric pager */
	var selectable = obj.selectable || false;                           /* The maximum number of buttons displayed in the numeric pager */
	var onSelectionFn = obj.onSelectionFn || null;                      /* Function to be called on row selection */
	var rowAdditionalObj = obj.rowAdditionalObj || null;                /* Object to be add inside row dataItem*/
	/* Manually configured Template */
	var rowTemplate = obj.rowTemplate || "";                            /* Function to be called on row selection */
	var rowClass = obj.rowClass || "";									/* Add class to row */
	var rowSortable = obj.rowSortable || false;                         /* The template which renders rows. Be default renders a table row (<tr>) for every data source item.  */
	var totalInputType = obj.totalInputType || "";                      /* Count total row  */
	var doubleClickFn = obj.doubleClickFn || null;                      /* Initiates double click Fn */
	var allowSelectMultipleRow = obj.allowSelectMultipleRow || false;   /* Allow Select multiple row */
	var customizeCheckbox = obj.customizeCheckbox || false;             /* Initiates customize checkbox will not work with kendo selection checkbox */
	var customizeCheckboxFn = obj.customizeCheckboxFn || null;
	/* Initiates calling function from other script in customize checkbox on click. Will work only if customizecheckbox is true */
	var pageSizes = obj.pageSizes === false ? false : obj.pageSizes || [15, 25, 50, 100, 200, 500];     /*If set to true the pager will display a drop-down which allows the user to pick a page size. */
	var dataSourceOnSuccessFn = obj.dataSourceOnSuccessFn || null; /*Reads the data items from a remote service */
	var assignCheckbox = obj.assignCheckbox || false;                   /* Assign checkboxes checked by default when it loads */
	var editable = obj.editable || false; /*If set to true the user would be able to edit the data to which the grid is bound. By default editing is disabled. ; */
	var remove = obj.remove || false; /*Fired when the user clicks the "destroy" command button and delete operation is confirmed in the confirmation window, if the cancel button in the window is clicked the event will not be fired.*/
	var toolbar = obj.toolbar || null;

	var edit = obj.edit || null;
	var saveChanges = obj.saveChanges || null;
	var save = obj.save || null;

	var display = $globalMessages.grid.display1;
	var empty = $globalMessages.grid.empty1;
	var noRecords = $globalMessages.grid.empty1;
	var itemsPerPage = $globalMessages.grid.itemsPerPage;

	var defaultPageableSetting = {
		pageSize: pageSize,
		alwaysVisible: true,
		pageSizes: pageSizes,
		numeric: true,
		refresh: false,
		buttonCount: buttonCount,
		messages: {
			/*tooltip*/
			first: $globalMessages.grid.firstPage,
			last: $globalMessages.grid.lastPage,
			next: $globalMessages.grid.nextPage,
			previous: $globalMessages.grid.prevPage,
			refresh: $globalMessages.grid.refreshPage,
			morePages: $globalMessages.grid.morePages,
			display: display,
			empty: empty,
			noRecords: noRecords,
			itemsPerPage: itemsPerPage
		}
	};
	var disablePageable = obj.disablePageable || false;
	var pageable = disablePageable ? false : defaultPageableSetting;
    /*If set to true there will be a fixedGridHeight implement to the grid. 
        Default height is always to the bottom screen
        Add class "k-grid-fixed" to fixed grid height height add data-height to set height or else set 250px 
        Add class "k-grid-small" to reduce the grid height or  
        Add class "k-grid-large" to increase the grid height
        Add class "scrollbar-div" to respective sibling div for dislay scrollbar with same height */
	var fixedGridHeight = (obj.fixedGridHeight === null || obj.fixedGridHeight === undefined) ? true : obj.fixedGridHeight ;
	var pdfSettings = obj.pdfSettings || {};
    var excelSettings = obj.excelSettings || {};
    var excelExport = obj.excelExport || null;
	
	var onDataBoundExtraFn = obj.onDataBoundExtraFn || null;

	if (dataSource && dataSource.transport && dataSource.transport.read) {
		dataSource.transport.read.complete = function (jqXHR, textStatus) {
			if (textStatus === 'parsererror' || jqXHR.status === 401) {
				window.location = '/login';
			}
			if (jqXHR.readyState === 4 && jqXHR.responseJSON && jqXHR.responseJSON.TypeName && jqXHR.responseJSON.TypeName === "ServerError") {
                swal($globalMessages.swal.error.title, jqXHR.responseJSON.Value, "error");
            }
		};
	}

	if ($(id).length) {
		if (totalInputType.length > 0) {
			$(totalInputType).attr("data-grid", id[0].id);
		}
		if ($(id).length > 0 && $(id)[0].childNodes.length > 0) {
			$(id).attr("setScroll", true);
			$(id).attr("scrollLeft", $(id).find(".k-grid-content").scrollLeft());
			dataSource.pageSize = $(id).data("kendoGrid").dataSource.pageSize();

			var newDs = new kendo.data.DataSource(dataSource);
			/*kendogridcustomization.destroy($(id));  To destroy grid on re-initialization as pagination may not work accordingly*/

			if (dataSourceOnSuccessFn !== null) {
				newDs.fetch(function () {
					/* refer to inboundrouting.js */
					var resetGrid = $(id).data("kendoGrid");
					resetGrid.setDataSource(this);
					dataSourceOnSuccessFn.call(this);
					$(id).data("kendoGrid").dataSource.read();
				});
			}
			else {
				var resetGrid = $(id).data("kendoGrid");
				resetGrid.setDataSource(newDs);
				$(id).data("kendoGrid").dataSource.read();
			}
		}
		else {
			pageSize = parseInt($("#defaultPageSize").val()) > 0 ? parseInt($("#defaultPageSize").val()) : pageSize; /*Page size are based on id in user/shared/layout --> ConfigDictionary.UsrDefaultGridPageSize*/

			if (!disablePageable) {
				pageable.pageSize = pageSize;
				dataSource.pageSize = pageSize;
            }

			if ($(id).hasClass("k-grid-short-width")) {
				buttonCount = 1;
				display = $globalMessages.grid.display2;
				empty = $globalMessages.grid.empty2;
				noRecords = $globalMessages.grid.empty2;
				itemsPerPage = "";
			}

			var newDataSource = dataSource;
			if (dataSourceOnSuccessFn !== null) {
				newDataSource = new kendo.data.DataSource(dataSource);
				newDataSource.fetch(function () {
					dataSourceOnSuccessFn.call(this);
				});
			}
			/*For DataSource please fully use transport method*/
			$grid = $(id).kendoGrid({
				autoBind: false,
				pdf: pdfSettings,
                excel: excelSettings,
                excelExport: excelExport,
				dataSource: newDataSource,
				editable: editable,
				remove: remove,
				toolbar: toolbar,
				columns: columns,
				columnResizeHandleWidth: 10,
				resizable: resizable,
				sortable: sortable,
				scrollable: scrollable,
				noRecords: {
					template: $globalMessages.grid.noRecords
				},
				pageable: pageable,
				selectable: selectable,
				rowTemplate: rowTemplate,
				save: save,
				edit: edit,
				saveChanges: saveChanges,
				/*change: kendogridcustomization.selectChange,*/
				dataBound: function (e) {
					var grid = this;
					if (doubleClickFn !== null) {
						grid.tbody.find("tr td:not(.checkboxSelection)").dblclick(function (e) {
							var dataItem = grid.dataItem($(this).parent());
							if (rowAdditionalObj !== null) {
								dataItem.rowAdditionalObj = rowAdditionalObj;
							}
							doubleClickFn.call(this, dataItem);
						});
					}
					if (onSelectionFn !== null) {
						grid.tbody.find("tr td:not(.checkboxSelection)").click(function (e) {
							var dataItem = grid.dataItem($(this).parent());
							if (rowAdditionalObj !== null) {
								dataItem.rowAdditionalObj = rowAdditionalObj;
							}
							onSelectionFn.call(this, dataItem);
						});
					}
					if (customizeCheckbox) {
						/*for customize checkbox selection*/
						kendogridcustomization.customizeCheckbox(grid, customizeCheckboxFn);
					}

					if (assignCheckbox) {

						grid = this;
						var rows = grid.items();

						$(rows).each(function (e) {
							var row = this;
							var dataItem = grid.dataItem(row);

							console.log('grid databound');
							console.log(dataItem);
							if (JSON.parse(dataItem.IsBLSubscriber)) {
								grid.select(row);
							}

						});
                    }
					if (onDataBoundExtraFn !== null) onDataBoundExtraFn.call(this, e);
					if (grid.element.attr("setScroll") === "true") {
						kendogridcustomization.customizeGridHeight(grid.element);
						var getScrollLeft = grid.element.attr("scrollLeft");
						var setScroll = grid.tbody.outerWidth() - grid.element.find(".k-grid-content").outerWidth();
						setScroll = getScrollLeft != null ? getScrollLeft : setScroll;
						grid.element.find(".k-grid-content").scrollLeft(setScroll);
						grid.element.attr("setScroll", false);
					}

					if (rowClass != "") {
						grid.element.find("tr").addClass(rowClass);
                    }
				},

				dataBinding: function (e) {
					if (totalInputType.length > 0) {
						kendogridcustomization.refreshTotalCount($(id), totalInputType);
					}
				}
			});
			setTimeout(function () {
				kendogridcustomization.customizeGridHeight($(id));
				$(id).data("kendoGrid").dataSource.read();

			}, 100);
		}

		/*Manually reset Setting*/
		if (allowSelectMultipleRow) {
			kendogridcustomization.selectMultipleRow(id);
		}

		if (rowSortable) {
			/*for sortable cant drag & scroll*/
			kendogridcustomization.sortable(id, $(id));
		}

		/*Manually reset Setting*/

		/*Reset Guid*/
		var checkboxes = $(id).find("table> thead th.k-header input[type='checkbox'].k-checkbox");

		checkboxes.each(function (i) {
			var prevId = $(this).attr('id');
			var newGuid = createGuid();
			$(this).attr('id', newGuid);
			$(this).parent().find('label[for=' + prevId + ']').attr('for', newGuid);
		});

		return $grid;
	}
};

kendogridcustomization.guid = function () {
	return createGuid();
};

createGuid = function () {
	function _p8(s) {
		var p = (Math.random().toString(16) + "000000000").substr(2, 8);
		return s ? "-" + p.substr(0, 4) + "-" + p.substr(4, 4) : p;
	}
	return _p8() + _p8(true) + _p8(true) + _p8();
};

kendogridcustomization.selectMultipleRow = function (event) {

    /*$("#" + event[0].id + " tbody").on("click", "tr", function (e) {

        var grid = $("#" + event[0].id).getKendoGrid();
        var rowElement = this;
        var row = $(rowElement);
        var getParentNode = e.target.parentNode;
        var getClosestTd = e.target.closest("td");
        if (!$(getClosestTd).hasClass("disabledClickableRow")) /*Any td class has disabledClickableRow will not trigger select row
        {
            if (row.hasClass("k-state-selected")) {
                var selected = grid.select();

                selected = $.grep(selected, function (x) {
                    var itemToRemove = grid.dataItem(row);
                    var currentItem = grid.dataItem(x);

                    return itemToRemove != currentItem
                })

                grid.clearSelection(); /* Clear all selection 

                grid.select(selected); /*Reselect the row

            } else {
                grid.select(row);
            }
            e.preventDefault(); /* If this method is called, the default action of the event will not be triggered.
        }

        e.stopPropagation(); /*  It prevents the event from propagating (or “bubbling up”) the DOM. Stops callback execution and returns immediately when called. 

    }); */

	/*Re initialize guid for select all button as redundant guid may occur for multiple table in a view*/


};

kendogridcustomization.doubleClick = function (event, postSelectFn) {
	var grid = $("#" + event[0].id).getKendoGrid();
	$("#" + event[0].id + " tbody").on("dblclick", "tr", function (e) {
		if (postSelectFn !== null && requiredUserSelection) {
			postSelectFn.call(this, id);
		}
	});
};

kendogridcustomization.sortable = function (id, event) {
	$(id).addClass("rowSortable");
	var grid = event.data("kendoGrid");
	grid.table.kendoSortable({
		filter: "> tbody > tr",
		hint: function (element) { /*customize the hint*/
			var table = $('<table style="width: 600px;" class="k-grid k-widget"></table>'),
				hint;

			table.append(element.clone()); /*append the dragged element*/
			table.css("opacity", 0.7);

			return table; /*return the hint element*/
		},
		placeholder: function (element) {
			return $('<tr colspan="4" class="placeholder"></tr>');
		},
		change: function (e) {
			var skip = grid.dataSource.skip(),
				oldIndex = e.oldIndex + skip,
				newIndex = e.newIndex + skip,
				data = grid.dataSource.data(),
				dataItem = grid.dataSource.getByUid(e.item.data("uid"));

			if (dataItem !== null) {
				grid.dataSource.remove(dataItem);
				grid.dataSource.insert(newIndex, dataItem);
			}

		}
	});
};

kendogridcustomization.refreshTotalCount = function (event, totalInputType) {

	if ($(totalInputType).attr("data-grid") == event[0].id) {
		var grid = event.data("kendoGrid");
		var dataSource = grid.dataSource;
		$(totalInputType).val(dataSource.total());
		$(totalInputType).text(dataSource.total());

		try {
			if ($(totalInputType).val() > 0)
				$(totalInputType).valid();
		}
		catch (ex) {
			/* */
		}
	}

};

kendogridcustomization.selectChange = function (e) {
	var selectedDataItems = [];

	var selectedRows = this.select();

	for (var i = 0; i < selectedRows.length; i++) {
		var dataItem = this.dataItem(selectedRows[i]);
		selectedDataItems.push(dataItem);
	}
};

kendogridcustomization.customizeCheckbox = function (event, customizeCheckboxFn) {
	event.tbody.find("div.custom-checkbox input:checkbox").change(function (e) {        /*Customize template*/
        /*  template: '<div class="custom-checkbox"><input class="k-checkbox-custom rrs" #= IsRssOn == "True" ? \'checked="checked"\' : "" # data-role="checkbox" data-id="#= ContactId #" id="send-#= ContactId #" type="checkbox"> '
                                        + '     <label for="send-#= ContactId #" class="k-checkbox-custom-label k-no-text"></label></div>',*/
		var grid = event;
		var col = $(this).closest('td');
		var dataItem = grid.dataItem($(this).closest('tr'));
		dataItem[grid.columns[col.index()].field] = this.checked;

		/*nitiates calling function from other script*/
		if (customizeCheckboxFn != null) {
			customizeCheckboxFn.call(e, dataItem, $(this));
		}
	});
};

kendogridcustomization.customizeGridHeight = function (id, overrideHeight) {
/* changed from id to $(id). will prompt an error sometimes. */
	if ($(id).length == 0 || !$(id).is(":visible"))
	{
		return false;
	}

	overrideHeight = overrideHeight || false;
	var windowHeight = $(window).outerHeight();
	var windowWidth = $(window).width();
	var recalculateHeight = false;
	var getGridPosition = $(id).offset().top;
	var getGridHeaderHeight = $(id).children(".k-grid-header").length ? $(id).children(".k-grid-header").outerHeight() : 0;
	getGridHeaderHeight = getGridHeaderHeight > 49 ? getGridHeaderHeight: 49;
	var getGridPagerHeight = $(id).children(".k-grid-pager").length ?$(id).children(".k-grid-pager").outerHeight(): 0;
	var getGridToolBar = $(id).children(".k-grid-toolbar").length ? $(id).children(".k-grid-toolbar").outerHeight() : 0;

	/*Set Fixed Pager Height when window width is less than 1024*/
	getGridPagerHeight = windowWidth > 1024 ? getGridPagerHeight : 58;

	/**
	 * Calculate Bottom Height
	 */
	var rowHeight = windowHeight - getGridToolBar - getGridPosition - getGridHeaderHeight - getGridPagerHeight;
	if ($(id).closest(".modal").is(":visible") && (!$(id).children(".k-grid-content").parent(".k-grid").hasClass("k-grid-fixed") || !$(id).children(".k-grid-content").parent(".k-grid").hasClass("k-grid-fixed") ))
	{
		var getModalParent = $(id);
		var getModalBottomHeight = 0;
		while (getModalParent.length && getModalParent.is(":visible")) {

			if (getModalParent.next().length && getModalParent.next().is(":visible")) {
				getModalBottomHeight = getModalParent.next().outerHeight();
				break; /* breaks out of loop completely */
			}

			getModalParent = getModalParent.parent();
			if (getModalParent.hasClass("modal")) {
				break;
			}

		}
		var getmodalPosition = $(id).closest(".modal").find(".modal-content").offset().top;
		rowHeight = (windowHeight * 80 / 100) - getGridToolBar + getmodalPosition - getGridPosition - getGridHeaderHeight - getGridPagerHeight - 2 - getModalBottomHeight;

		rowHeight = rowHeight > 250 ? rowHeight : 250;
	}
	else if ($(id).children(".k-grid-content").parent(".k-grid").hasClass("k-grid-fixed")) {
		var getHeight = $(id).children(".k-grid-content").parent(".k-grid").attr("data-height");
		getHeight = getHeight == undefined ? 250 : getHeight;
		rowHeight = getHeight;
	}
	else if ($(id).children(".k-grid-content").parent(".k-grid").hasClass("k-grid-small")) {
		rowHeight = (rowHeight - $(id).offset().top - 200) / 2;
	}
	else {
		var getBottomHeight = 0;
		var parent = $(id);
		while (parent.length && parent.is(":visible") && parent.not(".page-wrapper").length) {
			if (parent.next().length && parent.next().is(":visible") && !parent.next().hasClass("slimScrollBar")) {
				getBottomHeight += parent.next().outerHeight() + 10;
				break; /* breaks out of loop completely */
			}
			if (parent.parent().hasClass("slimScrollDiv"))
			{
				getBottomHeight += 10;
				break;
			}
			parent = parent.parent();
			
			if (parent.prop("tagName") == "SECTION" || parent.prop("tagName") == "FORM") {
				parent = parent.parent();
				continue; /* breaks out of loop completely */
			}
		}
		if ($(id).closest(".tab-pane").length > 0)
		{
			getBottomHeight += 30;
		}
		rowHeight = windowHeight - getGridToolBar - getGridPosition - getGridHeaderHeight - getGridPagerHeight - getBottomHeight - 5;
		
		rowHeight = rowHeight > 200 ? rowHeight : 200;
	}
	$(id).children(".k-grid-content").css("max-height", rowHeight);
	$(id).children(".k-grid-content").css("height", rowHeight);
	setTimeout(function () {
		if ($(id).closest(".row").find(".scrollbar-div").is(':visible') || $(id).parents(".row:eq(1)").find(".scrollbar-div").is(':visible')) {

			var getScrollBar = $(id).closest(".row").find(".scrollbar-div").length > 0 ? $(id).closest(".row").find(".scrollbar-div") : $(id).parents(".row:eq(1)").find(".scrollbar-div");

			if (getScrollBar.length > 0 && $(id).is(':visible')) {
				var getGridTop = $(id).offset().top;

				var getSideTop = getScrollBar.offset().top;

				var differentHeight = getSideTop - getGridTop;

				var getGridHeight = $(id).outerHeight() - differentHeight;
				var scrollBarHeight = getGridHeight + "px";
				var maxScrollBarHeight = Math.floor(getGridHeight) + "px";
				getScrollBar.css("height", maxScrollBarHeight);
				if (!getScrollBar.prop("style")["max-height"]) {

					getScrollBar.css("max-height", maxScrollBarHeight);
					getScrollBar.slimScroll({
						height: scrollBarHeight 
					});
				}
				else {

					getScrollBar.css("max-height", maxScrollBarHeight);
					$(id).closest(".row").find(".scrollbar-div").css("height", scrollBarHeight);
					$(id).closest(".row").find(".scrollbar-div").closest(".slimScrollDiv").css("height", scrollBarHeight);
				}

			}
		}
		/*custom.setModal();*/
	}, 50);
};

kendogridcustomization.destroy = function (event) {
	/*event --> $("#grid")*/
	event.kendoGrid({ /* configuration */ }); /* create a Grid widget */

	event.data("kendoGrid").destroy(); /* destroy the Grid */

	event.empty(); /* empty the Grid content (inner HTML) */

	event.removeClass("k-grid k-widget k-display-block");
};

/* How to used */

/* initiate grid -->  $.messages.initgrid($('#grid'), data);  where grid is the div id */
/* for single selection : initialize obj.selectable = true; and pass obj to here */
/*(function ($) {
    var $grid;
    $.messages = {
        initgrid: function (e, data) {
            var id = e;
            var columns = [
                    { field: "checkboxSelection", selectable: true, width: 64, sortable: false },
                    { field: "id", title: "ID" },
                    { field: "name", title: "Name", hidden: false },
                    {
                        field: "age", values: [
                            { text: "Beverages", value: "30" },
                            { text: "Food", value: "33" }
                        ]
                    },
                    { field: "age", title: "Age" },
                    {
                        field: "status",
                        title: "Status",
                        width: 320,
                        template: function (dataRow) {
                            var icon = '<i class="mdi mdi-check"></i>';
                            var status = "Completed";
                            var statusClass = "complete"
                            var printableClass = 'kendo-btn-circle-hidden';
                            var saveClass = 'kendo-btn-circle-hidden';
                            var notifyClass = 'kendo-btn-circle-hidden';
                            var forwardClass = 'kendo-btn-circle-hidden';
                            switch (dataRow.status) {
                                case "failed":
                                    icon = '<i class="mdi mdi-window-close"></i>';
                                    status = "Failed";
                                    statusClass = "fail";
                                    break;
                                default:
                            }

                            if (dataRow.printable) {
                                printableClass = "";
                            }

                            if (dataRow.save) {
                                saveClass = "";
                            }

                            if (dataRow.notify) {
                                notifyClass = "";
                            }

                            if (dataRow.forward) {
                                forwardClass = "";
                            }

                            var result = '<div status="kendo-container"><span class="badge kendo-span-status badge-pill badge-' + statusClass + '">' + icon + status + '</span> ' +
                                        '<span title="Printed" class="btn btn-secondary btn-printable btn-circle kendo-btn-status kendo-btn-circle ' + printableClass + '"><i class="mdi mdi-printer"></i></span> ' +
                                        '<span title="Saved" class="btn btn-secondary btn-save btn-circle kendo-btn-status kendo-btn-circle ' + saveClass + '"><i class="mdi mdi-content-save"></i></span> ' +
                                        '<span title="Notified" class="btn btn-secondary btn-notify btn-circle kendo-btn-status kendo-btn-circle ' + notifyClass + '"><i class="mdi mdi-bell"></i></span> ' +
                                        '<span title="Forwarded" class="btn btn-secondary btn-forwarded btn-circle kendo-btn-status kendo-btn-circle ' + forwardClass + '"><i class="mdi mdi-arrow-right-bold"></i></span> </div>';
                            return result;
                        }
                    }
            ];
            var dataSource = [
                  { id: "1", name: "Jane Doe1", age: "30", status: "failed", printable: true, save: true, notify: true, forward: true },
                  { id: "2", name: "John Doe2", age: "30", status: "completed", printable: false, save: false, notify: false, forward: true },
                  { id: "3", name: "Jane Doe3", age: "30", status: "completed", printable: true, save: true, notify: false, forward: true },
                  { id: "4", name: "John Doe4", age: "30", status: "completed", printable: true, save: true, notify: true, forward: true },
                  { id: "5", name: "Jane Doe5", age: "30", status: "failed", printable: true, save: false, notify: false, forward: true },
                  { id: "6", name: "John Doe6", age: "30", status: "failed", printable: false, save: true, notify: false, forward: true },
                  { id: "7", name: "Jane Doe7", age: "30", status: "completed", printable: true, save: true, notify: false, forward: false },
                  { id: "8", name: "John Doe8", age: "30", status: "failed", printable: true, save: true, notify: false, forward: true },
                  { id: "9", name: "Jane Doe9", age: "30", status: "failed", printable: true, save: false, notify: false, forward: false },
                  { id: "10", name: "John Doe10", age: "30", status: "failed", printable: true, save: true, notify: false, forward: true },
                  { id: "12", name: "Jane Doe11", age: "30", status: "failed", printable: true, save: true, notify: false, forward: true },
                  { id: "12", name: "John Doe12", age: "30", status: "failed", printable: true, save: true, notify: false, forward: true },
                  { id: "13", name: "Jane Doe13", age: "30", status: "failed", printable: true, save: true, notify: false, forward: true },
                  { id: "14", name: "John Doe14", age: "30", status: "completed", printable: true, save: true, notify: false, forward: true },
                  { id: "15", name: "Jane Doe15", age: "30", status: "completed", printable: true, save: true, notify: false, forward: true },
                  { id: "16", name: "John Doe16", age: "30", status: "failed", printable: true, save: true, notify: false, forward: true },
                  { id: "17", name: "Jane Doe17", age: "30", status: "failed", printable: true, save: true, notify: false, forward: true },
                  { id: "18", name: "John Doe18", age: "30", status: "failed", printable: true, save: true, notify: false, forward: true },
                  { id: "19", name: "Jane Doe19", age: "30", status: "failed", printable: true, save: true, notify: false, forward: true },
                  { id: "20", name: "John Doe20", age: "30", status: "completed", printable: true, save: true, notify: false, forward: true },
                  { id: "21", name: "Jane Doe21", age: "30", status: "failed", printable: true, save: true, notify: false, forward: true },
                  { id: "22", name: "John Doe22", age: "30", status: "completed", printable: true, save: true, notify: false, forward: true },
                  { id: "23", name: "Jane Doe23", age: "30", status: "completed", printable: true, save: true, notify: false, forward: true },
                  { id: "24", name: "John Doe24", age: "30", status: "completed", printable: true, save: true, notify: false, forward: true },
                  { id: "25", name: "Jane Doe25", age: "30", status: "completed", printable: true, save: true, notify: false, forward: true },
                  { id: "26", name: "John Doe26", age: "30", status: "failed", printable: true, save: true, notify: false, forward: true },
                  { id: "27", name: "Jane Doe27", age: "30", status: "completed", printable: true, save: true, notify: false, forward: true },
                  { id: "28", name: "John Doe28", age: "30", status: "completed", printable: true, save: true, notify: false, forward: true },
                  { id: "29", name: "Jane Doe29", age: "30", status: "completed", printable: true, save: true, notify: false, forward: true },
                  { id: "30", name: "John Doe30", age: "30", status: "failed", printable: true, save: true, notify: false, forward: true },
                  { id: "31", name: "Jane Doe31", age: "30", status: "completed", printable: true, save: true, notify: false, forward: true },
                  { id: "32", name: "John Doe32", age: "30", status: "completed", printable: true, save: true, notify: false, forward: true },
                  { id: "33", name: "Jane Doe33", age: "30", status: "failed", printable: true, save: true, notify: false, forward: true },
                  { id: "34", name: "John Doe34", age: "30", status: "completed", printable: true, save: true, notify: false, forward: true },
                  { id: "35", name: "Jane Doe35", age: "30", status: "completed", printable: true, save: true, notify: false, forward: true },
                  { id: "36", name: "John Doe36", age: "30", status: "completed", printable: true, save: true, notify: false, forward: true },
                  { id: "37", name: "Jane Doe37", age: "30", status: "completed", printable: true, save: true, notify: false, forward: true },
            ];

            var obj = {};
            obj.selectable = true;

            $grid = kendogridcustomization.init(id, dataSource,
                                                        columns);

        },
    };
})(window.jQuery); */
