﻿var customErrorPlacement = function (error, element) {
    var p = element.parent('div').parent();
    if (p.hasClass('form-group')) {
        error.appendTo(p);
    } else {
        error.insertAfter(element);
    }
};

var validation = function () {
    $("#formBarcode").validate({
        rules: {
            BarcodeData: {
                required: true
            },
            BarcodeSizeOther: {
                required: true,
                number: true,
                min: 2,
                max: 100
            },
        },
        errorPlacement: customErrorPlacement,
        submitHandler: function (form) {
            $.editor.createBarcode();
        }
    });
}
$.editor = {

    init: function (e) {
        $('#BarcodeSizeOther').mask('999');

        /*Btn Action*/
        $.editor.insertBarcodeButtonClickHandler($(".btn-insert-barcode"));
        $.editor.insertTokenButtonClickHandler($(".btn-insert-token"));
        $.editor.tokenGroupsOnChangeHandler($("#TokenGroups"));
        $.editor.barcodeSizeOnChangeHandler($("#BarcodeSize"));
        $.editor.initForm();

        validation();
    },
    /*Default kendo editor*/
	initKendoEditor: function (kendoEditorID) {
		if ($(kendoEditorID).closest("html[dir]").length) {
			$(kendoEditorID).closest(".row").addClass("k-" + $(kendoEditorID).closest("html[dir]").attr("dir"));
		}
        $(kendoEditorID).kendoEditor({
            tools: [
            {
                name: "barcode",
                tooltip: "Generate Barcode",
                exec: function (e) {
                    $.editor.barcodeButtonHandler(kendoEditorID);
                }
            },
            {
                name: "token",
                tooltip: "Generate Token",
                exec: function (e) {
                    $.editor.tokenButtonHandler(kendoEditorID);
                }
            },
                "separator",
                "bold",
                "italic",
                "underline",
                "strikethrough",
                "separator",
                "formatting",
                "fontSize",
                "separator",
                "justifyLeft",
                "justifyCenter",
                "justifyRight",
                "justifyFull",
                "justifyNone",
                "separator",
                "indent",
                "outdent",
                "separator",
                "cleanFormatting",
                "separator",
                "tableWizard",
                "createTable",
                "addColumnLeft",
                "addColumnRight",
                "addRowAbove",
                "addRowBelow",
                "deleteRow",
                "deleteColumn",
                "separator",
                "insertOrderedList",
                "insertUnorderedList",
                "separator",
                "viewHtml",
                "print",
                "pdf",
                "createLink",
                "insertImage"
            ]
        });
    },
    initForm: function (e) {
        fxcRequest.get('/Common/GetKendoEditor',
            null,
            function (data) {
                $("#BarcodeSize").html('');
                $("#BarcodeSize").append(data.DdlBarcodeSize);

                /*TokenGroups, Token*/
                $("#TokenGroups").html('');
                $("#TokenGroups").append(data.DdlTokenGroups);

                $("#Token").html('');
                $("#Token").append(data.DdlToken);
            },
            function (error) {
                console.log(error);
            }, false);
    },

    /*Btn Action*/
    barcodeButtonHandler: function (kendoEditorID) {
        $('#barcode-modal').modal('show');
        $("#formBarcode").trigger("reset");
		$("#formBarcode").validate().resetForm();
		$("#BarcodeSize").change();
        $("#BarcodeEditorID").val(kendoEditorID);
    },
    barcodeSizeOnChangeHandler: function (e) {
        $(e).on('change', function (e) {
            if (this.value == 0)
            {
                $('div#BarcodeSizeOtherPanel').removeClass("hide");
            }
            else {
                $('div#BarcodeSizeOtherPanel').addClass("hide");
            }
        });
    },
    insertBarcodeButtonClickHandler: function (e) {
        $(e).on('click', function () {
            $("#formBarcode").submit();
        });
    },
    tokenButtonHandler: function (kendoEditorID) {
        $('#token-modal').modal('show');
        $("#formToken").trigger("reset");
        $("#formToken").validate().resetForm();
        $("#TokenEditorID").val(kendoEditorID);
    },
    insertTokenButtonClickHandler: function (e) {
        $(e).on('click', function () {
            var token = "$$" + $("#Token").val() + "$$";
            var kendoEditorID = $("#TokenEditorID").val();
            $.editor.pasteEditorContent(token, kendoEditorID);

            $('#token-modal').modal('hide');
        });
    },
    tokenGroupsOnChangeHandler: function (e) {
        $(e).on('change', function (e) {
            var getValue = this.value;
            $.editor.tokenGroupChange(getValue);
        });
    },

    /*Logic*/
    pasteEditorContent: function (e, kendoEditorID) {
        var editor = $(kendoEditorID).data("kendoEditor");
        editor.exec("inserthtml", { value: e });
    },

    /*Post or Get Function*/
    createBarcode: function (e) {
        var bd = $('#BarcodeData').val();
        var bs = $('#BarcodeSize').val();
        var kendoEditorID = $("#BarcodeEditorID").val();
        if ($('#BarcodeSize').val() == '0') {
            bs = $('#BarcodeSizeOther').val();
        }

        fxcRequest.get('/Common/GenerateBarcodeBase64',
            {
                "bd": bd,
                "bs": bs,
            },
            function (data) {
                var img = '<img alt="bootstraps.png"  src="data:image/png;base64, ' + data.Base64String + '" />';
                $.editor.pasteEditorContent(img, kendoEditorID);
            },
            function (error) {
                console.log(error);
            });
        $('#barcode-modal').modal('hide');
    },
    tokenGroupChange: function (e) {
        fxcRequest.get('/Common/GetKendoEditorToken',
            {
                "SelectedTokenGroupId": e,
            },
            function (data) {
                $("#Token").html('');
                $("#Token").append(data.DdlToken);
            },
            function (error) {
                console.log(error);
            }, false);
    }
}