﻿var listbox = listbox || {};
var obj = obj || {};
var tempRow = null;
var tempEntityGrid = null;

listbox.init = function (listBoxID, dataSource, obj) {
	/*listBoxID --> "#ListBoxA" or "#Anything" only*/
	var $listbox;
	obj = obj || {};

	/* Configuration */
	var autoBind = obj.autoBind || true; /*If set to false, the widget will not bind to the data source during initialization.*/

	/*Draggable Setting*/
	var draggable = obj.draggable == null ? true : obj.draggable || false; /* Indicates whether the ListBox items can be dragged and dropped. */
	var draggableHint = obj.draggableHint || null; /*Provides an option to customize the draggable item hint --> Function |String |jQuery)*/
	var draggablePlaceholder = obj.draggablePlaceholder || null; /*Provides an option to customize the item placeholder of the ListBox --> Function |String |jQuery*/

	var getDraggable = draggable ? {
		enabled: draggable,
		hint: draggableHint
	} : false;
	/*Draggable Setting End*/

	var dataTextField = obj.dataTextField || ""; /*The Display Text field of the data item that provides the text content of the list items.*/
	var dataValueField = obj.dataValueField || ""; /*The ID field of the data item that provides the text content of the list items.*/

	var doubleClickFn = obj.doubleClickFn || null;

	/*Toolbar Setting*/
	var toolbarTools = obj.toolbarTools || ["transferTo", "transferFrom", "transferAllTo", "transferAllFrom"];
    /*
        A collection of tools that are used to interact with the ListBox.
        The built-in tools are:
            "moveUp" - Moves up the selected ListBox items.
            "moveDown" - Moves down the selected ListBox items.
            "remove" - Removes the selected ListBox items.
            "transferTo" - Moves the selected items from the current ListBox to the target that is defined in the connectWith option.
            "transferFrom" - Moves the selected items from the ListBox that is defined in the connectWith option to the current ListBox.
            "transferAllTo" - Moves all items from the current ListBox to the target that is defined in the connectWith option.
            "transferAllFrom" - Moves all items from the ListBox that is defined in the connectWith option to the current ListBox.
    */
	var toolbarPosition = obj.toolbarPosition || "right";
    /* The relative position of the ListBox element at which the toolbar will be displayed. 
     The possible values are "left", "right", "top", and "bottom".
    */

	/*Toolbar Setting End*/

	var navigatable = obj.navigatable || false; /*Indicates whether the keyboard navigation is enabled or disabled.*/
	var selectable = obj.selectable || "multiple"; /*Indicates whether the selection is single or multiple*/
    /*
        "single" - A single-item selection.
        "multiple" - A multiple-item selection.
    */

	var dropSources = obj.dropSources || null; /*Array of id strings which determines the ListBoxes that can drag and drop their items to the current ListBox*/
	var connectWith = obj.connectWith || null; /* The id of the target ListBox to which items from the source ListBox will be transferred and vice versa */

	var template = obj.template || ""; /*Specifies the item template of the ListBox.*/

	/* End Configuration */

	/*Event Configuration*/
	var onAdd = obj.onAdd || function (e) {/* handle event on Add*/ };
	var onChange = obj.onChange || function (e) {/* handle event on Change*/ };
	var onDataBound = obj.onDataBound || function (e) {/* handle event on DataBound*/ };
	var onDrop = obj.onDrop || function (e) {/* handle event on drop*/ };
	var onReorder = obj.onReorder || function (e) {/* handle event on reorder*/ };
	var onDragend = obj.onDragend || function (e) {/* handle event on drag end*/ };
	var onRemove = obj.onRemove || function (e) {/* handle event on Remove*/ };
	/*End Event Configuration*/

	var staticListBox = obj.staticListBox || false;
	
	if ($("#" + listBoxID).length) {
		
		var attr = $("#" + listBoxID).attr("data-role");
		if ($("#" + listBoxID).length > 0 && typeof attr !== typeof undefined && attr !== false) {

			if (!staticListBox) {
				$listbox = $("#" + listBoxID).data("kendoListBox");

				$listbox.setDataSource(dataSource);
			}
		}
		else {
			$listbox = $("#" + listBoxID).kendoListBox({
				add: onAdd,
				autoBind: autoBind,
				connectWith: connectWith,
				dataSource: dataSource,
				change: onChange,
				dataBound: onDataBound,
				dataTextField: dataTextField,
				dataValueField: dataValueField,
				dropSources: dropSources,
				draggable: getDraggable,
				drop: onDrop,
				dragend: onDragend,
				remove: onRemove,
				reorder: onReorder,
				messages: {
					tools: {
						moveUp: "MoveUp",
						moveDown: "MoveDown",
						remove: "Remove",
						transferTo: "TransferTo",
						transferFrom: "TransferFrom",
						transferAllTo: "TransferAllTo",
						transferAllFrom: "TransferAllFrom"
					}
				},
				selectable: selectable,
				template: template,
				toolbar: {
					position: toolbarPosition,
					tools: toolbarTools
				}
			});

			$("#" + listBoxID).siblings(".k-selectable").on("dblclick", "li.k-item", function (e) {
				if (doubleClickFn !== null) {
					var listboxId = $(this).closest(".k-selectable").siblings("select").attr("id");
					var listbox = $("#" + listboxId).data("kendoListBox");
					var dataItem = listbox.dataItem(this);
					doubleClickFn.call(this, listboxId, dataItem);
				}
			});

			listbox.customizeHeight($("#" + listBoxID).parent(".k-listbox"), true);
		}
	}
};

listbox.mutual = function (listBoxID, dataSourceSelection, objUserSelection, dataSourceSelected) {
	if($("#" + listBoxID).closest("html[dir]").length){
		$("#" + listBoxID).closest(".row").addClass("k-"+ $("#" + listBoxID).closest("html[dir]").attr("dir"));
	}

	var $listBoxSelection, $listBoxSelected = null;
	var listBoxIDConnectWith = objUserSelection.connectWith;
	var listBoxIDCustomCounter = objUserSelection.customCounter || "";
	var staticSelectedListBox = objUserSelection.staticSelectedListBox || false;

	var draggable = objUserSelection.draggable == null ? true : obj.draggable || false;

	$("#" + listBoxID).attr("data-ConnectWith", listBoxIDConnectWith);
	$("#" + listBoxID).attr("data-CustomCounter", listBoxIDCustomCounter);
	$("#" + listBoxIDConnectWith).attr("data-ConnectWith", listBoxID);
	var onAdd = function onAdd(e) {
		var tempListBoxID = e.sender.element.attr("id");
		/*console.log(tempListBoxID + ": Add");*/
		var checkCounter = $($("#" + tempListBoxID).attr("data-CustomCounter"));
		var checkCounterVal = checkCounter.text();
		var NewcheckCounterVal = parseInt(checkCounterVal) + e.dataItems.length;
		checkCounter.text(NewcheckCounterVal);
		listbox.mutation(tempListBoxID);

		$("#" + tempListBoxID).siblings(".k-listbox-toolbar").find("a[data-command='transferAllTo']").addClass("k-state-disabled");
	};

	var onChangeSelection = function onChangeSelection(e) {
		var tempListBoxID = e.sender.element.attr("id");
		/*console.log(tempListBoxID + ": ChangeSelection");*/
		var checkCounter = $($("#" + tempListBoxID).attr("data-CustomCounter"));

		if (checkCounter.length > 0) {
			var checkCounterVal = parseInt(checkCounter.text());
			var selectedItems = this.select().length;

			if (checkCounterVal < 1 || selectedItems > checkCounterVal) {
				$("#" + tempListBoxID).siblings(".k-listbox-toolbar").find("a[data-command='transferTo']").addClass("k-state-disabled");
			}

			$("#" + tempListBoxID).siblings(".k-listbox-toolbar").find("a[data-command='transferAllTo']").addClass("k-state-disabled");
		}
	};
	var onChangeSelected = function onChangeSelected(e) {

		var tempListBoxID = e.sender.element.attr("id");
		/*console.log(tempListBoxID + ": changeSelected");*/
		var tempListBoxSelectionID = $("#" + tempListBoxID).attr("data-ConnectWith");

		var checkCounter = $($("#" + tempListBoxSelectionID).attr("data-CustomCounter"));
		if (checkCounter.length > 0) {
			var checkCounterVal = checkCounter.text();

			$("#" + tempListBoxSelectionID).siblings(".k-listbox-toolbar").find("a[data-command='transferAllTo']").addClass("k-state-disabled");
		}
	};

	var onDrop = function onDrop(e) {
		var tempListBoxID = e.sender.element.attr("id");
		/*console.log(tempListBoxID + ": onDrop");*/
		var tempListBoxIDConnectWith = $("#" + tempListBoxID).attr("data-ConnectWith");
		var widgetSide = listbox.getWidgetName(e);
		var mouseX = e.draggableEvent.pageX;
		var mouseY = e.draggableEvent.pageY;

		var listboxLocation = $("#" + tempListBoxIDConnectWith).parent(".k-listbox");
		var expectedTargetAreaStartWidth = listboxLocation.offset().left;
		var expectedTargetAreaEndWidth = listboxLocation.offset().left + listboxLocation.width();
		var expectedTargetAreaStartHeight = listboxLocation.offset().top;
		var expectedTargetAreaEndHeight = listboxLocation.offset().top + listboxLocation.height();

		var checkWidthLoc = mouseX >= expectedTargetAreaStartWidth && mouseX <= expectedTargetAreaEndWidth;
		var checkHeightLoc = mouseY >= expectedTargetAreaStartHeight && mouseY <= expectedTargetAreaEndHeight;

		var currentElemID = e.dataItems[0].Value;
		if (checkWidthLoc && checkHeightLoc) {
			if (tempRow && tempEntityGrid) {
				$("#" + tempListBoxID).find("li.k-item").removeClass("k-ghost");
				jQuery.each(tempRow, function (index, row) {
					var selectedItem = tempEntityGrid.dataItem(row);

					if (selectedItem.Value != currentElemID || widgetSide == "right") {
						var checkCounterAdd = $($("#" + tempListBoxIDConnectWith).attr("data-CustomCounter"));

						var checkCounterAddVal = checkCounterAdd.text();

						$("#" + tempListBoxIDConnectWith).data("kendoListBox").dataSource.add(selectedItem);
						checkCounterAdd.text(parseInt(checkCounterAddVal) + 1);

					}
					var checkCounterDeduct = $($("#" + tempListBoxID).attr("data-CustomCounter"));

					var checkCounterDeductVal = checkCounterDeduct.text();

					$("#" + tempListBoxID).data("kendoListBox").dataSource.remove(selectedItem);
					checkCounterDeduct.text(parseInt(checkCounterDeductVal) - 1);
				});

				var checkCounter = $($("#" + tempListBoxID).attr("data-CustomCounter"));
				if (checkCounter.length > 0) {
					var checkCounterVal = checkCounter.text();
					checkCounter.text(parseInt(checkCounterVal) + 1);
				}
			}
		}
		else {
			e.preventDefault;
		}
	};

	var onRemove = function onRemove(e) {
		var tempListBoxID = e.sender.element.attr("id");
		/*console.log(tempListBoxID + ": onRemove");*/
		var checkCounter = $($("#" + tempListBoxID).attr("data-CustomCounter"));
		if (checkCounter.length > 0) {
			var checkCounterVal = checkCounter.text();
			checkCounter.text(parseInt(checkCounterVal) - e.dataItems.length);
			/*console.log("Remove");*/
			$("#" + tempListBoxID).siblings(".k-listbox-toolbar").find("a[data-command='transferAllTo']").addClass("k-state-disabled");
		}
	};

	var doubleClickSelectionFn = function doubleClickSelectionFn(listboxId, dataItem) {
		var tempListBoxID = listboxId;
		/*console.log(tempListBoxID + ": doubleClickSelectionFn");*/
		var tempListBoxIDConnectWith = $("#" + tempListBoxID).attr("data-ConnectWith");
		var checkCounter = $($("#" + tempListBoxID).attr("data-CustomCounter"));
		var checkCounterVal = checkCounter.text();
		var newCounterVal = parseInt(checkCounterVal) - 1;
		if (checkCounterVal == "" || parseInt(checkCounterVal) > 0) {
			$("#" + tempListBoxIDConnectWith).data("kendoListBox").dataSource.add(dataItem);
			$("#" + tempListBoxID).data("kendoListBox").dataSource.remove(dataItem);

			checkCounter.text(newCounterVal);
		}
		if (checkCounter.length > 0) {
			$("#" + tempListBoxID).siblings(".k-listbox-toolbar").find("a[data-command='transferAllTo']").addClass("k-state-disabled");
		}
	};

	var doubleClickSelectedFn = function doubleClickSelectedFn(listboxId, dataItem) {
		var tempListBoxID = listboxId;
		/*console.log(tempListBoxID + ": doubleClickSelectedFn");*/
		var tempListBoxIDConnectWith = $("#" + tempListBoxID).attr("data-ConnectWith");

		$("#" + tempListBoxIDConnectWith).data("kendoListBox").dataSource.add(dataItem);

		$("#" + tempListBoxID).data("kendoListBox").dataSource.remove(dataItem);

		var checkCounter = $($("#" + tempListBoxIDConnectWith).attr("data-CustomCounter"));
		if (checkCounter.length > 0) {
			var checkCounterVal = checkCounter.text();
			var newCounterVal = parseInt(checkCounterVal) + 1;
			checkCounter.text(newCounterVal);

			$("#" + tempListBoxIDConnectWith).siblings(".k-listbox-toolbar").find("a[data-command='transferAllTo']").addClass("k-state-disabled");
		}
	};

	var onDragendSelection = !draggable ? null : function onDragendSelection(e) {
		var tempListBoxID = e.sender.element.attr("id");
		/*console.log(tempListBoxID + ": onDragend");*/
		var tempListBoxIDConnectWith = $("#" + tempListBoxID).attr("data-ConnectWith");
		$("#" + tempListBoxID).data("kendoListBox").refresh();
		$("#" + tempListBoxIDConnectWith).data("kendoListBox").refresh();

		listbox.mutation(tempListBoxID);
		$("#" + tempListBoxID).siblings(".k-listbox-toolbar").find("a[data-command='transferAllTo']").addClass("k-state-disabled");
	};

	var onDragendSelected =  !draggable ? null: function onDragendSelected(e) {
		var tempListBoxID = e.sender.element.attr("id");
		/*console.log(tempListBoxID + ": onDragend");*/
		var tempListBoxIDConnectWith = $("#" + tempListBoxID).attr("data-ConnectWith");
		$("#" + tempListBoxID).data("kendoListBox").refresh();
		$("#" + tempListBoxIDConnectWith).data("kendoListBox").refresh();

		listbox.mutation(tempListBoxIDConnectWith);
		$("#" + tempListBoxIDConnectWith).siblings(".k-listbox-toolbar").find("a[data-command='transferAllTo']").addClass("k-state-disabled");
	};

	var onHint = function onHint(element) {
		var elem = element.closest(".k-selectable").siblings("[data-role='listbox']");
		if (elem.length) {
			var elemID = $(elem)[0].id;
			var entityGrid = $("#" + elemID).data("kendoListBox");
			tempEntityGrid = entityGrid;

			var checkCounter = $($("#" + elemID).attr("data-CustomCounter"));
			var checkCounterVal = checkCounter.text();

			var checkRows = entityGrid.select();
			rows = checkRows;
			var $selected = [];
			if (checkCounter.length) {
				entityGrid.clearSelection();
				var checkRowsFinal = [];

				if (parseInt(checkCounterVal) > 0) {
					checkRows.each(function (index, row) {
						if (row != element[0]) {
							checkRowsFinal[index] = row;
						}
						else {
							$selected[0] = row;
						}
					});

					jQuery.each(checkRowsFinal, function (index, row) {
						if (parseInt(checkCounterVal) > index + 1) {
							$selected[index + 1] = row;
						}

					});
				}

				rows = $selected;
			}

			if (rows.length) {
				tempRow = rows;

				var x = this.currentTargetOffset.top;
				var y = this.currentTargetOffset.left;
				return $('<div/>').css({
					'position': 'absolute',
					'top': x,
					'left': y,
					"opacity": 0.5,
					"border": "1px dashed #000000"
				}).append(rows).appendTo('body');
			}
		}
	};

	objUserSelection = objUserSelection || {};
	objUserSelection.onAdd = onAdd;
	objUserSelection.onChange = onChangeSelection;
	objUserSelection.onDrop = onDrop;
	objUserSelection.onDragend = onDragendSelection;
	objUserSelection.onRemove = onRemove;
	objUserSelection.draggableHint = onHint;
	objUserSelection.doubleClickFn = doubleClickSelectionFn;
	objUserSelection.draggable = draggable;

	var objUserSelected = {};
	objUserSelected.dataTextField = objUserSelection.dataTextField;
	objUserSelected.dataValueField = objUserSelection.dataValueField;
	objUserSelected.dropSources = [listBoxID];
	objUserSelected.toolbarTools = [];
	objUserSelected.onChange = onChangeSelected;
	objUserSelected.onDrop = onDrop;
	objUserSelected.onDragend = onDragendSelected;
	objUserSelected.draggableHint = onHint;
	objUserSelected.doubleClickFn = doubleClickSelectedFn;
	objUserSelected.staticListBox = staticSelectedListBox;
	objUserSelected.draggable = draggable;

	$listBoxSelection = listbox.init(listBoxID, dataSourceSelection, objUserSelection);

	$("#" + listBoxIDConnectWith).addClass("optional");
	$listBoxSelected = listbox.init(listBoxIDConnectWith, dataSourceSelected, objUserSelected);

	var checkCounter = $($("#" + listBoxID).attr("data-CustomCounter"));
	if (checkCounter.length > 0) {
		var checkCounterVal = checkCounter.text();
		var countTotalData = $("#" + listBoxID).data("kendoListBox").dataSource.data().length;
		if (parseInt(checkCounterVal) < parseInt(countTotalData)) {
			$("#" + listBoxID).siblings(".k-listbox-toolbar").find("a[data-command='transferAllTo']").addClass("k-state-disabled");
		}
	}
	listbox.mutation(listBoxID);

	return {
		listBoxSelection: $listBoxSelection,
		listBoxSelected: $listBoxSelected
	};
};

listbox.mutation = function (listBoxID) {
	var observer = new MutationObserver(function (mutations) {
		mutations.forEach(function (mutation) {
			if (mutation.attributeName === "class") {
				var tempListBoxID = $(mutation.target).attr("data-ConnectID");
				/*if (tempListBoxID === undefined) { } empty block statement*/
				/*console.log(tempListBoxID + ": mutations");*/
				var checkCounter = $($("#" + tempListBoxID).attr("data-CustomCounter"));

				if (checkCounter.length > 0) {
					var checkCounterVal = checkCounter.text();
					var selectedItems = $("#" + tempListBoxID).data('kendoListBox').select().length;
					var countTotalData = $("#" + tempListBoxID).data("kendoListBox").dataSource.data().length;

					if (parseInt(checkCounterVal) < 1 || selectedItems > parseInt(checkCounterVal)) {
						$("#" + tempListBoxID).siblings(".k-listbox-toolbar").find("a[data-command='transferTo']").addClass("k-state-disabled");
					}

					if (parseInt(checkCounterVal) < parseInt(countTotalData)) {
						$("#" + tempListBoxID).siblings(".k-listbox-toolbar").find("a[data-command='transferAllTo']").addClass("k-state-disabled");
					}
				}
			}
		});
	});
	$("#" + listBoxID).siblings(".k-listbox-toolbar").find("a[data-command='transferAllTo']").attr("data-ConnectID", listBoxID);
	var $transferAllTo = $("a[data-command='transferAllTo']");
	observer.observe($transferAllTo[0], {

		attributes: true
	});
};

listbox.customizeHeight = function (e) {
	if ($(e).is(':visible') && !$(e).hasClass("fixedHeightListbox")) {
		
		var rowHeight = $(window).height();
		var topHeight = $(e).offset().top;
		var getScrollPosition = $(".fxc-main-content-body").get(0).scrollTop;
		topHeight = topHeight > 0 ? topHeight : (getScrollPosition + topHeight);
		var checkBottomSetting = $("div.k-widget.k-listbox.k-listbox-toolbar-right").find('[data-role="listbox"]');

		var assumeBottomHeight = $(e).closest(".modal").length > 0 ? 150 : (checkBottomSetting && checkBottomSetting.attr("data-bottom") ? parseInt(checkBottomSetting.attr("data-bottom")) : 0);
		var finalHeight = rowHeight - topHeight - assumeBottomHeight;

		/*Check if other listbox same row exist. If Yes save same height*/
		var getCurrentId = "";

		if ($(e).find("[data-role='listbox']").length) {
			if ($(e).closest(".tab-pane").length > 0) {
				finalHeight -= 40;
			}

			getCurrentId = $(e).find("[data-role='listbox']")[0].id;
		}
		if ($(e).closest(".row").find(".k-listbox").length > 1) {
			/*check if currentID is first id in listbox*/
			var listBoxFirstID = $($(e).closest(".row").find(".k-listbox")[0]).find("[data-role='listbox']")[0].id;
			if (listBoxFirstID != getCurrentId) {
				finalHeight = $($(e).closest(".row").find(".k-listbox")[0]).height();
			}
		}

		finalHeight = finalHeight > 200 ? finalHeight : 200;
		$(e).css("height", finalHeight);
	}

};

listbox.destroy = function (event) {
	/*event --> $("#grid")*/
	var listBox = event.data("kendoListBox");
	listBox.destroy();
};

listbox.getWidgetName = function (e) {
	var listBoxId = e.sender.element.hasClass("optional");
	var widgetName = listBoxId ? "right" : "left";
	return widgetName;
};





