﻿(function ($) {
    var newShape;
    var moveShape;
    var resizeShape;
    var selectedShape;
    var gap = 6;
    var canvas = document.getElementById('canvasarea'),
        context = canvas.getContext('2d');
    var recOffsetX, recOffsetY;
    var isDrawDown = false;
    var isMoveDown = false;
    var isResize = false;
    var startX, startY;
    var widthRectMax = 0;

    var successGetThumbnail = false;
    var successGetMainImage = false;
    var base_image = new Image();

    var cursorNorth = "n-resize";
    var cursorEast = "e-resize";
    var cursorSouth = "s-resize";
    var cursorWest = "w-resize";
    var cursorNorthEast = "ne-resize";
    var cursorSouthEast = "se-resize";
    var cursorSouthWest = "sw-resize";
    var cursorNorthWest = "nw-resize";

    var cursorEastWest = "grab";
    var cursorCrossHair = "crosshair";
    var cursorText = "text";
    var cursorDefault = "default";
    var cursorMove = "move";

    var selectedObjChange = false;

    var baseColorHover = "#fff";
    var baseColorDrag = "blue";

    $.messageAnnotation = {
        action: [],
        fullStack: [],
        displayStack: [],
        redoStack: [],
        drawCount: 0,
        trackCount: 0,
        rotateAngle: 0,
        zoom: 1,
        setZooming: true,
        scale: 1,
        obj: {
            page: 0,
            type: "",
            color: "rgb(255, 0, 0)",
            colorType: "dark",
            lineWidth: "8",
            onHover: false,
            onSelectItem: false,
            fontFamily: "Arial",
            fontSize: "24px",
            base_imageSrc: null,
            totalPage: 0,
        },
        objButton: [],
        result: [],
        init: function () {

            $.messageAnnotation.onBtnActionClick($('.btn-action'));
            $.messageAnnotation.onBtnSelectActionClick($('.btn-selectAction'));
            $.messageAnnotation.onBtnColorClick($('#btn-color'));
            $.messageAnnotation.onBtnColorChange($('#btn-group-color .dropdown-item-custom li'));
            $.messageAnnotation.onBtnDrawLineChange($('#btn-group-draw-line .dropdown-item'));
            $.messageAnnotation.onBtnDrawShapeChange($('#btn-group-draw-shape .dropdown-item'));
            $.messageAnnotation.onBtnLineWidthClick($('#btn-lineWidt'));
            $.messageAnnotation.onBtnLineWidthChange($('#btn-group-lineWidth .dropdown-item'));
            $.messageAnnotation.onBtnFontFamilyChange($('#btn-group-fontFamily .dropdown-item'));
            $.messageAnnotation.onBtnFontSizeChange($('#btn-group-fontSize .dropdown-item'));
            $.messageAnnotation.onBtnDeleteActionClick($('#btn-delete'));
            $.messageAnnotation.onBtnZoomClick($('.btn-zoom'));
            $.messageAnnotation.onBtnRotateClick($('.btn-rotate'));
            $.messageAnnotation.onBtnCancelClick($('#btn-cancel-sign'));
            $.messageAnnotation.onBtnDoneClick($('#btn-done-sign'));

            canvas.addEventListener("mousemove", function (e) {
                $.drawCanvas.handleMouseMove(e);
            }, false);
            canvas.addEventListener("mousedown", function (e) {
                $.drawCanvas.handleMouseDown(e);
            }, false);
            canvas.addEventListener("mouseup", function (e) {
                $.drawCanvas.handleMouseUp(e);
            }, false);
            canvas.addEventListener("mouseout", function (e) {
                $.drawCanvas.handleMouseOut(e);
            }, false);

            window.onscroll = function (e) {
                $.drawCanvas.reOffset();
            }
            window.onresize = function (e) {
                $.drawCanvas.reOffset();
                $.drawCanvas.fitToScreen();
                $.messageAnnotation.setBtnZoom();
            }

            $("#DocumentCanvasContainer").scroll(function () {
                $.drawCanvas.reOffset();
            });

            $.drawCanvas.reOffset();

            $.messageAnnotation.getThumbnails();

            $.messageAnnotation.getMainImage($.messageAnnotation.obj.page);

            $.signature.init();

            $(".editor-outer-textarea textarea").on('input', function () {
                this.style.height = 'auto';
                this.style.height = (this.scrollHeight) + 'px';
            });
        },

        /*Btn Action*/
        onBtnActionClick: function (e) {
            $(e).on('click', function (x, y) {
                var getDataType = $(this).attr("data-type");
                switch (getDataType) {
                    case "undo":
                        $.drawCanvas.undoAction();
                        break;
                    case "redo":
                        $.drawCanvas.redoAction();
                        break;
                    case "clear":
                        $.drawCanvas.clearAction();
                        break;
                    case "delete":
                        $.drawCanvas.deleteAction();
                        break;
                }

                $(".editor-outer-textarea textarea").val("");
                $(".editor-outer-textarea textarea").css("display", "none");
            });
        },
        onBtnSelectActionClick: function (e) {
            $(e).on('click', function (x, y) {
                $(".btn-selectAction.selected").removeClass("selected");
                $(this).addClass("selected");

                var getDataType = $(this).children(".command").length > 0 ? $(this).children(".command").attr("data-type") : $(this).attr("data-type");
                $.messageAnnotation.obj.type = getDataType;

                $.messageAnnotation.setBtnSelect(getDataType);
            });
        },
        onBtnColorClick: function (e) {
            $(e).on('click', function (x, y) {
                var getDataColor = $(this).children(".icon-custom").attr("data-color");
                var getDataColorType = $(this).children(".icon-custom").attr("data-colortype");

                $.messageAnnotation.obj.color = getDataColor;
                $.messageAnnotation.obj.colorType = getDataColorType;

                if (selectedShape != null) {
                    selectedObjChange = true;
                    selectedShape.color = getDataColor;
                    selectedShape.colorType = getDataColorType;

                    $.messageAnnotation.displayStack = $.grep($.messageAnnotation.displayStack, function (item) {
                        var removeItem = item.id == selectedShape.id;
                        return !removeItem;
                    });

                    $.drawCanvas.drawAll();
                    $.drawCanvas.drawAction(selectedShape);
                }
            });
        },
        onBtnColorChange: function (e) {
            $(e).on('click', function (x, y) {
                var getDataColor = $(this).attr("data-color");
                var getDataColorType = $(this).attr("data-colortype");

                $("#btn-color > .icon-custom").attr("data-color", getDataColor);
                $("#btn-color > .icon-custom").attr("data-colortype", getDataColorType);

                $.messageAnnotation.obj.color = getDataColor;
                $.messageAnnotation.obj.colorType = getDataColorType;

                if ($(".editor-outer-textarea textarea").is(":visible")) {
                    $(".editor-outer-textarea textarea").css("color", $.messageAnnotation.obj.color);
                    $(".editor-outer-textarea textarea").focus();
                }

                if (selectedShape != null) {
                    selectedObjChange = true;
                    selectedShape.color = getDataColor;
                    selectedShape.colorType = getDataColorType;

                    $.messageAnnotation.displayStack = $.grep($.messageAnnotation.displayStack, function (item) {
                        var removeItem = item.id == selectedShape.id;
                        return !removeItem;
                    });

                    $.drawCanvas.drawAll();
                    $.drawCanvas.drawAction(selectedShape);
                }
            });
        },
        onBtnDrawLineChange: function (e) {
            $(e).on('click', function (x, y) {
                var getDataType = $(this).children(".icon-custom-line").first().attr("data-type");

                $("#btn-draw-line > .icon-custom-line").attr("data-type", getDataType);

                $("#btn-draw-line > .icon-custom-line i").removeClass($("#btn-draw-line > .icon-custom-line i").attr("class"));
                $("#btn-draw-line > .icon-custom-line i").addClass($(this).children(".icon-custom-line").first().find("i").attr("class"));

                $("#btn-draw-line").click();
            });
        },
        onBtnDrawShapeChange: function (e) {
            $(e).on('click', function (x, y) {
                var getDataType = $(this).children(".icon-custom").first().attr("data-type");

                $("#btn-draw-shape > .command").attr("data-type", getDataType);

                $("#btn-draw-shape").click();
            });
        },
        onBtnLineWidthClick: function (e) {
            $(e).on('click', function (x, y) {
                var getDataLineWidth = $(this).children(".icon-custom").attr("data-linewidth");
                $.messageAnnotation.obj.lineWidth = parseInt(getDataLineWidth);

                if (selectedShape != null) {
                    selectedObjChange = true;
                    selectedShape.lineWidth = parseInt(getDataLineWidth);

                    $.messageAnnotation.displayStack = $.grep($.messageAnnotation.displayStack, function (item) {
                        var removeItem = item.id == selectedShape.id;
                        return !removeItem;
                    });

                    $.drawCanvas.drawAll();
                    $.drawCanvas.drawAction(selectedShape);
                }
            });
        },
        onBtnLineWidthChange: function (e) {
            $(e).on('click', function (x, y) {
                var getDataLineWidth = $(this).children(".icon-custom").first().attr("data-linewidth");

                $("#btn-lineWidth > .icon-custom").attr("data-linewidth", getDataLineWidth);

                $("#btn-lineWidth >.icon-line-span").val(getDataLineWidth);
                $("#btn-lineWidth >.icon-line-span").text(getDataLineWidth);
                $.messageAnnotation.obj.lineWidth = parseInt(getDataLineWidth);

                if (selectedShape != null) {
                    selectedObjChange = true;
                    selectedShape.lineWidth = parseInt(getDataLineWidth);

                    $.messageAnnotation.displayStack = $.grep($.messageAnnotation.displayStack, function (item) {
                        var removeItem = item.id == selectedShape.id;
                        return !removeItem;
                    });

                    $.drawCanvas.drawAll();
                    $.drawCanvas.drawAction(selectedShape);
                }
            });
        },
        onBtnFontFamilyChange: function (e) {
            $(e).on('click', function (x, y) {
                var getDataFontFamily = $(this).children(".font-span").first().attr("data-type");

                $("#btn-fontFamily > .font-span").attr("data-type", getDataFontFamily);

                $("#btn-fontFamily >.font-span").val(getDataFontFamily);
                $("#btn-fontFamily >.font-span").text(getDataFontFamily);
                $.messageAnnotation.obj.fontFamily = getDataFontFamily;

                if (selectedShape != null) {
                    selectedObjChange = true;
                    selectedShape.fontFamily = getDataFontFamily;

                    $.messageAnnotation.displayStack = $.grep($.messageAnnotation.displayStack, function (item) {
                        var removeItem = item.id == selectedShape.id;
                        return !removeItem;
                    });

                    $.drawCanvas.drawAll();
                    $.drawCanvas.drawAction(selectedShape);
                }
            });
        },
        onBtnFontSizeChange: function (e) {
            $(e).on('click', function (x, y) {
                var existingFontSize = $.messageAnnotation.obj.fontSize;
                var getDataFontSize = $(this).children(".font-span").first().attr("data-type");

                $("#btn-fontSize > .font-span").attr("data-type", getDataFontSize);

                $("#btn-fontSize >.font-span").val(getDataFontSize);
                $("#btn-fontSize >.font-span").text(getDataFontSize);
                $.messageAnnotation.obj.fontSize = (parseInt(getDataFontSize) * $.messageAnnotation.scale) + "px";
                $.messageAnnotation.obj.originalFontSize = getDataFontSize;

                if ($(".editor-outer-textarea textarea").is(":visible")) {
                    var fontSize = parseInt($.messageAnnotation.obj.fontSize);
                    var minHeight = fontSize + 10;
                    var fontHeight = fontSize + gap;
                    $(".editor-outer-textarea textarea").css("font", fontSize + "px / " + fontHeight + "px " + $.messageAnnotation.obj.fontFamily + "");

                    context.font = fontSize + "px / " + fontHeight + "px " + $.messageAnnotation.obj.fontFamily + "";

                    var keyWidth = 1.3;
                    if (fontSize < 15)
                    {
                        keyWidth = 1.6;
                    }
                    else if (fontSize < 25) {
                        keyWidth = 1.4;
                    }

                    if ($.messageAnnotation.obj.type == "writeDate") {
                        var contentArea = $(".editor-outer-textarea textarea").val();

                        var metrics = context.measureText("9999\99\99");
                        var testWidth = metrics.width;
                        
                        $(".editor-outer-textarea textarea").css("width", (testWidth * keyWidth) + "px");
                        $(".editor-outer-textarea textarea").css("height", fontHeight + "px");
                        $(".editor-outer-textarea textarea").css("min-width", "");
                        $(".editor-outer-textarea textarea").css("min-height", "");
                    }
                    else if ($.messageAnnotation.obj.type == "write") {
                        var metrics = context.measureText("w");
                        var testMinWidth = metrics.width;

                        $(".editor-outer-textarea textarea").css("min-width", (testMinWidth * keyWidth) + "px");
                        $(".editor-outer-textarea textarea").css("min-height", fontHeight + "px");

                        var getTextAreaWidth = parseInt($(".editor-outer-textarea textarea").css("width"));
                        var getTextAreaHeight = parseInt($(".editor-outer-textarea textarea").css("height"));
                        var getTextAreaExistingFontSize = parseInt(existingFontSize);
                        var getTextAreaNewFontSize = parseInt(getDataFontSize);

                        var getRatio = getTextAreaNewFontSize / getTextAreaExistingFontSize;

                        $(".editor-outer-textarea textarea").css("width", getTextAreaWidth * getRatio);
                        $(".editor-outer-textarea textarea").css("height", getTextAreaHeight * getRatio);
                    }

                    $(".editor-outer-textarea textarea").focus();
                }

                if (selectedShape != null) {
                    selectedObjChange = true;
                    selectedShape.fontSize = $.messageAnnotation.obj.fontSize;
                    selectedShape.originalFontSize = $.messageAnnotation.obj.originalFontSize;

                    $.messageAnnotation.displayStack = $.grep($.messageAnnotation.displayStack, function (item) {
                        var removeItem = item.id == selectedShape.id;
                        return !removeItem;
                    });

                    $.drawCanvas.drawAll();
                    $.drawCanvas.drawAction(selectedShape);
                }
            });
        },
        onBtnDeleteActionClick: function (e) {
            $(e).on('click', function (x, y) {
                var getDataType = $(this).attr("data-type");
                $.messageAnnotation.obj.type = getDataType;
                $.drawCanvas.deleteAction();

                $("[data-type='delete']").prop("disabled", true);

                var getDataType = $(".btn-selectAction.selected").children(".command").length > 0 ? $(".btn-selectAction.selected").children(".command").attr("data-type") : $(".btn-selectAction.selected").attr("data-type");
                $.messageAnnotation.obj.type = getDataType;

            });
        },
        onBtnZoomClick: function (e) {
            $(e).on('click', function (x, y) {
                if ($(".editor-outer-textarea textarea").is(":visible")) {
                    $.drawCanvas.drawTextArea();
                }

                var getDataType = $(this).attr("data-type");
                switch (getDataType) {
                    case "zoomout":
                        $.messageAnnotation.setZooming = false;
                        $.messageAnnotation.zoom = parseInt($(".zoomLabel").text()) / 100;

                        if ($.messageAnnotation.zoom < 0.25) {
                            $.messageAnnotation.zoom = 0.25
                        }
                        else if ($.messageAnnotation.zoom > 0.25 && $.messageAnnotation.zoom < 0.50) {
                            $.messageAnnotation.zoom = 0.50
                        }
                        else if ($.messageAnnotation.zoom > 0.50 && $.messageAnnotation.zoom < 0.75) {
                            $.messageAnnotation.zoom = 0.75
                        }
                        else if ($.messageAnnotation.zoom > 0.75 && $.messageAnnotation.zoom < 1.00) {
                            $.messageAnnotation.zoom = 1.00
                        }
                        else if ($.messageAnnotation.zoom > 1.00 && $.messageAnnotation.zoom < 1.25) {
                            $.messageAnnotation.zoom = 1.25
                        }
                        else if ($.messageAnnotation.zoom > 1.25 && $.messageAnnotation.zoom < 1.50) {
                            $.messageAnnotation.zoom = 1.50
                        }
                        else if ($.messageAnnotation.zoom > 1.50 && $.messageAnnotation.zoom < 1.75) {
                            $.messageAnnotation.zoom = 1.75
                        }
                        else if ($.messageAnnotation.zoom > 1.75 && $.messageAnnotation.zoom < 2.00) {
                            $.messageAnnotation.zoom = 2.00
                        }
                        else if ($.messageAnnotation.zoom > 2.00 && $.messageAnnotation.zoom < 2.25) {
                            $.messageAnnotation.zoom = 2.25
                        }
                        else if ($.messageAnnotation.zoom > 2.25 && $.messageAnnotation.zoom < 2.50) {
                            $.messageAnnotation.zoom = 2.50
                        }
                        else if ($.messageAnnotation.zoom > 2.50 && $.messageAnnotation.zoom < 2.75) {
                            $.messageAnnotation.zoom = 2.75
                        }
                        else if ($.messageAnnotation.zoom > 2.75 && $.messageAnnotation.zoom < 3.00) {
                            $.messageAnnotation.zoom = 3.00
                        }
                        else if ($.messageAnnotation.zoom > 3.00 ) {
                            $.messageAnnotation.zoom = 3.25
                        }

                        $.messageAnnotation.zoom -= 0.25;
                        $("#btn-zoomin").prop("disabled", false);

                        break;
                    case "zoomin":
                        $.messageAnnotation.setZooming = false;
                        $.messageAnnotation.zoom = parseInt($(".zoomLabel").text()) / 100;

                        if ($.messageAnnotation.zoom < 0.25) {
                            $.messageAnnotation.zoom = 0.00
                        }
                        else if ($.messageAnnotation.zoom > 0.25 && $.messageAnnotation.zoom < 0.50) {
                            $.messageAnnotation.zoom = 0.25
                        }
                        else if ($.messageAnnotation.zoom > 0.50 && $.messageAnnotation.zoom < 0.75) {
                            $.messageAnnotation.zoom = 0.50
                        }
                        else if ($.messageAnnotation.zoom > 0.75 && $.messageAnnotation.zoom < 1.00) {
                            $.messageAnnotation.zoom = 0.75
                        }
                        else if ($.messageAnnotation.zoom > 1.00 && $.messageAnnotation.zoom < 1.25) {
                            $.messageAnnotation.zoom = 1.00
                        }
                        else if ($.messageAnnotation.zoom > 1.25 && $.messageAnnotation.zoom < 1.50) {
                            $.messageAnnotation.zoom = 1.25
                        }
                        else if ($.messageAnnotation.zoom > 1.50 && $.messageAnnotation.zoom < 1.75) {
                            $.messageAnnotation.zoom = 1.50
                        }
                        else if ($.messageAnnotation.zoom > 1.75 && $.messageAnnotation.zoom < 2.00) {
                            $.messageAnnotation.zoom = 1.75
                        }
                        else if ($.messageAnnotation.zoom > 2.00 && $.messageAnnotation.zoom < 2.25) {
                            $.messageAnnotation.zoom = 2.00
                        }
                        else if ($.messageAnnotation.zoom > 2.25 && $.messageAnnotation.zoom < 2.50) {
                            $.messageAnnotation.zoom = 2.25
                        }
                        else if ($.messageAnnotation.zoom > 2.50 && $.messageAnnotation.zoom < 2.75) {
                            $.messageAnnotation.zoom = 2.50
                        }
                        else if ($.messageAnnotation.zoom > 2.75 && $.messageAnnotation.zoom < 3.00) {
                            $.messageAnnotation.zoom = 2.75
                        }
                        else if ($.messageAnnotation.zoom > 3.00 ) {
                            $.messageAnnotation.zoom = 3.00
                        }

                        $.messageAnnotation.zoom += 0.25;
                        $("#btn-zoomout").prop("disabled", false);

                        break;
                    case "fittoscreen":
                        $.messageAnnotation.setZooming = true;
                        $.drawCanvas.fitToScreen();
                        break;
                }

                $.messageAnnotation.setBtnZoom();
            });
        },
        onBtnRotateClick: function (e) {
            $(e).on('click', function (x, y) {
                if ($(".editor-outer-textarea textarea").is(":visible")) {
                    $.drawCanvas.drawTextArea();
                }

                var getDataType = $(this).attr("data-type");

                switch (getDataType) {
                    case "rotateLeft":
                        $.messageAnnotation.rotateAngle -= 90;
                        break;
                    case "rotateRight":
                        $.messageAnnotation.rotateAngle += 90;
                        break;
                }

                $.messageAnnotation.setBtnRotate();
                $.drawCanvas.fitToScreen();
                $.messageAnnotation.setBtnZoom();
            });

            $(e).click();
        },
        onBtnCancelClick: function (e) {
            $(e).on('click', function (x, y) {
                window.close();
            });
        },
        onBtnDoneClick: function (e) {
            $(e).on('click', function (x, y) {
                swal({
                    title: $globalMessages.swal.loader.title,
                    text: $globalMessages.swal.loader.text,
                    imageUrl: '/Content/img/ajax-loading2.gif',
                    showConfirmButton: false,
                    closeOnClickOutside: false,
                    allowEscapeKey: false,
                });

                var call = $.messageAnnotation.saveImageTemp($.messageAnnotation.obj.page);

                $.when(call).then(function (cb) {
                    var deferreds = [];
                    var docPageArr = [];

                    for (var page = 0; page < $.messageAnnotation.obj.totalPage; page++) {
                        var deferred = new $.Deferred();

                        var getExistingImg = $.messageAnnotation.result.filter(function (e) { return e.page === page; });

                        if (getExistingImg.length > 0) {
                            docPageArr.push(getExistingImg[0].finalUrl);
                            deferred.resolve(getExistingImg[0].finalUrl);
                        }
                        else {
                            $.messageAnnotation.getMainImageUrl(page, function (data) {
                                docPageArr.push(data.MainImage.Url);
                                deferreds[data.MainImage.Page].resolve();
                            });
                        }

                        deferreds.push(deferred);
                    }

                    $.when.apply(null, deferreds).done(function () {
                        if (docPageArr.length > 0) {
                            $.messageAnnotation.saveImage(docPageArr);
                        }
                    });
                });
            });
        },

        setBtnSelect: function (getType) {
            $(".editor-outer-textarea textarea").val("");
            $(".editor-outer-textarea textarea").css("display", "none");
            $(".nav-font").addClass("hide");
            $(".nav-lineWidth").removeClass("hide");

            if (getType.startsWith("draw")) {
                $("#btn-group-color button").prop("disabled", false);

                if ($.messageAnnotation.obj.type == "draw-square" ||
                    $.messageAnnotation.obj.type == "draw-circle") {
                    $("#btn-group-lineWidth button").prop("disabled", true);
                }
                else {
                    $("#btn-group-lineWidth button").prop("disabled", false);
                }

                canvas.style.cursor = cursorCrossHair;
            }
            else if (getType.startsWith("write")) {
                canvas.style.cursor = cursorText;

                $(".nav-font").removeClass("hide");
                $(".nav-lineWidth").addClass("hide");

                $("#btn-group-color button").prop("disabled", false);
                $("#btn-group-fontSize button").prop("disabled", false);
                $("#btn-group-fontFamily button").prop("disabled", false);

                $("[data-type='move']").prop("disabled", false);
                $.messageAnnotation.obj.originalFontSize = $("#btn-fontSize").children(".font-span").attr("data-type");
                $.messageAnnotation.obj.fontSize = (parseInt($("#btn-fontSize").children(".font-span").attr("data-type")) * $.messageAnnotation.scale) + "px";
            }
            else if (getType == "attachImage") {
                $("#btn-group-color button").prop("disabled", true);
                $("#btn-group-lineWidth button").prop("disabled", true);
                $.signature.loadModal(true);
            }
            else {
                canvas.style.cursor = cursorDefault;
                $("#btn-group-color button").prop("disabled", true);
                $("#btn-group-lineWidth button").prop("disabled", true);
            }

            $.drawCanvas.reOffset();
        },
        setBtnRotate: function () {
            if (Math.abs($.messageAnnotation.rotateAngle) == 360) {
                $.messageAnnotation.rotateAngle = 0;
            }

            if (Math.abs($.messageAnnotation.rotateAngle) == 0) {
                cursorNorth = "n-resize";
                cursorEast = "e-resize";
                cursorSouth = "s-resize";
                cursorWest = "w-resize";
                cursorNorthEast = "ne-resize";
                cursorSouthEast = "se-resize";
                cursorSouthWest = "sw-resize";
                cursorNorthWest = "nw-resize";

                $(".canvasEditArea").css("min-width", (parseInt($(canvas).css("width")) * $.messageAnnotation.zoom) + "px");
                $(".canvasEditArea").css("height", (parseInt($(canvas).css("height")) * $.messageAnnotation.zoom) + "px");
                $(canvas).css({ 'transform': '' });
            }
            else if ($.messageAnnotation.rotateAngle == 90 || $.messageAnnotation.rotateAngle == -270) {
                cursorNorth = "e-resize";
                cursorEast = "s-resize";
                cursorSouth = "w-resize";
                cursorWest = "n-resize";
                cursorNorthEast = "se-resize";
                cursorSouthEast = "sw-resize";
                cursorSouthWest = "nw-resize";
                cursorNorthWest = "ne-resize";

                $(".canvasEditArea").css("min-width", (parseInt($(canvas).css("height")) * $.messageAnnotation.zoom) + "px");
                $(".canvasEditArea").css("height", (parseInt($(canvas).css("width")) * $.messageAnnotation.zoom) + "px");
                var translateX = (canvas.width - canvas.height) / 2;
                $(canvas).css({ 'transform': 'rotate(' + $.messageAnnotation.rotateAngle + 'deg) translateX(' + translateX + 'px)' });
            }
            else if ($.messageAnnotation.rotateAngle == 270 || $.messageAnnotation.rotateAngle == -90) {
                cursorNorth = "w-resize";
                cursorEast = "n-resize";
                cursorSouth = "e-resize";
                cursorWest = "s-resize";
                cursorNorthEast = "nw-resize";
                cursorSouthEast = "ne-resize";
                cursorSouthWest = "se-resize";
                cursorNorthWest = "sw-resize";

                $(".canvasEditArea").css("min-width", (parseInt($(canvas).css("height")) * $.messageAnnotation.zoom) + "px");
                $(".canvasEditArea").css("height", (parseInt($(canvas).css("width")) * $.messageAnnotation.zoom) + "px");
                var translateX = -(canvas.width - canvas.height) / 2;
                $(canvas).css({ 'transform': 'rotate(' + $.messageAnnotation.rotateAngle + 'deg) translateX(' + translateX + 'px)' });
            }
            else if (Math.abs($.messageAnnotation.rotateAngle) == 180) {
                cursorNorth = "s-resize";
                cursorEast = "w-resize";
                cursorSouth = "n-resize";
                cursorWest = "e-resize";
                cursorNorthEast = "sw-resize";
                cursorSouthEast = "nw-resize";
                cursorSouthWest = "ne-resize";
                cursorNorthWest = "se-resize";

                $(".canvasEditArea").css("min-width", (parseInt($(canvas).css("width")) * $.messageAnnotation.zoom) + "px");
                $(".canvasEditArea").css("height", (parseInt($(canvas).css("height")) * $.messageAnnotation.zoom) + "px");
                $(canvas).css({ 'transform': 'rotate(' + $.messageAnnotation.rotateAngle + 'deg)' });
            }

            $.drawCanvas.reOffset();
        },
        setBtnRotate: function () {
            if (Math.abs($.messageAnnotation.rotateAngle) == 360) {
                $.messageAnnotation.rotateAngle = 0;
            }

            if (Math.abs($.messageAnnotation.rotateAngle) == 0) {
                cursorNorth = "n-resize";
                cursorEast = "e-resize";
                cursorSouth = "s-resize";
                cursorWest = "w-resize";
                cursorNorthEast = "ne-resize";
                cursorSouthEast = "se-resize";
                cursorSouthWest = "sw-resize";
                cursorNorthWest = "nw-resize";

                $(".canvasEditArea").css("min-width", (parseInt($(canvas).css("width")) * $.messageAnnotation.zoom) + "px");
                $(".canvasEditArea").css("height", (parseInt($(canvas).css("height")) * $.messageAnnotation.zoom) + "px");
                $(canvas).css({ 'transform': '' });
            }
            else if ($.messageAnnotation.rotateAngle == 90 || $.messageAnnotation.rotateAngle == -270) {
                cursorNorth = "e-resize";
                cursorEast = "s-resize";
                cursorSouth = "w-resize";
                cursorWest = "n-resize";
                cursorNorthEast = "se-resize";
                cursorSouthEast = "sw-resize";
                cursorSouthWest = "nw-resize";
                cursorNorthWest = "ne-resize";

                $(".canvasEditArea").css("min-width", (parseInt($(canvas).css("height")) * $.messageAnnotation.zoom) + "px");
                $(".canvasEditArea").css("height", (parseInt($(canvas).css("width")) * $.messageAnnotation.zoom) + "px");
                var translateX = (canvas.width - canvas.height) / 2;
                $(canvas).css({ 'transform': 'rotate(' + $.messageAnnotation.rotateAngle + 'deg) translateX(' + translateX + 'px)' });
            }
            else if ($.messageAnnotation.rotateAngle == 270 || $.messageAnnotation.rotateAngle == -90) {
                cursorNorth = "w-resize";
                cursorEast = "n-resize";
                cursorSouth = "e-resize";
                cursorWest = "s-resize";
                cursorNorthEast = "nw-resize";
                cursorSouthEast = "ne-resize";
                cursorSouthWest = "se-resize";
                cursorNorthWest = "sw-resize";

                $(".canvasEditArea").css("min-width", (parseInt($(canvas).css("height")) * $.messageAnnotation.zoom) + "px");
                $(".canvasEditArea").css("height", (parseInt($(canvas).css("width")) * $.messageAnnotation.zoom) + "px");
                var translateX = -(canvas.width - canvas.height) / 2;
                $(canvas).css({ 'transform': 'rotate(' + $.messageAnnotation.rotateAngle + 'deg) translateX(' + translateX + 'px)' });
            }
            else if (Math.abs($.messageAnnotation.rotateAngle) == 180) {
                cursorNorth = "s-resize";
                cursorEast = "w-resize";
                cursorSouth = "n-resize";
                cursorWest = "e-resize";
                cursorNorthEast = "sw-resize";
                cursorSouthEast = "nw-resize";
                cursorSouthWest = "ne-resize";
                cursorNorthWest = "se-resize";

                $(".canvasEditArea").css("min-width", (parseInt($(canvas).css("width")) * $.messageAnnotation.zoom) + "px");
                $(".canvasEditArea").css("height", (parseInt($(canvas).css("height")) * $.messageAnnotation.zoom) + "px");
                $(canvas).css({ 'transform': 'rotate(' + $.messageAnnotation.rotateAngle + 'deg)' });
            }

            $.drawCanvas.reOffset();
        },
        setBtnZoom: function () {
            var setZoomLabel = $.messageAnnotation.parseFloat($.messageAnnotation.zoom * 100, 1);

            $(".zoomLabel").text(setZoomLabel + "%");

            $(canvas).css("zoom", $.messageAnnotation.zoom);
            $(".editor-outer-textarea").css("zoom", $.messageAnnotation.zoom);

            if ($.messageAnnotation.zoom <= 0.25) {
                $("#btn-zoomout").prop("disabled", true);
                $.messageAnnotation.zoom = 0.25;
            }
            else {
                $("#btn-zoomout").prop("disabled", false);
            }

            if ($.messageAnnotation.zoom >= 3) {
                $("#btn-zoomin").prop("disabled", true);
                $.messageAnnotation.zoom = 3;
            }
            else {
                $("#btn-zoomin").prop("disabled", false);
            }

            if ($.messageAnnotation.setZooming) {
                $("#btn-fittoscreen").addClass("selected");
                $("#btn-fittoscreen").prop("disabled", true);
            }
            else {
                $("#btn-fittoscreen").prop("disabled", false);
                $("#btn-fittoscreen").removeClass("selected");
            }

            if (Math.abs($.messageAnnotation.rotateAngle) == 0) {
                $(".canvasEditArea").css("min-width", (parseInt($(canvas).css("width")) * $.messageAnnotation.zoom) + "px");
                $(".canvasEditArea").css("height", (parseInt($(canvas).css("height")) * $.messageAnnotation.zoom) + "px");
                $(canvas).css({ 'transform': '' });
            }
            else if ($.messageAnnotation.rotateAngle == 90 || $.messageAnnotation.rotateAngle == -270) {
                $(".canvasEditArea").css("min-width", (parseInt($(canvas).css("height")) * $.messageAnnotation.zoom) + "px");
                $(".canvasEditArea").css("height", (parseInt($(canvas).css("width")) * $.messageAnnotation.zoom) + "px");
                var translateX = (canvas.width - canvas.height) / 2;
                $(canvas).css({ 'transform': 'rotate(' + $.messageAnnotation.rotateAngle + 'deg) translateX(' + translateX + 'px)' });
            }
            else if ($.messageAnnotation.rotateAngle == 270 || $.messageAnnotation.rotateAngle == -90) {
                $(".canvasEditArea").css("min-width", (parseInt($(canvas).css("height")) * $.messageAnnotation.zoom) + "px");
                $(".canvasEditArea").css("height", (parseInt($(canvas).css("width")) * $.messageAnnotation.zoom) + "px");
                var translateX = -(canvas.width - canvas.height) / 2;
                $(canvas).css({ 'transform': 'rotate(' + $.messageAnnotation.rotateAngle + 'deg) translateX(' + translateX + 'px)' });
            }
            else if (Math.abs($.messageAnnotation.rotateAngle) == 180) {
                $(".canvasEditArea").css("min-width", (parseInt($(canvas).css("width")) * $.messageAnnotation.zoom) + "px");
                $(".canvasEditArea").css("height", (parseInt($(canvas).css("height")) * $.messageAnnotation.zoom) + "px");
                $(canvas).css({ 'transform': 'rotate(' + $.messageAnnotation.rotateAngle + 'deg)' });
            }

            $.drawCanvas.reOffset();
        },
        saveImage: function (base64Strings) {
            var params = {
                DocUid: $('#DocUid').val(),
                Base64String: base64Strings
            };
            var url = '/annotation/mergeannotatepages';
            var source = $('#AnnotationImageSrc').val();

            if (source === 'MessageViewer') {
                params = {
                    DocUid: $('#MessageId').val(),
                    Base64String: base64Strings,
                    TransactId: $('#TransactId').val(),
                    DelegatorId: $('#DelegatorId').val()
                };
                url = '/annotation/saveannotationfile';
            }

            fxcRequest.post(url, params,
                function (data) {
                    if (opener) {
                        opener.initAnnotationCallback();
                    }

                    swal.close();
                    window.close();
                }, null);
        },
        newGuid: function () {
            return 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g,
                function (c) {
                    var r = Math.random() * 16 | 0,
                        v = c == 'x' ? r : (r & 0x3 | 0x8);
                    return v.toString(16);
                }).toUpperCase();
        },
        getTodayDate: function (spliter) {
            spliter = spliter || "-";
            var today = new Date();
            //var dd = today.getDate().toString();
            //var mm = today.getMonth() + 1;
            //var yyyy = today.getFullYear().toString();
            //var textVal = yyyy + spliter + mm + spliter + dd;

            //return textVal;
            return moment(today).format($annotationResources.dtformat);
        },
        getTodayDateTime: function () {
            var today = new Date();
            //var dd = today.getDate().toString();
            //var mm = today.getMonth() + 1;
            //var yyyy = today.getFullYear().toString();
            //var hh = today.getHours().toString();
            //var mins = today.getMinutes().toString();
            //var ss = today.getSeconds().toString();

            //return dd + mm.toString() + yyyy + hh + mins + ss;

            return moment(today).format($annotationResources.tmformat);
        },

        getThumbnails: function () {
            successGetThumbnail = false;
            $.messageAnnotation.freezeControl(true);
            $("#DocumentThumbnailContainer .loader").show();
            $("#DocumentThumbnailContainer #thumbnail-list").hide();

            var params = {
                'Name': $('#Name').val(),
                'DocUid': $('#DocUid').val(),
                'DocumentId': $('#DocumentId').val(),
                'DocTypes': $('#DocTypes').val(),
                'MessageId': $("#MessageId").val(),
                'DeselectedPages': $("#DeselectedPages").val(),
            };
            var url = '/annotation/getthumbnails/';
            var source = $('#AnnotationImageSrc').val();

            if (source === 'MessageViewer') {
                params = {
                    'Name': $('#Name').val(),
                    'MessageId': $('#TransactId').val()
                };
                url = '/annotation/retrievethumbnailsmsgviewer/';
            }

            fxcRequest.get(url, params,
                function (data) {
                    if (data && data.ThumbnailImages) {
                        $.messageAnnotation.obj.totalPage = data.ThumbnailImages.length || 0;
                        $.each(data.ThumbnailImages, function (i, thumbnail) {
                            $("#DocumentThumbnailContainer .loader").hide();
                            $("#DocumentThumbnailContainer #thumbnail-list").show();

                            var isActive = i === 0;

                            var page = i + 1;
                            var item = $('<li class="nav-item' + (isActive ? ' active' : '') + '" data-page="' + i + '">');
                            var linkId = 'link-page-' + i;
                            var link = $('<a class="nav-link" id="' + linkId + '" data-page="'+i+'">');
                            var labelId = 'label-page-' + i;
                            var pageNumber = $annotationResources.pg + page;
                            var pageWrapper = $('<div class="thumnbnail-page">');
                            var label = $('<label id="' + labelId + '">');
                            var imgContainer = $('<img class="xf">');

                            link.click(function (e) {
                                var getPage = $(this).attr("data-page");
                                $.messageAnnotation.getMainImage(getPage);
                            });

                            label.html(pageNumber);

                            pageWrapper.append(label);

                            link.append(imgContainer.attr('src', thumbnail.Url));

                            item.append(pageWrapper);
                            item.append(link);
                            $('#thumbnail-list').append(item);
                        });

                        successGetThumbnail = true;
                        $.messageAnnotation.freezeControl(false);
                    } else {

                        $("#DocumentThumbnailContainer .loader").hide();
                        $("#DocumentThumbnailContainer #thumbnail-list").show();

                        swal($globalMessages.swal.error.title, 'Unable to get the thumbnail images!', "error");
                    }
                }, null, false, null, function (data) {
                    $("#DocumentThumbnailContainer .loader").hide();
                    $("#DocumentThumbnailContainer #thumbnail-list").show();

                    swal($globalMessages.swal.error.title, 'Unable to get the thumbnail images!', "error");
                });
        },
        saveImageTemp: function (pageNumber) {
            var dfd = new $.Deferred();
            if ($.messageAnnotation.obj.base_imageSrc != null) {
                $.messageAnnotation.obj.onSelectItem = false;
                $.messageAnnotation.setBtnSelect($.messageAnnotation.obj.type);
                $.messageAnnotation.obj.onHover = false;

                $.drawCanvas.drawAll();
                var saveExistingImg = $.messageAnnotation.result.filter(function (e) { return parseInt(e.page) === parseInt(pageNumber); });

                var getCanvasPage = parseInt($(canvas).attr("data-page"));
                var canvasDataUrl = null;

                if (getCanvasPage == parseInt(pageNumber)) {
                    canvasDataUrl = canvas.toDataURL();
                }

                if (saveExistingImg.length > 0) {
                    saveExistingImg[0].dataUrl = $.messageAnnotation.obj.base_imageSrc;
                    saveExistingImg[0].finalUrl = canvasDataUrl;
                    saveExistingImg[0].displayStack = $.messageAnnotation.displayStack;
                    saveExistingImg[0].redoStack = $.messageAnnotation.redoStack;
                    saveExistingImg[0].fullStack = $.messageAnnotation.fullStack;
                    saveExistingImg[0].action = $.messageAnnotation.action;
                    saveExistingImg[0].drawCount = $.messageAnnotation.drawCount;
                    saveExistingImg[0].trackCount = $.messageAnnotation.trackCount;
                    saveExistingImg[0].rotateAngle = $.messageAnnotation.rotateAngle;
                    saveExistingImg[0].zoom = $.messageAnnotation.zoom;
                    saveExistingImg[0].setZooming = $.messageAnnotation.setZooming;
                    saveExistingImg[0].scrollTop = $("#DocumentCanvasContainer").scrollTop() || 0;
                    saveExistingImg[0].scrollLeft = $("#DocumentCanvasContainer").scrollLeft() || 0;
                    dfd.resolve();
                }
                else {
                    $.messageAnnotation.result.push({
                        page: parseInt(pageNumber),
                        dataUrl: $.messageAnnotation.obj.base_imageSrc,
                        finalUrl: canvasDataUrl,
                        displayStack: $.messageAnnotation.displayStack,
                        redoStack: $.messageAnnotation.redoStack,
                        fullStack: $.messageAnnotation.fullStack,
                        action: $.messageAnnotation.action,
                        drawCount: $.messageAnnotation.drawCount,
                        trackCount: $.messageAnnotation.trackCount,
                        rotateAngle: $.messageAnnotation.rotateAngle,
                        zoom: $.messageAnnotation.zoom,
                        setZooming: $.messageAnnotation.setZooming,
                        scrollTop: $("#DocumentCanvasContainer").scrollTop() || 0,
                        scrollLeft: $("#DocumentCanvasContainer").scrollLeft() || 0
                    });
                    dfd.resolve();
                }
            }
            else {
                dfd.resolve();
            }

            return dfd.promise();
        },
        getMainImage: function (page) {
            successGetMainImage = false;
            $.messageAnnotation.freezeControl(true);

            $("#DocumentCanvasContainer").css("position", "relative");
            $("#DocumentCanvasContainer .loader").show();
            $(".canvasEditArea").hide();

            var call = $.messageAnnotation.saveImageTemp($.messageAnnotation.obj.page);

            $.when(call).then(function (cb) {

                $("#thumbnail-list").children('li').removeClass("active");
                $("#thumbnail-list").children('li[data-page="' + parseInt(page) + '"]').addClass("active");

                var newImg = $.messageAnnotation.result.filter(function (e) { return e.page === parseInt(page); });
                if (newImg.length > 0) {

                    $.messageAnnotation.obj.base_imageSrc = newImg[0].dataUrl;

                    $.messageAnnotation.displayStack = newImg[0].displayStack;
                    $.messageAnnotation.redoStack = newImg[0].redoStack;
                    $.messageAnnotation.fullStack = newImg[0].fullStack;
                    $.messageAnnotation.action = newImg[0].action;
                    $.messageAnnotation.drawCount = newImg[0].drawCount;
                    $.messageAnnotation.trackCount = newImg[0].trackCount;

                    $.messageAnnotation.rotateAngle = newImg[0].rotateAngle;
                    $.messageAnnotation.setZooming = newImg[0].setZooming;
                    $.messageAnnotation.zoom = newImg[0].zoom;

                    successGetMainImage = true;
                    $.drawCanvas.resetDraw(page, newImg[0].scrollLeft, newImg[0].scrollTop);
                }
                else {
                    var params = {
                        'Page': page,
                        'Name': $('#Name').val(),
                        'DocUid': $('#DocUid').val(),
                        'DocumentId': $('#DocumentId').val(),
                        'DocTypes': $('#DocTypes').val(),
                        'MessageId': $("#MessageId").val(),
                        'DeselectedPages': $("#DeselectedPages").val(),
                    };
                    var url = '/annotation/retrieveimage/';
                    var source = $('#AnnotationImageSrc').val();

                    if (source === 'MessageViewer') {
                        params = {
                            'Page': page,
                            'Name': $('#Name').val(),
                            'MessageId': $('#TransactId').val()
                        };
                        url = '/annotation/retrieveimagemsgviewer/';
                    }

                    fxcRequest.get(url, params,
                        function (data) {
                            if (data && data.MainImage) {
                                $.messageAnnotation.obj.base_imageSrc = data.MainImage.Url;
                                successGetMainImage = true;

                                $.messageAnnotation.displayStack = [];
                                $.messageAnnotation.redoStack = [];
                                $.messageAnnotation.fullStack = [];
                                $.messageAnnotation.action = [];
                                $.messageAnnotation.drawCount = 0;
                                $.messageAnnotation.trackCount = 0;

                                $.messageAnnotation.rotateAngle = 0;

                                $.messageAnnotation.setZooming = true;
                                $.messageAnnotation.zoom = 1;

                                $.drawCanvas.resetDraw(page);
                            }
                        }, null, false, null, function (data) {

                            $("#DocumentCanvasContainer").css("position", "initial");
                            $("#DocumentCanvasContainer .loader").hide();
                            $(".canvasEditArea").hide();

                            swal($globalMessages.swal.error.title, data.Value, "error");
                        });
                }
            });
        },
        getMainImageUrl: function (page, callback) {

            var params = {
                'Page': page,
                'Name': $('#Name').val(),
                'DocUid': $('#DocUid').val(),
                'DocumentId': $('#DocumentId').val(),
                'DocTypes': $('#DocTypes').val(),
                'MessageId': $("#MessageId").val(),
                'DeselectedPages': $("#DeselectedPages").val(),
            };
            var url = '/annotation/retrieveimage/';
            var source = $('#AnnotationImageSrc').val();

            if (source === 'MessageViewer') {
                params = {
                    'Page': page,
                    'Name': $('#Name').val(),
                    'MessageId': $('#TransactId').val()
                };
                url = '/annotation/retrieveimagemsgviewer/';
            }

            fxcRequest.get(url, params,
                function (data) {
                    if (data && data.MainImage) {
                        callback.call(this, data);
                    }
                });
        },

        freezeControl: function (disable) {
            /*additional flag here*/
            var completedRequest = successGetThumbnail && successGetMainImage;

            if (!disable && completedRequest) {
                jQuery.each($.messageAnnotation.objButton, function (i, val) {
                    $('.freezeload button#' + val).prop("disabled", "");
                });

                if (!$("#btn-group-zoom button").prop("disabled")) {
                    $(".zoomLabel").removeClass("disabled");
                }

                $("#btn-done-sign").prop("disabled", "");

                $.messageAnnotation.objButton = [];

            } else if (disable) {
                $('.freezeload button:not([disabled])').each(function () {
                    $.messageAnnotation.objButton.push(this.id);
                });

                $('.freezeload button').prop("disabled", "true");
                if ($("#btn-group-zoom button").prop("disabled")) {
                    $(".zoomLabel").addClass("disabled");
                }

                $("#btn-done-sign").prop("disabled", true);
            }
        },
        goclone: function(source) {
            return Object.assign({}, source);
        },
        parseFloat: function (str, val) {
            str = str.toString();
            if (str.indexOf(".") > 0) {
                str = str.slice(0, (str.indexOf(".")) + val + 1);
            }
            return Number(str);
        }
    };

    $.drawCanvas = {
        reOffset: function () {
            $.messageAnnotation.scale = 1;

            $("#AnnotationDiv .divEditor").css("top", $("header").height() + "px");

            var BB = canvas.getBoundingClientRect();
            recOffsetX = BB.left;
            recOffsetY = BB.top;
        },

        handleMouseDown: function (e) {
            if ($(".editor-outer-textarea textarea").val().length > 0) {
                $.drawCanvas.drawTextArea();
                return;
            }

            if (selectedObjChange && selectedShape != null) {
                $.messageAnnotation.obj.onHover = false;
                selectedShape.no = $.messageAnnotation.drawCount;
                selectedShape.fullStackId = $.messageAnnotation.newGuid();

                $.messageAnnotation.displayStack.push(selectedShape);
                $.messageAnnotation.fullStack.push(selectedShape);
                $.messageAnnotation.action.push({
                    id: selectedShape.fullStackId,
                    action: "move"
                });

                $("[data-type='delete']").prop("disabled", false);

                $.messageAnnotation.drawCount++;

                $.drawCanvas.drawAll();

                selectedShape = null;
                selectedObjChange = false;
                $.messageAnnotation.obj.onSelectItem = false;
                $.messageAnnotation.setBtnSelect($.messageAnnotation.obj.type);
                return;
            }

            e.preventDefault();
            e.stopPropagation();

            var getFinalX = parseInt(e.clientX - (recOffsetX * $.messageAnnotation.zoom));
            var getFinalY = parseInt(e.clientY - (recOffsetY * $.messageAnnotation.zoom));

            var getMouseAreaX = e.clientX;
            var getMouseAreaY = startY;
            var rotateTransform = 4; /*X position*/

            if ($.messageAnnotation.rotateAngle == 90 || $.messageAnnotation.rotateAngle == -270) {
                startX = (getFinalY / $.messageAnnotation.zoom);
                startY = base_image.height - (getFinalX / $.messageAnnotation.zoom);
                rotateTransform = 5; /*Y position*/
            }
            else if (Math.abs($.messageAnnotation.rotateAngle) == 180) {
                startX = base_image.width - (getFinalX / $.messageAnnotation.zoom);
                startY = base_image.height - (getFinalY / $.messageAnnotation.zoom);
                rotateTransform = 4; /*X position*/
            }
            else if ($.messageAnnotation.rotateAngle == 270 || $.messageAnnotation.rotateAngle == -90) {
                startX = base_image.width - (getFinalY / $.messageAnnotation.zoom);
                startY = (getFinalX / $.messageAnnotation.zoom);

                getMouseAreaX = base_image.width - e.clientX;
                getMouseAreaY = base_image.height - e.clientY;
                rotateTransform = 5; /*Y position*/
            }
            else {
                startX = getFinalX / $.messageAnnotation.zoom;
                startY = getFinalY / $.messageAnnotation.zoom;
                rotateTransform = 4; /*X position*/
            }

            if (selectedObjChange) {
                return;
            }

            selectedShape = null;
            $.messageAnnotation.obj.onSelectItem = false;
            $.messageAnnotation.setBtnSelect($.messageAnnotation.obj.type);

            if ($.messageAnnotation.obj.type.startsWith("write")) {

                $.drawCanvas.drawAll();
                $("[data-type='delete']").prop("disabled", false);

                $(".editor-outer-textarea textarea").css("display", "initial");
                $(".editor-outer-textarea textarea").css("padding-left", "6px");
                $(".editor-outer-textarea textarea").css("color", $.messageAnnotation.obj.color);
                var fontSize = parseInt($.messageAnnotation.obj.fontSize);
                var minHeight = fontSize + 10;
                var fontHeight = fontSize + gap;

                var getMargin = parseInt($(canvas).css("margin-left"));
                var getTranslateX = parseInt($(canvas).css("transform").split(',')[rotateTransform]) || 0;

                var textAreaX = (getFinalX / $.messageAnnotation.zoom) + getMargin - Math.abs(getTranslateX);
                var textAreaY = (getFinalY / $.messageAnnotation.zoom) - (fontSize / 2);

                $(".editor-outer-textarea textarea").css("transform", "matrix(1, 0, 0, 1, " + textAreaX + "," + textAreaY + ")");

                $(".editor-outer-textarea textarea").css("font", fontSize + "px / " + fontHeight + "px " + $.messageAnnotation.obj.fontFamily + "");

                context.font = fontSize + "px / " + fontHeight + "px " + $.messageAnnotation.obj.fontFamily + "";

                var keyWidth = 1.3;
                if (fontSize < 15) {
                    keyWidth = 1.6;
                }
                else if (fontSize < 25) {
                    keyWidth = 1.4;
                }

                if ($.messageAnnotation.obj.type == "writeDate") {
                    var contentArea = $.messageAnnotation.getTodayDate("\\");
                    var minLength = contentArea.length > 0 ? contentArea.length : 2;
                    $(".editor-outer-textarea textarea").val(contentArea);

                    var metrics = context.measureText("9999\99\99");
                    var testWidth = metrics.width;

                    $(".editor-outer-textarea textarea").css("width", (testWidth * keyWidth) + "px");
                    $(".editor-outer-textarea textarea").css("height", fontHeight + "px");
                    $(".editor-outer-textarea textarea").css("min-width", "");
                    $(".editor-outer-textarea textarea").css("min-height", "");
                }
                else if ($.messageAnnotation.obj.type == "write") {
                    $(".editor-outer-textarea textarea").val("");

                    var metric = context.measureText("wwwwwwwwww");
                    var testWidth = metric.width;

                    var metric2 = context.measureText("w");
                    var testMinWidth = metric2.width;

                    $(".editor-outer-textarea textarea").css("min-width", (testMinWidth * keyWidth) + "px");
                    $(".editor-outer-textarea textarea").css("min-height", fontHeight + "px");
                    $(".editor-outer-textarea textarea").css("width", (testWidth * keyWidth) + "px");
                    $(".editor-outer-textarea textarea").css("height", "");
                }

                $(".editor-outer-textarea textarea").attr("data-type", $.messageAnnotation.obj.type);
                $(".editor-outer-textarea textarea").focus();

                return;
            }

            $("[data-type='delete']").prop("disabled", true);

            for (var i = $.messageAnnotation.displayStack.length - 1, obj; obj = $.messageAnnotation.displayStack[i]; i--) {
                var leftPos = Math.min(obj.startX, obj.mouseX);
                var rightPos = Math.max(obj.startX, obj.mouseX);
                var topPos = Math.min(obj.startY, obj.mouseY);
                var bottomPos = Math.max(obj.startY, obj.mouseY);

                let path1 = new Path2D();

                if (obj.type == "draw-square-o") {
                    let path2 = new Path2D();

                    var lineWidth = 6;

                    path1.rect(leftPos - lineWidth, topPos - lineWidth, rightPos - leftPos + (lineWidth * 2), bottomPos - topPos + (lineWidth * 2));
                    path2.rect(leftPos + lineWidth, topPos + lineWidth, rightPos - leftPos - (lineWidth * 2), bottomPos - topPos - (lineWidth * 2));

                    if (context.isPointInPath(path1, mouseX, mouseY) && !context.isPointInPath(path2, mouseX, mouseY)) {
                        selectedShape = $.messageAnnotation.goclone(obj);
                        $("[data-type='delete']").prop("disabled", false);

                        $("#btn-draw-shape > .command").attr("data-type", obj.type);
                        $.messageAnnotation.setBtnSelect(obj.type);

                        $.messageAnnotation.obj.onSelectItem = true;
                        $.drawCanvas.drawAll();
                    }
                }
                else if (obj.type == "draw-square") {
                    path1.rect(leftPos, topPos, rightPos - leftPos, bottomPos - topPos);

                    if (context.isPointInPath(path1, mouseX, mouseY)) {
                        selectedShape = $.messageAnnotation.goclone(obj);
                        $("[data-type='delete']").prop("disabled", false);

                        $("#btn-draw-shape > .command").attr("data-type", obj.type);
                        $.messageAnnotation.setBtnSelect(obj.type);

                        $.messageAnnotation.obj.onSelectItem = true;
                        $.drawCanvas.drawAll();
                    }
                }
                else if (obj.type == "draw-circle-o") {
                    var radiusX = (obj.mouseX - obj.startX) * 0.5,
                        radiusY = (obj.mouseY - obj.startY) * 0.5,
                        centerX = obj.startX + radiusX,
                        centerY = obj.startY + radiusY,
                        step = 0.1,
                        a = 0,
                        pi2 = Math.PI * 2 + step,
                        finala = 0;

                    path1.moveTo(centerX + radiusX * Math.cos(0), centerY + radiusY * Math.sin(0));

                    for (; a < pi2; a += step) {
                        finala = a;
                        path1.lineTo(centerX + radiusX * Math.cos(a), centerY + radiusY * Math.sin(a));
                    }

                    if (finala < pi2 && a > pi2) {
                        path1.lineTo(centerX + radiusX * Math.cos(pi2), centerY + radiusY * Math.sin(pi2));
                    }

                    if (context.isPointInStroke(path1, mouseX, mouseY)) {
                        selectedShape = $.messageAnnotation.goclone(obj);
                        $("[data-type='delete']").prop("disabled", false);

                        $("#btn-draw-shape > .command").attr("data-type", obj.type);
                        $.messageAnnotation.setBtnSelect(obj.type);

                        $.messageAnnotation.obj.onSelectItem = true;
                        $.drawCanvas.drawAll();
                    }
                }
                else if (obj.type == "draw-circle") {
                    var radiusX = (obj.mouseX - obj.startX) * 0.5,
                        radiusY = (obj.mouseY - obj.startY) * 0.5,
                        centerX = obj.startX + radiusX,
                        centerY = obj.startY + radiusY,
                        step = 0.1,
                        a = 0,
                        pi2 = Math.PI * 2 + step,
                        finala = 0;

                    path1.moveTo(centerX + radiusX * Math.cos(0), centerY + radiusY * Math.sin(0));

                    for (; a < pi2; a += step) {
                        finala = a;
                        path1.lineTo(centerX + radiusX * Math.cos(a), centerY + radiusY * Math.sin(a));
                    }

                    if (finala < pi2 && a > pi2) {
                        path1.lineTo(centerX + radiusX * Math.cos(pi2), centerY + radiusY * Math.sin(pi2));
                    }

                    if (context.isPointInPath(path1, mouseX, mouseY)) {
                        selectedShape = $.messageAnnotation.goclone(obj);
                        $("[data-type='delete']").prop("disabled", false);

                        $("#btn-draw-shape > .command").attr("data-type", obj.type);
                        $.messageAnnotation.setBtnSelect(obj.type);

                        $.messageAnnotation.obj.onSelectItem = true;
                        $.drawCanvas.drawAll();
                    }
                }
                else if (obj.type == "draw-line") {
                    path1.moveTo(obj.startX, obj.startY);
                    path1.lineTo(obj.mouseX, obj.mouseY);
                    if (context.isPointInStroke(path1, mouseX, mouseY)) {
                        selectedShape = $.messageAnnotation.goclone(obj);
                        $("[data-type='delete']").prop("disabled", false);

                        $("#btn-draw-line > .command").attr("data-type", obj.type);
                        $.messageAnnotation.setBtnSelect(obj.type);

                        $.messageAnnotation.obj.onSelectItem = true;
                        $.drawCanvas.drawAll();
                    }
                }
                else if (obj.type == "draw-arrow") {
                    var lineWidth = parseInt(obj.lineWidth);
                    var minLineWidth = lineWidth > 4 ? lineWidth * 2.5 : lineWidth * 10;
                    var maxLineWidth = lineWidth > 4 ? lineWidth * 5 : lineWidth * 20;
                    const dx = obj.mouseX - obj.startX;
                    const dy = obj.mouseY - obj.startY;
                    var baseHeadlen = Math.sqrt(dx * dx + dy * dy) * 0.2;
                    var ratio = 6;
                    if (baseHeadlen > maxLineWidth) {
                        baseHeadlen = maxLineWidth;
                    }
                    else if (baseHeadlen < minLineWidth) {
                        baseHeadlen = minLineWidth;
                        ratio = 8;
                    }

                    var headlen = baseHeadlen;
                    const angle = Math.atan2(dy, dx);

                    path1.moveTo(obj.startX, obj.startY);
                    path1.lineTo(obj.mouseX, obj.mouseY);

                    path1.moveTo(obj.mouseX - headlen * Math.cos(angle - Math.PI / ratio), obj.mouseY - headlen * Math.sin(angle - Math.PI / ratio));
                    path1.lineTo(obj.mouseX, obj.mouseY);
                    path1.lineTo(obj.mouseX - headlen * Math.cos(angle + Math.PI / ratio), obj.mouseY - headlen * Math.sin(angle + Math.PI / ratio));
                    if (context.isPointInStroke(path1, mouseX, mouseY)) {
                        selectedShape = $.messageAnnotation.goclone(obj);
                        $("[data-type='delete']").prop("disabled", false);

                        $("#btn-draw-line > .command").attr("data-type", obj.type);
                        $.messageAnnotation.setBtnSelect(obj.type);

                        $.messageAnnotation.obj.onSelectItem = true;
                        $.drawCanvas.drawAll();
                    }
                }
                else if (obj.type.startsWith("write")) {
                    var rectX = obj.startX;
                    var rectY = obj.startY;
                    context.save();

                    if (obj.rotateAngle == 90 || obj.rotateAngle == -270) {
                        context.translate(obj.rectStartX + gap, obj.rectStartY);
                        context.rotate(-obj.rotateAngle * Math.PI / 180);
                        rectX = 0;
                        rectY = 0;

                        path1.rect(rectX - gap, rectY - (obj.minHeight / 2), obj.widthRectMax, obj.heightRect);
                    }
                    else if (Math.abs(obj.rotateAngle) == 180) {
                        context.translate(obj.rectStartX, obj.rectStartY - 8);
                        context.rotate(obj.rotateAngle * Math.PI / 180);
                        rectX = 0;
                        rectY = 0;

                        path1.rect(rectX - gap, rectY - (obj.minHeight / 2), obj.widthRectMax, obj.heightRect);
                    }
                    else if (obj.rotateAngle == -90 || obj.rotateAngle == 270) {
                        context.translate(obj.rectStartX - 8, obj.rectStartY);
                        context.rotate(-obj.rotateAngle * Math.PI / 180);
                        rectX = 0;
                        rectY = 0;

                        path1.rect(rectX - gap, rectY - (obj.minHeight / 2), obj.widthRectMax, obj.heightRect);
                    }
                    else {
                        path1.rect(obj.rectStartX - gap, obj.rectStartY - (parseInt(obj.fontSize) / 2), obj.widthRectMax, obj.heightRect);
                    }

                    if (context.isPointInPath(path1, mouseX, mouseY)) {
                        selectedShape = $.messageAnnotation.goclone(obj);
                        $("[data-type='delete']").prop("disabled", false);

                        if (obj.type = "writeDate") {
                            $.messageAnnotation.setBtnSelect(obj.type);
                        }
                        else if (obj.type = "write") {
                            $.messageAnnotation.setBtnSelect(obj.type);
                        }

                        $.messageAnnotation.obj.onSelectItem = true;
                        context.restore();
                        $.drawCanvas.drawAll();
                    }
                    context.restore();
                }
                else if (obj.type == "attachImage") {

                    var rectX = obj.startX;
                    var rectY = obj.startY;
                    context.save();

                    context.translate(obj.startX, obj.startY);
                    context.rotate(-obj.rotateAngle * Math.PI / 180);

                    path1.rect(rectX, rectY, obj.imgWidth, obj.imgHeight);

                    if (context.isPointInPath(path1, mouseX, mouseY)) {
                        selectedShape = $.messageAnnotation.goclone(obj);
                        $("[data-type='delete']").prop("disabled", false);
                        $.messageAnnotation.obj.onSelectItem = true;
                        context.restore();
                    }

                    context.restore();
                }
            }

            if ($.messageAnnotation.obj.onHover && moveShape != null) {
                isMoveDown = true;
                isResize = false;
                $.messageAnnotation.redoStack = [];
            }
            else if ($.messageAnnotation.obj.onHover && resizeShape != null) {
                isMoveDown = false;
                isResize = true;
                $.messageAnnotation.redoStack = [];
            }
            else if ($.messageAnnotation.obj.type != "" && !$.messageAnnotation.obj.onSelectItem) {
                isDrawDown = true;
                if ($.messageAnnotation.trackCount == $.messageAnnotation.drawCount) {
                    $.messageAnnotation.fullStack = $.messageAnnotation.fullStack.slice(0, $.messageAnnotation.trackCount);
                }
            }
        },

        handleMouseUp: function (e) {
            e.preventDefault();
            e.stopPropagation();

            mouseX = parseInt(e.clientX - recOffsetX);
            mouseY = parseInt(e.clientY - recOffsetY);

            if (isDrawDown) {
                isDrawDown = false;

                if (newShape != null && newShape.type != "" &&
                    !(newShape.mouseX == newShape.startX && newShape.mouseY == newShape.startY) &&
                    ($.messageAnnotation.displayStack.findIndex((e) => e.id === newShape.id)) === -1) {
                    $.messageAnnotation.displayStack.push(newShape);
                    $.messageAnnotation.fullStack.push(newShape);
                    $.messageAnnotation.redoStack = [];

                    $.messageAnnotation.action.push({
                        id: newShape.fullStackId,
                        action: "add"
                    });

                    $.messageAnnotation.drawCount++;
                    $.drawCanvas.drawAll();

                    newShape = null;

                    return;
                }
            }

            if (isMoveDown) {
                isMoveDown = false;
                $.messageAnnotation.obj.onHover = false;
                moveShape = null;
                
                if (newShape != null) {
                    selectedShape = $.messageAnnotation.goclone(newShape);
                    $.messageAnnotation.displayStack.push(newShape);
                    $.messageAnnotation.fullStack.push(newShape);
                    $.messageAnnotation.action.push({
                        id: newShape.fullStackId,
                        action: "move"
                    });

                    $("[data-type='delete']").prop("disabled", false);

                    $.messageAnnotation.drawCount++;

                    $.drawCanvas.drawAll();

                    newShape = null;

                    return;
                }
            }

            if (isResize && newShape != null) {
                isResize = false;
                $.messageAnnotation.obj.onHover = false;
                resizeShape = null;
                $.messageAnnotation.displayStack.push(newShape);
                $.messageAnnotation.fullStack.push(newShape);
                $.messageAnnotation.action.push({
                    id: newShape.fullStackId,
                    action: "resize"
                });

                $("[data-type='delete']").prop("disabled", false);

                $.messageAnnotation.drawCount++;

                $.drawCanvas.drawAll();
                newShape = null;
                return;
            }

            if (selectedObjChange && selectedShape != null) {
                $.messageAnnotation.obj.onHover = false;

                selectedShape.no = $.messageAnnotation.drawCount;
                selectedShape.fullStackId = $.messageAnnotation.newGuid();

                $.messageAnnotation.displayStack.push(selectedShape);
                $.messageAnnotation.fullStack.push(selectedShape);
                $.messageAnnotation.action.push({
                    id: selectedShape.fullStackId,
                    action: "move"
                });

                $("[data-type='delete']").prop("disabled", false);

                $.messageAnnotation.drawCount++;

                $.drawCanvas.drawAll();

                selectedShape = null;
                selectedObjChange = false;
                $.messageAnnotation.obj.onSelectItem = false;

                return;
            }
        },

        handleMouseOut: function (e) {
            if (!isDrawDown && !isMoveDown && !isResize) {
                return;
            }
            e.preventDefault();
            e.stopPropagation();

            mouseX = parseInt(e.clientX - recOffsetX);
            mouseY = parseInt(e.clientY - recOffsetY);

            /*if (isDrawDown) {
                isDrawDown = false;

                if (newShape.type != "" &&
                    !(newShape.mouseX == newShape.startX && newShape.mouseY == newShape.startY) &&
                    ($.messageAnnotation.displayStack.findIndex((e) => e.id === newShape.id)) === -1) {
                    $.messageAnnotation.displayStack.push(newShape);
                    $.messageAnnotation.fullStack.push(newShape);
                    $.messageAnnotation.action.push({
                        id: newShape.fullStackId,
                        action: "add"
                    });
                    $.messageAnnotation.drawCount++;
                }

                $.drawCanvas.drawAll();
            }
            */
        },

        handleMouseMove: function (e) {
            var getFinalX = parseInt(e.clientX - (recOffsetX * $.messageAnnotation.zoom));
            var getFinalY = parseInt(e.clientY - (recOffsetY * $.messageAnnotation.zoom));

            if ($.messageAnnotation.rotateAngle == 90 || $.messageAnnotation.rotateAngle == -270) {
                mouseX = (getFinalY / $.messageAnnotation.zoom);
                mouseY = base_image.height - (getFinalX / $.messageAnnotation.zoom);
            }
            else if (Math.abs($.messageAnnotation.rotateAngle) == 180) {
                mouseX = base_image.width - (getFinalX / $.messageAnnotation.zoom);
                mouseY = base_image.height - (getFinalY / $.messageAnnotation.zoom);
            }
            else if ($.messageAnnotation.rotateAngle == 270 || $.messageAnnotation.rotateAngle == -90) {
                mouseX = base_image.width - (getFinalY / $.messageAnnotation.zoom);
                mouseY = (getFinalX / $.messageAnnotation.zoom);
            }
            else {
                mouseX = getFinalX / $.messageAnnotation.zoom;
                mouseY = getFinalY / $.messageAnnotation.zoom;
            }

            if (!isDrawDown && !isMoveDown && !isResize && !selectedObjChange) {
                if ($.messageAnnotation.obj.type == "move") {
                    $.messageAnnotation.obj.onHover = false;
                    canvas.style.cursor = cursorDefault;

                    moveShape = null;
                    resizeShape = null;

                    for (var i = $.messageAnnotation.displayStack.length - 1, obj; obj = $.messageAnnotation.displayStack[i]; i--) {
                        var leftPos = Math.min(obj.startX, obj.mouseX);
                        var rightPos = Math.max(obj.startX, obj.mouseX);
                        var topPos = Math.min(obj.startY, obj.mouseY);
                        var bottomPos = Math.max(obj.startY, obj.mouseY);

                        context.lineWidth = obj.lineWidth;
                        let path1 = new Path2D();
                        if (obj.type == "draw-square-o") {
                            var lineWidth = parseInt(obj.lineWidth);

                            path1 = new Path2D(); /*topLeftDot dot*/
                            path1.arc(leftPos, topPos, lineWidth * 2, 0, Math.PI * 2, true);
                            var topLeftDot = context.isPointInPath(path1, mouseX, mouseY);

                            path1 = new Path2D(); /*topRightDot dot*/
                            path1.arc(leftPos + rightPos - leftPos, topPos, lineWidth * 2, 0, Math.PI * 2, true);
                            var topRightDot = context.isPointInPath(path1, mouseX, mouseY);

                            path1 = new Path2D(); /*bottomLeftDot dot*/
                            path1.arc(leftPos, topPos + bottomPos - topPos, lineWidth * 2, 0, Math.PI * 2, true);
                            var bottomLeftDot = context.isPointInPath(path1, mouseX, mouseY);

                            path1 = new Path2D(); /*bottomRightDot dot*/
                            path1.arc(leftPos + rightPos - leftPos, topPos + bottomPos - topPos, lineWidth * 2, 0, Math.PI * 2, true);
                            var bottomRightDot = context.isPointInPath(path1, mouseX, mouseY);

                            path1 = new Path2D(); /*outlineRect*/
                            path1.rect(leftPos, topPos, rightPos - leftPos, bottomPos - topPos);
                            var outlineRect = context.isPointInStroke(path1, mouseX, mouseY);

                            if (topLeftDot) {
                                $.messageAnnotation.obj.onHover = true;
                                $.messageAnnotation.obj.resize = "north-west";
                                resizeShape = obj;
                                canvas.style.cursor = cursorNorthWest;
                            }
                            else if (topRightDot) {
                                $.messageAnnotation.obj.onHover = true;
                                $.messageAnnotation.obj.resize = "north-east";
                                resizeShape = obj;
                                canvas.style.cursor = cursorNorthEast;
                            }
                            else if (bottomLeftDot) {
                                $.messageAnnotation.obj.onHover = true;
                                $.messageAnnotation.obj.resize = "south-west";
                                resizeShape = obj;
                                canvas.style.cursor = cursorSouthWest;
                            }
                            else if (bottomRightDot) {
                                $.messageAnnotation.obj.onHover = true;
                                $.messageAnnotation.obj.resize = "south-east";
                                resizeShape = obj;
                                canvas.style.cursor = cursorSouthEast;
                            }
                            else if (outlineRect) {
                                $.messageAnnotation.obj.onHover = true;

                                moveShape = obj;
                                canvas.style.cursor = cursorMove;
                            }
                        }
                        else if (obj.type == "draw-square") {
                            var lineWidth = 6;

                            path1 = new Path2D(); /*topLeftDot dot*/
                            path1.arc(leftPos, topPos, lineWidth * 2, 0, Math.PI * 2, true);
                            var topLeftDot = context.isPointInPath(path1, mouseX, mouseY);

                            path1 = new Path2D(); /*topRightDot dot*/
                            path1.arc(leftPos + rightPos - leftPos, topPos, lineWidth * 2, 0, Math.PI * 2, true);
                            var topRightDot = context.isPointInPath(path1, mouseX, mouseY);

                            path1 = new Path2D(); /*bottomLeftDot dot*/
                            path1.arc(leftPos, topPos + bottomPos - topPos, lineWidth * 2, 0, Math.PI * 2, true);
                            var bottomLeftDot = context.isPointInPath(path1, mouseX, mouseY);

                            path1 = new Path2D(); /*bottomRightDot dot*/
                            path1.arc(leftPos + rightPos - leftPos, topPos + bottomPos - topPos, lineWidth * 2, 0, Math.PI * 2, true);
                            var bottomRightDot = context.isPointInPath(path1, mouseX, mouseY);

                            path1 = new Path2D(); /*fullRect*/
                            path1.rect(leftPos, topPos, rightPos - leftPos, bottomPos - topPos);
                            var fullRect = context.isPointInPath(path1, mouseX, mouseY);

                            if (topLeftDot) {
                                $.messageAnnotation.obj.onHover = true;
                                $.messageAnnotation.obj.resize = "north-west";
                                resizeShape = obj;
                                canvas.style.cursor = cursorNorthWest;
                            }
                            else if (topRightDot) {
                                $.messageAnnotation.obj.onHover = true;
                                $.messageAnnotation.obj.resize = "north-east";
                                resizeShape = obj;
                                canvas.style.cursor = cursorNorthEast;
                            }
                            else if (bottomLeftDot) {
                                $.messageAnnotation.obj.onHover = true;
                                $.messageAnnotation.obj.resize = "south-west";
                                resizeShape = obj;
                                canvas.style.cursor = cursorSouthWest;
                            }
                            else if (bottomRightDot) {
                                $.messageAnnotation.obj.onHover = true;
                                $.messageAnnotation.obj.resize = "south-east";
                                resizeShape = obj;
                                canvas.style.cursor = cursorSouthEast;
                            }
                            else if (fullRect) {
                                $.messageAnnotation.obj.onHover = true;

                                moveShape = obj;
                                canvas.style.cursor = cursorMove;
                            }
                        }
                        else if (obj.type == "draw-circle-o") {
                            var lineWidth = 6;

                            path1 = new Path2D(); /*topLeftDot dot*/
                            path1.arc(leftPos - lineWidth, topPos - lineWidth, lineWidth * 2, 0, Math.PI * 2, true);
                            var topLeftDot = context.isPointInPath(path1, mouseX, mouseY);

                            path1 = new Path2D(); /*topRightDot dot*/
                            path1.arc(leftPos + rightPos - leftPos + lineWidth, topPos - lineWidth, lineWidth * 2, 0, Math.PI * 2, true);
                            var topRightDot = context.isPointInPath(path1, mouseX, mouseY);

                            path1 = new Path2D(); /*bottomLeftDot dot*/
                            path1.arc(leftPos - lineWidth, topPos + bottomPos - topPos + lineWidth, lineWidth * 2, 0, Math.PI * 2, true);
                            var bottomLeftDot = context.isPointInPath(path1, mouseX, mouseY);

                            path1 = new Path2D(); /*bottomRightDot dot*/
                            path1.arc(leftPos + rightPos - leftPos + lineWidth, topPos + bottomPos - topPos + lineWidth, lineWidth * 2, 0, Math.PI * 2, true);
                            var bottomRightDot = context.isPointInPath(path1, mouseX, mouseY);

                            path1 = new Path2D(); /*cicle intersect*/
                            var radiusX = (obj.mouseX - obj.startX) * 0.5,
                                radiusY = (obj.mouseY - obj.startY) * 0.5,
                                centerX = obj.startX + radiusX,
                                centerY = obj.startY + radiusY,
                                step = 0.1,
                                a = 0,
                                pi2 = Math.PI * 2 + step,
                                finala = 0;

                            path1.moveTo(centerX + radiusX * Math.cos(0), centerY + radiusY * Math.sin(0));

                            for (; a < pi2; a += step) {
                                finala = a;
                                path1.lineTo(centerX + radiusX * Math.cos(a), centerY + radiusY * Math.sin(a));
                            }

                            if (finala < pi2 && a > pi2) {
                                path1.lineTo(centerX + radiusX * Math.cos(pi2), centerY + radiusY * Math.sin(pi2));
                            }
                            var circleIntersect = context.isPointInStroke(path1, mouseX, mouseY)

                            if (topLeftDot) {
                                $.messageAnnotation.obj.onHover = true;
                                $.messageAnnotation.obj.resize = "north-west";
                                resizeShape = obj;
                                canvas.style.cursor = cursorNorthWest;
                            }
                            else if (topRightDot) {
                                $.messageAnnotation.obj.onHover = true;
                                $.messageAnnotation.obj.resize = "north-east";
                                resizeShape = obj;
                                canvas.style.cursor = cursorNorthEast;
                            }
                            else if (bottomLeftDot) {
                                $.messageAnnotation.obj.onHover = true;
                                $.messageAnnotation.obj.resize = "south-west";
                                resizeShape = obj;
                                canvas.style.cursor = cursorSouthWest;
                            }
                            else if (bottomRightDot) {
                                $.messageAnnotation.obj.onHover = true;
                                $.messageAnnotation.obj.resize = "south-east";
                                resizeShape = obj;
                                canvas.style.cursor = cursorSouthEast;
                            }
                            else if (circleIntersect) {
                                $.messageAnnotation.obj.onHover = true;
                                moveShape = obj;
                                canvas.style.cursor = cursorMove;
                            }
                        }
                        else if (obj.type == "draw-circle") {
                            var lineWidth = 6;

                            path1 = new Path2D(); /*topLeftDot dot*/
                            path1.arc(leftPos - lineWidth, topPos - lineWidth, lineWidth * 2, 0, Math.PI * 2, true);
                            var topLeftDot = context.isPointInPath(path1, mouseX, mouseY);

                            path1 = new Path2D(); /*topRightDot dot*/
                            path1.arc(leftPos + rightPos - leftPos + lineWidth, topPos - lineWidth, lineWidth * 2, 0, Math.PI * 2, true);
                            var topRightDot = context.isPointInPath(path1, mouseX, mouseY);

                            path1 = new Path2D(); /*bottomLeftDot dot*/
                            path1.arc(leftPos - lineWidth, topPos + bottomPos - topPos + lineWidth, lineWidth * 2, 0, Math.PI * 2, true);
                            var bottomLeftDot = context.isPointInPath(path1, mouseX, mouseY);

                            path1 = new Path2D(); /*bottomRightDot dot*/
                            path1.arc(leftPos + rightPos - leftPos + lineWidth, topPos + bottomPos - topPos + lineWidth, lineWidth * 2, 0, Math.PI * 2, true);
                            var bottomRightDot = context.isPointInPath(path1, mouseX, mouseY);

                            path1 = new Path2D(); /*cicle intersect*/
                            var radiusX = (obj.mouseX - obj.startX) * 0.5,
                                radiusY = (obj.mouseY - obj.startY) * 0.5,
                                centerX = obj.startX + radiusX,
                                centerY = obj.startY + radiusY,
                                step = 0.1,
                                a = 0,
                                pi2 = Math.PI * 2 + step,
                                finala = 0;

                            path1.moveTo(centerX + radiusX * Math.cos(0), centerY + radiusY * Math.sin(0));

                            for (; a < pi2; a += step) {
                                finala = a;
                                path1.lineTo(centerX + radiusX * Math.cos(a), centerY + radiusY * Math.sin(a));
                            }

                            if (finala < pi2 && a > pi2) {
                                path1.lineTo(centerX + radiusX * Math.cos(pi2), centerY + radiusY * Math.sin(pi2));
                            }
                            var circleIntersect = context.isPointInPath(path1, mouseX, mouseY)

                            if (topLeftDot) {
                                $.messageAnnotation.obj.onHover = true;
                                $.messageAnnotation.obj.resize = "north-west";
                                resizeShape = obj;
                                canvas.style.cursor = cursorNorthWest;
                            }
                            else if (topRightDot) {
                                $.messageAnnotation.obj.onHover = true;
                                $.messageAnnotation.obj.resize = "north-east";
                                resizeShape = obj;
                                canvas.style.cursor = cursorNorthEast;
                            }
                            else if (bottomLeftDot) {
                                $.messageAnnotation.obj.onHover = true;
                                $.messageAnnotation.obj.resize = "south-west";
                                resizeShape = obj;
                                canvas.style.cursor = cursorSouthWest;
                            }
                            else if (bottomRightDot) {
                                $.messageAnnotation.obj.onHover = true;
                                $.messageAnnotation.obj.resize = "south-east";
                                resizeShape = obj;
                                canvas.style.cursor = cursorSouthEast;
                            }
                            else if (circleIntersect) {
                                $.messageAnnotation.obj.onHover = true;
                                moveShape = obj;
                                canvas.style.cursor = cursorMove;
                            }
                        }
                        else if (obj.type == "draw-line") {
                            var lineWidth = parseInt(obj.lineWidth);

                            path1 = new Path2D(); /*first dot*/
                            path1.arc(obj.startX, obj.startY, lineWidth * 2, 0, Math.PI * 2, true);
                            var firstDot = context.isPointInPath(path1, mouseX, mouseY);

                            path1 = new Path2D(); /*second dot*/
                            path1.arc(obj.mouseX, obj.mouseY, lineWidth * 2, 0, Math.PI * 2, true);
                            var secondDot = context.isPointInPath(path1, mouseX, mouseY);

                            path1 = new Path2D(); /*line*/
                            path1.moveTo(obj.startX, obj.startY);
                            path1.lineTo(obj.mouseX, obj.mouseY);
                            var linePoint = context.isPointInStroke(path1, mouseX, mouseY);

                            if (firstDot) {
                                $.messageAnnotation.obj.onHover = true;
                                $.messageAnnotation.obj.resize = "east-west-1";
                                resizeShape = obj;
                                canvas.style.cursor = cursorEastWest;
                            }
                            else if (secondDot) {
                                $.messageAnnotation.obj.onHover = true;
                                $.messageAnnotation.obj.resize = "east-west-2";
                                resizeShape = obj;
                                canvas.style.cursor = cursorEastWest;
                            }
                            else if (linePoint) {
                                $.messageAnnotation.obj.onHover = true;

                                moveShape = obj;

                                canvas.style.cursor = cursorMove;
                            }
                        }
                        else if (obj.type == "draw-arrow") {
                            var lineWidth = parseInt(obj.lineWidth);

                            path1 = new Path2D(); /*first dot*/
                            path1.arc(obj.startX, obj.startY, lineWidth * 2, 0, Math.PI * 2, true);
                            var firstDot = context.isPointInPath(path1, mouseX, mouseY);

                            path1 = new Path2D(); /*second dot*/
                            path1.arc(obj.mouseX, obj.mouseY, lineWidth * 2, 0, Math.PI * 2, true);
                            var secondDot = context.isPointInPath(path1, mouseX, mouseY);

                            path1 = new Path2D(); /*line*/
                            var minLineWidth = lineWidth > 4 ? lineWidth * 2.5 : lineWidth * 10;
                            var maxLineWidth = lineWidth > 4 ? lineWidth * 5 : lineWidth * 20;
                            const dx = obj.mouseX - obj.startX;
                            const dy = obj.mouseY - obj.startY;
                            var baseHeadlen = Math.sqrt(dx * dx + dy * dy) * 0.2;
                            var ratio = 6;
                            if (baseHeadlen > maxLineWidth) {
                                baseHeadlen = maxLineWidth;
                            }
                            else if (baseHeadlen < minLineWidth) {
                                baseHeadlen = minLineWidth;
                                ratio = 8;
                            }

                            var headlen = baseHeadlen;
                            const angle = Math.atan2(dy, dx);
                            path1.moveTo(obj.startX, obj.startY);
                            path1.lineTo(obj.mouseX, obj.mouseY);
                            path1.moveTo(obj.mouseX - headlen * Math.cos(angle - Math.PI / ratio), obj.mouseY - headlen * Math.sin(angle - Math.PI / ratio));
                            path1.lineTo(obj.mouseX, obj.mouseY);
                            path1.lineTo(obj.mouseX - headlen * Math.cos(angle + Math.PI / ratio), obj.mouseY - headlen * Math.sin(angle + Math.PI / ratio));
                            var linePoint = context.isPointInStroke(path1, mouseX, mouseY);
                            
                            if (firstDot) {
                                $.messageAnnotation.obj.onHover = true;
                                $.messageAnnotation.obj.resize = "east-west-1";
                                resizeShape = obj;
                                canvas.style.cursor = cursorEastWest;
                            }
                            else if (secondDot) {
                                $.messageAnnotation.obj.onHover = true;
                                $.messageAnnotation.obj.resize = "east-west-2";
                                resizeShape = obj;
                                canvas.style.cursor = cursorEastWest;
                            }
                            else if (linePoint) {
                                $.messageAnnotation.obj.onHover = true;

                                moveShape = obj;

                                canvas.style.cursor = cursorMove;
                            }
                        }
                        else if (obj.type.startsWith("write")) {
                            path1 = new Path2D(); /*topLeftDot dot*/

                            context.textBaseline = "middle";
                            context.save();

                            var rectX = obj.startX;
                            var rectY = obj.startY;
                            var newX1 = 0;
                            var newY1 = 0;
                            var newWidth = obj.widthRectMax;
                            var newHeight = obj.heightRect;

                            if (obj.rotateAngle == 90 || obj.rotateAngle == -270) {
                                context.translate(obj.rectStartX + gap, obj.rectStartY);
                                context.rotate(-obj.rotateAngle * Math.PI / 180);
                                rectX = 0;
                                rectY = 0;
                            }
                            else if (Math.abs(obj.rotateAngle) == 180) {
                                context.translate(obj.rectStartX, obj.rectStartY - 8);
                                context.rotate(obj.rotateAngle * Math.PI / 180);
                                rectX = 0;
                                rectY = 0;
                            }
                            else if (obj.rotateAngle == -90 || obj.rotateAngle == 270) {
                                context.translate(obj.rectStartX - 8, obj.rectStartY);
                                context.rotate(-obj.rotateAngle * Math.PI / 180);
                                rectX = 0;
                                rectY = 0;
                            }
                            

                            if (Math.abs(obj.rotateAngle) == 90 || Math.abs(obj.rotateAngle) == 270 || Math.abs(obj.rotateAngle) == 180) {
                                newX1 = rectX - gap - 5;
                                newY1 = rectY - (obj.minHeight / 2) - 5;

                                newWidth = newWidth + gap + 5;
                            }
                            else {
                                newX1 = obj.rectStartX - gap - 5;
                                newY1 = obj.rectStartY - (parseInt(obj.fontSize) / 2);
                                newWidth = newWidth + gap + 5;
                            }

                            context.lineWidth = lineWidth / 2;
                            path1.rect(newX1, newY1, newWidth, newHeight);

                            var rectPoint = context.isPointInPath(path1, mouseX, mouseY);

                            if (rectPoint) {
                                $.messageAnnotation.obj.onHover = true;

                                moveShape = obj;
                                canvas.style.cursor = cursorMove;
                            }
                            context.restore();
                        }
                        else if (obj.type == "attachImage") {

                            var rectX = obj.startX;
                            var rectY = obj.startY;
                            context.save();

                            if (obj.rotateAngle != 0) {

                                context.translate(obj.startX, obj.startY);
                                context.rotate(-obj.rotateAngle * Math.PI / 180);

                                rectX = 0;
                                rectY = 0;
                            }

                            var lineWidth = 6;

                            path1 = new Path2D(); /*topLeftDot dot*/
                            path1.arc(rectX, rectY, lineWidth * 2, 0, Math.PI * 2, true);
                            var topLeftDot = context.isPointInPath(path1, mouseX, mouseY);

                            path1 = new Path2D(); /*topRightDot dot*/
                            path1.arc(rectX + obj.imgWidth, rectY, lineWidth * 2, 0, Math.PI * 2, true);
                            var topRightDot = context.isPointInPath(path1, mouseX, mouseY);

                            path1 = new Path2D(); /*bottomLeftDot dot*/
                            path1.arc(rectX, rectY + obj.imgHeight, lineWidth * 2, 0, Math.PI * 2, true);
                            var bottomLeftDot = context.isPointInPath(path1, mouseX, mouseY);

                            path1 = new Path2D(); /*bottomRightDot dot*/
                            path1.arc(rectX + obj.imgWidth, rectY + obj.imgHeight, lineWidth * 2, 0, Math.PI * 2, true);
                            var bottomRightDot = context.isPointInPath(path1, mouseX, mouseY);

                            path1 = new Path2D(); /*left line*/
                            path1.moveTo(rectX, rectY);
                            path1.lineTo(rectX, obj.imgHeight + rectY);
                            var leftLine = context.isPointInStroke(path1, mouseX, mouseY);

                            path1 = new Path2D(); /*top line*/
                            path1.moveTo(rectX, rectY);
                            path1.lineTo(rectX + obj.imgWidth, rectY);
                            var topLine = context.isPointInStroke(path1, mouseX, mouseY);

                            path1 = new Path2D(); /*right line*/
                            path1.moveTo(rectX + obj.imgWidth, rectY);
                            path1.lineTo(rectX + obj.imgWidth, rectY + obj.imgHeight);
                            var rightLine = context.isPointInStroke(path1, mouseX, mouseY);

                            path1 = new Path2D(); /*bottom line*/
                            path1.moveTo(rectX, obj.imgHeight + rectY);
                            path1.lineTo(rectX + obj.imgWidth, rectY + obj.imgHeight);
                            var bottomLine = context.isPointInStroke(path1, mouseX, mouseY);

                            path1 = new Path2D();
                            path1.rect(rectX, rectY, obj.imgWidth, obj.imgHeight);
                            var isInnerRect = context.isPointInPath(path1, mouseX, mouseY);

                            if (topLeftDot) {
                                $.messageAnnotation.obj.onHover = true;
                                $.messageAnnotation.obj.resize = "north-west";
                                resizeShape = obj;
                                canvas.style.cursor = cursorNorthWest;
                            }
                            else if (topRightDot) {
                                $.messageAnnotation.obj.onHover = true;
                                $.messageAnnotation.obj.resize = "north-east";
                                resizeShape = obj;
                                canvas.style.cursor = cursorNorthEast;
                            }
                            else if (bottomLeftDot) {
                                $.messageAnnotation.obj.onHover = true;
                                $.messageAnnotation.obj.resize = "south-west";
                                resizeShape = obj;
                                canvas.style.cursor = cursorSouthWest;
                            }
                            else if (bottomRightDot) {
                                $.messageAnnotation.obj.onHover = true;
                                $.messageAnnotation.obj.resize = "south-east";
                                resizeShape = obj;
                                canvas.style.cursor = cursorSouthEast;
                            }
                            else if (isInnerRect) {
                                $.messageAnnotation.obj.onHover = true;

                                moveShape = obj;
                                canvas.style.cursor = cursorMove;
                            }

                            context.restore();
                        }
                    }

                    $.drawCanvas.drawAll();
                }

                return;
            }

            e.preventDefault();
            e.stopPropagation();

            if (isDrawDown && $.messageAnnotation.obj.type != "move") {
                newShape = {
                    no: $.messageAnnotation.drawCount,
                    fullStackId: $.messageAnnotation.newGuid(),
                    id: $.messageAnnotation.newGuid(),
                    startX: startX,
                    startY: startY,
                    mouseX: mouseX,
                    mouseY: mouseY,
                    color: $.messageAnnotation.obj.color,
                    colorType: $.messageAnnotation.obj.colorType,
                    lineWidth: $.messageAnnotation.obj.lineWidth,
                    type: $.messageAnnotation.obj.type,
                    rotateAngle: $.messageAnnotation.rotateAngle,
                    action: "add"
                }

                $.drawCanvas.drawAll();
                $.drawCanvas.drawAction(newShape);
            }
            else if (isMoveDown) {
                $.messageAnnotation.displayStack = $.grep($.messageAnnotation.displayStack, function (item) {
                    var removeItem = item.id == moveShape.id;

                    return !removeItem;
                });

                var differentFromStartPointX = startX - moveShape.startX;
                var differentFromStartPointY = startY - moveShape.startY;

                var newShapeStartX = mouseX - differentFromStartPointX;
                var newShapeStartY = mouseY - differentFromStartPointY;
                var newShapeMouseX = moveShape.startX > moveShape.mouseX ? newShapeStartX - Math.abs(moveShape.startX - moveShape.mouseX) : newShapeStartX + Math.abs(moveShape.startX - moveShape.mouseX);
                var newShapeMouseY = moveShape.startY > moveShape.mouseY ? newShapeStartY - Math.abs(moveShape.startY - moveShape.mouseY) : newShapeStartY + Math.abs(moveShape.startY - moveShape.mouseY);

                if (moveShape.type.startsWith("write")) {
                    var newRectShapeStartX = mouseX - differentFromStartPointX;
                    var newRectShapeStartY = mouseY - differentFromStartPointY - gap;
                }

                newShape = {
                    no: $.messageAnnotation.drawCount,
                    fullStackId: $.messageAnnotation.newGuid(),
                    id: moveShape.id,
                    startX: newShapeStartX,
                    startY: newShapeStartY,
                    mouseX: newShapeMouseX,
                    mouseY: newShapeMouseY,
                    color: moveShape.color,
                    colorType: moveShape.colorType,
                    lineWidth: moveShape.lineWidth,
                    type: moveShape.type,
                    fontFamily: moveShape.fontFamily,
                    fontSize: moveShape.fontSize,
                    fontText: moveShape.fontText,
                    maxWidth: moveShape.maxWidth,
                    heightRect: moveShape.heightRect,
                    minHeight: moveShape.minHeight,
                    rectStartX: newRectShapeStartX,
                    rectStartY: newRectShapeStartY,
                    rotateAngle: moveShape.rotateAngle,
                    widthRectMax: moveShape.widthRectMax,
                    imageSrc: moveShape.imageSrc,
                    naturalWidth: moveShape.naturalWidth,
                    naturalHeight: moveShape.naturalHeight,
                    imgWidth: moveShape.imgWidth,
                    imgHeight: moveShape.imgHeight,
                    originalFontSize: moveShape.originalFontSize,
                    fontScale: moveShape.fontScale,
                    action: "move",
                    type: moveShape.type,
                }

                $.drawCanvas.drawAll();
                $.drawCanvas.drawAction(newShape);
            }
            else if (isResize) {
                $.messageAnnotation.displayStack = $.grep($.messageAnnotation.displayStack, function (item) {
                    var removeItem = item.id == resizeShape.id;

                    return !removeItem;
                });

                var differentFromStartPointX = startX - (resizeShape.mouseX != null && resizeShape.startX > resizeShape.mouseX ? resizeShape.mouseX : resizeShape.startX);
                var differentFromStartPointY = startY - (resizeShape.mouseY != null && resizeShape.startY > resizeShape.mouseY ? resizeShape.mouseY : resizeShape.startY);

                var newShapeStartX = mouseX - differentFromStartPointX;
                var newShapeStartY = mouseY - differentFromStartPointY;
                var newShapeMouseX = resizeShape.startX > resizeShape.mouseX ? newShapeStartX - Math.abs(resizeShape.startX - resizeShape.mouseX) : newShapeStartX + Math.abs(resizeShape.startX - resizeShape.mouseX);
                var newShapeMouseY = resizeShape.startY > resizeShape.mouseY ? newShapeStartY - Math.abs(resizeShape.startY - resizeShape.mouseY) : newShapeStartY + Math.abs(resizeShape.startY - resizeShape.mouseY);
                var newShapeImgWidth = resizeShape.imgWidth;
                var newShapeImgHeight = resizeShape.imgHeight;
                var newShapeNaturalWidth = resizeShape.naturalWidth;
                var newShapeNaturalHeight = resizeShape.naturalHeight;

                var newRectShapeStartX = resizeShape.rectStartX;
                var newRectShapeStartY = resizeShape.rectStartY;
                var newRectShapeWidthRectMax = resizeShape.widthRectMax;
                var newRectShapeHeightRect = resizeShape.heightRect;

                var newFontScale = resizeShape.fontScale;
                var newFontSize = resizeShape.fontSize;

                if (resizeShape.type.startsWith("write")) {
                    newRectShapeStartX = mouseX - differentFromStartPointX;
                    newRectShapeStartY = mouseY - differentFromStartPointY - gap;
                }

                if ($.messageAnnotation.obj.resize == "north") {
                    newShapeStartX = resizeShape.startX;
                    newShapeStartY = mouseY - differentFromStartPointY;

                    var extraY = resizeShape.startY - newShapeStartY;

                    newShapeImgHeight = resizeShape.imgHeight + extraY;
                    newShapeNaturalHeight = resizeShape.naturalHeight + extraY;

                    if (newShapeImgHeight < 10 || newShapeNaturalHeight < 10) {
                        return;
                    }
                }
                else if ($.messageAnnotation.obj.resize == "south") {
                    newShapeStartX = resizeShape.startX;
                    newShapeStartY = resizeShape.startY;

                    newShapeImgHeight = mouseY - resizeShape.startY;
                    newShapeNaturalHeight = mouseY - resizeShape.startY;

                    if (newShapeImgHeight < 10 || newShapeNaturalHeight < 10) {
                        return;
                    }
                }
                else if ($.messageAnnotation.obj.resize == "east") {
                    newShapeStartX = resizeShape.startX;
                    newShapeStartY = resizeShape.startY;

                    newShapeImgWidth = mouseX - resizeShape.startX;
                    newShapeNaturalWidth = mouseX - resizeShape.startX;

                    if (newShapeImgWidth < 10 || newShapeNaturalWidth < 10) {
                        return;
                    }
                }
                else if ($.messageAnnotation.obj.resize == "west") {
                    newShapeStartX = mouseX - differentFromStartPointX;
                    newShapeStartY = mouseY - differentFromStartPointY;

                    var extraX = resizeShape.startX - newShapeStartX;

                    newShapeImgWidth = resizeShape.imgWidth + extraX;
                    newShapeNaturalWidth = resizeShape.naturalWidth + extraX;

                    if (newShapeImgWidth < 10 || newShapeNaturalWidth < 10) {
                        return;
                    }
                }
                else if ($.messageAnnotation.obj.resize == "north-west") {
                    newShapeStartX = mouseX - differentFromStartPointX;
                    newShapeStartY = mouseY - differentFromStartPointY;

                    if (resizeShape.mouseX != null) {
                        newShapeMouseX = resizeShape.startX > resizeShape.mouseX ? resizeShape.startX : resizeShape.mouseX;

                        if ((resizeShape.startX < resizeShape.mouseX && newShapeStartX > newShapeMouseX - 10) ||
                            (resizeShape.mouseX < resizeShape.startX && newShapeStartX > newShapeMouseX - 10)) {
                            return;
                        }
                    }

                    if (resizeShape.mouseY != null) {
                        newShapeMouseY = resizeShape.startY > resizeShape.mouseY ? resizeShape.startY : resizeShape.mouseY;

                        if ((resizeShape.startY < resizeShape.mouseY && newShapeStartY > newShapeMouseY - 10) ||
                            (resizeShape.mouseY < resizeShape.startY && newShapeStartY > newShapeMouseY - 10)) {
                            return;
                        }
                    }

                    if (resizeShape.imgWidth != null) {
                        var extraX = resizeShape.startX - newShapeStartX;

                        newShapeImgWidth = resizeShape.imgWidth + extraX;
                        newShapeNaturalWidth = resizeShape.naturalWidth + extraX;

                        if (newShapeImgWidth < 10 || newShapeNaturalWidth < 10) {
                            return;
                        }
                    }

                    if (resizeShape.imgHeight != null) {
                        var extraY = resizeShape.startY - newShapeStartY;

                        newShapeImgHeight = resizeShape.imgHeight + extraY;
                        newShapeNaturalHeight = resizeShape.naturalHeight + extraY;

                        if (newShapeImgHeight < 10 || newShapeNaturalHeight < 10) {
                            return;
                        }
                    }
                }
                else if ($.messageAnnotation.obj.resize == "north-east") {
                    newShapeStartX = resizeShape.startX;
                    newShapeStartY = mouseY - differentFromStartPointY;

                    if (resizeShape.mouseX != null) {
                        newShapeMouseX = mouseX;

                        if ((resizeShape.startX < resizeShape.mouseX && newShapeStartX > newShapeMouseX - 10) ||
                            (resizeShape.mouseX < resizeShape.startX && newShapeStartX > newShapeMouseX - 10)) {
                            return;
                        }
                    }

                    if (resizeShape.mouseY != null) {
                        newShapeMouseY = resizeShape.startY > resizeShape.mouseY ? resizeShape.startY : resizeShape.mouseY;

                        if ((resizeShape.startY < resizeShape.mouseY && newShapeStartY > newShapeMouseY - 10) ||
                            (resizeShape.mouseY < resizeShape.startY && newShapeStartY > newShapeMouseY - 10)) {
                            return;
                        }
                    }

                    if (resizeShape.imgWidth != null) {
                        newShapeImgWidth = mouseX - resizeShape.startX;
                        newShapeNaturalWidth = mouseX - resizeShape.startX;

                        if (newShapeImgWidth < 10 || newShapeNaturalWidth < 10) {
                            return;
                        }
                    }

                    if (resizeShape.imgHeight != null) {
                        var extraY = resizeShape.startY - newShapeStartY;

                        newShapeImgHeight = resizeShape.imgHeight + extraY;
                        newShapeNaturalHeight = resizeShape.naturalHeight + extraY;

                        if (newShapeImgHeight < 10 || newShapeNaturalHeight < 10) {
                            return;
                        }
                    }
                }
                else if ($.messageAnnotation.obj.resize == "south-west") {
                    newShapeStartX = mouseX - differentFromStartPointX;
                    newShapeStartY = resizeShape.startY;

                    if (resizeShape.mouseX != null) {
                        newShapeMouseX = resizeShape.startX > resizeShape.mouseX ? resizeShape.startX : resizeShape.mouseX;

                        if ((resizeShape.startX < resizeShape.mouseX && newShapeStartX > newShapeMouseX - 10) ||
                            (resizeShape.mouseX < resizeShape.startX && newShapeStartX > newShapeMouseX - 10)) {
                            return;
                        }
                    }

                    if (resizeShape.mouseY != null) {
                        newShapeMouseY = mouseY;

                        if ((resizeShape.startY < resizeShape.mouseY && newShapeStartY > newShapeMouseY - 10) ||
                            (resizeShape.mouseY < resizeShape.startY && newShapeStartY > newShapeMouseY - 10)) {
                            return;
                        }
                    }

                    if (resizeShape.imgWidth != null) {
                        var extraX = resizeShape.startX - newShapeStartX;

                        newShapeImgWidth = resizeShape.imgWidth + extraX;
                        newShapeNaturalWidth = resizeShape.naturalWidth + extraX;

                        if (newShapeImgWidth < 10 || newShapeNaturalWidth < 10) {
                            return;
                        }
                    }

                    if (resizeShape.imgHeight != null) {
                        newShapeImgHeight = mouseY - resizeShape.startY;
                        newShapeNaturalHeight = mouseY - resizeShape.startY;

                        if (newShapeImgHeight < 10 || newShapeNaturalHeight < 10) {
                            return;
                        }
                    }
                }
                else if ($.messageAnnotation.obj.resize == "south-east") {
                    newShapeStartX = resizeShape.startX;
                    newShapeStartY = resizeShape.startY;

                    if (resizeShape.mouseX != null) {
                        newShapeMouseX = mouseX;

                        if ((resizeShape.startX < resizeShape.mouseX && newShapeStartX > newShapeMouseX - 10) ||
                            (resizeShape.mouseX < resizeShape.startX && newShapeStartX > newShapeMouseX - 10)) {
                            return;
                        }
                    }

                    if (resizeShape.mouseY != null) {

                        newShapeMouseY = mouseY;

                        if ((resizeShape.startY < resizeShape.mouseY && newShapeStartY > newShapeMouseY - 10) ||
                            (resizeShape.mouseY < resizeShape.startY && newShapeStartY > newShapeMouseY - 10)) {
                            return;
                        }
                    }

                    if (resizeShape.imgWidth != null) {
                        newShapeImgWidth = mouseX - resizeShape.startX;
                        newShapeNaturalWidth = mouseX - resizeShape.startX;

                        if (newShapeImgWidth < 10 || newShapeNaturalWidth < 10) {
                            return;
                        }
                    }

                    if (resizeShape.imgHeight != null) {
                        newShapeImgHeight = mouseY - resizeShape.startY;
                        newShapeNaturalHeight = mouseY - resizeShape.startY;

                        if (newShapeImgHeight < 10 || newShapeNaturalHeight < 10) {
                            return;
                        }
                    }
                }
                else if ($.messageAnnotation.obj.resize == "east-west-1") {
                    newShapeStartX = mouseX;
                    newShapeStartY = mouseY;
                    newShapeMouseX = resizeShape.mouseX;
                    newShapeMouseY = resizeShape.mouseY;
                }
                else if ($.messageAnnotation.obj.resize == "east-west-2") {
                    newShapeStartX = resizeShape.startX;
                    newShapeStartY = resizeShape.startY;
                    newShapeMouseX = mouseX;
                    newShapeMouseY = mouseY;
                }

                newShape = {
                    no: $.messageAnnotation.drawCount,
                    fullStackId: $.messageAnnotation.newGuid(),
                    id: resizeShape.id,
                    startX: newShapeStartX,
                    startY: newShapeStartY,
                    mouseX: newShapeMouseX,
                    mouseY: newShapeMouseY,
                    color: resizeShape.color,
                    colorType: resizeShape.colorType,
                    lineWidth: resizeShape.lineWidth,
                    type: resizeShape.type,
                    fontFamily: resizeShape.fontFamily,
                    fontSize: newFontSize,
                    originalFontSize: resizeShape.originalFontSize,
                    fontScale: newFontScale,
                    fontText: resizeShape.fontText,
                    maxWidth: resizeShape.maxWidth,
                    heightRect: newRectShapeHeightRect,
                    minHeight: resizeShape.minHeight,
                    rectStartX: newRectShapeStartX,
                    rectStartY: newRectShapeStartY,
                    rotateAngle: resizeShape.rotateAngle,
                    widthRectMax: newRectShapeWidthRectMax,
                    imageSrc: resizeShape.imageSrc,
                    naturalWidth: newShapeNaturalWidth,
                    naturalHeight: newShapeNaturalHeight,
                    imgWidth: newShapeImgWidth,
                    imgHeight: newShapeImgHeight,
                    action: "move",
                    type: resizeShape.type,
                }

                $.drawCanvas.drawAll();
                $.drawCanvas.drawAction(newShape);
            }
        },

        drawTextArea: function (e) {
            $("[data-type='delete']").prop("disabled", true);

            var maxWidth = $(".editor-outer-textarea textarea").outerWidth();

            var fontSize = parseInt($.messageAnnotation.obj.fontSize);
            startX = startX;
            startY = startY;

            var getRectX = startX;
            var getRectY = startY;
            var space = fontSize / 12;
            var fontY = startY + gap;

            newShape = {
                no: $.messageAnnotation.drawCount,
                fullStackId: $.messageAnnotation.newGuid(),
                id: $.messageAnnotation.newGuid(),
                startX: startX,
                startY: fontY,
                rectStartX: getRectX,
                rectStartY: getRectY,
                rotateAngle: $.messageAnnotation.rotateAngle,
                color: $.messageAnnotation.obj.color,
                colorType: $.messageAnnotation.obj.colorType,
                fontText: $(".editor-outer-textarea textarea").val(),
                fontSize: $.messageAnnotation.obj.fontSize,
                originalFontSize: $.messageAnnotation.obj.originalFontSize,
                fontScale: $.messageAnnotation.scale,
                fontFamily: $.messageAnnotation.obj.fontFamily,
                maxWidth: maxWidth,
                type: $.messageAnnotation.obj.type,
                action: "add"
            }

            $.messageAnnotation.displayStack.push(newShape);
            $.messageAnnotation.fullStack.push(newShape);
            $.messageAnnotation.redoStack = [];

            $.messageAnnotation.action.push({
                id: newShape.fullStackId,
                action: "add"
            });

            $.messageAnnotation.drawCount++;

            $.drawCanvas.drawAll();

            newShape = null;

            $(".editor-outer-textarea textarea").val("");
            $(".editor-outer-textarea textarea").css("display", "none");
        },
        drawAll: function () {
            context.clearRect(0, 0, canvas.width, canvas.height);

            if ($.messageAnnotation.obj.base_image != null) {
                context.drawImage($.messageAnnotation.obj.base_image, 0, 0);
            }

            for (var i = 0; i < $.messageAnnotation.displayStack.length; i++) {
                var r = $.messageAnnotation.displayStack[i];
               
                $.drawCanvas.drawAction(r);
            }

            if ($.messageAnnotation.displayStack.length == 0) {
                $("[data-type='undo']").prop("disabled", true);
                $("[data-type='move']").prop("disabled", true);
                $("[data-type='delete']").prop("disabled", true);
            }
            else {
                $("[data-type='undo']").prop("disabled", false);
                $("[data-type='move']").prop("disabled", false);
            }

            if ($.messageAnnotation.redoStack.length == 0) {
                $("[data-type='redo']").prop("disabled", true);
            }
            else {
                $("[data-type='redo']").prop("disabled", false);
            }

            if ($.messageAnnotation.fullStack.length == 0) {
                $("[data-type='clear']").prop("disabled", true);
            }
            else {
                $("[data-type='clear']").prop("disabled", false);
            }
        },
        drawAction: function (obj) {
            if (obj.action == "delete") {
                return;
            }

            if (obj.colorType == "light") {
                baseColorHover = "#999999";
            }
            else {
                baseColorHover = "#fff";
            }

            var onHover = (moveShape != null && obj.id == moveShape.id) || (resizeShape != null && obj.id == resizeShape.id) ? $.messageAnnotation.obj.onHover : false;

            var leftPos = Math.min(obj.startX, obj.mouseX);
            var rightPos = Math.max(obj.startX, obj.mouseX);
            var topPos = Math.min(obj.startY, obj.mouseY);
            var bottomPos = Math.max(obj.startY, obj.mouseY);

            context.save();
            var hoverStyle = false;
            var selectStyle = false;

            if (onHover || $.messageAnnotation.obj.onSelectItem && selectedShape != null && obj.id == selectedShape.id) {
                hoverStyle = true;
                selectStyle = true;
            }

            if (obj.type == "draw-square-o") {
                if (hoverStyle) {
                    context.strokeStyle = baseColorHover;

                    var lineWidth = parseInt(obj.lineWidth);

                    context.strokeRect(leftPos - lineWidth, topPos - lineWidth, rightPos - leftPos + (lineWidth * 2), bottomPos - topPos + (lineWidth * 2));
                    context.strokeRect(leftPos + lineWidth, topPos + lineWidth, rightPos - leftPos - (lineWidth * 2), bottomPos - topPos - (lineWidth * 2));

                    if (selectStyle) {
                        context.fillStyle = baseColorHover;
                        context.beginPath();
                        context.arc(leftPos, topPos, lineWidth * 2, 0, Math.PI * 2, true);
                        context.closePath();
                        context.fill();

                        context.beginPath();
                        context.arc(leftPos + rightPos - leftPos, topPos, lineWidth * 2, 0, Math.PI * 2, true);
                        context.closePath();
                        context.fill();

                        context.beginPath();
                        context.arc(leftPos, topPos + bottomPos - topPos, lineWidth * 2, 0, Math.PI * 2, true);
                        context.closePath();
                        context.fill();

                        context.beginPath();
                        context.arc(leftPos + rightPos - leftPos, topPos + bottomPos - topPos, lineWidth * 2, 0, Math.PI * 2, true);
                        context.closePath();
                        context.fill();
                    }
                }

                context.strokeStyle = obj.color;
                context.lineWidth = obj.lineWidth;
                context.strokeRect(leftPos, topPos, rightPos - leftPos, bottomPos - topPos);

                if (selectStyle) {
                    var lineWidth = parseInt(obj.lineWidth);

                    context.fillStyle = baseColorDrag;
                    context.beginPath();
                    context.arc(leftPos, topPos, lineWidth * 1.3, 0, Math.PI * 2, true);
                    context.closePath();
                    context.fill();

                    context.beginPath();
                    context.arc(leftPos + rightPos - leftPos, topPos, lineWidth * 1.3, 0, Math.PI * 2, true);
                    context.closePath();
                    context.fill();

                    context.beginPath();
                    context.arc(leftPos, topPos + bottomPos - topPos, lineWidth * 1.3, 0, Math.PI * 2, true);
                    context.closePath();
                    context.fill();

                    context.beginPath();
                    context.arc(leftPos + rightPos - leftPos, topPos + bottomPos - topPos, lineWidth * 1.3, 0, Math.PI * 2, true);
                    context.closePath();
                    context.fill();
                }
            }
            else if (obj.type == "draw-square") {
                if (hoverStyle) {
                    var lineWidth = 6;
                    context.strokeStyle = baseColorHover;
                    context.strokeRect(leftPos - (lineWidth/2), topPos - (lineWidth/2), rightPos - leftPos + (lineWidth), bottomPos - topPos + (lineWidth));

                    if (selectStyle) {
                        context.fillStyle = baseColorHover;
                        context.beginPath();
                        context.arc(leftPos, topPos, lineWidth * 2, 0, Math.PI * 2, true);
                        context.closePath();
                        context.fill();

                        context.beginPath();
                        context.arc(leftPos + rightPos - leftPos, topPos, lineWidth * 2, 0, Math.PI * 2, true);
                        context.closePath();
                        context.fill();

                        context.beginPath();
                        context.arc(leftPos, topPos + bottomPos - topPos, lineWidth * 2, 0, Math.PI * 2, true);
                        context.closePath();
                        context.fill();

                        context.beginPath();
                        context.arc(leftPos + rightPos - leftPos, topPos + bottomPos - topPos, lineWidth * 2, 0, Math.PI * 2, true);
                        context.closePath();
                        context.fill();
                    }
                }

                context.fillStyle = obj.color;
                context.fillRect(leftPos, topPos, rightPos - leftPos, bottomPos - topPos);

                if (selectStyle) {
                    var lineWidth = 6;

                    context.fillStyle = baseColorDrag;
                    context.beginPath();
                    context.arc(leftPos, topPos, lineWidth * 1.3, 0, Math.PI * 2, true);
                    context.closePath();
                    context.fill();

                    context.beginPath();
                    context.arc(leftPos + rightPos - leftPos, topPos, lineWidth * 1.3, 0, Math.PI * 2, true);
                    context.closePath();
                    context.fill();

                    context.beginPath();
                    context.arc(leftPos, topPos + bottomPos - topPos, lineWidth * 1.3, 0, Math.PI * 2, true);
                    context.closePath();
                    context.fill();

                    context.beginPath();
                    context.arc(leftPos + rightPos - leftPos, topPos + bottomPos - topPos, lineWidth * 1.3, 0, Math.PI * 2, true);
                    context.closePath();
                    context.fill();
                }
                
            }
            else if (obj.type == "draw-circle-o") {
                if (hoverStyle) {
                    context.beginPath();
                    var radiusX = (obj.mouseX - obj.startX) * 0.5,
                        radiusY = (obj.mouseY - obj.startY) * 0.5,
                        centerX = obj.startX + radiusX,
                        centerY = obj.startY + radiusY,
                        step = 0.1,
                        a = 0,
                        pi2 = Math.PI * 2 + step,
                        finala = 0;

                    context.moveTo(centerX + radiusX * Math.cos(0), centerY + radiusY * Math.sin(0));

                    for (; a < pi2; a += step) {
                        finala = a;
                        context.lineTo(centerX + radiusX * Math.cos(a), centerY + radiusY * Math.sin(a));
                    }

                    if (finala < pi2 && a > pi2) {
                        context.lineTo(centerX + radiusX * Math.cos(pi2), centerY + radiusY * Math.sin(pi2));
                    }

                    context.strokeStyle = baseColorHover;
                    context.lineWidth = obj.lineWidth * 2;
                    context.stroke();

                    if (selectStyle) {
                        var lineWidth = 6;

                        context.fillStyle = baseColorHover;
                        context.beginPath();
                        context.arc(leftPos - lineWidth, topPos - lineWidth, lineWidth * 2, 0, Math.PI * 2, true);
                        context.closePath();
                        context.fill();

                        context.beginPath();
                        context.arc(leftPos + rightPos - leftPos + lineWidth, topPos - lineWidth, lineWidth * 2, 0, Math.PI * 2, true);
                        context.closePath();
                        context.fill();

                        context.beginPath();
                        context.arc(leftPos - lineWidth, topPos + bottomPos - topPos + lineWidth, lineWidth * 2, 0, Math.PI * 2, true);
                        context.closePath();
                        context.fill();

                        context.beginPath();
                        context.arc(leftPos + rightPos - leftPos + lineWidth, topPos + bottomPos - topPos + lineWidth, lineWidth * 2, 0, Math.PI * 2, true);
                        context.closePath();
                        context.fill();
                    }
                }

                context.beginPath();
                
                var radiusX = (obj.mouseX - obj.startX) * 0.5,
                    radiusY = (obj.mouseY - obj.startY) * 0.5,
                    centerX = obj.startX + radiusX,
                    centerY = obj.startY + radiusY,
                    step = 0.1,
                    a = 0,
                    pi2 = Math.PI * 2 + step,
                    finala = 0;

                for (; a < pi2; a += step) {
                    finala = a;
                    context.lineTo(centerX + radiusX * Math.cos(a), centerY + radiusY * Math.sin(a));
                }

                if (finala < pi2 && a > pi2) {
                    context.lineTo(centerX + radiusX * Math.cos(pi2), centerY + radiusY * Math.sin(pi2));
                }

                context.moveTo(centerX + radiusX * Math.cos(0), centerY + radiusY * Math.sin(0));

                context.strokeStyle = obj.color;
                context.lineWidth = obj.lineWidth;
                context.stroke();

                if (selectStyle) {
                    var lineWidth = 6;

                    context.fillStyle = baseColorDrag;
                    context.beginPath();
                    context.arc(leftPos - lineWidth, topPos - lineWidth, lineWidth * 1.3, 0, Math.PI * 2, true);
                    context.closePath();
                    context.fill();

                    context.beginPath();
                    context.arc(leftPos + rightPos - leftPos + lineWidth, topPos - lineWidth, lineWidth * 1.3, 0, Math.PI * 2, true);
                    context.closePath();
                    context.fill();

                    context.beginPath();
                    context.arc(leftPos - lineWidth, topPos + bottomPos - topPos + lineWidth, lineWidth * 1.3, 0, Math.PI * 2, true);
                    context.closePath();
                    context.fill();

                    context.beginPath();
                    context.arc(leftPos + rightPos - leftPos + lineWidth, topPos + bottomPos - topPos + lineWidth, lineWidth * 1.3, 0, Math.PI * 2, true);
                    context.closePath();
                    context.fill();
                }
            }
            else if (obj.type == "draw-circle") {
                if (hoverStyle) {
                    var lineWidth = 6;

                    if (selectStyle) {
                        context.fillStyle = baseColorHover;
                        context.beginPath();
                        context.arc(leftPos - lineWidth, topPos - lineWidth, lineWidth * 2, 0, Math.PI * 2, true);
                        context.closePath();
                        context.fill();

                        context.beginPath();
                        context.arc(leftPos + rightPos - leftPos + lineWidth, topPos - lineWidth, lineWidth * 2, 0, Math.PI * 2, true);
                        context.closePath();
                        context.fill();

                        context.beginPath();
                        context.arc(leftPos - lineWidth, topPos + bottomPos - topPos + lineWidth, lineWidth * 2, 0, Math.PI * 2, true);
                        context.closePath();
                        context.fill();

                        context.beginPath();
                        context.arc(leftPos + rightPos - leftPos + lineWidth, topPos + bottomPos - topPos + lineWidth, lineWidth * 2, 0, Math.PI * 2, true);
                        context.closePath();
                        context.fill();
                    }
                }

                context.beginPath();
                var radiusX = (obj.mouseX - obj.startX) * 0.5,
                    radiusY = (obj.mouseY - obj.startY) * 0.5,
                    centerX = obj.startX + radiusX,
                    centerY = obj.startY + radiusY,
                    step = 0.1,
                    a = 0,
                    pi2 = Math.PI * 2 + step,
                    finala = 0;

                context.moveTo(centerX + radiusX * Math.cos(0), centerY + radiusY * Math.sin(0));
                for (; a < pi2; a += step) {
                    finala = a;
                    context.lineTo(centerX + radiusX * Math.cos(a), centerY + radiusY * Math.sin(a));
                }

                if (finala < pi2 && a > pi2) {
                    context.lineTo(centerX + radiusX * Math.cos(pi2), centerY + radiusY * Math.sin(pi2));
                }

                context.fillStyle = obj.color;

                if (onHover) {
                    context.strokeStyle = baseColorHover;
                    context.lineWidth = 12;
                    context.stroke();
                }
               
                context.fill();

                if (selectStyle) {
                    var lineWidth = 6;

                    context.fillStyle = baseColorDrag;
                    context.beginPath();
                    context.arc(leftPos - lineWidth, topPos - lineWidth, lineWidth * 1.3, 0, Math.PI * 2, true);
                    context.closePath();
                    context.fill();

                    context.beginPath();
                    context.arc(leftPos + rightPos - leftPos + lineWidth, topPos - lineWidth, lineWidth * 1.3, 0, Math.PI * 2, true);
                    context.closePath();
                    context.fill();

                    context.beginPath();
                    context.arc(leftPos - lineWidth, topPos + bottomPos - topPos + lineWidth, lineWidth * 1.3, 0, Math.PI * 2, true);
                    context.closePath();
                    context.fill();

                    context.beginPath();
                    context.arc(leftPos + rightPos - leftPos + lineWidth, topPos + bottomPos - topPos + lineWidth, lineWidth * 1.3, 0, Math.PI * 2, true);
                    context.closePath();
                    context.fill();
                }
            }
            else if (obj.type == "draw-line") {
                if (hoverStyle) {
                    var lineWidth = parseInt(obj.lineWidth);

                    context.beginPath();
                    context.moveTo(obj.startX, obj.startY);
                    context.lineTo(obj.mouseX, obj.mouseY);
                    context.strokeStyle = baseColorHover;
                    context.lineWidth = obj.lineWidth * 3;
                    context.stroke();

                    if (selectStyle) {

                        context.fillStyle = baseColorHover;
                        context.beginPath();
                        context.arc(obj.startX, obj.startY, lineWidth * 2, 0, Math.PI * 2, true);
                        context.closePath();
                        context.fill();

                        context.beginPath();
                        context.arc(obj.mouseX, obj.mouseY, lineWidth * 2, 0, Math.PI * 2, true);
                        context.closePath();
                        context.fill();
                    }
                }

                context.beginPath();
                context.lineWidth = obj.lineWidth;
                context.moveTo(obj.startX, obj.startY);
                context.lineTo(obj.mouseX, obj.mouseY);
                context.strokeStyle = obj.color;
                context.stroke();

                if (selectStyle) {
                    var lineWidth = parseInt(obj.lineWidth);

                    context.fillStyle = baseColorDrag;
                    context.beginPath();
                    context.arc(obj.startX, obj.startY, lineWidth * 1.3, 0, Math.PI * 2, true);
                    context.closePath();
                    context.fill();

                    context.beginPath();
                    context.arc(obj.mouseX, obj.mouseY, lineWidth * 1.3, 0, Math.PI * 2, true);
                    context.closePath();
                    context.fill();
                }
            }
            else if (obj.type == "draw-arrow") {
                var lineWidth = parseInt(obj.lineWidth);
                var minLineWidth = lineWidth > 4 ? lineWidth * 2.5 : lineWidth * 10 ;
                var maxLineWidth = lineWidth > 4 ? lineWidth * 5 : lineWidth * 20;
                const dx = obj.mouseX - obj.startX;
                const dy = obj.mouseY - obj.startY;
                var baseHeadlen = Math.sqrt(dx * dx + dy * dy) * 0.2;
                var ratio = 6;
                if (baseHeadlen > maxLineWidth) {
                    baseHeadlen = maxLineWidth;
                }
                else if (baseHeadlen < minLineWidth) {
                    baseHeadlen = minLineWidth;
                    ratio = 8;
                }

                var headlen = baseHeadlen;
                const angle = Math.atan2(dy, dx);

                if (hoverStyle) {
                    context.beginPath();
                    context.strokeStyle = baseColorHover;
                    context.lineWidth = obj.lineWidth * 3;

                    var calcExtraWidth = (context.lineWidth - parseInt(obj.lineWidth)) / 2;
                    headlen = headlen + calcExtraWidth ;

                    context.moveTo(obj.startX, obj.startY);
                    context.lineTo(obj.mouseX, obj.mouseY);
                    context.moveTo(obj.mouseX - headlen * Math.cos(angle - Math.PI / ratio), obj.mouseY - headlen * Math.sin(angle - Math.PI / ratio));
                    context.lineTo(obj.mouseX, obj.mouseY);
                    context.lineTo(obj.mouseX - headlen * Math.cos(angle + Math.PI / ratio), obj.mouseY - headlen * Math.sin(angle + Math.PI / ratio));
                    context.stroke();

                    if (selectStyle) {

                        context.fillStyle = baseColorHover;
                        context.beginPath();
                        context.arc(obj.startX, obj.startY, lineWidth * 2, 0, Math.PI * 2, true);
                        context.closePath();
                        context.fill();

                        context.beginPath();
                        context.arc(obj.mouseX, obj.mouseY, lineWidth * 2, 0, Math.PI * 2, true);
                        context.closePath();
                        context.fill();
                    }
                }
                headlen = baseHeadlen;
                context.beginPath();
                context.strokeStyle = obj.color;
                context.lineWidth = obj.lineWidth;
                context.moveTo(obj.startX, obj.startY);
                context.lineTo(obj.mouseX, obj.mouseY);
                context.moveTo(obj.mouseX - headlen * Math.cos(angle - Math.PI / ratio), obj.mouseY - headlen * Math.sin(angle - Math.PI / ratio));
                context.lineTo(obj.mouseX, obj.mouseY);
                context.lineTo(obj.mouseX - headlen * Math.cos(angle + Math.PI / ratio), obj.mouseY - headlen * Math.sin(angle + Math.PI / ratio));
                context.stroke();

                if (selectStyle) {

                    context.fillStyle = baseColorDrag;
                    context.beginPath();
                    context.arc(obj.startX, obj.startY, lineWidth * 1.3, 0, Math.PI * 2, true);
                    context.closePath();
                    context.fill();

                    context.beginPath();
                    context.arc(obj.mouseX, obj.mouseY, lineWidth * 1.3, 0, Math.PI * 2, true);
                    context.closePath();
                    context.fill();
                }
            }
            else if (obj.type.startsWith("write")) {
                var fontSize = parseInt(obj.fontSize);
                var minHeight = fontSize + 10;
                var fontHeight = fontSize + 8;

                context.fillStyle = obj.color;
                context.font = fontSize + "px / " + fontHeight + "px " + obj.fontFamily + "";

                var maxWidth = parseFloat(obj.maxWidth);

                widthRectMax = 0;

                context.textBaseline = "middle";
                context.save();

                var rectX = obj.startX;
                var rectY = obj.startY;

                if (obj.rotateAngle == 90 || obj.rotateAngle == -270) {
                    context.translate(obj.rectStartX + gap, obj.rectStartY);
                    context.rotate(-obj.rotateAngle * Math.PI / 180);
                    rectX = 0;
                    rectY = 0;
                }
                else if (Math.abs(obj.rotateAngle) == 180) {
                    context.translate(obj.rectStartX, obj.rectStartY - 8);
                    context.rotate(obj.rotateAngle * Math.PI / 180);
                    rectX = 0;
                    rectY = 0;
                }
                else if (obj.rotateAngle == -90 || obj.rotateAngle == 270) {
                    context.translate(obj.rectStartX - 8, obj.rectStartY);
                    context.rotate(-obj.rotateAngle * Math.PI / 180);
                    rectX = 0;
                    rectY = 0;
                }

                var heightRect = $.drawCanvas.addTextCnv(obj.fontText, rectX, rectY, maxWidth, fontHeight);


                if (hoverStyle) {
                    
                    var lineWidth = parseInt(parseInt(obj.fontSize) / 10);

                    if (lineWidth < 4) {
                        lineWidth = 4;
                    }

                    var newX1 = 0;
                    var newY1 = 0;
                    var newWidth = widthRectMax;
                    var newHeight = heightRect;

                    if (Math.abs(obj.rotateAngle) == 90 || Math.abs(obj.rotateAngle) == 270 || Math.abs(obj.rotateAngle) == 180) {
                        newX1 = rectX - gap - 5;
                        newY1 = rectY - (minHeight / 2) - 5;

                        newWidth = newWidth + gap + 5;
                    }
                    else {
                        newX1 = obj.rectStartX - gap - 5;
                        newY1 = obj.rectStartY - (fontSize / 2);
                        newWidth = newWidth + gap + 5;
                    }

                    context.strokeStyle = "grey";
                    context.lineWidth = lineWidth;
                    context.strokeRect(newX1, newY1, newWidth, newHeight);

                    context.strokeStyle = baseColorHover;
                    context.lineWidth = lineWidth/2;
                    context.strokeRect(newX1, newY1, newWidth, newHeight);
                }

                obj.minHeight = minHeight;
                obj.widthRectMax = widthRectMax;
                obj.heightRect = heightRect;
                context.restore();
            }
            else if (obj.type == "attachImage") {
                var imageObj = new Image();
                imageObj.src = obj.imageSrc;
                if (obj.imgWidth == null) {
                    imageObj.onload = function () {
                        var imgWidth = imageObj.naturalWidth;

                        var screenWidth = $(window).width() - 20;
                        var scaleX = $.messageAnnotation.scale;
                        if (imgWidth > screenWidth)
                            scaleX = screenWidth / imgWidth;
                        var imgHeight = imageObj.naturalHeight;
                        var screenHeight = $(window).height() - canvas.offsetTop - 10;
                        var scaleY = $.messageAnnotation.scale;
                        if (imgHeight > screenHeight)
                            scaleY = screenHeight / imgHeight;
                        var scale = scaleY;
                        if (scaleX < scaleY)
                            scale = scaleX;
                        if (scale < 1) {
                            imgHeight = imgHeight * scale;
                            imgWidth = imgWidth * scale;
                        }

                        obj.naturalWidth = imageObj.naturalWidth;
                        obj.naturalHeight = imageObj.naturalHeight;
                        obj.imgWidth = imgWidth;
                        obj.imgHeight = imgHeight;

                        context.save();
                        context.translate(obj.startX, obj.startY);
                        context.rotate(-obj.rotateAngle * Math.PI / 180);
                        context.drawImage(imageObj, 0, 0, obj.naturalWidth, obj.naturalHeight, 0, 0, obj.imgWidth, obj.imgHeight);

                        context.restore();
                    }
                }
                else {
                    context.save();
                    context.translate(obj.startX, obj.startY);
                    context.rotate(-obj.rotateAngle * Math.PI / 180);
                    context.drawImage(imageObj, 0, 0, obj.imgWidth, obj.imgHeight);

                    if (hoverStyle) {
                        context.strokeStyle = baseColorHover;
                        context.lineWidth = "6";
                        context.strokeRect(0, 0, obj.imgWidth, obj.imgHeight);

                        var lineWidth = 6;

                        if (selectStyle) {
                            context.fillStyle = baseColorHover;
                            context.beginPath();
                            context.arc(0, 0, lineWidth * 2, 0, Math.PI * 2, true);
                            context.closePath();
                            context.fill();

                            context.beginPath();
                            context.arc(obj.imgWidth, 0, lineWidth * 2, 0, Math.PI * 2, true);
                            context.closePath();
                            context.fill();

                            context.beginPath();
                            context.arc(0, obj.imgHeight, lineWidth * 2, 0, Math.PI * 2, true);
                            context.closePath();
                            context.fill();

                            context.beginPath();
                            context.arc(obj.imgWidth, obj.imgHeight, lineWidth * 2, 0, Math.PI * 2, true);
                            context.closePath();
                            context.fill();

                            context.fillStyle = baseColorDrag;
                            context.beginPath();
                            context.arc(0, 0, lineWidth * 1.3, 0, Math.PI * 2, true);
                            context.closePath();
                            context.fill();

                            context.beginPath();
                            context.arc(obj.imgWidth, 0, lineWidth * 1.3, 0, Math.PI * 2, true);
                            context.closePath();
                            context.fill();

                            context.beginPath();
                            context.arc(0, obj.imgHeight, lineWidth * 1.3, 0, Math.PI * 2, true);
                            context.closePath();
                            context.fill();

                            context.beginPath();
                            context.arc(obj.imgWidth, obj.imgHeight, lineWidth * 1.3, 0, Math.PI * 2, true);
                            context.closePath();
                            context.fill();
                        }
                    }

                    context.restore();
                }
            }

            context.restore();
        },
        addTextCnv: function (text, x, y, maxWidth, lineHeight) {

            var words = text.split('\n');
            words = words.filter(item => item);
            var endY = 0;

            for (var n = 0; n < words.length; n++) {
                y = $.drawCanvas.addTextCnvLength(words[n], x, y, maxWidth, lineHeight);
                y += lineHeight;
                endY += lineHeight;
            }

            return endY;
        },
        resetDraw: function (page, scrollLeft, scrollTop) {
            scrollLeft = scrollLeft || 0;
            scrollTop = scrollTop || 0;
            $.messageAnnotation.obj.page = parseInt(page);

            if ($(".editor-outer-textarea textarea").is(":visible")) {
                $(".editor-outer-textarea textarea").val("");
                $(".editor-outer-textarea textarea").css("display", "none");
            }

            var getPage = $("#thumbnail-list").children("li.nav-item.active").find("a.nav-link").attr("data-page");

            if (parseInt(getPage) == $.messageAnnotation.obj.page) {
                context.clearRect(0, 0, canvas.width, canvas.height);

                base_image.src = $.messageAnnotation.obj.base_imageSrc;
                $.messageAnnotation.obj.base_image = base_image;

                base_image.onload = function () {
                    $("#DocumentCanvasContainer").css("position", "initial");
                    $("#DocumentCanvasContainer .loader").hide();
                    $(".canvasEditArea").show();

                    canvas.width = base_image.width;
                    canvas.height = base_image.height;
                    context.drawImage(base_image, 0, 0);

                    $.messageAnnotation.freezeControl(false);

                    $.drawCanvas.fitToScreen();

                    $.messageAnnotation.setBtnZoom();

                    $.messageAnnotation.setBtnRotate();

                    $.drawCanvas.reOffset();
                    $.drawCanvas.drawAll();

                    $("#DocumentCanvasContainer").scrollLeft(scrollLeft);
                    $("#DocumentCanvasContainer").scrollTop(scrollTop);

                    $("#canvasarea").attr("data-page", $.messageAnnotation.obj.page);
                }
            }
        },
        fitToScreen: function () {
            if ($.messageAnnotation.setZooming) {
                var containerWidth = parseInt($("#DocumentCanvasContainer").css("width"));
                var containerHeight = parseInt($("#DocumentCanvasContainer").css("height"));

                var canvasWidth = parseInt($("#canvasarea").css("width"));
                var canvasHeight = parseInt($("#canvasarea").css("height"));


                var getScreenRatioWidth = containerWidth / canvasWidth;
                var getScreenRatioHeight = containerHeight / canvasHeight;
                var getScreenRatioWidthWithScroll = (containerWidth - 20)/ canvasWidth;

                if ($.messageAnnotation.rotateAngle == 90 || $.messageAnnotation.rotateAngle == -90 ||
                        $.messageAnnotation.rotateAngle == 270 || $.messageAnnotation.rotateAngle == -270) {
                    getScreenRatioWidth = containerWidth / canvasHeight;
                    getScreenRatioHeight = containerHeight / canvasWidth;
                    getScreenRatioWidthWithScroll = (containerWidth - 20)/ canvasHeight;
                }

                console.log("containerWidth: " + containerWidth);
                console.log("canvasWidth: " + canvasWidth);
                console.log("containerHeight: " + containerHeight);
                console.log("canvasHeight: " + canvasHeight);
                console.log("getScreenRatioWidth: " + getScreenRatioWidth);
                console.log("getScreenRatioWidthWithScroll: " + getScreenRatioWidthWithScroll);
                console.log("getScreenRatioHeight: " + getScreenRatioHeight);

                var setRatio = getScreenRatioWidth > getScreenRatioHeight ? getScreenRatioWidthWithScroll : getScreenRatioWidth;
                console.log("setRatio: " + setRatio);


                $.messageAnnotation.zoom = $.messageAnnotation.parseFloat(setRatio, 3);
            }
        },

        addTextCnvLength: function (text, x, y, maxWidth, lineHeight) {
            var words = text.trimEnd(" ").split(' ');
            words = words.filter(item => item);
            var line = '';

            for (var n = 0; n < words.length; n++) {
                var testLine = line + words[n] + ' ';
                var metrics = context.measureText(testLine);
                var testWidth = metrics.width;

                if (testWidth > maxWidth && n > 0) {

                    if (testWidth > widthRectMax) {
                        widthRectMax = testWidth + 6;
                    }

                    context.fillText(line, x, y);
                    line = words[n] + ' ';
                    y += lineHeight;
                }
                else {
                    line = testLine;
                }
            }

            if (line.length > 0) {

                var metrics = context.measureText(line);
                var testWidth = metrics.width;

                if (testWidth > widthRectMax) {
                    widthRectMax = testWidth + 6;
                }

                context.fillText(line, x, y);
            }
            return y;
        },

        undoAction: function (element) {
            var lastItem = $.messageAnnotation.displayStack.pop();
            $.messageAnnotation.redoStack.push(lastItem);
            $.messageAnnotation.drawCount--;

            $.messageAnnotation.trackCount = $.messageAnnotation.drawCount;

            const array = $.messageAnnotation.fullStack.slice(0, $.messageAnnotation.drawCount);
            const key = 'id';

            const arrayUniqueByKey = [...new Map(array.map(item =>
                [item[key], item])).values()];

            $.messageAnnotation.displayStack = arrayUniqueByKey.sort((a, b) => a.no - b.no);

            $.drawCanvas.drawAll();
        },
        redoAction: function (element) {
            $.messageAnnotation.redoStack.pop();
            $.messageAnnotation.drawCount++;
            $.messageAnnotation.trackCount = $.messageAnnotation.drawCount;

            const array = $.messageAnnotation.fullStack.slice(0, $.messageAnnotation.drawCount);
            const key = 'id';

            const arrayUniqueByKey = [...new Map(array.map(item =>
                [item[key], item])).values()];

            $.messageAnnotation.displayStack = arrayUniqueByKey.sort((a, b) => a.no - b.no);

            $.drawCanvas.drawAll();
        },

        clearAction: function (element) {
            $.messageAnnotation.redoStack = [];
            $.messageAnnotation.fullStack = [];
            $.messageAnnotation.action = [];
            $.messageAnnotation.drawCount = 0;
            $.messageAnnotation.trackCount = 0;

            $.messageAnnotation.displayStack = [];
            $.drawCanvas.drawAll();
        },
        deleteAction: function (element) {
            if (selectedShape != null) {

                newShape = {
                    no: $.messageAnnotation.drawCount,
                    fullStackId: $.messageAnnotation.newGuid(),
                    id: selectedShape.id,
                    startX: mouseX,
                    startY: mouseY,
                    mouseX: mouseX + Math.abs(selectedShape.startX - selectedShape.mouseX),
                    mouseY: mouseY + Math.abs(selectedShape.startY - selectedShape.mouseY),
                    color: selectedShape.color,
                    colorType: selectedShape.colorType,
                    lineWidth: selectedShape.lineWidth,
                    type: selectedShape.type,
                    action: "delete"
                }

                $.messageAnnotation.drawCount++;
                selectedShape = null;
                $.messageAnnotation.obj.onSelectItem = false;
                $.messageAnnotation.setBtnSelect($.messageAnnotation.obj.type);
                $.messageAnnotation.fullStack.push(newShape);
                const array = $.messageAnnotation.fullStack.slice(0, $.messageAnnotation.drawCount);
                const key = 'id';

                const arrayUniqueByKey = [...new Map(array.map(item =>
                    [item[key], item])).values()];

                $.messageAnnotation.displayStack = arrayUniqueByKey.sort((a, b) => a.no - b.no);
                $.drawCanvas.drawAll();
            }
            else if ($(".editor-outer-textarea textarea").is(":visible")) {
                $(".editor-outer-textarea textarea").val("");
                $(".editor-outer-textarea textarea").css("display", "none");
            }
        },

        definePath: function (p) {
            context.beginPath();
            context.moveTo(p.startX, p.startY);
            context.lineTo(p.mouseX, p.mouseY);
            context.closePath();
        },
    };

    $.signature = {
        obj: {
            folder: null,
            currentTab: "",
            transparency: {
                color: '#fddcca',
                threshold: '40'
            }
        },
        init: function (e) {
            $("#addSignatureModal").on("hide.bs.modal", function (e) {
                $("#btn-writeSignature").blur();
                $("#btn-writeSignature").removeClass("selected");
                $.messageAnnotation.obj.type = "";

                if ($.signature.obj.signatureDropify) {
                    var signDropify = $.signature.obj.signatureDropify.data('dropify');
                    signDropify.resetPreview();
                    signDropify.clearElement();
                }

                $.signature.getSignatures();
            });

            $.signature.getFolder();

            $.signature.onBtnClick($('.signature-option-btns button'));
            $.signature.onBtnInsertClick($('#btn-insert-sign'));
        },
        initDropify: function () {
            $.signature.obj.signatureDropify = $('#upload-sign-img').dropify({ allowedFileExtensions: ['png', 'jpg', 'jpeg', 'gif', 'bmp'] });
            var canvasDropify = document.getElementById('upload-sign-canvas');
            var reader = new FileReader();

            reader.addEventListener('load', function () {
                $.signature.createImg(reader.result, function () {
                    canvasDropify.width = this.width;
                    canvasDropify.height = this.height;
                    $.signature.createTransparent(canvasDropify, this);
                    $.signature.enableInsertBtn(true);
                });
            }, false);

            $('#upload-sign-img').on('change', function () {
                if (!$('.dropify-wrapper').hasClass('.has-error') && $(this).val() !== '') {
                    reader.readAsDataURL(this.files[0]);
                }
            });

            $.signature.obj.signatureDropify.on('dropify.afterClear', function (event, element) {
                $.signature.enableInsertBtn(false);
            });
        },

        initSignaturePad: function () {
            var canvasSignature = document.getElementById('signonit-canvas');
            var signaturePad = new SignaturePad(canvasSignature, {
                /* It's Necessary to use an opaque color when saving image as JPEG;
                 this option can be omitted if only saving as PNG or SVG */
                backgroundColor: 'rgba(255, 255, 255, 0)',
                onEnd: onEndSign
            });
            $.signature.obj.signaturePad = signaturePad;

            function onEndSign() {
                $.signature.enableInsertBtn(true);
            }

            function resizeCanvas() {
                var ratio = Math.max(window.devicePixelRatio || 1, 1);
                canvasSignature.width = canvasSignature.offsetWidth * ratio;
                canvasSignature.height = canvasSignature.offsetHeight * ratio;
                canvasSignature.getContext("2d").scale(ratio, ratio);
                signaturePad.clear(); /* otherwise isEmpty() might return incorrect value */
            }

            $(window).resize(resizeCanvas);
            resizeCanvas();

            $('#signpad-clear-btn').click(function () {
                signaturePad.clear();
                $.signature.enableInsertBtn(false);
            });

            $('#signpad-undo-btn').click(function () {
                var data = signaturePad.toData();
                if (data) {
                    data.pop();
                    signaturePad.fromData(data);
                }
                if (data.length === 0)
                    $.signature.enableInsertBtn(false);
            });

            $('#signpad-aspng-btn').click(function () {
                if (signaturePad.isEmpty()) {
                    alert("Please provide a signature first.");
                } else {
                    var dataURL = signaturePad.toDataURL();
                    download(dataURL, "signature.png");
                }
            });

            $('#signpad-asjpeg-btn').click(function () {
                if (signaturePad.isEmpty()) {
                    alert("Please provide a signature first.");
                } else {
                    var dataURL = signaturePad.toDataURL("image/jpeg");
                    download(dataURL, "signature.jpg");
                }
            });

            function download(dataURL, filename) {
                if (navigator.userAgent.indexOf("Safari") > -1 && navigator.userAgent.indexOf("Chrome") === -1) {
                    window.open(dataURL);
                } else {
                    var blob = dataURLToBlob(dataURL);
                    var url = window.URL.createObjectURL(blob);

                    var a = document.createElement("a");
                    a.style = "display: none";
                    a.href = url;
                    a.download = filename;

                    document.body.appendChild(a);
                    a.click();

                    window.URL.revokeObjectURL(url);
                }
            }

            function dataURLToBlob(dataURL) {
                /* Code taken from https://github.com/ebidel/filer.js */
                var parts = dataURL.split(';base64,');
                var contentType = parts[0].split(":")[1];
                var raw = window.atob(parts[1]);
                var rawLength = raw.length;
                var uInt8Array = new Uint8Array(rawLength);

                for (var i = 0; i < rawLength; ++i) {
                    uInt8Array[i] = raw.charCodeAt(i);
                }

                return new Blob([uInt8Array], { type: contentType });
            }
        },
        loadModal: function (show) {
            if (show) {
                $('#addSignatureModal').modal("show");
                $("#btn-saved-sign").click();
            }
            else {
                $('#addSignatureModal').modal('hide');
            }
        },

        getFolder: function () {
            fxcRequest.get('/annotation/getsignaturefolder/',
                {},
                function (data) {
                    if (data != null) {
                        $.signature.obj.folder = data;
                        $.signature.getSignatures();
                    }
                    else {
                        $.signature.createFolder();
                    }
                }
            );
        },
        createFolder: function (callback) {
            fxcRequest.post('/annotation/createsignaturefolder/',
                {},
                function (data) {
                    if (data) {
                        $.signature.obj.folder = data;
                        $.signature.obj.savedSignatures = null;
                        $.signature.showEmptySignature();
                        swal.close();
                    }
                }
            );
        },
        getSignatures: function () {
            $('#modal-loading').show();
            $('#signaturesCarousel').hide();
            fxcRequest.get('/annotation/getsignaturelist/',
                { 'FolderID': $.signature.obj.folder.FolderId },
                $.signature.displaySignatures
            );
        },
        saveSignature: function (name, folderId, b64, callback) {
            fxcRequest.post('/annotation/savenewsignature/',
                {
                    'FileName': name,
                    'FolderID': folderId,
                    'Base64String': b64
                },
                callback, null, false);
        },
        deleteSignature: function (docId, callback) {
            fxcRequest.post('/annotation/deletesignatureimage/',
                {
                    'DocumentID': docId
                }, function (data) {
                    if (data) {
                        swal.close();
                        $('#signaturesCarousel').show();
                        $('#modal-loading').hide();

                        if (data.IsSuccess) {
                            var imgElemnt = $("img[data-docid='" + docId + "']");

                            var carouselItem = $(this).parent().parent();

                            var updatedSignatures = $.grep($.signature.obj.savedSignatures, function (item) {
                                return docId === item.DocumentID;
                            }, true);

                            $.signature.obj.savedSignatures = updatedSignatures;
                            var remainingImg = $('.carousel-item', $('#signaturesCarousel')).length;
                            if (remainingImg > 1) {
                                $.signature.removeCarouselItem(imgElemnt);

                            } else {
                                $.signature.showEmptySignature();
                                $.signature.removeCarouselItem(imgElemnt);
                                $.signature.obj.savedSignatures = null;
                            }

                        } else {
                            console.log('failed to delete');
                        }
                    }
                }, null, true, function (data) {
                    $('#signaturesCarousel').show();
                    $('#modal-loading').hide();
                }, null, null, true, function (data) {
                    $('#signaturesCarousel').hide();
                    $('#modal-loading').show();
                });
        },

        createIndicatorElement: function (index, isActive) {
            var indicatorElement = document.createElement('li');
            indicatorElement = $(indicatorElement);
            indicatorElement.attr('data-bs-target', '#signaturesCarousel');
            indicatorElement.attr('data-bs-slide-to', index);

            if (isActive) {
                indicatorElement.addClass('active');
            } else {
                indicatorElement.removeClass('active');
            }

            /*add to indicator parent element*/
            $('.carousel-indicators').append(indicatorElement);

            return indicatorElement;
        },
        displaySignatures: function (data) {
            if (data && data.Records && data.Records.length > 0) {
                $.signature.obj.savedSignatures = data.Records;
                var signatures = data.Records;

                var inner = $('#signaturesCarousel').find('.carousel-inner');
                inner.html("");

                $('.carousel-indicators').html("");

                if (signatures && signatures.length > 0) {
                    /*add signatures to carousel*/
                    $('#modal-loading').show();
                    $('#signaturesCarousel').hide();

                    $.each(signatures, function (i, sign) {
                        var isActive = i === 0 ;
                        var activeItem = isActive ? 'active' : '';
                        var carouselItem = $('<div class="carousel-item ' + activeItem + '" style="height: 300px; width: 500px;">');
                        var carouselImg = $('<img class="signatureimage" data-imgid="' + i + '" data-docid="' + sign.DocumentID + '" >');
                        var deleteSignBtn = $('<button data-docid="' + sign.DocumentID + '" class="btn btn-danger">Delete</button>');
                        var deleteWrapper = $('<div class="delete-saved-sign"></div>');

                        /*start indicator element*/
                        $.signature.createIndicatorElement(i, isActive);
                        /*end indicator element*/

                        deleteSignBtn.click(function (e) {
                            var docId = $(this).data('docid').toString();
                            $.signature.deleteSignature(docId);
                        });

                        /*change from call getSignatureB64Str to GetSignatureImageStream*/
                        carouselImg.on('load', function () {

                            var imgIndex = $(this).data('imgid');

                            $('#modal-loading').hide();
                            $('#signaturesCarousel').show();
                            $.signature.enableInsertBtn(true);
                        });

                        fxcRequest.get('/annotation/GetSignatureBase64String',
                            { "DocumentID": sign.DocumentID },
                            function (data) {
                                carouselImg.attr('src', data.Base64String);
                            }
                        );
                       
                        carouselImg.on("error", function () {
                            console.log("[Error] Image" + sign.DocumentID);
                        });

                        deleteWrapper.append(deleteSignBtn);
                        carouselItem.append(carouselImg);
                        carouselItem.append(deleteWrapper);
                        inner.append(carouselItem);
                    });

                    $('#empty-signatures').hide();
                    $('#signaturesCarousel').carousel();
                }
            }
            else {
                $.signature.showEmptySignature();
            }
        },
        getUpdatedSignatures: function (signatures) {
            var tempSignatures = [];
            if ($.signature.obj.savedSignatures) {
                if (signatures.length > $.signature.obj.savedSignatures.length) {
                    $.each(signatures, function (i, sign) {
                        var signature = $.grep($.signature.obj.savedSignatures, function (item) {
                            return sign.DocumentID.toString() === item.DocumentID.toString();
                        }, false);
                        if (signature.length === 0) tempSignatures.push(sign);
                        /* save the newly added signatures to saveSignatures.*/
                    });
                    isUpdateSignature = true;
                } else {
                    $('#modal-loading').hide();
                    $('#signaturesCarousel').show();
                    $.signature.enableInsertBtn(true);
                }
            } else {
                tempSignatures = signatures;
            }

            $.signature.obj.savedSignatures = signatures;

            return tempSignatures;
        },
        removeCarouselItem: function (imgElemnt) {
            if (imgElemnt) {
                var indexRemove = imgElemnt.attr('data-imgid');

                if ($(imgElemnt).closest(".carousel-item").hasClass("active")) {
                    $('#signaturesCarousel').carousel("next");
                }

                $(imgElemnt).closest(".carousel-item").remove();

                /*delete indicator*/
                var indicatorParentElement = $('.carousel-indicators');

                var indicatorElement = $('li[data-bs-slide-to="' + indexRemove + '"]', indicatorParentElement);
                if (indicatorElement) {
                    indicatorElement.remove();
                }

                var carouselItem = indicatorParentElement.children();
                $.each(carouselItem, function (index, item) {
                    var currentSlideID = $(item).attr('data-bs-slide-to');
                    $("img[data-imgid='" + currentSlideID + "']").attr('data-imgid', index);
                    $(item).attr('data-bs-slide-to', index);
                    if (carouselItem.length === 1) {
                        $(item).addClass('active');
                    }
                });
            }
        },
        showEmptySignature: function (e) {
            $('#modal-loading').hide();
            $("#signaturesCarousel").hide();
            $("#signaturesCarousel").find('.carousel-inner').html('');
            $.signature.enableInsertBtn(false);
            $('#empty-signatures').show();
        },

        enableInsertBtn: function (x) {
            if (x) {
                $('#div-insert-sign').show();
                $('#btn-insert-sign').prop('disabled', false);
                $('#btn-insert-sign').removeClass('btn-disabled');
                $('#btn-insert-sign').removeClass('disabled');
                $('#btn-insert-sign').addClass('btn-success');
            }
            else {
                $('#div-insert-sign').hide();
                $('#btn-insert-sign').removeClass('btn-success');
                $('#btn-insert-sign').addClass('btn-disabled');
                $('#btn-insert-sign').addClass('disabled');
                $('#btn-insert-sign').prop('disabled', true);
            }
        },

        createImg: function (b64, imgLoadCallback) {
            var img = new Image();
            img.onload = imgLoadCallback;
            img.src = b64;
        },
        createTransparent: function (canvas, imgdata) {
            var transparencyColor = $.signature.obj.transparency.color;
            var transparencyThreshold = parseInt($.signature.obj.transparency.threshold);

            var mask = document.createElement('canvas');
            mask.width = imgdata.width;
            mask.height = imgdata.height;

            mask.getContext('2d').drawImage(imgdata, 0, 0);
            var pixels = mask.getContext('2d').getImageData(0, 0, mask.width, mask.height);

            if (transparencyColor) {
                transparencyColor = colorToRGBA(transparencyColor);
                for (var i = 0; i < pixels.data.length; i += 4) {
                    var color = {
                        r: pixels.data[i + 0],
                        g: pixels.data[i + 1],
                        b: pixels.data[i + 2],
                        a: pixels.data[i + 3]
                    };

                    var delta = rgbaDifference(color, transparencyColor);

                    if (delta < transparencyThreshold) {
                        pixels.data[i + 0] = 0;
                        pixels.data[i + 1] = 0;
                        pixels.data[i + 2] = 0;
                        pixels.data[i + 3] = 0;
                    }
                }
            }

            mask.getContext('2d').putImageData(pixels, 0, 0);
            canvas.getContext('2d').drawImage(mask, 0, 0);
        },
        getScaling: function (width, height, maxWidth, maxHeight) {
            /*return (Math.min((maxWidth / width), (maxHeight / height)));*/
            return { width: maxWidth / width, height: maxHeight / height };
        },
        clearCanvas: function (e) {
            var canvasSign = document.getElementById('signonit-canvas'),
                contextSign = canvasSign.getContext('2d');
            contextSign.clearRect(0, 0, canvasSign.width, canvasSign.height);
        },

        /*Btn Action*/
        onBtnClick: function (e) {
            $(e).on('click', function (x, y) {
                $('.signature-option-btns button').removeClass("active");
                $(this).addClass("active");
                $.signature.enableInsertBtn(false);

                var getDataView = $(this).attr("data-view");
                var getDataType = $(this).attr("data-type");
                $.signature.obj.currentType = getDataType;
                $(".signature-div").hide();
                $(getDataView).show();

                switch (getDataType) {
                    case "select":
                        $($.signature.obj.savedSignatures != null && $.signature.obj.savedSignatures.length > 0)
                        {
                            $.signature.enableInsertBtn(true);
                        }
                        
                        break;
                    case "manual":
                        if (!$.signature.obj.signaturePad)
                            $.signature.initSignaturePad();
                        else
                            $.signature.clearCanvas();
                        break;
                    case "upload":
                        if (!$.signature.obj.signatureDropify)
                            $.signature.initDropify();

                        var signDropify = $.signature.obj.signatureDropify.data('dropify');
                        signDropify.resetPreview();
                        signDropify.clearElement();
                        break;
                }
            });
        },
        onBtnInsertClick: function (e) {
            $(e).on('click', function (x, y) {

                if ($.signature.obj.folder !== {}) {
                    var getDataType = $.signature.obj.currentType;

                    switch (getDataType) {
                        case "select":
                            var activeCarousel = $('#signaturesCarousel').find('.carousel-item.active');
                            $.signature.obj.imageSrc = $(activeCarousel).find('img').attr('src');
                            break;
                        case "manual":
                            if ($.signature.obj.signaturePad != null)
                                $.signature.obj.imageSrc = $.signature.obj.signaturePad.toDataURL('image/png');
                            var today = $.messageAnnotation.getTodayDateTime();
                            $.signature.saveSignature(today, $.signature.obj.folder.FolderId, $.signature.obj.imageSrc, function (data) {
                                swal.close();
                            });

                            break;
                        case "upload":
                            var today = $.messageAnnotation.getTodayDateTime();
                            var canvasDropify = document.getElementById('upload-sign-canvas');
                            $.signature.obj.imageSrc = canvasDropify.toDataURL('image/png');

                            $.signature.saveSignature(today, $.signature.obj.folder.FolderId, $.signature.obj.imageSrc, function (data) {
                                swal.close();
                            });
                            break;
                    }
                }
                if ($.signature.obj.imageSrc != null) {

                    var getX = 0;
                    var getY = 0;

                    if ($.messageAnnotation.rotateAngle == 90 || $.messageAnnotation.rotateAngle == -270) {
                        getX = 0;
                        getY = base_image.height;
                    }
                    else if (Math.abs($.messageAnnotation.rotateAngle) == 180) {
                        getX = base_image.width;
                        getY = base_image.height;
                    }
                    else if ($.messageAnnotation.rotateAngle == 270 || $.messageAnnotation.rotateAngle == -90) {
                        getX = base_image.width;
                        getY = 0;
                    }

                    newShape = {
                        no: $.messageAnnotation.drawCount,
                        fullStackId: $.messageAnnotation.newGuid(),
                        id: $.messageAnnotation.newGuid(),
                        startX: getX,
                        startY: getY,
                        imageSrc: $.signature.obj.imageSrc,
                        type: $.messageAnnotation.obj.type,
                        rotateAngle: $.messageAnnotation.rotateAngle,
                        action: "add"
                    }

                    $.messageAnnotation.displayStack.push(newShape);
                    $.messageAnnotation.fullStack.push(newShape);
                    $.messageAnnotation.redoStack = [];
                    $.drawCanvas.drawAll();

                    $.messageAnnotation.drawCount++;
                }

                newShape = null;

                $.signature.loadModal(false);
            });
        },
    }
})(window.jQuery || $);