﻿/*Detail Tab*/
$.delegatee = {
    initGridDelegateeHistory: function (e) {
        var id = $('#gridDelgHist');

        var dataSource = {
            transport: {
                read: {
                    url: '/Common/MessageViewer/GetDelegateeHistory',
                    dataType: "json",
                    type: "GET"
                },
                parameterMap: function (options) {
                    /* Fix url param for sort values */
                    var result = {
                        Skip: options.skip,
                        Take: options.take,
                        Sort: options.sort,
                        MessageId: $('#MsgID').val()
                    };
                    if (options.sort && options.sort.length > 0) {
                        result.SortBy = options.sort[0].field;
                        result.Direction = options.sort[0].dir;
                    }
                    return result;
                }
            },
            schema: {
                data: "Records",
                total: "Total",
                model: {
                    id: "Id"
                }
            },
            serverPaging: true,
            serverSorting: true
        };

        var col = [
            { field: 'ActionID', hidden: true },
            { field: 'ActionDateFormat', title: $msgViewer.delegatorHistory.colActionDate, minWidth: 200, width: 300, sortable: true },
            { field: 'Delegator', title: $msgViewer.delegatorHistory.colDelegator, minWidth: 200, width: 300, sortable: true },
            { field: 'ActionTitle', title: $msgViewer.delegatorHistory.colActionTitle, sortable: true, minWidth: 200, width: 350 },
            { field: 'ActionDesc', title: $msgViewer.delegatorHistory.colActionDescription, sortable: true, minWidth: 350, width: 500 }
        ];

        var obj = {};
        obj.onDataBoundExtraFn = $.detail.initGridDelegateeHistory_dataBound;
        var $grid = kendogridcustomization.init(id, dataSource, col, obj);
    },
    initGridDelegateeHistory_dataBound: function (e) {
        var grid = e.sender;
        var data = grid.dataSource.data();
        if (data.length === 0) {
            $('#gridDelgHist').hide();
        }
    }
};