﻿$.imageViewer = {
    init: function (e) {
        $.imageViewer.selectAllThumbnailClickEventHandler($('.btn-select-all-thumb'));
        $.imageViewer.thumbnailClickEventHandler($('#imageThumbnail .li-checkbox-img'));
        $.imageViewer.thumbnailCheckboxClickEventHandler($('#imageThumbnail input[type="checkbox"][id^=img]'));
    },
    constructImageViewer: function (e) {
        if (!mvPrivacy) {
            var messageId = $('#MsgID').val();
            var transId = $("#TranscList-Value").val();
            var pageNumber = '0';
            var width = '125'; /*set thumbnail width, 125 is default from v5*/
            var format = 'image'; /* native or image*/
            var isXsact = '1'; /* 0 or 1*/

            fxcRequest.get('/Common/MessageViewer/GetFrameCount',
                {
                    "XsactId": transId,
                    "IsXsact": isXsact
                }, function (data) {
                    pageNumber = data.Count;
                    $('#PageCount').val(Number(pageNumber));

                    $.imageViewer.showBtnAnnotation();

                    if (Number(pageNumber) > 0) {
                        $.imageViewer.noImage(false);

                        /*Construct Main Image*/
                        var params = {
                            messageId: messageId,
                            transactId: transId,
                            page: '0',
                            format: 'image',
                            isXsact: isXsact,
                            pageNumber: $('#PageCount').val()
                        };

                        $.imageViewer.displayMainImage(params);
                        /*End Construct Main Image*/

                        /* Construct Thumbnails */
                        /* Load all the thumbnails
                         * TODO: Lazy loading on thumbnails */
                        maxSlide = pageNumber;

                        $('#ImageTab .pane-div #imageThumbnail ul#carousel').empty();

                        for (i = 0; i < pageNumber; i++) {
                            var html = '<li id="thumbnail-' + i + '" class="li-checkbox-img ' + (i == 0 ? 'selected' : '') + '">' +
                                '<a href="#">' +
                                '<img src= "/Common/MessageViewer/RetrieveImage?XsactId=' +
                                transId + '&PageNumber=' + i + '&Width=' + width + '' +
                                '&Format=' + format + '&IsXsact=' + isXsact + '"' +
                                ' alt="Image-'+i+'" data-format="' + format + '" data-isXsact="' + isXsact + '" data-page="' + i + '"' +
                                (i == 0 ? 'class="selectedThumbnail"' : '') + '>' +
                                '</a> ' +
                                '<div class="checkbox checkbox-success img-group">' +
                                '<input id ="img' + i + '" class="filled-in chk-col-blue" type="checkbox">' +
                                '<label for="img' + i + '"><span>' + $msgViewer.grid.page + (i + 1) + '</span></label>' +
                                '</div>' +
                                '</li>';

                            if (i < maxSlide) {
                                $('#ImageTab .pane-div #imageThumbnail ul').append(html);
                            } else {
                                $('#ImageTab .pane-div #imageThumbnail ul').append('<li id="thumbnail-' + i + '" class="li-checkbox-img hide"></li>');
                            }
                        }

                        /* Enable and show the annotation button */
                        if (!loadAnnotate && $("#btn-annotate").length > 0) {
                            loadAnnotate = true;
                        }
                        /* End Construct Thumbnails */
                    }
                    else {
                        $.imageViewer.noImage(true);
                    }


                    /* Construct More Thumbnails */
                    var allImgControl = $('ul#carousel li');
                    var totalList = allImgControl.length;
                    var loadedList = $('ul#carousel li a').length;
                    var pendingLoad = totalList - loadedList;

                    if (pendingLoad > 0) {
                        $('#loadmore').show();
                    }
                    else {
                        $('#loadmore').hide();
                    }

                    $('#loadmore').on('click', function () {
                        var scrollToEle;

                        /* Get which element is not fully visible, scroll to it later */
                        $('#carousel li').each(function () {
                            var parentHeight = $("#carousel_wrapper").height();
                            var elePosition = $(this).offset().top - $("#carousel_wrapper").offset().top;
                            var eleHeight = $(this).height();

                            /* If this element is 50% less visible in the div, scroll to it*/
                            if (((elePosition + eleHeight / 2) >= parentHeight) && (elePosition > 0)) {
                                scrollToEle = this.id;

                                return false;
                            }
                        });

                        /* if user scrolled to the bottom, scroll to the next first loaded element*/
                        if (typeof scrollToEle === 'undefined' || scrollToEle == '') {
                            scrollToEle = "thumbnail-" + (loadedList + 1);
                        }

                        if (pendingLoad > 0) {
                            var loadLimit = loadedList + maxSlide;

                            var dataTarget = $('.btn-select-all-thumb').data("target");
                            var checkThumbnail = flag ? "checked" : "";
                            for (next = loadedList; next < loadLimit; next++) {

                                var nextLoadControl = allImgControl[next];
                                if (nextLoadControl) {

                                    var content = $(nextLoadControl).innerHtml;
                                    if (!content) {
                                        var html = '<a href="#">' +
                                            '<img src= "/Common/MessageViewer/RetrieveImage?XsactId=' +
                                            transId + '&PageNumber=' + next + '&Width=' + width + '' +
                                            '&Format=' + format + '&IsXsact=' + isXsact + '"' +
                                            ' alt="Image='+next+'" data-format="' + format + '" data-isXsact="' + isXsact + '" data-page="' + next + '">' +
                                            '</a> ' +
                                            '<div class="checkbox checkbox-success img-group">' +
                                            '<input id ="img' + next + '" class="filled-in chk-col-blue" type="checkbox" ' + checkThumbnail + '>' +
                                            '<label for="img' + next + '"><span>' + $msgViewer.grid.page + (next + 1) + '</span></label>' +
                                            '</div>';


                                        $(nextLoadControl).empty();
                                        $(nextLoadControl).removeClass('hide');
                                        $(nextLoadControl).append(html);
                                        $.imageViewer.thumbnailClickEventHandler($('.li-checkbox-img', $(nextLoadControl)));
                                        $.imageViewer.thumbnailCheckboxClickEventHandler($('input[type="checkbox"][id^=img]', $(nextLoadControl)));

                                    }
                                }
                            }
                            /* Check pending load again !*/
                            allImgControl = $('ul#carousel li');
                            totalList = allImgControl.length;
                            loadedList = $('ul#carousel li a').length;
                            pendingLoad = totalList - loadedList;

                            if (pendingLoad == 0) {
                                $('#loadmore').hide();
                            }

                            /* Scroll to the next thumbnail that is 50% less visible in the carousel */
                            var images = $("ul#carousel li a img");
                            var unloaded = loadedList.length;
                            images.on('load', function () {
                                --unloaded;
                                if (!unloaded) {
                                    $("#carousel_wrapper").animate({ scrollTop: ($('#' + scrollToEle).offset().top - $("#carousel").offset().top) }, "slow")
                                }
                            });
                        }
                    });
                    /* End Construct More Thumbnails */

                    $.imageViewer.init();
                }, function (error) { }, false, null, function (serverError) {
                    $.imageViewer.noImage(true);
                });
        }
        else {
            $.imageViewer.noImage(true, $msgViewer.message.restricted);
        }

        $.messageviewer.onAnnotateClickHandler('#btn-annotate');

        $('.viewer').bind('ivieweronfinishload', function (ev, src) {
            iv1.iviewer('fit');
            iv1.iviewer('update');
            $(this).children(".loader").addClass("hide");
            if ($allowImgRightClick != true) {
                $("#ImageTab img").attr("oncontextmenu", "return false;");

                for (let i = 0; i < $('img[alt="No Image"]').length; i++) {
                    $('img[alt="No Image"]:eq(' + i + ')').attr('alt', 'image-' + i)
                } 
                $('#imageMain img').attr('alt', 'image-main')
                $('#imageMain div.img-content img').attr('alt', '')
            }
        });
    },

    /*Btn Action*/
    selectAllThumbnailClickEventHandler: function (e) {
        $(e).on('click', function (x, y) {
            $.imageViewer.selectAll($(this));
        });
        $(e).click();
    },
    thumbnailCheckboxClickEventHandler: function (e) {
        $(e).on('click', function (event) {
            var e = $('.btn-select-all-thumb');
            var dataTarget = e.data("target");
            var getCount = $('#PageCount').val();
            var checkCurrentItemFlag = $(this).is(':checked');

            var countThumbnailCheckbox = $('#imageThumbnail input[type="checkbox"][id^=img]').length;

            var checkUnloadThumbnailCheckbox = getCount - countThumbnailCheckbox;
            var countCheckItem = 0;
            var countUnCheckItem = 0;
            if (checkUnloadThumbnailCheckbox > 0) {
                countCheckItem = flag ? countCheckItem + checkUnloadThumbnailCheckbox : countCheckItem;
                countUnCheckItem = flag ? countUnCheckItem : countUnCheckItem + checkUnloadThumbnailCheckbox;
            }
            $('#imageThumbnail input[type="checkbox"][id^=img]').each(function (index, value) {
                if ($(this).is(':checked'))
                    countCheckItem++;
                else
                    countUnCheckItem++;
            });

            if (countCheckItem > 0) {
                $('#hfNoneSelected').val('false');
            }
            else {
                $('#hfNoneSelected').val('true');
            }

            if (countCheckItem == getCount) {
                $.imageViewer.selectAllThumbnailFn(e, true);
            }
            else if (countUnCheckItem != getCount || (countUnCheckItem == 1 && countUnCheckItem == getCount)) {
                $.imageViewer.selectAllThumbnailFn(e, false);
            }
        });
    },
    thumbnailClickEventHandler: function (e) {
        $(e).on('click', function (event) {
            $('.li-checkbox-img.selected').removeClass('selected');
            $('.selectedThumbnail').removeClass('selectedThumbnail'); /* removes the previous selected class*/

            $(this).addClass('selected');
            $(this).children('img').addClass('selectedThumbnail'); /* adds the class to the clicked image*/

            var newImg = $(event.currentTarget).find('img')[0];
            $(".viewer").children(".loader").removeClass("hide");
            $.imageViewer.retrieveMainImage(newImg);
        });
    },

    /*Logic*/
    displayMainImage: function (e) {
        var imgSrc = '/Common/MessageViewer/RetrieveImage?XsactId=' + e.transactId + '&PageNumber=' + e.page + '&Width=' + 0 + '&Format=' + e.format + '&IsXsact=' + e.isXsact;

        if (e.pageNumber > 0) {
            $('#imageMain h2').remove();
            iv1.iviewer('loadImage', imgSrc);
        }
        else {
            imgSrc = '/Content/iviewer/img/noImg.png';
        }
    },
    getSelectedImage: function () {
        /* Selected refers to the unchecked thumbnails */
        deselectImgCount = 0;
        var img = '';

        /* If all thumbnails are selected */
        if ($('.btn-select-all-thumb').data('target') == 'SelectAll') {
            return $('#hfDeselectedPages').val('');
        }

        if ($('#hfNoneSelected').val() == 'false') { /* If at least one thumbnails selected */
            var selectedImg = $('#carousel input[type="checkbox"]');
            var totalImg = Number($('#PageCount').val());

            if (selectedImg != undefined || selectedImg != null) {
                $.each(selectedImg, function (i, v) {
                    var data = v.id.substr(3);

                    if (!v.checked)
                        img += data + ';';
                });


                if (selectedImg.length < totalImg) {
                    if (!flag) { /* If the unloaded images are unselected, add them in */
                        for (i = selectedImg.length; i < totalImg; i++) {
                            img += i + ';';
                        }
                    }
                }
            }
        }
        else { /* If NO thumbnails selected (All checkboxes unchecked) */
            for (i = 0; i < Number($('#PageCount').val()); i++) {
                img += i + ';';
            }
        }

        if (img != '') {
            deselectImgCount = img.substring(0, img.length - 1).split(';').length;
            $('#hfDeselectedPages').val(img.substring(0, img.length - 1));
        }

        return $('#hfDeselectedPages').val();

    },
    retrieveMainImage: function (e) {
        var params = {
            messageId: $('#MsgID').val(),
            transactId: $("#TranscList-Value").val(),
            page: e.dataset.page,
            format: e.dataset.format,
            isXsact: e.dataset.isxsact,
            pageNumber: $('#PageCount').val()
        };

        $.imageViewer.displayMainImage(params);
    },
    selectAll: function (e) {
        var dataTarget = $(e).data("target");

        flag = dataTarget === 'SelectAll' ? false : true;
        $('#hfNoneSelected').val(!flag);

        $.imageViewer.selectAllThumbnailFn(e, flag);

        $('#carousel div.checkbox.checkbox-success.img-group input[type="checkbox"]').each(function (i, v) {

            if (!$(this).is(':disabled')) {
                $(this).prop('checked', flag);
            }
        });

        $(e).blur();

    },
    selectAllThumbnailFn: function (e, flag) {
        var iClass = $(e).find("i").attr("class");
        if (flag) {
            $(e).data("target", "SelectAll");
            $(e).find("span").text($msgViewer.actionTitle.unselectAll + " (" + $('#PageCount').val() + ")");
            $(e).attr("title", $msgViewer.actionTitle.unselectAll);
            $(e).find("i").removeClass(iClass);
            $(e).find("i").addClass("mdi mdi-checkbox-blank-circle-outline");
            $(e).addClass("btn-secondary");
            $(e).removeClass("btn-success");
        }
        else {
            $(e).data("target", "UnselectAll");
            $(e).find("span").text($msgViewer.actionTitle.selectAll + " (" + $('#PageCount').val() + ")");
            $(e).attr("title", $msgViewer.actionTitle.selectAll);
            $(e).find("i").removeClass(iClass);
            $(e).find("i").addClass("mdi mdi-check-circle-outline");
            $(e).removeClass("btn-secondary");
            $(e).addClass("btn-success");

        }
    },
    noImage: function (e, customMessage) {
        if (e) {
            $('#noimage-overlay').removeClass('hide');
            var noImageMsg = customMessage ? customMessage : $msgViewer.message.noImageAvailable;
            $('#noimage-overlay h2').empty().append('<i class="fa fa-image fa-3x"></i><br />' + noImageMsg);
            $('#saveAction button, #printAction button').attr('disabled', 'disabled');
        }
        else {
            $('#noimage-overlay').addClass('hide');
            $('#noimage-overlay h2').empty().append('<i class="fa fa-spinner fa-pulse fa-2x fa-fw"></i><br />' + $msgViewer.message.loading);
            $('#saveAction button, #printAction button').removeAttr('disabled', 'disabled');

            if ($('#saveAction button.btn-msgviewer-save').attr("data-download") == "false") {
                $('#saveAction button.btn-msgviewer-save').attr('disabled', 'disabled');
            }
        }
    },
    showBtnAnnotation: function () {
        var $pages = $('#PageCount').val();
        if ($pages == '' || parseInt($pages) == 0) {
            $('#btn-annotate').hide();
        }
        else {
            $('#btn-annotate').show();
        }
    }
    /*Post or Get Function*/
};