﻿/*Tracking Tab*/
var validationTracking = function () {
	$('#formSubmit-tracking').validate({
		ignoreTitle: true,
        submitHandler: function (form) {
            $.tracking.save();
        }
    });
};

$.tracking = {
    init: function () {
        /*Button Handler*/
        $.tracking.backButtonClickHandler($('#btn-back-tracking'));
        $.tracking.createButtonClickHandler($('#btn-add-tracking'));
        $.tracking.editButtonClickHandler($('#btn-edit-tracking'));
        $.tracking.resetButtonClickHandler($('#btn-reset-tracking'));
        $.tracking.saveButtonClickHandler($('#btn-save-tracking'));

        validationTracking();
        $.tracking.showDisplay(true);

        /*update rules*/
		var allinput = $("#formSubmit-tracking input");
		var isRequired = false;
        $.each(allinput, function (index, control) {

			var errMsg = $(control).data("errmessage");

			var regexFormat = $(control).attr("pattern");
			if (regexFormat != null) {
				$(control).rules("add", {
					required: $(control).prop('required'),
					regex: regexFormat,
					messages: {
						regex: errMsg,
						required: $globalMessages.validation.required,
						minlength: errMsg,
						maxlenght: errMsg
					}
				});
			}

			var maskFormat = $(control).data("inputmask");
			if (maskFormat != null) {
				$(control).rules("add", {
					required: $(control).prop('required'),
					messages: {
						required: $globalMessages.validation.required,
						minlength: errMsg,
						maxlenght: errMsg
					}
				});

				$(control).mask(maskFormat);
			}

			if (!isRequired) {
				isRequired = $(control).prop('required');
			}

        });
        /*end update rules*/
    },

    /*Btn Action*/
    backButtonClickHandler: function (e) {
        $(e).on('click', function (x, y) {
            $.tracking.showDisplay(true);
            $('#TrackingType').val('1');
        });
    },
    createButtonClickHandler: function (e) {
        $(e).on('click', function (x, y) {
            $.tracking.showDisplay(false);
            $('#TrackingType').val('0');
        });
    },
    editButtonClickHandler: function (e) {
        $(e).on('click', function (x, y) {
            $.tracking.showDisplay(false);
        });
    },
    resetButtonClickHandler: function (e) {
        $(e).on('click', function (x, y) {
            $.tracking.resetFields();
        });
    },
    saveButtonClickHandler: function (e) {
        $(e).on('click', function (x, y) {
            $("#formSubmit-tracking").submit();
        });
    },

    /*Logic*/
    resetFields: function () {
        $("#formSubmit-tracking").trigger("reset");
        $("#formSubmit-tracking").validate().resetForm();
    },
    showDisplay: function (show) {
        show = show || false; /* default value is false
        If true --> show*/

        $(".displayView").each(function (index) {
			if (show) {
				$.tracking.resetFields();
                if ($(this).hasClass("hide")) {
                    $(this).removeClass("hide");
                }
            }
            else {
                if (!$(this).hasClass("hide")) {
                    $(this).addClass("hide");
                }
            }
        });

        $(".actionView").each(function (index) {
            if (!show) {
                if ($(this).hasClass("hide")) {
                    $(this).removeClass("hide");
                }
            }
            else {
                if (!$(this).hasClass("hide")) {
                    $(this).addClass("hide");
                }
            }
        });
    },

    /*Post or Get Function*/
    initForm: function (e) {
        $("#TrackingTab .div-msg-tracking").html("");
        $("#TrackingTab .div-msg-tracking").addClass("divLoading");
        fxcRequest.post('/Common/MessageViewer/GetTrackingView',
            {
                "ID": $('#MsgID').val(),
                "UserMsgID": $('#UserMsgID').val(),
                "AppReqID": $('#ApprovalReqID').val(),
                "FolderID": $('#FolderId').val(),
                "DelgID": $('#DelegatorID').val(),
                "DelgPro": $('#DelgProID').val()
            },
            function (data, textStatus, jqXHR) {
                $("#TrackingTab .div-msg-tracking").html(data);
                $("#TrackingTab .div-msg-tracking").removeClass("divLoading");
                $.tracking.init();

            }, function (error) {
                swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnSubmit, "error");
            }, false);
    },
    save: function () {
        fxcRequest.post('/Common/MessageViewer/SaveTracking',
            {
                "ID": $('#MsgID').val(),
                "UserMsgID": $('#UserMsgID').val(),
                "AppReqID": $('#ApprovalReqID').val(),
                "FolderID": $('#FolderId').val(),
                "DelgID": $('#DelegatorID').val(),
                "DelgPro": $('#DelgProID').val(),
                "TrackingType": $('#TrackingType').val(),
				"TrackingFormData": $("#TrackingTable-Action").MapFormData(),
				"TrackingKeyInfo": {
					"MessageId": $("#TrackingKeyInfo_MessageId").val(),
					"UserId": $("#TrackingKeyInfo_UserId").val(),
					"TrackingKey": parseInt($("#TrackingKeyInfo_TrackingKey").val()),
					"ShowValue": $("#TrackingKeyInfo_ShowValue").val() == "true" ? true : false,
				}
            },
            function (data) {
                $.toast({
                    heading: 'Success',
					text: $msgViewer.message.trackSaveSuccess,
                    position: 'bottom-right',
                    loaderBg: '#ff6849',
                    icon: 'success',
                    hideAfter: 3500,
                    stack: 6
                });

                $.tracking.initForm();
            },
            function (error) {
                swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnSubmit, "error");
            }, false);
    }
};
