﻿(function ($) {
    $.sharedUiGuide = {
        init: function (opts) {
            if ($(opts.startTourBtn)) {
                this.addClickListener('#fxcMenu', function () {
                    if (hopscotch.isActive) hopscotch.startTour(opts.tour, hopscotch.getCurrStepNum());
                });
                this.addClickListener(opts.startTourBtn, function () {
                    hopscotch.endTour();
                    if (!hopscotch.isActive) hopscotch.startTour(opts.tour);
                });
                /*change the position of ui guide everytime the user scrolls*/
                $('.fxc-main-content-body').scroll(function () {
                    if (hopscotch.isActive) {
                        hopscotch.startTour(hopscotch.getCurrTour(), hopscotch.getCurrStepNum());
                    }
                });
            }
        },
        scrollToFixedPlacementTarget: function (tour, step, target) {
            var isFixed = tour.steps[step].fixedElement ? true : false;
            if (isFixed) {
                var body = $('.fxc-main-content-body');
                var container = $('.fxc-main-content');
                body.scrollTop($(target).offset().top - container.offset().top + body.scrollTop());
            }
        },
        addClickListener: function (el, fn) {
            $(el).on('click', fn);
        },
        setCustomRenderer: function () {
            hopscotch.setRenderer($.fxcCustomHopscotch.fxcBubble);
        },
        getUser: function (user) {
            return user.split('(')[1].split(')')[0];
        },
        storeState: function (stateName, data) {
            if (this.hasLocalStorage()) {
                localStorage.setItem(stateName, JSON.stringify(data));
            } else {
                this.addCookie(stateName, JSON.stringify(data));
            }
        },
        hasLocalStorage: function () {
            var test = 'test';
            try {
                localStorage.setItem(test, test);
                localStorage.removeItem(test);
                return true;
            } catch (e) {
                return false;
            }
        },
        getCookie: function (c) {
            var b = document.cookie.match('(^|;)\\s*' + c + '\\s*=\\s*([^;]+)');
            return b ? b.pop() : '';
        },
        addCookie: function (name, value) {
            var domain = window.location.hostname;
            var now = new Date();
            var expires = new Date();
            expires.setMonth(expires.getMonth() + 1);
            var extras = { path: '/', domain: domain, expires: expires, secure: false };

            this.setCookie(name, value, extras);
        },
        setCookie: function (key, value, extras) {
            key = key.replace(/[^#$&+\^`|]/g, encodeURIComponent);
            key = key.replace(/\(/g, '%28').replace(/\)/g, '%29');
            /*value = (value + '').replace(/[^!#$&-+\--:<-\[\]-~]/g, encodeURIComponent);*/
            extras = extras || {};

            var cookieString = key + '=' + value;
            cookieString += extras.path ? ';path=' + extras.path : '';
            cookieString += extras.domain ? ';domain=' + extras.domain : '';
            cookieString += extras.expires ? ';expires=' + extras.expires.toUTCString() : '';
            cookieString += extras.secure ? ';secure' : '';

            document.cookie = cookieString;
        },
        unbindStartTourBtn: function () {
            $('.sidebar-nav-link').on('click', function () {
                $('#pageGuideBtn').unbind('click');
                var domain = $(this).attr('href');

                if (domain.indexOf('admin') !== -1 && hopscotch.isActive && hopscotch.getCurrTour().id !== 'admin-hopscotch') {
                    hopscotch.endTour(true);
                }
                if (domain.indexOf('user') !== -1 && hopscotch.isActive && hopscotch.getCurrTour().id !== 'user-hopscotch') {
                    hopscotch.endTour(true);
                }
            });
        },
        destroy: function () {
            hopscotch.endTour(true);
        }
    };
})(window.jQuery);