﻿var fxcUserConn = fxcUserConn || {};
$(function () {
    $.connection.userHub.client.claimsUpdate = function (refreshPage) {
        if ($.connection.userHub.connection.state === 4) {
            return;
        }
        /*
            if we want to add browser notification 
            fxcNotification.notify('message');
         */
        var domainId = $('#dashboardID').val();
        /*domainId will be undefined or null in /user section*/
        if (domainId === undefined || domainId === null) {
            updateClaims(refreshPage);
        } else {
            fxcRequest.get('/DomainActive', { DomainId: $('#dashboardID').val() }, function (data) {
                console.log(data);
                if (data === 'true' || data === true) {
                    updateClaims(refreshPage);
                } else {
                    $.connection.userHub.client.forceLogout();
                }
            });
        }
    };

    var updateClaims = function (refreshPage, immediateRefresh = false) {
        if ($.connection.userHub.connection.state === 4) {
            return;
        }
        fxcRequest.get('/UpdateClaims', {}, function (data) {
            if (immediateRefresh) {
                window.location.reload();
            }
            if (refreshPage) {
                if (!fxcNotification.notify($globalMessages.swal.alert.promptRefresh, refreshPage)) {
                    setTimeout(window.location.reload(), 3000);
                }
            }
        });
    };

    $.connection.userHub.client.forceLogout = function () {
        if ($.connection.userHub.connection.state === 4) {
            return;
        }
        fxcNotification.notify($globalMessages.swal.alert.promptInactiveDomain, false);
        $.connection.hub.stop();
        fxcRequest.get('/logout', { redirect: false }, function (data) { });
        swal({
            title: $globalMessages.swal.domainOffline,
            text: $globalMessages.swal.alert.promptForceLogout,
            type: "warning",
            showCancelButton: false,
            confirmButtonClass: "btn-danger",
            confirmButtonText: $globalMessages.swal.continue,
            closeOnConfirm: false,
            closeOnCancel: false
        }, function () {
            window.location.pathname = '/logout';
        });
    };

    $.connection.userHub.client.loginEmailUpdate = function () {
        if ($.connection.userHub.connection.state === 4) {
            return;
        }
        var seconds = 5;
        var cancelBtn = $globalMessages.button.cancel + " ({0})";
        var timer;

        swal({
            title: $globalMessages.swal.loginAddUpd,
            text: $globalMessages.swal.loginAddUpdDesc,
            type: "warning",
            showCancelButton: true,
            cancelButtonText: cancelBtn.replace(/\{0\}/, seconds),
            confirmButtonClass: "btn-danger",
            confirmButtonText: "Refresh",
            closeOnConfirm: false,
            closeOnCancel: true,
            timer: seconds * 1000
        }, function (isConfirm) {
            if (isConfirm) {
                updateClaims(false, true);
            }
            else {
                swal.close();
            }
        });

        timer = setInterval(function () {
            seconds--;

            if (seconds < 0) {
                clearInterval(timer);
            }

            $('.sweet-alert button.cancel').text(cancelBtn.replace(/\{0\}/, seconds));

        }, 1000);
    };

    $.connection.hub.logging = true;
    $.connection
        .hub
        .start()
        .done(function () {
            fxcNotification.requestPermission();
        })
        .fail(function () {
            /* swal($globalMessages.swal.error.errorCap, $globalMessages.swal.alert.unableLoadSignalR, "error"); */
        });

    fxcUserConn.onDomainChanges = function (domainId, notifyAll, refreshPage, isactive) {
        if ($.connection.userHub.connection.state === 4) {
            return;
        }
        $.connection.userHub.server.onDomainUpdated(domainId, notifyAll, refreshPage, isactive);
    };

    fxcUserConn.onUpdateUser = function (userId, refreshPage, isactive) {
        if ($.connection.userHub.connection.state === 4) {
            return;
        }
        $.connection.userHub.server.onUserUpdated(userId, refreshPage, isactive);
    };

    fxcUserConn.onUpdateInactive = function (userId, isactive) {
        if ($.connection.userHub.connection.state === 4) {
            return;
        }
        $.connection.userHub.server.onUserUpdated(userId, isactive);
    };

    fxcUserConn.onUpdateLoginEmail = function (userId) {
        if ($.connection.userHub.connection.state === 4) {
            return;
        }
        $.connection.userHub.server.onLoginEmailUpdated(userId);
    };
});