﻿var fxcMessageHub = fxcMessageHub || {};
$(function () {

    fxcMessageHub = $.connection.messageHub;

    fxcMessageHub.client.refresh = function (model) {
        if (fxcMessageHub.connection.state === 4) {
            return;
        }
        var location = model.RefreshLocation;
        switch (location) {
            case 1:/*refresh message grid*/
                $.messages.refreshMessageFromHub(model);
                break;
            case 2:
                $.messages.refreshMessageFromHub(model);
                break;
            case 3:
                $.searchMessages.refreshMessageFromHub(model);
                break;
            case 4:
                $.msgqueue.refreshMessageFromHub(model);
                break;
            case 5:
                $.msgschedule.refreshMessageFromHub(model);
                break;
        }
    };

    fxcMessageHub.client.markAsRead = function (id) {
        if (fxcMessageHub.connection.state === 4) {
            return;
        }
        $.messageviewer.markAsRead(id);
    };

    fxcMessageHub.client.writeToView = function (message) {
        if (fxcMessageHub.connection.state === 4) {
            return;
        }
        fxcNotification.notify(message);
    };

    fxcMessageHub.client.notifySender = function (mid, message, date) {
        if (fxcMessageHub.connection.state === 4) {
            return;
        }
        fxcNotification.notify(message, false, mid);
        fxcNotificationStorage.insert(mid, message, date);
    };

    fxcMessageHub.client.notifyReciever = function (mid, message, date) {
        if (fxcMessageHub.connection.state === 4) {
            return;
        }
        fxcNotification.notify(message, false, mid);
        fxcNotificationStorage.insert(mid, message, date);
    };

    fxcMessageHub.connection.start();
});