﻿var userSelectionID;

(function ($) {
    $.domainSelection = {
        init: function (id, obj) {
            /* Configuration */
            obj = obj || {};
            var bootstrapInput = obj.bootstrapInput || "False"; /*Indicates whether to triggered insert info to bootstrapInput */
            userSelectionID = id; /*Set ID*/

			$.domainSelection.searchPressEnter($('input[data-role="search-' + id + '-item"]'));
			$.domainSelection.searchButtonClickHandler($('.btn-search-' + id));
            if ((bootstrapInput + "").toLowerCase() === "true") {
                $.domainSelection.initBootstrapInput();
            }
			$.domainSelection.addButtonClickHandler($("#BtnAdd" + id));

			$('#modal-' + id).attr("data-modalId", id);

            $('#modal-' + id).on('shown.bs.modal', function () {
				userSelectionID = $(this).attr("data-modalId");

                var defaultDomainSelectionControlId = '#defaultSelectedID-' + userSelectionID;
                var selectedDefaultdomainContolId = $(defaultDomainSelectionControlId).val();
                var selectedDefaultdomainId = $(selectedDefaultdomainContolId).val();
                /*Prev: $("#DomainSelection-" + userSelectionID + "-id").val($('#dashboardID').val());*/
                $("#DomainSelection-" + userSelectionID + "-id").val(selectedDefaultdomainId);

                var node = $("#DomainSelection-" + userSelectionID).tree().getNodeById($("#DomainSelection-" + userSelectionID + "-id").val());

                $("#DomainSelection-" + userSelectionID).tree().unselectAll();
                $("#DomainSelection-" + userSelectionID).tree().select(node);

			});
			$.domainSelection.initTreeView(id);
        },
        initBootstrapInput: function () {
            var bootstrapInputID = $("#bootstrapInputID-" + userSelectionID).val();
            var tooltip = $('input#' + bootstrapInputID).attr('title');

            $('input#' + bootstrapInputID).addClass('userSelection');
            $('input#' + bootstrapInputID).parent().attr('id', bootstrapInputID + 'box');
            $('input#' + bootstrapInputID).tagsinput({
                itemValue: 'id',  /* this will be used to set id of tag*/
                itemText: 'label' /* this will be used to set text of tag*/
            });

            $('input#' + bootstrapInputID).attr("data-userSelectionID", userSelectionID);

            $('div#' + bootstrapInputID + 'box div.bootstrap-tagsinput').attr('title', tooltip);

            $('div#' + bootstrapInputID + 'box div.bootstrap-tagsinput').append("<input type='hidden' id='Hidden-" + userSelectionID + "-Value'/>");

            $('div#' + bootstrapInputID + 'box div.bootstrap-tagsinput').click(function (e) {
                if (e.target.nodeName === "SPAN")
                    return;

                var getInputId = $(this).find(".userSelection");
                userSelectionID = $(this).parent().children(".userSelection").attr("data-userselectionid");
                $("#modal-" + userSelectionID).modal('show');
            });
        },
		initGridGetUser: function (obj, t, a) {
			var getGridId = a.gridId;
			console.log(getGridId);
            var $grid;
			var gridSingleSelection = $("#gridSingleSelection-" + getGridId).val();
			var bootstrapInput = $("#bootstrapInput-" + getGridId).val();
            var bootstrapInputID = $("#bootstrapInputID-" + getGridId).val();
            var domainAdminOnly = $("#domainAdminOnly-" + getGridId).val() === '' ? 'false' : 'true';

			var defaultAreas = $("#defaultAreas-" + getGridId).val();
			var getUserRequestType = $("#getUserRequestType-" + getGridId).val();
            if (getUserRequestType === null || getUserRequestType === undefined) {
                getUserRequestType = "1";
            }

			var id = $('.grid-' + getGridId);
            var domainId = "";

            if (obj !== null && obj !== undefined) {
				$('input[data-role="search-' + getGridId + '-item"]').val("");
                domainId = obj;
            }
            else {
				domainId = $('#DomainSelection-' + getGridId + '-id').val();
            }

            var dataSource = {
                transport: {
                    read: {
                        url: "/Common/GetUser",
                        dataType: "json",
                        type: "GET"
                    },
                    parameterMap: function (options) {

                        var sortBy = "";
                        var direction = "";
                        if ((options.sort != null && options.sort != undefined) && options.sort.length > 0) {
                            var s = options.sort[0];
                            sortBy = s.field;
                            direction = s.dir;
                        }

                        var result = {
                            Type: getUserRequestType,
                            Areas: defaultAreas,
                            DomainId: domainId,
                            DomainAdminOnly: domainAdminOnly,
							SearchText: $('input[data-role="search-' + getGridId + '-item"]').val(),
                            Page: options.page,
                            Limit: options.pageSize,
                            SortBy: sortBy,
                            Direction: direction
                        };
                        return result;
                    }
                },
                schema: {
                    data: "UserList",
                    total: "Total",
                    model: {
                        id: "Id"
                    }
                },
                serverPaging: true,
                serverSorting: true
            };

            var columns = [];
            columns = [
                { field: "id", title: "ID", hidden: true },
                { field: "Name", title: "Name", width: "500px" }
            ];

            var objTreeView = {};
            objTreeView.allowSelectMultipleRow = true;

            if (gridSingleSelection === "0") {
                var x = {
                    selectable: true,
                    width: "45px",
                    sortable: false,
                    attributes: {
                        "class": "checkboxSelection"
                    }
                };

                columns.unshift(x);
            }
            else {

                objTreeView.onSelectionFn = $.domainSelection.addSingleBootstrapInput;
            }
            $grid = kendogridcustomization.init(id, dataSource,
                columns, objTreeView);

            if (bootstrapInput === "1") {
                var getSelectedID = $('input#' + bootstrapInputID).val();
            }
        },
        initGridGetMultiUser: function (obj) {
            var $grid;
            var gridSingleSelection = $("#gridSingleSelection-" + userSelectionID).val();
            var bootstrapInput = $("#bootstrapInput-" + userSelectionID).val();
            var bootstrapInputID = $("#bootstrapInputID-" + userSelectionID).val();

            var id = $('.grid-' + userSelectionID);
            var domainId = "";

            if (obj !== null && obj !== undefined) {
                $('input[data-role="search-' + userSelectionID + '-item"]').val("");
                domainId = obj;
            }
            else {
                domainId = $('#DomainSelection-' + userSelectionID + '-id').val();
            }

            var dataSource = {
                transport: {
                    read: {
                        url: "/Common/GetMultiUser",
                        dataType: "json",
                        type: "GET"
                    },
                    parameterMap: function (options) {

                        var sortBy = "";
                        var direction = "";
                        if ((options.sort != null && options.sort != undefined) && options.sort.length > 0) {
                            var s = options.sort[0];
                            sortBy = s.field;
                            direction = s.dir;
                        }

                        var result = {
                            Type: "1",
                            DomainId: domainId,
                            SearchText: $('input[data-role="search-' + userSelectionID + '-item"]').val(),
                            Page: options.page,
                            Limit: options.pageSize,
                            SortBy: sortBy,
                            Direction: direction
                        };
                        return result;
                    }
                },
                schema: {
                    data: "Records",
                    total: "Total",
                    model: {
                        id: "UserId"
                    }
                },
                serverPaging: true,
                serverSorting: true
            };

            var columns = [];
            columns = [
                { field: "UserId", title: "ID", hidden: true },
                { field: "Name", title: "Name", width: "500px" }
            ];

            var objTreeView = {};
            objTreeView.allowSelectMultipleRow = true;

            if (gridSingleSelection === "0") {
                var x = {
                    selectable: true,
                    width: "45px",
                    sortable: false,
                    attributes: {
                        "class": "checkboxSelection"
                    }
                };

                columns.unshift(x);
            }
            else {

                objTreeView.onSelectionFn = $.domainSelection.addSingleBootstrapInput;
            }

            $grid = kendogridcustomization.init(id, dataSource,
                columns, objTreeView);

            if (bootstrapInput === "1") {
                var getSelectedID = $('input#' + bootstrapInputID).val();

            }
        },
		initGridGetUnassignedDelegatee: function (obj) {
			var delegatorValue = "";
			var isAllowedDelegation = $('#UserAllowDelegation').val(); /* hidden field from _layout */

			var defaultAreas = $("#defaultAreas-" + userSelectionID).val();
			var delegatorID = $("#delegatorID-" + userSelectionID).val();

			if (delegatorID.length && defaultAreas.toLowerCase() !== "user") {
				delegatorValue = $("#" + delegatorID).length === 0 ? "" : $("#" + delegatorID).val();
			}

			if (delegatorValue.length > 0 || (isAllowedDelegation === 'true' && defaultAreas.toLowerCase() === "user")) {
                var $grid;
                var gridSingleSelection = $("#gridSingleSelection-" + userSelectionID).val();
                var bootstrapInput = $("#bootstrapInput-" + userSelectionID).val();
                var bootstrapInputID = $("#bootstrapInputID-" + userSelectionID).val();

                var id = $('.grid-' + userSelectionID);
                var domainId = "";

                if (obj !== null && obj !== undefined) {
                    $('input[data-role="search-' + userSelectionID + '-item"]').val("");
                    domainId = obj;
				}
				else {
					domainId = $('#DomainSelection-' + userSelectionID + '-id').val();
				}

                var dataSource = {
                    transport: {
                        read: {
                            url: "/Common/GetUnassignedDelegatee",
                            dataType: "json",
                            type: "GET"
                        },
                        parameterMap: function (options) {

                            var sortBy = "";
                            var direction = "";
                            if ((options.sort != null && options.sort != undefined) && options.sort.length > 0) {
                                var s = options.sort[0];
                                sortBy = s.field;
                                direction = s.dir;
                            }

                            var result = {
                                Areas: defaultAreas,
                                DomainId: domainId,
                                DelegatorID: delegatorValue,
                                SearchText: $('input[data-role="search-' + userSelectionID + '-item"]').val(),
                                Page: options.page,
                                Limit: options.pageSize,
								SortBy: sortBy,
								Skip: options.skip,
								Take: options.take,
                                Direction: direction
                            };
                            return result;
                        }
                    },
                    schema: {
                        data: "Records",
                        total: "Total",
                        model: {
                            id: "UserId"
                        }
                    },
                    serverPaging: true,
                    serverSorting: true
                };

                var columns = [];
                columns = [
                    { field: "UserId", title: "ID", hidden: true },
                    { field: "Name", title: "Name", width: "500px" }
                ];

                var objTreeView = {};
                objTreeView.allowSelectMultipleRow = true;

                if (gridSingleSelection === "0") {
                    var x = {
                        selectable: true,
                        width: "45px",
                        sortable: false,
                        attributes: {
                            "class": "checkboxSelection"
                        }
                    };

                    columns.unshift(x);
                }
                else {

                    objTreeView.onSelectionFn = $.domainSelection.addSingleBootstrapInput;
                }

                $grid = kendogridcustomization.init(id, dataSource,
                    columns, objTreeView);

                if (bootstrapInput === "1") {
                    var getSelectedID = $('input#' + bootstrapInputID).val();

                }
			}
        },
		initTreeView: function (id) {
            /* Domain Selection Treeview */
			$("#DomainSelection-" + id + "-id").val($('#dashboardID').val());

            var objSelection = {};
            objSelection.expandAll = true;
            objSelection.declareType = "textbox";
			objSelection.gridId = id;
			var gridTypeSelection = $("#gridTypeSelection-" + id).val();
            switch (gridTypeSelection) {

                case "2":
                    /*Call Common/GetMultiUser*/
                    objSelection.postSelectFn = $.domainSelection.initGridGetMultiUser;
                    break;
                case "3":
                    /*Call Common/GetUnassignedDelegateeDt*/
                    objSelection.postSelectFn = $.domainSelection.initGridGetUnassignedDelegatee;
                    break;
                default:
                    /*Call Common/GetUser*/
                    objSelection.postSelectFn = $.domainSelection.initGridGetUser;
			}
			userSelectionID = id;
			treeview.init("DomainSelection-" + id + "", "DomainSelection-" + id + "-name", "DomainSelection-" + id + "-id", objSelection);
        },

        /*Btn Action*/
        addButtonClickHandler: function (e) {
            $(e).attr("data-userSelectionID", userSelectionID);

            $(e).on('click', function () {
                userSelectionID = $(e).attr("data-userSelectionID");
                var gridPostAddFn = $("#gridPostAddFn-" + userSelectionID).val();

                gridPostAddFn = gridPostAddFn.length > 0 ? gridPostAddFn : "$.domainSelection.addMultipleBootstrapInput";

                new Function(gridPostAddFn + ".call(this)")();
            });
        },
        searchButtonClickHandler: function (e) {
            $(e).on('click', function () {
                $.domainSelection.search(e);
            });
        },
        searchPressEnter: function (e) {
            $(e).on('keypress', function (enter) {
                if (enter.which === 13) {
                    $.domainSelection.search(e);
                }
            });
        },

        /*End Btn Action*/

        /* Logic */
		search: function (e) {
            var gridTypeSelection = $("#gridTypeSelection-" + userSelectionID).val();

            switch (gridTypeSelection) {
                case "2":
                    /*Call Common/GetMultiUser*/
                    $.domainSelection.initGridGetMultiUser();
                    break;
                case "3":
                    /*Call Common/GetUnassignedDelegateeDt*/
                    $.domainSelection.initGridGetUnassignedDelegatee();
                    break;
				default:
					var obj = {
						gridId: $(e).data("grid")
					};
                    /*Call Common/GetUser*/
					$.domainSelection.initGridGetUser(null, null, obj);
            }
        },
        addSingleBootstrapInput: function (dataItem) {
            var selectedItem = [{ ID: dataItem.Id, Text: dataItem.Name }];

            $.domainSelection.setBootstrapInput(selectedItem, 1);
        },
        addMultipleBootstrapInput: function () {
            var selectedItem = [];
            var gridTypeSelection = $("#gridTypeSelection-" + userSelectionID).val();

            switch (gridTypeSelection) {
                case "2":
                    /*Ca"ll Common/GetMultiUser*/
                    selectedItem = $.domainSelection.getGridMultiUserSelections($('.grid-' + userSelectionID));
                    break;
                case "3":
                    /*Call Common/GetUnassignedDelegateeDt*/
                    selectedItem = $.domainSelection.getGridUnassignedDelegateeSelections($('.grid-' + userSelectionID));
                    break;
                default:
                    /*Call Common/GetUser*/
                    selectedItem = $.domainSelection.getGridUserSelections($('.grid-' + userSelectionID));
            }

            if (selectedItem.length === 0) {
                swal("", "No user(s) selected!");
                return false;
            }

            $.domainSelection.setBootstrapInput(selectedItem, 2);

        },
        setBootstrapInput: function (selectedItem, selectionType) {
            var getSelectedValue;
            var bootstrapInputID = $("#bootstrapInputID-" + userSelectionID).val();
            if (selectionType === 1) {
                $('input#' + bootstrapInputID).tagsinput('removeAll');
            }
            else {
                var selectedValue = $('input#' + bootstrapInputID).val();

                if (selectedValue.lastIndexOf(',')) {
                    selectedValue = selectedValue.substring(0, selectedValue.lastIndexOf(','));
                }
                getSelectedValue = selectedValue.split(',');
            }

            $.each(selectedItem, function (index, obj) {
                if (selectionType !== 1 && (getSelectedValue.indexOf(obj.ID) > -1)) {
                    return true;
                }
                else
                    $('input#' + bootstrapInputID).tagsinput('add', { id: obj.ID, label: obj.Text });
            });

            $('#modal-' + userSelectionID).modal('hide');
        },
        /* End Logic */

        /*Post or Get Function*/

        getGridUserSelections: function (event) {
            var entityGrid = event.data("kendoGrid");
            var rows = entityGrid.select();
            var $selectedUser = [];
            rows.each(function (index, row) {
                var selectedItem = entityGrid.dataItem(row);
                $selectedUser[index] = { ID: selectedItem.Id, Text: selectedItem.Name };
            });

            return $selectedUser;
        },
        getGridUnassignedDelegateeSelections: function (event) {
            var entityGrid = event.data("kendoGrid");
            var rows = entityGrid.select();
            var $selectedUser = [];
            rows.each(function (index, row) {
                var selectedItem = entityGrid.dataItem(row);
                $selectedUser[index] = { ID: selectedItem.Id, Text: selectedItem.Name };
            });

            return $selectedUser;
        },
        getGridMultiUserSelections: function (event) {
            var entityGrid = event.data("kendoGrid");
            var rows = entityGrid.select();
            var $selectedUser = [];
            rows.each(function (index, row) {
                var selectedItem = entityGrid.dataItem(row);
                $selectedUser[index] = { ID: selectedItem.UserId, Text: selectedItem.Name };
            });

            return $selectedUser;
        }
    };
})(window.jQuery);