﻿var $validator_default = {
    errorClass: 'field-validation-error',
    errorElement: 'span',
    errorLabelContainer: '.fxc-validation'    
};

(function ($, $validator) {
    $validator = $validator || $.validator;
    $validator.setDefaults($validator_default);

    if ($validator) {
        /* Create a custom validator rule for our server errors that are just going to ensure that a different value is used*/
        $validator.addMethod("serverError", function (value, element) {
            return this.optional(element) || $(element).data("serverError-value") !== value;
        }, $validator.format($.validator.messages.serverErrMsg));
    }

    /* Add a flag for ajax errors to make global identification of them easier*/
    $.ajaxPrefilter(function (options, originalOptions, jqXHR) {
        var jqXHRWrapper = $.Deferred(function (defer) {
            jqXHR.done(defer.resolve)
                .fail(function (jqXHR, status, thrownError) {

                    if (jqXHR.status === 401) {
                        window.location = "/login";
                    }
                    jqXHR.isResponseValidationErrors = false;
                    if (jqXHR.responseJSON !== null && jqXHR.responseJSON !== undefined && jqXHR.responseJSON.TypeName === "ValidationErrors") {
                        jqXHR.isResponseValidationErrors = true;
                    }
                    defer.rejectWith(this, [jqXHR, status, thrownError]);
                });
        });

        /* Impose our wrapper on the jqXHR*/
        jqXHRWrapper.promise(jqXHR);

        /* For compatibility*/
        jqXHR.success = jqXHR.done;
        jqXHR.error = jqXHR.fail;
    });

    /* Add a global ajax error handler to deal with validation errors*/
    $(document).ajaxError(function (event, jqXHR, settings, thrownError) {
        if (jqXHR.isResponseValidationErrors === true && jqXHR.responseJSON) {
            var errors = $(jqXHR.responseJSON.Value);
            errors.each(function () {
                var that = this;
                $('[name="' + that.Key + '"]').each(function () {
                    $(this).data("serverError-value", $(this).val());
                    $(this).rules('add', {
                        serverError: true,
                        messages: {
                            serverError: that.Message
                        }
                    });
                    var form = $(this).closest("form");
                    if (form.validate) {
                        var validator = form.validate();
                        validator.element(this);
                    }
                });
            });
        }
    });



    $(document).ajaxSend(function (event, xhr, ajaxOptions) {
        xhr.setRequestHeader('FXC-RequestVerificationToken', xsrf());
    });
    var xsrf = function () {
        return $('input[name="__RequestVerificationToken"]').val();
    };
})(jQuery, jQuery.validator);