var bodyScroll = $("html[dir]").attr("dir") === "rtl" ? "left": "right";
var menuScroll = $("html[dir]").attr("dir") === "rtl" ? "right": "left";
 
var custom = {
	initHeight: function (resizeWindowFn) {
		resizeWindowFn = resizeWindowFn || false;
		var setEditorTimer = resizeWindowFn ? 150 : 0;
		var setKendoTimer = resizeWindowFn ? 150 : 0;
		var setMainTimer = 200;
		var setMinWidthFaxCoreBtn = 0;
		if ($(".fxc-main-content").find(".k-grid:visible").length > 0) {
			$(".fxc-main-content").scrollTop(0);
		}
		jQuery('.faxcoreBreadcrumbBtn > div:visible > *:visible').each(function () {
			var getMarginLeftBtn = parseInt($(this).css("margin-left"));
			var getMarginRightBtn = parseInt($(this).css("margin-right"));
			setMinWidthFaxCoreBtn += $(this).outerWidth() + (getMarginLeftBtn > 0 ? getMarginLeftBtn : 0) + (getMarginRightBtn > 0 ? getMarginRightBtn : 0);
		});
		var getFxcButtonWidth = $("#fxc-button").width();
		setMinWidthFaxCoreBtn = setMinWidthFaxCoreBtn > getFxcButtonWidth ? getFxcButtonWidth : setMinWidthFaxCoreBtn;
		$(".faxcoreBreadcrumbBtn").css("min-width", setMinWidthFaxCoreBtn + 20 + "px");

		if (resizeWindowFn) {
			if ($("#context-menu-layer").length > 0) {
				768 > (window.innerWidth > 0 ? window.innerWidth : this.screen.width) ? ($("body").addClass("mini-sidebar"), $("body").addClass("show-sidebar")
				) : ($("body").removeClass("mini-sidebar"), $("body").removeClass("show-sidebar"));
			}
			else {
				1300 > (window.innerWidth > 0 ? window.innerWidth : this.screen.width) ? ($("body").addClass("mini-sidebar"),
					$(".scroll-sidebar, .slimScrollDiv").css("overflow-x", "visible").parent().css("overflow", "visible"),
					$(".sidebartoggler i").addClass("ti-menu")) : ($("body").removeClass("mini-sidebar"), $("body").removeClass("show-sidebar"));
			}
		}
		
		$(".modal-body:visible").each(function (e, index) {
			custom.setModal($(this).closest(".modal"));
		});
		setTimeout(function () {
			$(".tab-content.tab-contentScrollBar").each(function (e, index) {    
				if ($(this).find(".k-grid:visible").length > 0) {
					$(this).scrollTop(0);
				}
				var windowHeight = $(window).outerHeight();
				var currentTop = $(this).offset().top;
				currentTop = $(this).closest(".MsgViewerView").length > 0 ? currentTop - 10 : currentTop + 10;
				$(this).css("height", windowHeight - currentTop -10);
			}); 
		}, 150);
		setTimeout(function () {
			$(".fxc-main-content").find(".k-editor:visible").each(function (index) {
				/*Set Kendo Editor Height based on screen height*/
				var rowHeight = $(window).height();

				var parent = $(this);
				var hasBottom = false;

				while (parent.length && parent.not(".page-wrapper").length) {

					if (parent.next().length) {
						hasBottom = true;
						break; /* breaks out of loop completely*/
					}

					parent = parent.parent();
					if (parent.prop("tagName") === "SECTION" || parent.prop("tagName") === "FORM") {
						parent = parent.parent();
						continue; /* breaks out of loop completely*/
					}
				}

				var calcBottomContentHeight = 0;
				if (hasBottom) {
					calcBottomContentHeight = parent.next().outerHeight(true) + 50;
				}

				var calcToolBarHeight = $(this).find(".k-editor-toolbar-wrap").height();

				rowHeight = rowHeight - $(this).offset().top - calcToolBarHeight - calcBottomContentHeight - 22;

				if ($(this).find("iframe").is(':visible')) {
					$(this).find("iframe").css("max-height", rowHeight);
					$(this).find("iframe").css("height", rowHeight);
				}
			});
		}, setEditorTimer);

		$(".fullDivHeight").each(function (e, index) {
            custom.setHeight($(this));
		});
		$(".fullDivMinHeight").each(function (e, index) {
			custom.setHeight($(this), true);
		});
		
		$(".fxc-main-content").find(".k-listbox").each(function (index) {
			/*Set Kendo List Box height based on screen height*/
			if ($(".fxc-main-content").find(".k-listbox").closest(".modal").length > 0)
			{
				return false;
			}
			var id = $(this);
			listbox.customizeHeight(id);
        });
		
		if (resizeWindowFn)
		{
			setTimeout(function () {
				$(".fxc-main-content").find(".k-grid:not(.lazyGrid):visible").each(function (index) {
					/*Set Kendo Grid height based on screen height*/
					var id = $(this);
					kendogridcustomization.customizeGridHeight($(this), true);
				});
			}, setKendoTimer);
		}

		

		setTimeout(function () {
			$('.dropdown-menu:not(.daterangepicker):not(.noScroll)').each(function (e, index) {
				custom.setDropDownMenu($(this));

				custom.setDropDownLocation($(this));

			});
			var getWindowHeight = window.innerHeight;
			var getHeaderHeight = $("header").outerHeight();

			$(".fxc-main-content").innerHeight(getWindowHeight - getHeaderHeight + "px");
		}, setMainTimer);
	},
	getBrowserVersion: function () {
		var type = '';
		var userAgent = navigator.userAgent;

		if (userAgent.indexOf('Opera') !== -1) {
			return 'opera';
		} else if (userAgent.indexOf('Firefox') !== -1) {
			return 'firefox';
		} else if (userAgent.indexOf('Edge') !== -1) {
			return 'edge';
		} else if (userAgent.indexOf('Chrome') !== -1) {
			return 'chrome';
		}
	},
	setDropDownLocation: function (e) {
		if ($(e).parent().is(":visible"))
		{
			/*calulcate top bottom position*/
			var windowHeight = $(window).outerHeight();
			var parentTop = $(e).parent().offset().top;
			var parentHeight = $(e).parent().height();
			var elementHeight = $(e).outerHeight();

			if (windowHeight - parentTop - parentHeight < elementHeight + 50 && $(e).closest("header").length === 0)
			{
				var newTopLocation = elementHeight + 2;
				$(e).css('transform', "translate3d(0px, -" + newTopLocation+"px, 0px)");
			}

			/*calculate left right position*/
			if ($(e).hasClass("dropdown-menu-left")) {
				var parentLeft = $(e).parent().offset().left;
				var parentWidth = $(e).parent().width();
				var elemWidth = $(e).width();
				var windowWidth = $(window).width();
				var isRtl = $(e).closest("html[dir]").length > 0 && $(e).closest("html[dir]").attr("dir") === "rtl";

				$(e).removeClass("exceedLeft");
				$(e).removeClass("exceedRight");

				if (!isRtl && windowWidth < parentLeft + elemWidth) {
					$(e).addClass("exceedRight");
				}
				if (isRtl && windowWidth < parentLeft + elemWidth + 30) {
					$(e).addClass("exceedRight");
				}
				else if (isRtl && parentLeft + parentWidth - 20 < elemWidth) {
					$(e).addClass("exceedLeft");
				}
			}
		}
	},
    setDropDownMenu: function (e) {
		var rowHeight = $(window).height();
		if ($(e).parent().length) {
			var currentLocation = $(e).parent().offset().top;
			var calHeight = ((rowHeight - currentLocation) / 2) + 25;
			calHeight = calHeight < 150 ? 150 : calHeight;
            calHeight = calHeight > 500 ? 500 : calHeight;
			if (!$(e).has(".menu-scrollbar").length) {
				var $newdiv1 = $("<div class='menu-scrollbar'></div>"),
                    existingChild = $(e).children();

				if (existingChild.length > 0) {
                    $newdiv1.append(existingChild);
                    $(e).append($newdiv1);

                    $(e).children(".menu-scrollbar").slimScroll({
                        height: 'auto',
						position: bodyScroll,
                    });

                    $(e).children(".slimScrollDiv").children(".menu-scrollbar").css('max-height', $(e).children(".slimScrollDiv").children(".menu-scrollbar").css('height'));
                    $(e).children(".slimScrollDiv").children(".menu-scrollbar").css('height', '');
                }
			}

			if ($(e).has(".slimScrollDiv").length) {
                $(e).children(".slimScrollDiv").css('height', 'auto');
				$(e).children(".slimScrollDiv").children(".menu-scrollbar").css('max-height', calHeight + 'px');
			}
		}
	},
    setCustomHeight: function (e, calHeight) {
		calHeight = calHeight || 150;
		calHeight = calHeight < 150 ? 150 : calHeight;
		if (!$(e).has(".menu-scrollbar").length) {

			$(e).slimScroll({
				height: calHeight,
				position: bodyScroll,
			});
		}

		if ($(e).parent(".slimScrollDiv").length) {
			$(e).css('height', calHeight);
			$(e).parent(".slimScrollDiv").css('height', calHeight);
		}
	},
	setModal: function (modalId) {
		if ($(modalId).length === 0 || !$(modalId).is(":visible")) {
			return false;
		}
		var getWindowHeight = $(window).outerHeight();

		if (getWindowHeight > 350) {
			$(modalId).find(".modal-dialog").removeClass("fixedTop");

		}
		else {
			$(modalId).find(".modal-dialog").addClass("fixedTop");
		}

        setTimeout(function () {
            var modalHeader = $(modalId).find(".modal-header");
            var modalFooter = $(modalId).find(".modal-footer");
            
            var calculateMaxModal = $(window).outerHeight() - 2;

            if (modalHeader.length)
                calculateMaxModal -= modalHeader.outerHeight();

            if (modalFooter.length)
                calculateMaxModal -= modalFooter.outerHeight();                    

			$(modalId).find(".modal-body").css("max-height", calculateMaxModal);

		}, 200);
	},
	setHeight: function (e, setMinHeight) {
		setMinHeight = setMinHeight || false;
		var rowHeight = $(window).height();
        var topHeight = $(e).offset().top;
        var assumeBottomHeight = 0;

        if ($(e).next().length) {
            assumeBottomHeight = $(e).next().outerHeight(true);
        }

		var finalHeight = rowHeight - topHeight - assumeBottomHeight;
		if (setMinHeight) {
			$(e).css("min-height", finalHeight);
		}
		else {
			$(e).css("height", finalHeight);
		}
	},
	setNavigationVisbility: function (e) {
		if (1300 > (window.innerWidth > 0 ? window.innerWidth : this.screen.width)) {
			$("body").addClass("mini-sidebar"),
			$(".scroll-sidebar, .slimScrollDiv").css("overflow-x", "visible").parent().css("overflow", "visible"),
			$(".sidebartoggler i").addClass("ti-menu");
		}
	}
};

$(function () {
	"use strict";
	$(function () {
		$(".preloader").fadeOut();
	}), jQuery(document).on("click", ".mega-dropdown", function (i) {
		i.stopPropagation();
	});
	
	$(window).ready(),
		$(window).on("resize", custom.initHeight),
		$(document).ready(function () {
			$(".slimScrollDiv").css("overflow", "hidden");
		}), $(".sidebartoggler").on("click", function () {
			$("body").hasClass("mini-sidebar") ? ($("body").trigger("resize"), $(".scroll-sidebar, .slimScrollDiv").css("overflow", "hidden").parent().css("overflow", "visible"), $("body").removeClass("mini-sidebar")) : ($("body").trigger("resize"), $(".scroll-sidebar, .slimScrollDiv").css("overflow-x", "visible").parent().css("overflow", "visible"), $("body").addClass("mini-sidebar"));
		}), $(".fix-header .topbar").stick_in_parent({}), $(".nav-toggler").click(function () {
			$("body").toggleClass("show-sidebar"), $(".nav-toggler i").toggleClass("ti-menu"), $(".nav-toggler i").addClass("ti-close");
		}), $(function () {
			$('[data-toggle="tooltip"]').tooltip();
		}), $(function () {
			$("nav.sidebar-nav").metisMenu();
		}), $(".scroll-sidebar").slimScroll({
			position: menuScroll,
			size: "5px",
			height: "100%",
			color: "#dcdcdc"
		});
		
	$("body").trigger("resize"), $(".list-task li label").click(function () {
		$(this).toggleClass("task-done")
	}), $('a[data-action="collapse"]').on("click", function (i) {
		i.preventDefault(), $(this).closest(".card").find('[data-action="collapse"] i').toggleClass("ti-minus ti-plus"), $(this).closest(".card").children(".card-body").collapse("toggle");
	}), $('a[data-action="expand"]').on("click", function (i) {
		i.preventDefault(), $(this).closest(".card").find('[data-action="expand"] i').toggleClass("mdi-arrow-expand mdi-arrow-compress"), $(this).closest(".card").toggleClass("card-fullscreen");
	}), $('a[data-action="close"]').on("click", function () {
		$(this).closest(".card").removeClass().slideUp("fast");
	});
});

