﻿(function ($) {

	var $grid, $grid2;
    $.accessDomainPermission = {
        init: function () {

			$.accessDomainPermission.createButtonClickHandler($('.View1 .btn-add-grid'));
			$.accessDomainPermission.refreshButtonClickHandler($('.View1 .btn-refresh-grid'));
			$.accessDomainPermission.deleteButtonClickHandler($('.View1 .btn-delete-grid'));
			$.accessDomainPermission.searchHandler($('input[data-role="search-all-item"]'));
			$.accessDomainPermission.searchButtonClickHandler($('.View1 .btn-search-grid'));
			$.accessDomainPermission.initializeGrid();
			$.sectionproperties.FirstLevel($('.btn-back2'));

			$('.btn-save2').on('click', function () {
				$("#form-domain-permission").submit();
			});
			formPermissionValidation();

			$('#selectTreeView-DomainSelection-ProfileUserSelections').hide();
        },
        initializeGrid: function () {
			var gridId = $('#grid');

			var dataSource = {
				transport: {
					read: {
						url: '/Admin/Permissions/ReadProfiles',
						dataType: "json",
						type: "GET"
					},
					parameterMap: function (options) {
						var result = {
							Filter: $('.View1 input[data-role="search-all-item"]').val(),
							Skip: options.skip,
							Take: options.take,
							Page: options.page
						};

						if (options.sort && options.sort.length > 0) {
							result.SortBy = options.sort[0].field;
							result.Direction = options.sort[0].dir;
						}
						return result;
					}
				},
				schema: {
					data: "Records",
					total: "Total",
					model: {
						id: "Id"
					}
				},
				serverPaging: true,
				serverSorting: true
			};

			var col = [
				{
					selectable: true,
					width: "45px",
					attributes: { "class": "checkboxSelection" }
				},
				{ field: 'Id', hidden: true },
				{ field: 'Name' },
				{ field: 'Description' },
			];
			var obj = {};
			obj.allowSelectMultipleRow = true;
			obj.customizeCheckbox = true;
			obj.onSelectionFn = $.accessDomainPermission.editButtonClickHandler;
			$grid = kendogridcustomization.init(gridId, dataSource, col, obj);
        },

        createButtonClickHandler: function (e) {
            $(e).on('click', function (e) {
                $.sectionproperties.SecondLevel($(e));
                $(".Add-Edit-header h4").text($permissionResource.createNewEntry);
                $(".breadcrumb .add-edit-breadcrumb-item").text($permissionResource.createNewEntry);

                $("#form-action").val("Create");
                $('#form-domain-permission').trigger("reset");
				$('#form-domain-permission').validate().resetForm();

				$('#UID').val('');
				$('input[name="Name"]').val('');
				$('input[name="Description"]').val('');
				$('input[name="ProfileUsers"]').tagsinput('removeAll');
				/*load profiles*/
				$.accessDomainPermission.loadProfileAccessItems();
            });
		},
		refreshButtonClickHandler: function (e) {
			$(e).on('click', function () {
				$('input[data-role="search-all-item"]').val("");
				$.accessDomainPermission.initializeGrid();
			});
		},
		editButtonClickHandler: function (e) {
			/*debugger*/
			$.sectionproperties.SecondLevel($(e));
			$('#form-domain-permission').validate().resetForm();

			$(".Add-Edit-header h4").text($permissionResource.editEntry);
			$(".breadcrumb .add-edit-breadcrumb-item").text($permissionResource.editEntry);
			$("#form-action").val("Edit");
			$('#UID').val(e.id);
			$('input[name="Name"]').val(e.Name);
			$('input[name="Description"]').val(e.Description).change();
			$('input[name="ProfileUsers"]').val('').change();
			/*load profiles*/
			$.accessDomainPermission.loadProfileAccessItems();
			/*load users*/
			$.accessDomainPermission.loadProfileUsers();
		},
		deleteButtonClickHandler: function (e) {
			$(e).on('click', function () {
				$(this).blur();
				var ids = getMainGridSelections($('#grid'));
				if (ids.length > 0) {
					swal({
						title: "",
						text: $globalMessages.swal.alert.deleteConfirmation,
						type: "info",
						showCancelButton: true,
						closeOnConfirm: false,
						reverseButtons: true,
						showLoaderOnConfirm: true
					}, function () {
						$.accessDomainPermission.delete(ids);
					});
				}
				else {
					swal("", $globalMessages.swal.alert.noItemSelected);
				}
			});
		},
		delete: function (ids) {
			swal({
				title: $globalMessages.swal.loader.title,
				text: $permissionResource.swal,
				imageUrl: '/Content/img/ajax-loading2.gif',
				showConfirmButton: false,
				closeOnClickOutside: false,
				allowEscapeKey: false,
			});
			fxcRequest.post('/Admin/Permissions/DeleteEntry',
				{
					Ids: ids
				},
				function (data) {
					$.accessDomainPermission.initializeGrid();
					swal.close();
					$.toast({
						text: $globalMessages.toast.success,
						position: 'bottom-right',
						loaderBg: '#ff6849',
						icon: 'success',
						hideAfter: 1500,
						stack: 6
					});
				},
				function (error) {
					swal.close();
					swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnSubmit, "error");
				}, false);
        },
		searchHandler: function (e) {
			$(e).keypress(function (event) {
				if (event.which === 13) {
					$.accessDomainPermission.initializeGrid();
				}
			});
		},
		searchButtonClickHandler: function (e) {
			$(e).on('click', function () {
				$.accessDomainPermission.initializeGrid();
			});
		},
		loadProfileAccessItems: function () {
			$.accessDomainPermission.initializeAccessUrlGrid();
		},
		loadProfileUsers: function () {
			fxcRequest.get('/Admin/Permissions/ReadProfileUsers',
				{
					ProfileId: $('#UID').val(),
				},
				function (data) {
					var control = $("#ProfileUsers");
					control.tagsinput({
						itemValue: 'id',  /* this will be used to set id of tag*/
						itemText: 'label', /* this will be used to set text of tag*/
					});

					var val = data.UserIds;
					var source = data.UserNames;
					if (val.lastIndexOf(';') == val.length - 1) {
						val = val.substring(0, val.lastIndexOf(';'));
					}
					var selectedItem = val == "" ? [] : val.split(';');
					source = source == null || source.length == 0 ? val : source;
					var selectedSource = source == "" ? [] : source.split(';');
					control.tagsinput('removeAll');
					$.each(selectedItem, function (index, obj) {
						control.tagsinput('add', { id: obj, label: selectedSource[index] });
					});
				},
				function (error) {
					swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnSubmit, "error");
				}, false);
        },
		initializeAccessUrlGrid: function () {
			var defaultPageSize = $("#defaultPageSize").val()

			$("#defaultPageSize").val(100);
			var gridId = $('#gridProfileItems');
			var dataSource = {
				transport: {
					read: {
						url: '/Admin/Permissions/ReadProfileItems',
						dataType: "json",
						type: "GET"
					},
					parameterMap: function (options) {

						var result = {
							Filter: $('input[data-role="search-access-url-entry"]').val(),
							ProfileId: $('input[name="UID"]').val(),
							Skip: options.skip,
							Take: options.take,
							Page: options.page
						};

						if (options.sort && options.sort.length > 0) {
							result.SortBy = options.sort[0].field;
							result.Direction = options.sort[0].dir;
						}

						return result;
					}
				},
				schema: {
					data: "Records",
					total: "Total",
					model: {
						id: "Id"
					}
				},
				serverPaging: true,
				serverSorting: true
			};

			var col = [
				{ field: 'Id', hidden: true },
				{ field: 'Section' },
				{ field: 'View' },
				{
					attributes: {
						"class": "checkboxSelection"
					},
					field: "CanRead",
					title: $permissionResource.grid.canRead.title,
					width: 150,
					template: '<div class="custom-checkbox"><input class="k-checkbox-custom rrf" #= CanRead == true ? \'checked="checked"\' : "" # data-role="checkbox" data-id="#= Id #" id="#= Id #CanRead" type="checkbox"> '
						+ '     <label for="#= Id #CanRead" class="k-checkbox-custom-label k-no-text" title="' + $permissionResource.grid.canRead.toolTip + '"></label></div>'
				},
				{
					attributes: {
						"class": "checkboxSelection"
					},
					field: "CanWrite",
					title: $permissionResource.grid.canWrite.title,
					width: 150,
					template: '<div class="custom-checkbox"><input class="k-checkbox-custom rrf" #= CanWrite == true ? \'checked="checked"\' : "" # data-role="checkbox" data-id="#= Id #" id="#= Id #CanWrite" type="checkbox"> '
						+ '     <label for="#= Id #CanWrite" class="k-checkbox-custom-label k-no-text" title="' + $permissionResource.grid.canWrite.toolTip + '"></label></div>'
				}
			];

			var obj = {};
			obj.allowSelectMultipleRow = true;
			obj.customizeCheckbox = true;
			obj.customizeCheckboxFn = $.accessDomainPermission.checkBoxHandler;
			obj.pageSize = 100;
			obj.onDataBoundExtraFn = $.accessDomainPermission.dataBoundHandler;
			$grid2 = kendogridcustomization.init(gridId, dataSource, col, obj);

			$("#defaultPageSize").val(defaultPageSize);
		},
		dataBoundHandler: function (e) {
			var $data = e.sender.dataSource.data();
			for (var i = 0; i < $data.length; ++i) {
				var model = $data[i];
				if (model.Checked === true) {
					var tr = $("[data-uid='" + model.uid + "']", grid.tbody);
					$('#gridProfileItems').data("kendoGrid").select(tr);
                }
			}
        },
		checkBoxHandler: function (dataItem, e) {
			var $grid = $('#gridProfileItems').data("kendoGrid");

			if (!dataItem.CanRead && !dataItem.CanWrite) {
				var selected = $grid.select();
				selected = $.grep(selected, function (x) {
					var currentItem = $grid.dataItem(x);
					return (!currentItem.CanRead && !currentItem.CanWrite);
				});
				
				$.each(selected, function (key, value) {
					$(value).removeClass('k-state-selected');
				});
			} else {
                if (dataItem.CanWrite) {
                    if (!$('input#' + dataItem.id + 'CanRead').is(":checked")) {
                        $('input#' + dataItem.id + 'CanRead').click();
                    }
                }
				var tr = $("[data-uid='" + dataItem.uid + "']", $grid.tbody);
				$grid.select(tr);
			}
		},
		saveButtonHandler: function (e) {
		},
		save: function () {
			swal({
				title: $globalMessages.swal.loader.title,
				text: $permissionResource.swal,
				imageUrl: '/Content/img/ajax-loading2.gif',
				showConfirmButton: false,
				closeOnClickOutside: false,
				allowEscapeKey: false,
			});
			fxcRequest.post('/Admin/Permissions/SaveEntry',
				{
					ProfileId: $('#UID').val(),
					Name: $('#Name').val(),
					Description: $('#Description').val(),
					Users: $('#ProfileUsers').val(),
					Items: getGridSelections($('#gridProfileItems'))
				},
				function (data) {
					$.sectionproperties.FirstLevelView();
					$.accessDomainPermission.initializeGrid();
					swal.close();
					$.toast({
						text: $globalMessages.toast.success,
						position: 'bottom-right',
						loaderBg: '#ff6849',
						icon: 'success',
						hideAfter: 1500,
						stack: 6
					});
				},
				function (error) {
					swal.close();
					swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnSubmit, "error");
				}, false);
        }
	};

	var formPermissionValidation = function () {
		$('#form-domain-permission').validate({
			ignoreTitle: true,
			rules: {
				Name: { required: true },
				Description: { required: true },
				ProfileUsers: { required: true }
			},
			messages: {
				ProfileUsers: { required: 'Add at least one Domain Admin user.' }
            },
			errorPlacement: function (error, element) {
				var p = element.parent('span').parent();
				if (p.hasClass('form-control')) {
					error.appendTo(p);
				} else {
					error.insertAfter(element);
				}
			},
			submitHandler: function (form) {
				$.accessDomainPermission.save();
			}
		});
	};

	var getGridSelections = function (grid) {
		var selectedId = [];
		var entityGrid = grid.data("kendoGrid");
		var rows = entityGrid.select();

		rows.each(function (index, row) {
			var selectedItem = entityGrid.dataItem(row);
			selectedId[index] = {
				Id: selectedItem.Id,
				CanRead: selectedItem.CanRead,
				CanWrite: selectedItem.CanWrite
			};
		});
		return selectedId;
	};
	var getMainGridSelections = function (grid) {
		var selectedId = [];
		var entityGrid = grid.data("kendoGrid");
		var rows = entityGrid.select();

		rows.each(function (index, row) {
			var selectedItem = entityGrid.dataItem(row);
			selectedId[index] = selectedItem.id;
		});
		return selectedId;
	};

})(window.jQuery);