﻿(function ($) {
	var datatrackconfig;
	var $treeDomain;
	var trackconfigvalidation = function () {
		$('#formSubmit').validate({
			ignoreTitle: true,
			rules: {
				DomainName: { required: true, noSpace: true },
				DisplayLabel: { required: true, noSpace: true },
				MinLenset: { number: true },
				MaxLenset: { number: true }
			},
			submitHandler: function (form) {
				$.trackconfig.save();
			}
		});
	};
	var resetfields = function (e) {
		if ($("#form-action").val() == "Edit") {
			$('#TrackCfgIDX').val(e.TrackCfgIDX);

			var ddldomainId = 'div#domain ul li[data-id="' + e.DomainIDX + '"]';
			treeview.selectNode($treeDomain, e.DomainIDX);
			$('#DisplayLabel').val(e.DisplayLabel);
			$("#DataFormatList").val(e.DataFormat).change();
			$("#CustomFormat").val(e.CustomFormat);
			$('#MinLenset').val(e.MinLenSet);
			$("#MaxLenset").val(e.MaxLenSet);
			$('#IsRequired').bootstrapSwitch('state', JSON.parse(e.IsRequired));
			$('#IsActive').bootstrapSwitch('state', JSON.parse(e.IsActive));

			$('#TrackDictionaryList_Value').val(e.SetDictID);
		}
		else {
            $('#formSubmit').trigger("reset");
            $('#TrackCfgIDX').val("");
			$("#DataFormatList").val("1").change();
			treeview.selectNode($treeDomain, $("#domain-id"));
		}
		$('#formSubmit').validate().resetForm();

		$.trackconfig.setMinMaxLength();
		
	};
	var constructsavemodel = function () {
		return {
			'DomainIDX': $("#domain-id").val(),
			'TrackCfgIDX': $('#TrackCfgIDX').val(),
			'DisplayLabel': $('#DisplayLabel').val(),
			'DataFormat': $("#DataFormatList").val(),
			'CustomFormat': $("#CustomFormat").val(),
			'MinLenSet': $('#MinLenset').val(),
			'MaxLenSet': $("#MaxLenset").val(),
			'IsRequired': $('#IsRequired').prop('checked'),
			'IsActive': $('#IsActive').prop('checked'),
			'SetDictID': $('#TrackDictionaryList_Value').val()
		};
	};

	$.trackconfig = {
		init: function (e) {
			$("#MinLenset").mask('99999');
			$("#MaxLenset").mask('99999');

			$.trackconfig.createButtonClickHandler($('.btn-new'));
			$.trackconfig.deleteButtonClickHandler($('.btn-delete'));
			$.trackconfig.refreshButtonClickHandler($('.btn-refresh'));
			$.trackconfig.searchHandler($('input[data-role="search-all-item"]'));
			$.trackconfig.searchButtonClickHandler($('.btn-Search'));
			$.trackconfig.resetmodalHandler($('button[data-role="reset-modal-value"]'));
			$.trackconfig.saveclosemodalHandler($('input[data-role="save-close-modal"]'));

			$.trackconfig.initTreeViewDomain();

			$('select#DataFormatList').on('change', function (event, state) {
				var result = false;
				var returnValue = $(this).val();
				var showid = "";

				if (returnValue == "7" || returnValue == "8") {
					/* Custom Mask --> 1 or Regular Expression --> 8 */
					result = true;
					$.sectionproperties.Hidden(this.id + "_7or8", result, false);
				}
				else {
					$.sectionproperties.Hidden(this.id + "_7or8", true, true);
				}
			});
			$('#MinLenset').on('blur', function (event, state) {
				$.trackconfig.setMinMaxLength();
			});
			$('#MaxLenset').on('blur', function (event, state) {
				$.trackconfig.setMinMaxLength();
			});
			$("select#DataFormatList").change();

			$.trackconfig.initGrid();
			trackconfigvalidation();
		},
		initGrid: function (refreshField) {
			refreshField = refreshField || false;
			var id = $('#grid');

			var dataSource = {
				transport: {
					read: {
						url: '/Admin/TrackConfig/Read',
						dataType: "json",
						type: "GET"
					},
					parameterMap: function (options) {
						var result = {
							FilterFields: "DisplayLabel,DictName,DataFormatLabel",
							Filter: $('input[data-role="search-all-item"]').val(),
							Skip: options.skip,
							Take: options.take,
							Page: options.page
						};

						if (options.sort && options.sort.length > 0) {
							result.SortBy = options.sort[0].field;
							result.Direction = options.sort[0].dir;
						}
						return result;
					}
				},
				schema: {
					data: "Records",
					total: "Total",
					model: {
						id: "TrackCfgIDX"
					}
                },
                /* To avoid form data unable to reset after edited and saved (If record is selected from page 2 onwards) */
				serverPaging: false,
                serverSorting: false
			};

			var col = [
				{
					selectable: true, width: "45px",
					attributes: {
						"class": "checkboxSelection"
					}
				},
				{ field: 'TrackCfgIDX', hidden: true },
				{ field: 'TrackSeq', title: $trackConfigResource.trackSeq, width: 100, sortable: true },
				{ field: 'CrDateFormat', title: $trackConfigResource.crDate, width: 300, sortable: true },
				{ field: 'EditDateFormat', title: $trackConfigResource.editDate, width: 300, sortable: true },
				{ field: 'DisplayLabel', title: $trackConfigResource.displayLabel, width: 350, sortable: true },
				{ field: 'DataFormatLabel', title: $trackConfigResource.dataFormat, width: 200, sortable: true },
				{ field: 'MinLenSet', title: $trackConfigResource.minLenSet, width: 200, sortable: true },
				{ field: 'MaxLenSet', title: $trackConfigResource.maxLenSet, width: 200, sortable: true },
				{
					field: "IsRequired",
					title: $trackConfigResource.isRequired,
					width: 150,
					filterable: {
						cell: {
							enabled: false
						}
					},
					template: '<div class="kendo-container"> <i #= IsRequired == true ? \'class="mdi fxc-checkbox-true"\' : "" #></i> </div>'
				},
				{
					field: "IsActive",
					title: $trackConfigResource.isActive,
					width: 150,
					filterable: {
						cell: {
							enabled: false
						}
					},
					template: '<div class="kendo-container"> <i #= IsActive == true ? \'class="mdi fxc-checkbox-true"\' : "" #></i> </div>'
				},
				{ field: 'DictName', title: $trackConfigResource.dictName, width: 220, sortable: true }
			];

			var obj = {};
			obj.allowSelectMultipleRow = true;
			obj.customizeCheckbox = true;
			obj.onSelectionFn = $.trackconfig.editButtonClickHandler;
			if (refreshField)
				obj.dataSourceOnSuccessFn = $.trackconfig.dataSourceOnSuccessFn;
			kendogridcustomization.init(id, dataSource, col, obj);
		},
		dataSourceOnSuccessFn: function (dataItem) {
			if (datatrackconfig != null) {
				datatrackconfig = $('#grid').data("kendoGrid").dataSource.get($('#TrackCfgIDX').val());
			}
			resetfields(datatrackconfig);
		},
		createButtonClickHandler: function (e) {
			$(e).on('click', function () {
				$("#form-action").val("Create");
				$(".modal-header h4").text($trackConfigResource.createNewEntry);
				$('#add-edit-modal').modal('show');
				$.sectionproperties.Hidden("DomainName", false);

				resetfields();
			});
		},
		editButtonClickHandler: function (dataItem) {
			$(".modal-header h4").text($trackConfigResource.editEntry);
			$("#form-action").val("Edit");
			$('#add-edit-modal').modal('show');
			$.sectionproperties.Hidden("DomainName", true);

			datatrackconfig = dataItem;
			resetfields(dataItem);
		},
		deleteButtonClickHandler: function (e) {
			$(e).on('click', function () {
				$(this).blur();
				var ids = $.trackconfig.getGridSelections();
				if (ids.length > 0) {
					swal({
						title: "",
						text: $globalMessages.swal.alert.deleteConfirmation,
						type: "info",
						showCancelButton: true,
						closeOnConfirm: false,
						reverseButtons: true,
						showLoaderOnConfirm: true
					}, function () {
						$.trackconfig.delete(ids);
					});
				} else {
					swal("", $globalMessages.swal.alert.noItemSelected);
				}
			});
		},
		refreshButtonClickHandler: function (e) {
			$(e).on('click', function () {
				$('input[data-role="search-all-item"]').val("");
				$.trackconfig.initGrid();
				$(this).blur();
			});
		},
		searchButtonClickHandler: function (e) {
			$(e).on('click', function () {
				$.trackconfig.initGrid();
				$(this).blur();
			});
		},
		searchHandler: function (e) {
			$(e).keypress(function (event) {
				if (event.which == 13) {
					$.trackconfig.initGrid();
				}
			});
		},
		resetmodalHandler: function (e) {
			$(e).on('click', function () {
				resetfields(datatrackconfig);
			});
		},
		saveclosemodalHandler: function (e) {
			$(e).on('click', function () {
				$('input[name="modal-action"]').val('save & close');
			});
		},
		getGridSelections: function (e) {
			var selectedId = [];
			var entityGrid = $('#grid').data("kendoGrid");
			var rows = entityGrid.select();

			rows.each(function (index, row) {
				var selectedItem = entityGrid.dataItem(row);
				selectedId[index] = selectedItem.id;
			});

			return selectedId;
		},
		initTreeViewDomain: function (e) {
			/* Text box: Domain Treeview */
			$('#domain-ddl').val($('#dashboardText').text());
			$("#domain-id").val($('#dashboardID').val());
			var objDomainSelection = {};
			objDomainSelection.expandAll = true;
			objDomainSelection.declareType = "textbox";
			$treeDomain = treeview.init("domain", "domain-name", "domain-id", objDomainSelection);
		},
		save: function () {
			fxcRequest.post('/Admin/TrackConfig/Save',
				constructsavemodel(),
				function (data) {
					var refreshField = true;
					if ($('input[name="modal-action"]').val() === 'save & close') {
						$('#add-edit-modal').modal('hide');
						$('input[name="modal-action"]').val('');
						refreshField = false;
					}
					$.trackconfig.initGrid(refreshField);
					swal($globalMessages.swal.success.title, $globalMessages.swal.success.text, "success");
				}, null, true);
		},
		delete: function (ids) {
			fxcRequest.post('/admin/trackconfig/delete',
				{
					Ids: ids
				},
				function (data) {
					$.trackconfig.initGrid();
					swal($globalMessages.swal.success.title, $globalMessages.swal.success.delete, "success");
				}, null, false);
		},
		setMinMaxLength: function () {
			var getMinLengthSet = $('#MinLenset').val();
			getMinLengthSet = parseInt(getMinLengthSet) < 1 ? 1 : parseInt(getMinLengthSet) + 1;
			$.sectionproperties.MinValue("MaxLenset", getMinLengthSet);

			var getMaxLengthSet = $('#MaxLenset').val();
			getMaxLengthSet = parseInt(getMaxLengthSet) < 0 ? 0 : parseInt(getMaxLengthSet) - 1;
			$.sectionproperties.MaxValue("MinLenset", getMaxLengthSet);
		}
	};
})(window.jQuery);