﻿(function ($) {
	var $treeDomain;
	var tempBLEData = null;
	var trackdictionaryvalidation = function () {
		$('#form-tracking-dictionary').validate({
			ignoreTitle: true,
			rules: {
				Name: { required: true, noSpace: true },
				DomainName: { required: true, noSpace: true  }
			},
			errorPlacement: function (error, element) {
				var p = element.parent('span').parent();
				if (p.hasClass('form-control')) {
					error.appendTo(p);
				} else {
					error.insertAfter(element);
				}
			},
			submitHandler: function (form) {
				$.trackdictionary.save();
			}
		});
	};
	var dictionaryentryvalidation = function () {
		$('#form-dictionary-entry').validate({
			ignoreTitle: true,
			rules: {
				EntryName: { required: true, noSpace: true },
				EntryAutoNumber: { required: true, number: true },
				IncrementBy: { required: true, number: true }
			},
			errorPlacement: function (error, element) {
				var p = element.parent('span').parent();
				if (p.hasClass('form-control')) {
					error.appendTo(p);
				} else {
					error.insertAfter(element);
				}
			},
			submitHandler: function (form) {
				$.trackdictionary.saveDictionaryEntry();
			}
		});
	};
	var resetfields = function () {
		var uid = $('#UID').val();
		if (uid !== '') {
			var row = $("[data-uid='" + uid + "']");
			var e = $('#grid').data("kendoGrid").dataItem(row);

			$('#obTree-id').val(e.DomainID).change;
			$('input[name="RecordId"]').val(e.DictID);
			$('input[name="UserID"]').val(e.UserID).change();
			$('input[name="Name"]').val(e.DictName).change();
			$('#VisibilityID').val(e.VisibilityID).change();
			$('#IsActive').bootstrapSwitch('state', e.IsActive);

			console.log('DictID :' + $('input[name="RecordId"]').val() + '');
		}
		else {
			$('#form-tracking-dictionary').trigger('reset');
			$('#obTree-id').val($('#dashboardID').val());
			$('#obTree-ddl').val($('#dashboardText').text()).change();
		}

		treeview.selectNode($treeDomain, $("#obTree-id").val());
	};
	var resetdictionaryentryfields = function () {

		$("#form-dictionary-entry").trigger("reset");
		$("#form-dictionary-entry").validate().resetForm();
        if (tempBLEData != null) { /* Use != instead of !== because it might be undefined */
			var e = tempBLEData;
			$('input[name="Action"]').val(2);
            $('input[name="TrackValRecordId"]').val(e.DictValueID);
			$('#EntryName').val(e.EntryName);
			$('#EntryTypeID').val(e.EntryTypeID).change();
			$('#EntryValue').val(e.EntryValue);
			$('#EntryAutoNumber').val(e.EntryAutoNumber);
			$('#IncrementBy').val(e.IncrementBy);
		}
        else {
			$('input[name="TrackValRecordId"]').val("");
			$("#modal-action").val("");
			$('input[name="Action"]').val(1); /* Add = 1, Update = 2, Delete = 3 */
		}
		$('#EntryTypeID').change();
	};
	var successCallback = function (data) {

	};
	var getGridSelections = function (grid) {
		var selectedId = [];
		var entityGrid = grid.data("kendoGrid");
		var rows = entityGrid.select();

		rows.each(function (index, row) {
			var selectedItem = entityGrid.dataItem(row);
			selectedId[index] = selectedItem.id;
		});
		return selectedId;
	};

	var $grid, bind = false;
	var $grid2, bind2 = false;
	var dataTrackingDictionary, dataDictionaryEntry;
	$.trackdictionary = {
		init: function (e) {
			/*debugger*/
			$("#EntryAutoNumber").mask('99999');
			$("#IncrementBy").mask('99999');

			/* View 1 */
			$.trackdictionary.createButtonClickHandler($('.View1 .btn-add-grid'));
			$.trackdictionary.deleteButtonClickHandler($('.View1 .btn-delete-grid'));
			$.trackdictionary.refreshButtonClickHandler($('.View1 .btn-refresh-grid'));
			$.trackdictionary.searchHandler($('input[data-role="search-all-item"]'));
			$.trackdictionary.searchButtonClickHandler($('.View1 .btn-search-grid'));
			$.trackdictionary.initGrid();

			/* View 2 */
			$.trackdictionary.initDomainTreeView();
			$.sectionproperties.FirstLevel($('.btn-back2'));
			$.trackdictionary.createDictionaryEntryButtonClickHandler($('.View2 .btn-add-gridDictionaryEntry'));
			$.trackdictionary.deleteDictionaryEntryButtonClickHandler($('.View2 .btn-delete-gridDictionaryEntry'));
			$.trackdictionary.refreshBLEButtonClickHandler($('.View2 .btn-refresh-gridDictionaryEntry'));
			$.trackdictionary.searchBLEHandler($('input[data-role="search-dictionary-entry"]'));
			$.trackdictionary.searchBLEButtonClickHandler($('.View2 .btn-search-gridDictionaryEntry'));
			$.trackdictionary.resetmodalHandler($('.View2 .btn-Reset2'));
			$.trackdictionary.saveDictionaryEntryclosemodalHandler($('#add-edit-dictionary-entry-modal input[data-role="save-close-modal"]'));
			$.trackdictionary.resetmodalDictionaryEntryHandler($('#add-edit-dictionary-entry-modal button[data-role="reset-modal-value"]'));

			$('select#EntryTypeID').on('change', function (event, state) {
				var result = false;
				var returnValue = $(this).val();
				var showid = "";

				if (returnValue === "2") {
					/* Fax Agent */
					result = true;
					$.sectionproperties.Hidden(this.id + "_AutoNumber", result, false);
				}
				else {
					$.sectionproperties.Hidden(this.id + "_AutoNumber", true, true);
				}
			});
			$("select#EntryTypeID").change();
			$('.btn-save2').on('click', function () {
				$("#form-tracking-dictionary").submit();
			});

			trackdictionaryvalidation();
			dictionaryentryvalidation();
		},
		initGrid: function () {
			var id = $('#grid');

			var dataSource = {
				transport: {
					read: {
						url: '/Admin/TrackDictionary/Read',
						dataType: "json",
						type: "GET"
					},
					parameterMap: function (options) {
						var result = {
							Filter: $('.View1 input[data-role="search-all-item"]').val(),
							Skip: options.skip,
							Take: options.take,
							Page: options.page
						};

						if (options.sort && options.sort.length > 0) {
							result.SortBy = options.sort[0].field;
							result.Direction = options.sort[0].dir;
						}
						return result;
					}
				},
				schema: {
					data: "Records",
					total: "Total",
					model: {
						id: "DictID"
					}
				},
				serverPaging: true,
				serverSorting: true
			};

			var col = [
				{
					selectable: true, width: "45px",
					attributes: {
						"class": "checkboxSelection"
					}
				},
				{ field: 'DictID', hidden: true },
				{ field: 'DomainID', hidden: true },
				{ field: 'VisibilityID', hidden: true },
				{ field: 'DomainName', title: $trackDicResource.domainName, width: 200, sortable: true },
				{
					field: "IsActive",
					title: $trackDicResource.isActive,
					width: 120,
					filterable: {
						cell: {
							enabled: false
						}
					},
					template: '<div class="kendo-container"> <i #= IsActive == true ? \'class="mdi fxc-checkbox-true"\' : "" #></i> </div>'
				},
				{ field: 'CrDate', title: $trackDicResource.createDate, minWidth: 200, width: 250, sortable: true },
				{ field: 'DictName', title: $trackDicResource.name, minWidth: 300, width: 350, sortable: true },
				{
					field: "VisibilityName",
					title: $trackDicResource.visibility,
					width: 150,
					template: function (dataRow) {
						var icon = '<i class="mdi mdi-check"></i>';
						var statusClass = "visibility" + dataRow.VisibilityID + "";

						var result = '<div status="kendo-container">' +
							'<span class="badge kendo-span-status badge-pill badge-' + statusClass.toLowerCase() + '">' + dataRow.VisibilityName + '</span> ' +
							'</div>';
						return result;
					},
					hidden: false,
					sortable: true
				}
			];

			var obj = {};
			obj.allowSelectMultipleRow = true;
			obj.customizeCheckbox = true;
			obj.onSelectionFn = $.trackdictionary.editButtonClickHandler;
			$grid = kendogridcustomization.init(id, dataSource, col, obj);
		},
		initDomainTreeView: function () {
			/*debugger*/
			$('#obTree-ddl').val($('#dashboardText').text());
			$('#obTree-id').val($('#dashboardID').val());

			var objDomainSelection = {};
			objDomainSelection.expandAll = true;
			objDomainSelection.declareType = 'textbox';

			$treeDomain = treeview.init("obTree", "obTree-name", "obTree-id", objDomainSelection);
		},
		createButtonClickHandler: function (e) {
			$(e).on('click', function () {
				/*debugger*/
				$.sectionproperties.SecondLevel($(e));
				$.sectionproperties.Hidden("DictionaryEntry", true);
				$.sectionproperties.Hidden("Domain", false);

				$(".Add-Edit-header h4").text($trackDicResource.createNewEntry);
				$(".breadcrumb .add-edit-breadcrumb-item").text($trackDicResource.createNewEntry);

				$("#form-action").val("Create");
				$('#form-tracking-dictionary').trigger("reset");
				$('#form-tracking-dictionary').validate().resetForm();

				$('#obTree-ddl').val($('#dashboardText').text()).change();

				$('input[name="RecordId"]').val('');
				$('#UID').val('');

				$('input[name="Creator"]').val($trackDicResource.username);
				$('input[name="UserID"]').val($trackDicResource.id);
			});
		},
		createDictionaryEntryButtonClickHandler: function (e) {
			$(e).on('click', function () {
				/*debugger*/
				$('#add-edit-dictionary-entry-modal').modal('show');
				$("#add-edit-dictionary-entry-modal .modal-header h4").text($trackDicResource.createNewEntry);
				tempBLEData = null;
				resetdictionaryentryfields();
			});
		},
		editButtonClickHandler: function (e) {
			/*debugger*/
			$.sectionproperties.SecondLevel($(e));
			$.sectionproperties.Hidden("DictionaryEntry", false);
			$('.HiddenDomain').addClass('hide');
			$('#form-tracking-dictionary').validate().resetForm();

			$(".Add-Edit-header h4").text($trackDicResource.editEntry);
			$(".breadcrumb .add-edit-breadcrumb-item").text($trackDicResource.editEntry);
			$("#form-action").val("Edit");
			$('#UID').val(e.uid);
            $('#obTree-id').val(e.DomainID).change;
			$('input[name="RecordId"]').val(e.DictID);
			$('input[name="UserID"]').val(e.UserID).change();
			$('input[name="Name"]').val(e.DictName).change();
			$('#VisibilityID').val(e.VisibilityID).change();
			$('#IsActive').bootstrapSwitch('state', e.IsActive);

			console.log('DictID :' + $('input[name="RecordId"]').val() + '');
			$('input[data-role="search-dictionary-entry"]').val("");
			$.trackdictionary.initDictionaryEntryGrid();
		},
		editDictionaryEntryButtonClickHandler: function (e) {
			/*debugger*/
			$("#add-edit-dictionary-entry-modal .modal-header h4").text($trackDicResource.editEntry);
			$('#add-edit-dictionary-entry-modal').modal('show');

			tempBLEData = e;
			resetdictionaryentryfields();

		},
		deleteButtonClickHandler: function (e) {
            $(e).on('click', function () {
                $(this).blur();
				$('input[name="modal-action"]').val('TrackingDictionary');
				var ids = getGridSelections($('#grid'));

				if (ids.length > 0) {
					swal({
						title: "",
						text: $globalMessages.swal.alert.deleteConfirmation,
						type: "info",
						showCancelButton: true,
						closeOnConfirm: false,
						reverseButtons: true,
						showLoaderOnConfirm: true
					}, function () {
						$.trackdictionary.delete(ids);
					});
				}
				else {
					swal("", $globalMessages.swal.alert.noItemSelected);
				}
			});
		},
		deleteDictionaryEntryButtonClickHandler: function (e) {
            $(e).on('click', function () {
                $(this).blur();
				$('input[name="Action"]').val(3); /* Add = 1, Update = 2, Delete = 3 */
				$('input[name="modal-action"]').val('DictionaryEntry');
				var ids = getGridSelections($('#gridDictionaryEntry'));

				if (ids.length > 0) {
					swal({
						title: "",
						text: $globalMessages.swal.alert.deleteConfirmation,
						type: "info",
						showCancelButton: true,
						closeOnConfirm: true,
						reverseButtons: true,
						showLoaderOnConfirm: true
					}, function () {
						$.trackdictionary.delete(ids);
					});
				}
				else {
					swal("", $globalMessages.swal.alert.noItemSelected);
				}
			});
		},
		refreshButtonClickHandler: function (e) {
			$(e).on('click', function () {

				$('input[data-role="search-all-item"]').val("");
				$.trackdictionary.initGrid();
			});
		},
		searchButtonClickHandler: function (e) {
			$(e).on('click', function () {
				$.trackdictionary.initGrid();
			});
		},
		searchHandler: function (e) {
			$(e).keypress(function (event) {
				if (event.which === 13) {
					$.trackdictionary.initGrid();
				}
			});
		},
		refreshBLEButtonClickHandler: function (e) {
            $(e).on('click', function () {
                $(this).blur();
				$('input[data-role="search-dictionary-entry"]').val("");
				$.trackdictionary.initDictionaryEntryGrid();
			});
		},
		resetBLEFieldsHandler: function (e) {
			tempBLEData = null;
			var getData = $("#gridDictionaryEntry").data("kendoGrid").dataSource.get($('input[name="TrackValRecordId"]').val());
            tempBLEData = getData;

			resetdictionaryentryfields();
		},
		searchBLEButtonClickHandler: function (e) {
			$(e).on('click', function () {
				/*debugger*/
				$.trackdictionary.initDictionaryEntryGrid();
			});
		},
		searchBLEHandler: function (e) {
			$(e).keypress(function (event) {
				if (event.which === 13) {
					/*debugger*/
					$.trackdictionary.initDictionaryEntryGrid();
				}
			});
		},
		resetmodalHandler: function (e) {
			$(e).on('click', function () {
				/*debugger*/
				resetfields();
			});

		},
		resetmodalDictionaryEntryHandler: function (e) {
			$(e).on('click', function () {
				/*debugger*/
				resetdictionaryentryfields();
			});
		},
		save: function () {
			/*debugger*/
			fxcRequest.post('/admin/trackdictionary/save',
				{
					DictID: $('input[name="RecordId"]').val(),
					DomainID: $('#obTree-id').val(),
					Name: $('#Name').val(),
					IsActive: $('#IsActive').prop('checked'),
					VisibilityID: $('#VisibilityID').val()
				},
				function (data) {
					$.sectionproperties.Hidden("DictionaryEntry", false);
					$.sectionproperties.FirstLevelView();
					$.trackdictionary.initGrid();

					swal($globalMessages.swal.success.title, $globalMessages.swal.success.text, "success");
				},
				function (error) {
					swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnSubmit, "error");
				});

		},
		saveDictionaryEntryclosemodalHandler: function (e) {
			$(e).on('click', function () {
				$('input[name="modal-action"]').val('save & close');
			});
		},
		saveDictionaryEntry: function () {
			/*debugger*/
			fxcRequest.post('/Admin/TrackDictionary/SaveEntry',
				{
					DictValueID: $('input[name="TrackValRecordId"]').val(),
					DictID: $('input[name="RecordId"]').val(),
					EntryName: $('#EntryName').val(),
					EntryTypeID: $('#EntryTypeID').val(),
					EntryValue: $('#EntryValue').val(),
					EntryAutoNumber: $('#EntryAutoNumber').val(),
					IncrementBy: $('#IncrementBy').val()
				},
                function (data) {
					$.trackdictionary.initDictionaryEntryGrid();

					if ($('input[name="modal-action"]').val() === 'save & close') {
						$('#add-edit-dictionary-entry-modal').modal('hide');
						$('input[name="modal-action"]').val('');
					}
			
					$.toast({
						text: $globalMessages.toast.updated,
						position: 'bottom-right',
						loaderBg: '#ff6849',
						icon: 'success',
						hideAfter: 1500,
						stack: 6
					});
				},
				function (error) {
					swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnSubmit, "error");
				}, false);
		},
		delete: function (ids) {
			/*debugger*/
			if ($('input[name="modal-action"]').val() === "TrackingDictionary") {
				ids = getGridSelections($('#grid'));
				fxcRequest.post('/admin/trackdictionary/delete',
					{
						Ids: ids
					},
					function (data) {
						$.trackdictionary.initGrid();
						swal($globalMessages.swal.success.title, $globalMessages.swal.success.delete, "success");
					},null);
			}
			else if ($('input[name="modal-action"]').val() === "DictionaryEntry") {
				ids = getGridSelections($('#gridDictionaryEntry'));
				fxcRequest.post('/admin/trackdictionary/DeleteEntry',
					{
						Ids: ids
					},
					function (data) {
						$.trackdictionary.initDictionaryEntryGrid();
						$('#delete-modal').modal('hide');

						$.toast({
							text: $globalMessages.toast.updated,
							position: 'bottom-right',
							loaderBg: '#ff6849',
							icon: 'success',
							hideAfter: 1500,
							stack: 6
						});
					},
					null, false);
			}
		},
        initDictionaryEntryGrid: function () {

			var action = "0";
			var id = $('#gridDictionaryEntry');

			var dataSource = {
				transport: {
					read: {
						url: '/Admin/TrackDictionary/ReadTrackDictValue',
						dataType: "json",
						type: "GET"
					},
					parameterMap: function (options) {

						var result = {
							Filter: $('input[data-role="search-dictionary-entry"]').val(),
							DictID: $('input[name="RecordId"]').val(),
							Skip: options.skip,
							Take: options.take,
							Page: options.page
						};

						if (options.sort && options.sort.length > 0) {
							result.SortBy = options.sort[0].field;
							result.Direction = options.sort[0].dir;
						}

						return result;
					}
				},
				schema: {
					data: "Records",
					total: "Total",
					model: {
						id: "DictValueID"
					}
				},
				serverPaging: true,
				serverSorting: true
			};

			var col = [
				{
					selectable: true, width: "45px",
					attributes: {
						"class": "checkboxSelection"
					}
				},
				{ field: 'DictID', hidden: true },
				{ field: 'DictValueID', hidden: true },
				{ field: 'EntryAutoNumber', hidden: true },
				{ field: 'IncrementBy', hidden: true },
				{ field: 'EntryTypeID', hidden: true },
				{ field: 'EntryName', title: $trackDicResource.entryName, width: 350, sortable: true },
				{ field: 'EntryValue', title: $trackDicResource.entryValue, minWidth: 200, width: 250, sortable: true },
				{ field: 'EntryTypeLabel', title: $trackDicResource.entryType, minWidth: 200, width: 150, sortable: true }

			];

			var obj = {};
			obj.allowSelectMultipleRow = true;
			obj.customizeCheckbox = true;
			obj.onSelectionFn = $.trackdictionary.editDictionaryEntryButtonClickHandler;
            obj.dataSourceOnSuccessFn = $.trackdictionary.resetBLEFieldsHandler;
            $grid2 = kendogridcustomization.init(id, dataSource, col, obj);
		}
	};
})(window.jQuery);