﻿(function ($) {
	var editTempData = null;
	var profileAssigntoAnonymousUserControl;
	var $treeDomain;
	var emailintegrationvalidation = function () {
		$('#formSubmit').validate({
			ignore: ".ignored",
			ignoreTitle: true,
			rules: {
				ExtDomain: { required: true, noSpace: true },
				ProfileAssigntoAnonymousUser: { required: true, noSpace: true },
				DomainName: { required: true, noSpace: true }
			},
			submitHandler: function (form) {
				$.emailintegration.save();
			}
		});
	};

	var resetfields = function () {
		profileAssigntoAnonymousUserControl.tagsinput('removeAll');
		if (editTempData != null) {
			$('input[name="RecordId"]').val(editTempData.Id);
			$('#ExtDomain').val(editTempData.ExtDomain);
			$('#IsAllowSubDomainSrch').bootstrapSwitch('state', editTempData.IsAllowSubDomainSearch);
			$('#IsAllowAnonymousUser').bootstrapSwitch('state', editTempData.IsAllowAnonymousUser);
			$('#IsActive').bootstrapSwitch('state', editTempData.IsActive);
			treeview.selectNode($treeDomain, editTempData.DomainIDX);
			
			if (editTempData.AnonymousUserIDX != null && editTempData.AnonymousUserIDX != "0" && editTempData.AnonymousUserIDX != "") {
				profileAssigntoAnonymousUserControl.tagsinput('add', { id: editTempData.AnonymousUserIDX, label: editTempData.AnonymousUser });
			}
			
		}
		else {
			$('#formSubmit').trigger("reset");
            treeview.selectNode($treeDomain, $('#dashboardID').val());
            $('input[name="RecordId"]').val("0");
		}
		$('#formSubmit').validate().resetForm();
	};

	$.emailintegration = {
		init: function (e) {
			emailintegrationvalidation();
			$.emailintegration.initTreeViewDomain();
			profileAssigntoAnonymousUserControl = $('#ProfileAssigntoAnonymousUser');
			profileAssigntoAnonymousUserControl.tagsinput({
				itemValue: 'id',
				itemText: 'label'
			});

			$('.btn-save2').on('click', function () {
				$("#form-action").val("");
				$("#formSubmit").submit();
			});
			
			$.emailintegration.createButtonClickHandler($('.View1 .btn-new'));
			$.emailintegration.deleteButtonClickHandler($('.View1 .btn-delete'));
			$.emailintegration.refreshButtonClickHandler($('.View1 .btn-refresh'));
			$.emailintegration.searchHandler($('.View1 input[data-role="search-all-item"]'));
			$.emailintegration.searchButtonClickHandler($('.View1 .btn-Search'));
			$.emailintegration.resetHandler($('.btn-Reset2'));
			$.emailintegration.initGrid();
			
			$.emailintegration.backButtonClickHandler($('.btn-back2'));
			$.sectionproperties.initHiddenProperties();
		},
		initTreeViewDomain: function (e) {
			$('#domain-ddl').val($('#dashboardText').text());
			$("#domain-id").val($('#dashboardID').val());

			var objDomainSelection = {};
			objDomainSelection.expandAll = true;
			objDomainSelection.declareType = "textbox";
			$treeDomain = treeview.init("domain", "domain-name", "domain-id", objDomainSelection);
		},
		initGrid: function (refreshField) {
			var id = $('#grid');
			var dataSource = {
				transport: {
					read: {
						url: '/admin/emailintegration/read',
						dataType: "json",
						type: "GET"
					},
					parameterMap: function (options) {

						var result = {
							Filter: $('input[data-role="search-all-item"]').val(),
							Skip: options.skip,
							Take: options.take,
							Page: options.page
						};

						if (options.sort && options.sort.length > 0) {
							result.SortBy = options.sort[0].field;
							result.Direction = options.sort[0].dir;
						}
						return result;
					}
				},
				schema: {
					data: function (data) {
						return data.Records;
					},
					total: "Total",
					model: {
						id: "MapID"
					}
				},
				serverPaging: true,
				serverSorting: true
			};

			var col = [
				{
					selectable: true, width: "45px",
					attributes: {
						"class": "checkboxSelection"
					}
				},
				{ field: 'MapID', hidden: true },
				{
					field: "IsActive",
					title: $emailIntResource.isActive,
					width: 100,
					filterable: {
						cell: {
							enabled: false
						}
					},
					template: '<div class="kendo-container"> <i #= IsActive == true ? \'class="mdi fxc-checkbox-true"\' : "" #></i> </div>'
				},
				{ field: 'DomainName', title: $emailIntResource.domainName, width: 200, sortable: true },
				{ field: 'ExtDomain', title: $emailIntResource.extDomain, width: 200, sortable: true },
				{
					field: "IsAllowSubDomainSrch",
					title: $emailIntResource.isAllowSubDomainSrch,
					minWidth: 250,
					width: 200,
					filterable: {
						cell: {
							enabled: false
						}
					},
					template: '<div class="kendo-container"> <i #= IsAllowSubDomainSrch == true ? \'class="mdi fxc-checkbox-true"\' : "" #></i> </div>'
				},
				{
					field: "IsAllowAnonymousUser",
					title: $emailIntResource.isAllowAnonymousUser,
					width: 200,
					filterable: {
						cell: {
							enabled: false
						}
					},
					template: '<div class="kendo-container"> <i #= IsAllowAnonymousUser == true ? \'class="mdi fxc-checkbox-true"\' : "" #></i> </div>'
				},
				{ field: 'UserProfile', title: $emailIntResource.userProfile, width: 250, sortable: true }

			];

			var obj = {};
			obj.allowSelectMultipleRow = true;
			obj.customizeCheckbox = true;
			obj.onSelectionFn = $.emailintegration.editButtonClickHandler;
			if (refreshField!= null)
				obj.dataSourceOnSuccessFn = $.emailintegration.dataSourceOnSuccessFn;
			kendogridcustomization.init(id, dataSource, col, obj);
		},
		initForm: function (e) {
			
			var obj = {
				blurForm: true,
				targetDiv: $("form#formSubmit")
			};
			fxcRequest2.get('/Admin/EmailIntegration/GetEmailMapSetting',
				{ "MapID": e },
				function (data) {
					editTempData = data;
					editTempData.Id = e;
					resetfields();
				}, obj);
		},

		getGridSelections: function (e) {
			var selectedId = [];
			var entityGrid = $('#grid').data("kendoGrid");
			var rows = entityGrid.select();

			rows.each(function (index, row) {
				var selectedItem = entityGrid.dataItem(row);
				selectedId[index] = selectedItem.id;
			});

			return selectedId;
		},
		backButtonClickHandler: function (e) {
			$(e).on('click', function () {
				$.sectionproperties.FirstLevelView($(e));
				editTempData = null;
				resetfields();
			});
		},
		createButtonClickHandler: function (e) {
			$(e).on('click', function () {
				$.sectionproperties.SecondLevel($(e));
				$(".Add-Edit-header h4").text($areaResources.actionTitle.createNewEntry);
				$(".breadcrumb .add-edit-breadcrumb-item").text($areaResources.actionTitle.createNewEntry);
				editTempData = null;
				resetfields();
				/*init treeview value*/
			});
		},
		dataSourceOnSuccessFn: function (dataItem) {
			if (editTempData != null) {
				$.emailintegration.initForm(parseInt($('input[name="RecordId"]').val()));
            }
            resetfields();
		},
		editButtonClickHandler: function (dataItem) {
			$.sectionproperties.SecondLevel();
			$(".Add-Edit-header h4").text($areaResources.actionTitle.editEntry);
			$(".breadcrumb .add-edit-breadcrumb-item").text($areaResources.actionTitle.editEntry);
			$.emailintegration.initForm(dataItem.id);

		},
		deleteButtonClickHandler: function (e) {
			$(e).on('click', function () {
				$(this).blur();
				var ids = $.emailintegration.getGridSelections();
				if (ids.length > 0) {
					swal({
						title: "",
						text: $globalMessages.swal.alert.deleteConfirmation,
						type: "info",
						showCancelButton: true,
						closeOnConfirm: false,
						reverseButtons: true,
						showLoaderOnConfirm: true
					}, function () {
						$.emailintegration.delete(ids);
					});
				} else {
					swal("", $globalMessages.swal.alert.noItemSelected);
				}
			});
		},
		refreshButtonClickHandler: function (e) {
			$(e).on('click', function () {
				$('input[data-role="search-all-item"]').val("");
				$.emailintegration.initGrid();
				$(this).blur();
			});
		},
		searchButtonClickHandler: function (e) {
			$(e).on('click', function () {
				$.emailintegration.initGrid();
			});
		},
		searchHandler: function (e) {
			$(e).keypress(function (event) {
				if (event.which == 13) {
					$.emailintegration.initGrid();
				}
			});
		},
		resetHandler: function (e) {
			$(e).on('click', function () {
				resetfields();
			});
		},
		save: function () {
			var id = $('input[name="RecordId"]').val();

			fxcRequest.post('/admin/emailintegration/save',
				{
					MapIDX: $('input[name="RecordId"]').val(),
					DomainIDX: $('#domain-id').val(),
					AnonymousUserIDX: $('#ProfileAssigntoAnonymousUser').val(),
					ExtDomain: $('#ExtDomain').val(),
					IsAllowSubDomainSearch: $('#IsAllowSubDomainSrch').prop('checked'),
					IsAllowAnonymousUser: $('#IsAllowAnonymousUser').prop('checked'),
					IsActive: $('#IsActive').prop('checked')
				},
				function (data) {
					$.emailintegration.initGrid(true);
					swal($globalMessages.swal.success.title, $globalMessages.swal.success.text, "success");
				},
				function (error) {
					swal($globalMessages.swal.error.errorCap, error.errorOnSubmit, "error");
				});
		},
		delete: function (ids) {
			fxcRequest.post('/admin/emailintegration/delete',
				{
					Ids: ids
				},
				function (data) {
					$.emailintegration.initGrid();
					swal($globalMessages.swal.success.title, $globalMessages.swal.success.delete, "success");
				},
				function (error) {
					swal($globalMessages.swal.error.errorCap, error.errorOnDelete, "error");
				});
		}
	};
})(window.jQuery);