﻿(function ($) {
    $.emailIntegrationSharedUiGuide = {
        init: function (opts) {
            $.emailIntegrationUiGuide.init(opts.startTourBtn);

            this.addRowClickListener(opts.gridRow, function () {
                $(opts.startTourBtn).unbind('click');
                hopscotch.endTour();
                $.emailIntegrationAddItemUiGuide.init(opts.startTourBtn);
            });
            this.addClickListener(opts.elements, function () {
                $(opts.startTourBtn).unbind('click');
                hopscotch.endTour();

                if ($(this).attr('id') === 'gridNewBtn') {
                    $.emailIntegrationAddItemUiGuide.init(opts.startTourBtn);
                } else if ($(this).hasClass('btn-back2')) {
                    $.emailIntegrationUiGuide.init(opts.startTourBtn);
                }
            });
        },
        addClickListener: function (el, fn) {
            $(el).on('click', fn);
        },
        addRowClickListener: function (el, fn) {
            $(el).on('click', 'td:not(.checkboxSelection)', fn);
        }
    };
})(window.jQuery);