﻿(function ($) {
    var forwardAddressControl;
    var editTempData;
    var startTimeControl;
    var endTimeControl;
    var interval = 60;
    var maxTime = "23:59";

    var inboundroutingvalidation = function () {
        $('#formSubmit').validate({
			ignore: ".ignored",
			ignoreTitle: true,
            rules: {
				ForwardAddress: { required: true, noSpace: true },
                Priority: {
                    required: true,
					noSpace: true,
                    number: true,
                    max: 9999,
                    min: 1
                },
				RoutestringExpr: { required: true, noSpace: true }
                /*ValidBeginTime: { required: true },
                ValidEndTime: { required: true, timeMustGreaterThan: ["StartTime"] },*/
            },
            
            errorPlacement: function (error, element) {
                var p = element.parent('span').parent();
                if (p.hasClass('form-control')) {
                    error.appendTo(p);
                } else {
                    error.insertAfter(element);
                }
            },
            submitHandler: function (form) {
                $.inboundrouting.save();
            }
        });
    };

    var conditionvalidation = function () {
        $('#formSubmit').validate({
            rules: {
                txtCondition1: { required: true }
            }            
        });
    };

    var resetfields = function () {
        forwardAddressControl.tagsinput('removeAll');
        $('#formSubmit').trigger("reset");
        $('#formSubmit').validate().resetForm();
        
        if (editTempData != null) {
            $.inboundrouting.mapData(editTempData);
        }
        else {
            $('input[name="RecordId"]').val('');
        }
    };

    var Routestring;
    var RoutestringExpr;
    var populateRoutestring = function () {

        var cond1Text = $("select#Condition1 option:selected").text();
        var cond1Val = $("select#Condition1 option:selected").val();
        var cond2Text = $("select#Condition2 option:selected").text();
        var cond2Val = $("select#Condition2 option:selected").val();
        var operator = $("select#Operator option:selected").val();
        var t1 = " = ";
        var t2 = " = ";

        var cond1 = cond1Val + t1 + $('#txtCondition1').val() + " ";
        var cond2 = operator + " " + cond2Val + t2 + $('#txtCondition2').val();
        var cond1expression = "[" + cond1Text + "]" + t1 + "'" + $('#txtCondition1').val() + "'" + " ";
        var cond2expression = operator + " " + "[" + cond2Text + "]" + t2 + "'" + $('#txtCondition2').val() + "'";

        if ($('#txtCondition2').val() === '') {
            RoutestringExpr = cond1expression;
            /*console.log(RoutestringExpr);*/
            $('#RoutestringExpr').val(RoutestringExpr);

            Routestring = cond1;
            /*console.log(Routestring);*/
            $('#Routestring').val(Routestring);
        }
        else {
            RoutestringExpr = cond1expression + cond2expression;
            /*console.log(RoutestringExpr);*/
            $('#RoutestringExpr').val(RoutestringExpr);

            Routestring = cond1 + cond2;
            /*console.log(Routestring);*/
            $('#Routestring').val(Routestring);
        }
    };
    
    var constructsavemodel = function () {        
        var days = '';
        $.each($('#Days input'), function (i, e) {

            if ($(e).prop('checked') === true) {

                var day = e.id;

                if (day === "DaysSun")
                    days += "0,";

                if (day === "DaysMon")
                    days += "1,";

                if (day === "DaysTues")
                    days += "2,";

                if (day === "DaysWed")
                    days += "3,";

                if (day === "DaysThurs")
                    days += "4,";

                if (day === "DaysFri")
                    days += "5,";

                if (day === "DaysSat")
                    days += "6,";

                return days;
            }
        });
      
        var id = $('input[name="RecordId"]').val();
        if (id == '') { id = '0'; }
      
        return {
            "IBRouteID": id,
            "IsActive": $('#ActivateRoute').prop('checked'),
            "Priority": $('#Priority').val(),
            "DestTypeID": $('#ForwardType').val(),
            "IsRestrict": $("#RouteByTimeBased").prop('checked'),
            "DestExpr": $('#ForwardAddress').val(),
            "AllowLoopBack": $('#AllowLoopBack').prop('checked'),
            "RouteByString": $('#Routestring').val(),
            "ValidDay": days,
            "ValidBeginTime": $('#ValidBeginTime').val(),
            "ValidEndTime": $('#ValidEndTime').val()
        };
    };
    
    $.inboundrouting = {
        init: function (e) {
            $('.btn-save2').on('click', function () {
                $("#form-action").val("");
                $("#formSubmit").submit();
            });
            $("#Priority").mask("9999");

            forwardAddressControl = $('#ForwardAddress');
            forwardAddressControl.tagsinput({
                itemValue: 'id',
                itemText: 'label'
            });

            $.inboundrouting.createButtonClickHandler($('.btn-new'));
            $.inboundrouting.deleteButtonClickHandler($('.btn-delete'));
            $.inboundrouting.refreshButtonClickHandler($('.btn-refresh'));
            $.inboundrouting.searchHandler($('input[data-role="search-all-item"]'));
            $.inboundrouting.searchButtonClickHandler($('.btn-Search'));
            $.inboundrouting.resetHandler($('.btn-Reset2'));
            $.inboundrouting.setButtonClickHandler($('button[data-role="delete-modal-action"]'));
            $.inboundrouting.forwardTypeSelectionChangeEvent();
            $.inboundrouting.initGrid();
            $.inboundrouting.initDateTime();

            inboundroutingvalidation();

            $(document).on('keypress', function (e) {
                let key = e.which || e.keyCode;
                if (key == '32' || '13') { /* Space, Enter */
                    if ($('.sweet-alert.visible').length > 0) {
                        swal.close();
                    }
                }
            });
        },
        initDateTime: function (e) {
            
            startTimeControl = $("#ValidBeginTime").kendoTimePicker({
                interval: interval,
				change: $.inboundrouting.onChangeStart,
				format: "HH:mm"
            }).data("kendoTimePicker");

            endTimeControl = $("#ValidEndTime").kendoTimePicker({
				interval: interval,
				format: "HH:mm"
            }).data("kendoTimePicker");

            startTimeControl.max(maxTime);
            endTimeControl.max(maxTime);

        },
        initGrid: function (e) {
            var id = $('#grid');
            var dataSource = {
                transport: {
                    read: {
                        url: '/admin/inboundrouting/read',
                        dataType: "json",
                        type: "GET"
                    },
                    parameterMap: function (options) {
                        var result = {
                            Filter: $('input[data-role="search-all-item"]').val(),
                            Skip: options.skip,
                            Take: options.take,
                            Page: options.page
                        };

                        if (options.sort && options.sort.length > 0) {
                            result.SortBy = options.sort[0].field;
                            result.Direction = options.sort[0].dir;
                        }

                        return result;
                    }
                },
                schema: {
                    data: function (data) {
                        return data.Records;
                    },
                    total: "Total",
                    model: {
                        id: "IBRouteID"
                    }
                },
                serverPaging: true,
                serverSorting: true
            };

            var col = [
                {
                    selectable: true, width: "45px",
                    attributes: {
                        "class": "checkboxSelection"
                    }
                },
                { field: 'IBRouteID', hidden: true },
                { field: 'DestTypeID', hidden: true },
                { field: 'CrDate', hidden: true },
                {
                    field: "IsActive",
					title: $inboundResource.isActiveLabel,
					width: 100,
                    filterable: {
                        cell: {
                            enabled: false
                        }
                    },
                    template: '<div class="kendo-container"> <i #= IsActive == true ? \'class="mdi fxc-checkbox-true"\' : "" #></i> </div>'
                },
                { field: 'Priority', title: $inboundResource.priority, width: 120, sortable: true },
                {
                    field: "IsRestrict",
					title: $inboundResource.isRestrictLabel,
                    width: 170,
                    filterable: {
                        cell: {
                            enabled: false
                        }
                    },
                    template: '<div class="kendo-container"> <i #= IsRestrict == true ? \'class="mdi fxc-checkbox-true"\' : "" #></i> </div>'
                },
				{ field: 'DestTypeSelect', title: $inboundResource.forwardType, width: 180, sortable: true },
				{ field: 'DestExprValue', title: $inboundResource.forwardAddress, width: 250, sortable: true },
				{ field: 'RouteByStringExpr', title: $inboundResource.routeStringExpr, width: 300, sortable: true }          
            ];

            var obj = {};
            obj.allowSelectMultipleRow = true;
            obj.customizeCheckbox = true;
            obj.onSelectionFn = $.inboundrouting.editButtonClickHandler;
            obj.dataSourceOnSuccessFn = $.inboundrouting.resetFieldsHandler;
            kendogridcustomization.init(id, dataSource, col, obj);
        },
        initForm: function (e) {
            var obj = {
                blurForm: true,
                targetDiv: $("form#formSubmit")
            };
            fxcRequest2.get('/Admin/InboundRouting/GetIBRoute',
                { "Id": e },
                function (data) {
                    editTempData = data;
                    resetfields();
                }, obj);
        },
        /*Btn Action*/
        createButtonClickHandler: function (e) {
            $(e).on('click', function () {
                $(".Add-Edit-header h4").text($areaResources.actionTitle.createNewEntry);
                $(".breadcrumb .add-edit-breadcrumb-item").text($areaResources.actionTitle.createNewEntry);
                
                $.sectionproperties.SecondLevel();
                editTempData = null;
                resetfields();
                $('#formSubmit').validate().resetForm();
            });
        },
        deleteButtonClickHandler: function (e) {
            $(e).on('click', function () {
				$(this).blur();
                var ids = $.inboundrouting.getGridSelections();
                if (ids.length > 0) {
                    swal({
                        title: "",
						text: $globalMessages.swal.alert.deleteConfirmation,
                        type: "info",
                        showCancelButton: true,
                        closeOnConfirm: false,
                        reverseButtons: true,
                        showLoaderOnConfirm: true
                    }, function () {
                        $.inboundrouting.delete(ids);
                    });
                } else {
					swal("", $globalMessages.swal.alert.noItemSelected);
                }
            });
        },
        editButtonClickHandler: function (dataItem) {
            $.sectionproperties.SecondLevel();
            $(".Add-Edit-header h4").text($areaResources.actionTitle.editEntry);
            $(".breadcrumb .add-edit-breadcrumb-item").text($areaResources.actionTitle.editEntry);

            $.inboundrouting.initForm(dataItem.IBRouteID);
        },
        forwardTypeSelectionChangeEvent: function () {
            $('#ForwardType').on('change', function (e) {

                $('input[name="ForwardAddress"]').val('');
                $('input[name="ForwardAddressValue"]').val('');
                forwardAddressControl.tagsinput('removeAll');

                if ($('#ForwardType').val() === "11") {
                    $('#modal-ForwardAddressSelection h4').text('User Selection');
                    $('#getUserRequestType-ForwardAddressSelection').val("1");
                } else {
                    $('#modal-ForwardAddressSelection h4').text('Group Selection');
                    $('#getUserRequestType-ForwardAddressSelection').val("2");
                }                    
            });
        },
        refreshButtonClickHandler: function (e) {
            $(e).on('click', function () {
                $('input[data-role="search-all-item"]').val("");
                $.inboundrouting.initGrid();
                $(this).blur();
            });
        },
        resetHandler: function (e) {
            $(e).on('click', function () {
                resetfields();
            });
        },
        searchButtonClickHandler: function (e) {
            $(e).on('click', function () {
                $.inboundrouting.initGrid();
            });
        },
        searchHandler: function (e) {
            $(e).keypress(function (event) {
                if (event.which === 13) {
                    $.inboundrouting.initGrid();
                }
            });
        },
        selectButtonClickHandler: function (e) {
            $(e).on('click', function () {
                if ($(this).text() === $globalMessages.button.selectAll) {
                    $grid.selectAll();
                    $(this).text($globalMessages.button.unSelectAll);
                } else {
                    $grid.unSelectAll();
                    $(this).text($globalMessages.button.selectAll);
                }
            });
        },
        setButtonClickHandler: function (e) {

            $('.btn-Set').on('click', function (e) {

                if ($('#txtCondition1').val() === '') {
                    $('#txtCondition1').attr('placeholder', $inboundResource.expression);
                    return false;
                }

                populateRoutestring();
            });
        },
        /*End Btn Action*/

        /* Logic */
        getGridSelections: function (e) {
            var selectedId = [];
            var entityGrid = $('#grid').data("kendoGrid");
            var rows = entityGrid.select();

            rows.each(function (index, row) {
                var selectedItem = entityGrid.dataItem(row);
                selectedId[index] = selectedItem.id;
            });

            return selectedId;
        },
        mapData: function (dataItem) {
            $('input[name="RecordId"]').val(dataItem.IBRouteID);
            $('#ForwardType').val(dataItem.DestTypeID).change();

            /*DestExpr = id, DestExprValue = label*/
            if (dataItem.DestExpr != null && dataItem.DestExpr != "0" && dataItem.DestExpr != "") {
                forwardAddressControl.tagsinput('add', { id: dataItem.DestExpr, label: dataItem.DestExprValue });
            }

            $('#RoutestringExpr').val(dataItem.RouteByStringExpr);
            $('#Routestring').val(dataItem.RouteByString);
            $("#ActivateRoute").prop('checked', dataItem.IsActive).change();
            $('#Priority').val(dataItem.Priority);
            $("#AllowLoopBack").prop('checked', dataItem.AllowLoopBack).change();
            $("#RouteByTimeBased").prop('checked', dataItem.IsRestrict).change();

            if (dataItem.ValidBeginTime != null && dataItem.ValidBeginTime != "") {
                /*console.log(dataItem.ValidBeginTime);*/
				var startTime = new Date();
                var startArr = dataItem.ValidBeginTime.split(":");
                startTime.setHours(startArr[0]);
                startTime.setMinutes(startArr[1]);
                startTimeControl.value(startTime);
                /*$('#StartTime').val(dataItem.ValidBeginTime);*/
            }

            if (dataItem.ValidEndTime != null && dataItem.ValidEndTime != "") {
                /*console.log(dataItem.ValidEndTime);*/
                var endTime = new Date();
                var endArr = dataItem.ValidEndTime.split(":");
                endTime.setHours(endArr[0]);
                endTime.setMinutes(endArr[1]);
                endTimeControl.value(endTime);
                /*$('#EndTime').val(dataItem.ValidEndTime);*/
            }

            var validDayArray = dataItem.ValidDay.split(',');
            var validDayInput = $('#Days input');
            $.each(validDayArray, function (i, e) {
                $(validDayInput[e]).prop('checked', true);
            });

        },
        onChangeStart: function (e) {
            /*console.log(this.options);*/
            var startTime = startTimeControl.value();

			if (startTime) {
				
				var finalTime = new Date();
				finalTime.setHours(23, 59, 59, 999);

                /*set value*/
				startTime = new Date(startTime);
                var defaultMinutes = startTime.getMinutes() + this.options.interval;
				startTime.setMinutes(defaultMinutes);
				if (startTime < finalTime)
				{
					finalTime = startTime;
				}
                endTimeControl.value(finalTime);
            }
        },
        resetFieldsHandler: function (e) {
            if (editTempData != null) {
                $.inboundrouting.initForm($('input[name="RecordId"]').val());
            }
            resetfields();
        },
        validateValidDays: function (e) {
            var result = false;
            var parentId = "Days";
            var controlId = '#' + parentId + ' input[type="checkbox"]';
            var checboxList = $(controlId);
            if (checboxList.length) {
                for (j = 0; j < checboxList.length; j++) {
                    var cbx = checboxList[j];
                    if (cbx.checked) {
                        result = true;
                        break;
                    }
                }
            }
            return result;
        },
        /* End Logic */

        /*Post or Get Function*/
        save: function () {
            var validDays = $.inboundrouting.validateValidDays();
            var isRestrict = $("#RouteByTimeBased").prop('checked');
            if (!validDays && isRestrict) {
				swal("", $inboundResource.swal.noValidDay);
                return false;
            }

            fxcRequest.post('/admin/inboundrouting/save',
                constructsavemodel(),
                function (data) {
                    $.inboundrouting.initGrid();

                    if (editTempData != null)
                        resetfields();

                    swal($globalMessages.swal.success.title, $globalMessages.swal.success.text, "success");
                },
                function (error) {
					swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnSubmit, "error");

                });
        },
        delete: function (ids) {
            fxcRequest.post('/admin/inboundrouting/delete',
                {
                    Ids: ids
                },
                function (data) {
                    $.inboundrouting.initGrid();
                    swal($globalMessages.swal.success.title, $globalMessages.swal.success.delete, "success");
                });
        }
    };
})(window.jQuery);