﻿(function ($) {

    var editTempData;
    var $PassIsEncrypted = false;
    var $TempPassword;
    var $PassIsEncrypted2 = false;
    var $TempPassword2;
    var startTimeControl;
    var endTimeControl;
    var interval = 60;
    var maxTime = "23:59";
    var txtUserCondtion1Control;
	var txtUserCondtion2Control;
    var firstAttemptNeworkRoute = true;
    var $treeDomain = null, $treeDomain2 = null;
    
    var outboundroutingvalidation = function () {
        $('#formSubmit').validate({
			ignore: ".ignored",
			ignoreTitle: true,
            rules: {
                Priority: {
					required: true,
					noSpace: true,
                    number: true
                },
				RouteByStringExpr: { required: true, noSpace: true },
				'FaxAgent.Value': { required: true, noSpace: true },
                PortAssignMethod: { requiredIf: ["ServerType", "1"] },
                PortNo: { requiredIf: ["PortAssignMethod", "Port"] },
                PortGroup: { requiredIf: ["PortAssignMethod", "Port Group"] },
				ServerIP: { required: true, noSpace: true },
				RmtUsn1: { required: true, noSpace: true },
				RmtPwd1: { required: true, noSpace: true }
            },
            errorPlacement: function (error, element) {
                var p = element.parent('span').parent();
                if (p.hasClass('form-control')) {
                    error.appendTo(p);
                } else {
                    error.insertAfter(element);
                }
            },
            submitHandler: function (form) {
                $.outboundrouting.save();
            }
        });
    };

    var resetfields = function () {
        $('#formSubmit').trigger("reset");
        $('#formSubmit').validate().resetForm();

        $('#PortNo').val("9999");
        $('#Condition1').change();
        $('#Condition2').change();
        $("#txtCondition2").prop('readonly', true);
        
        $PassIsEncrypted = false;
        $PassIsEncrypted2 = false;

        txtUserCondtion1Control.tagsinput('removeAll');
        txtUserCondtion2Control.tagsinput('removeAll');

        if (editTempData != null) {
            $.outboundrouting.mapData(editTempData);
        } else {
            $('#OBRouteID').val("0");
            $("#ServerType").val("1").change();
            $('#PortAssignMethod').val("Port").change();
        }
    };
    
    var constructsavemodel = function () {        
        var days = '';
        $.each($('#Days input'), function (i, e) {

            if ($(e).prop('checked') === true) {

                var day = e.id;

                if (day === "DaysSun")
                    days += "0,";

                if (day === "DaysMon")
                    days += "1,";

                if (day === "DaysTues")
                    days += "2,";

                if (day === "DaysWed")
                    days += "3,";

                if (day === "DaysThurs")
                    days += "4,";

                if (day === "DaysFri")
                    days += "5,";

                if (day === "DaysSat")
                    days += "6,";

                return days;
            }
        });

        var modelArr = $('#formSubmit').MapFormData();

        var saveObj = {};
        $.each(modelArr, function (index, formModel) {
            saveObj[formModel.Id] = formModel.Value;
        });
        
        if (saveObj.PortAssignMethod == "Port") {
            saveObj.PortID = saveObj.PortNo;
        } else if (saveObj.PortAssignMethod == "Port Group") {
            saveObj.PortID = saveObj.PortGroup;
        }

        saveObj.OverridePriorityEnable = $('#OverridePriorityEnable').bootstrapSwitch('state');

        saveObj.Pass1IsEncrypted = $PassIsEncrypted;
        saveObj.Pass2IsEncrypted = $PassIsEncrypted2;

        saveObj.ValidDay = days;
        saveObj.ValidBeginTime = $('#ValidBeginTime').val();
        saveObj.ValidEndTime = $("#ValidEndTime").val();

        return saveObj;
    };
    
    $.outboundrouting = {
        init: function (e) {
            $('.btn-save2').on('click', function () {
                $("#form-action").val("");
                $("#formSubmit").submit();
            });
            $("#Priority").mask("99999999");

            txtUserCondtion1Control = $('#txtCondition1-User');
            txtUserCondtion1Control.tagsinput({
                itemValue: 'id',
                itemText: 'label'
            });

            txtUserCondtion2Control = $('#txtCondition2-User');
            txtUserCondtion2Control.tagsinput({
                itemValue: 'id',
                itemText: 'label'
            });

            /*obroute rule*/
            $.outboundrouting.createButtonClickHandler($('.View1 .btn-new'));
            $.outboundrouting.deleteButtonClickHandler($('.View1 .btn-delete'));
            $.outboundrouting.refreshButtonClickHandler($('.View1 .btn-refresh'));
            $.outboundrouting.searchHandler($('.View1 input[data-role="search-all-item"]'));
            $.outboundrouting.searchButtonClickHandler($('.View1 .btn-Search'));
            $.outboundrouting.resetHandler($('.btn-Reset2'));
            $.outboundrouting.setButtonClickHandler($('button[data-role="delete-modal-action"]'));
            $.outboundrouting.faxAgentSelectionChanged($('#ServerType'));
            $.outboundrouting.faxAgentSelectionChanged($('#AgentID'));

            $.outboundrouting.routeTypeSelectionChangeEvent();
            $.outboundrouting.conditionSelectionChangeEvent();
            $.outboundrouting.initThirdSectionHandler();

            $.outboundrouting.initGrid();
            $.outboundrouting.initDateTime();
            $.outboundrouting.resetPassword();
            $.outboundrouting.resetPassword2();
            
            outboundroutingvalidation();
        },
        initDateTime: function (e) {
            startTimeControl = $("#ValidBeginTime").kendoTimePicker({
                interval: interval,
				change: $.outboundrouting.onChangeStart,
				format: "HH:mm"
            }).data("kendoTimePicker");

            endTimeControl = $("#ValidEndTime").kendoTimePicker({
				interval: interval,
				format: "HH:mm"
            }).data("kendoTimePicker");

            startTimeControl.max(maxTime);
            endTimeControl.max(maxTime);
        },
        resetPassword: function (e) {
            $("#RmtPwd1").focus(function () {
                if ($PassIsEncrypted) {
                    $TempPassword = $("#RmtPwd1").val();
                    $("#RmtPwd1").val("");
                }
            });
            $("#RmtPwd1").keyup(function () {
                $PassIsEncrypted = false;
            });
            $("#RmtPwd1").focusout(function () {
                if ($PassIsEncrypted) {
                    $("#RmtPwd1").val($TempPassword);
                }
            });
        },
        resetPassword2: function (e) {
            $("#RmtPwd2").focus(function () {
                if ($PassIsEncrypted2) {
                    $TempPassword2 = $("#RmtPwd2").val();
                    $("#RmtPwd2").val("");
                }
            });
            $("#RmtPwd2").keyup(function () {
                $PassIsEncrypted2 = false;
            });
            $("#RmtPwd2").focusout(function () {
                if ($PassIsEncrypted2) {
                    $("#RmtPwd2").val($TempPassword2);
                }
            });
        },
        onChangeStart: function (e) {
            /*console.log(this.options);*/
            var startTime = startTimeControl.value();

			if (startTime) {
				var finalTime = new Date();
				finalTime.setHours(23, 59, 59, 999);
				var defaultStartTime = new Date(startTime);

                /*set value*/
                startTime = new Date(startTime);
                var defaultMinutes = startTime.getMinutes() + this.options.interval;
				startTime.setMinutes(defaultMinutes);

				if (startTime < finalTime) {
					finalTime = startTime;
				}
				endTimeControl.value(finalTime);
				
            }
        },
        resetFieldsHandler: function (e) {
            if (editTempData != null) {
                $.outboundrouting.initForm($('#OBRouteID').val());
            }
            resetfields();
        },
        initGrid: function (e) {
            var id = $('#grid');
			
            var dataSource = {
                transport: {
                    read: {
                        url: '/admin/outboundrouting/ReadOB',
                        dataType: "json",
                        type: "GET"
                    },
                    parameterMap: function (options) {

                        var result = {
                            FilterFields: "Priority,RouteByStringExpr,ServerTypeLabel,AgentServerName",
                            Filter: $('input[data-role="search-all-item"]').val(),
                            Skip: options.skip,
                            Take: options.take,
                            Page: options.page
                        };

                        if (options.sort && options.sort.length > 0) {
                            result.SortBy = options.sort[0].field;
                            result.Direction = options.sort[0].dir;
                        }
                        return result;
                    }
                },
                schema: {
                    data: "Records",
                    total: "Total",
                    model: {
                        id: "OBRouteID"
                    }
                },
                serverPaging: true,
                serverSorting: true
            };

            var col = [
                {
                    selectable: true, width: "45px",
                    attributes: {
                        "class": "checkboxSelection"
                    }
                },
                { field: 'OBRouteID', hidden: true },
                {
                    field: "IsActive",
                    title: $outboundResource.isActiveLabel,
                    width: 100,
                    filterable: {
                        cell: {
                            enabled: false
                        }
                    },
                    template: '<div class="kendo-container"> <i #= IsActive == true ? \'class="mdi fxc-checkbox-true"\' : "" #></i> </div>'
                },
				{ field: 'Priority', title: $outboundResource.priority, width: 120, sortable: true },
                {
                    field: "IsRestrict",
                    title: $outboundResource.isRestrictLabel,
					width: 170,
                    filterable: {
                        cell: {
                            enabled: false
                        }
                    },
                    template: '<div class="kendo-container"> <i #= IsRestrict == true ? \'class="mdi fxc-checkbox-true"\' : "" #></i> </div>'
                },
				{ field: 'RouteByStringExpr', title: $outboundResource.routeStringExpr, width: 300, sortable: true },
                { field: 'ServerTypeLabel', title: $outboundResource.serverType, width: 150, sortable: true },
				{ field: 'AgentServerName', title: $outboundResource.serverName, width: 200, sortable: true },
                {
                    field: "AlternateNetRoute",
                    title: $outboundResource.alternativeNetworkRoute,
                    width: 250,
                    filterable: {
                        cell: {
                            enabled: false
                        }
                    },
                    template: '<div class="kendo-container"> <i #= AlternateNetRoute == true ? \'class="mdi fxc-checkbox-true"\' : "" #></i> </div>'
                }
            ];

            var obj = {};
            obj.allowSelectMultipleRow = true;
            obj.customizeCheckbox = true;
            obj.onSelectionFn = $.outboundrouting.editButtonClickHandler;
            obj.dataSourceOnSuccessFn = $.outboundrouting.resetFieldsHandler;

            kendogridcustomization.init(id, dataSource, col, obj);
        },
        initForm: function (e) {
            var obj = {
                blurForm: true,
                targetDiv: $("form#formSubmit")
            };
            fxcRequest2.get('/Admin/OutboundRouting/GetOBRoute',
                { "Id": e },
                function (data) {
                    editTempData = data;
                    resetfields();
                }, obj);
        },
        createButtonClickHandler: function (e) {
            $(e).on('click', function () {
                $(this).blur();
                $(".Add-Edit-header h4").text($areaResources.actionTitle.createNewEntry);
                $(".breadcrumb .add-edit-breadcrumb-item").text($areaResources.actionTitle.createNewEntry);
                if (!$(".HiddenManageAlternateNetworkRouting").hasClass("hide")) {
                  $(".HiddenManageAlternateNetworkRouting").addClass("hide");
                }
                $.sectionproperties.SecondLevel();
                editTempData = null;
                resetfields();
            });
        },
        editButtonClickHandler: function (dataItem) {
            $(".Add-Edit-header h4").text($areaResources.actionTitle.editEntry);
            $(".breadcrumb .add-edit-breadcrumb-item").text($areaResources.actionTitle.editEntry);
            if ($(".HiddenManageAlternateNetworkRouting").hasClass("hide")) {
              $(".HiddenManageAlternateNetworkRouting").removeClass("hide");
            }

            $.sectionproperties.SecondLevel();
            $.outboundrouting.initForm(dataItem.OBRouteID);

            /* editTempData = dataItem;
            resetfields(); */
        },
        mapData: function (dataItem) {
            /*console.log(dataItem);*/
            $('#formSubmit').BindToForm(dataItem, '#', '');

            $('#Domain-ddl').val(dataItem.DomainName);
            $("#Domain-id").val(dataItem.DomainID);

            $("#ServerType").val(dataItem.ServerType);
            if ($("#ServerType").val() == "1") {
                $('#PortNo').val(dataItem.PortID);
            }
            $("#ServerType").change();
            $("#PortAssignMethod").val(dataItem.PortAssignMethod).change();

            $("#AgentID").val(dataItem.AgentID);

            $PassIsEncrypted = true;
            $PassIsEncrypted2 = true;

            if (dataItem.ValidBeginTime != null && dataItem.ValidBeginTime != "") {
                /*console.log(dataItem.ValidBeginTime);*/
                var startTime = new Date();
                var startArr = dataItem.ValidBeginTime.split(":");
                startTime.setHours(startArr[0]);
                startTime.setMinutes(startArr[1]);
                startTimeControl.value(startTime);
                /*$('#StartTime').val(dataItem.ValidBeginTime);*/
            }

            if (dataItem.ValidEndTime != null && dataItem.ValidEndTime != "") {
                /*console.log(dataItem.ValidEndTime);*/
                var endTime = new Date();
                var endArr = dataItem.ValidEndTime.split(":");
                endTime.setHours(endArr[0]);
                endTime.setMinutes(endArr[1]);
                endTimeControl.value(endTime);
                /*$('#EndTime').val(dataItem.ValidEndTime);*/
            }

            var validDayArray = dataItem.ValidDay.split(',');
            var validDayInput = $('#Days input');
            $.each(validDayArray, function (i, e) {
                $(validDayInput[e]).prop('checked', true);
            });
        },
        deleteButtonClickHandler: function (e) {
            $(e).on('click', function () {
                $(this).blur();
                var ids = $.outboundrouting.getGridSelections();
                if (ids.length > 0) {
                    swal({
                        title: "",
						text: $globalMessages.swal.alert.deleteConfirmation,
                        type: "info",
                        showCancelButton: true,
                        closeOnConfirm: false,
                        reverseButtons: true,
                        showLoaderOnConfirm: true
                    }, function () {
                        $.outboundrouting.delete(ids);
                    });
                } else {
					swal("", $globalMessages.swal.alert.noItemSelected);
                }
            });
        },
        refreshButtonClickHandler: function (e) {
            $(e).on('click', function () {
                $(this).blur();
                $('input[data-role="search-all-item"]').val("");
                $.outboundrouting.initGrid();
            });
        },

        searchButtonClickHandler: function (e) {
            $(e).on('click', function () {
                $.outboundrouting.initGrid();
            });
        },
        searchHandler: function (e) {
            $(e).keypress(function (event) {
                if (event.which === 13) {
                    $.outboundrouting.initGrid();
                }
            });
        },
        resetHandler: function (e) {
            $(e).on('click', function () {
                resetfields();
            });
        },
        validateValidDays: function (e) {
            var result = false;
            var parentId = "Days";
            var controlId = '#' + parentId + ' input[type="checkbox"]';
            var checboxList = $(controlId);
            if (checboxList.length) {
                for (j = 0; j < checboxList.length; j++) {
                    var cbx = checboxList[j];
                    if (cbx.checked) {
                        result = true;
                        break;
                    }
                }
            }
            return result;
        },
        save: function () {            
            var validDays = $.outboundrouting.validateValidDays();
            var isRestrict = $("#IsRestrict").prop('checked');
            if (!validDays && isRestrict) {
				swal("", $outboundResource.swal.noValidDay);
                return false;
            }
            var savemodel = constructsavemodel();
            /* console.log(savemodel);*/

            fxcRequest.post('/admin/outboundrouting/saveob',
                savemodel,
                function (data) {
                    $.outboundrouting.initGrid();
                    if (editTempData == null) {
                        resetfields();
                    }

                    swal($globalMessages.swal.success.title, $globalMessages.swal.success.text, "success");
                },
                function (error) {
                    swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnSubmit, "error");

                });
        },
        delete: function (ids) {
            fxcRequest.post('/Admin/OutboundRouting/DeleteOB',
                {
                    Ids: ids
                },
                function (data) {
                    $.outboundrouting.initGrid();
                    swal($globalMessages.swal.success.title, $globalMessages.swal.success.delete, "success");
                });
        },
        getGridSelections: function (e) {
            var selectedId = [];
            var entityGrid = $('#grid').data("kendoGrid");
            var rows = entityGrid.select();

            rows.each(function (index, row) {
                var selectedItem = entityGrid.dataItem(row);
                selectedId[index] = selectedItem.id;
            });

            return selectedId;
        },
        setButtonClickHandler: function (e) {
            $('.btn-Set').on('click', function (e) {

                /*Condition 1 rules*/
                var cond1Text = "";
                var cond1Value = "";

                var ddl1value = $('#Condition1').val();
                var ddl1textId = '#Condition1 option[value="' + ddl1value + '"]';
                var ddl1Text = $(ddl1textId).text();

                if (ddl1value == "$$USER.DOMAIN_ID$$") {

                    cond1Value = $('#domain-id').val();
                    cond1Text = $('#domain-ddl').val();
                    
                } else if (ddl1value == "$$USER.USERID$$") {
                    cond1Value = $('#txtCondition1-User').val();
                    var userArr = $('#txtCondition1-User').tagsinput()[0].itemsArray;
                    if (userArr.length > 0) {
                        cond1Text = userArr[0].label;
                    }                    
                } else {
                    cond1Value = $('#txtCondition1').val();
                }
                
                var cond1 = {
                    "DdlCondition": { "Text": ddl1Text, "Value": ddl1value },
                    "Condition": { "Text": cond1Text, "Value": cond1Value }
              };

                /*Condition 2 rules*/
                var cond2Text = "";
                var cond2Value = "";

                var ddl2value = $('#Condition2').val();
                var ddl2textId = '#Condition2 option[value="' + ddl2value + '"]';
                var ddl2Text = $(ddl2textId).text();

                if (ddl2value == "$$USER.DOMAIN_ID$$") {
                    cond2Value = $('#domain2-id').val();
                    cond2Text = $('#domain2-ddl').val();

                } else if (ddl2value == "$$USER.USERID$$") {
                    cond2Value = $('#txtCondition2-User').val();
                    var userArr2 = $('#txtCondition2-User').tagsinput()[0].itemsArray;
                    if (userArr2.length > 0) {
                        cond2Text = userArr2[0].label;
                    }                    
                } else {
                    cond2Value = $('#txtCondition2').val();
                }

                var cond2 = {
                    "DdlCondition": { "Text": ddl2Text, "Value": ddl2value },
                    "Condition": { "Text": cond2Text, "Value": cond2Value }
                };

                /*Create Model*/
                var conditionmodel = {
                    "DdlCondition1Text": cond1.DdlCondition.Text,
                    "DdlCondition1Value": cond1.DdlCondition.Value,
                    "Condition1Text": cond1.Condition.Text,
                    "Condition1Value": cond1.Condition.Value,
                    "DdlCondition2Text": cond2.DdlCondition.Text,
                    "DdlCondition2Value": cond2.DdlCondition.Value,
                    "Condition2Text": cond2.Condition.Text,
                    "Condition2Value": cond2.Condition.Value,
                    "Operator": $('#Operator').val()
                };
                /*console.log(conditionmodel);*/

                if (conditionmodel.Condition1Value == "") {
					var message = "[" + conditionmodel.DdlCondition1Text + "] " + $outboundResource.expression;
                    swal("", message);
                    return false;
                }

                if (conditionmodel.DdlCondition2Text != "" && conditionmodel.Condition2Value == "") {
					var message2 = "[" + conditionmodel.DdlCondition2Text + "] " + $outboundResource.expression;
                    swal("", message2);
                    return false;
                }

                fxcRequest.post('/Admin/OutboundRouting/GetRouteByString',
                    conditionmodel,
                    function (data) {
                        /*console.log(data);*/
                        $('#RouteByStringExpr').val(data.RouteByStringExpr);
                        $('#RouteByString').val(data.RouteByString);
                    }, null, false);
            });
        },
        routeTypeSelectionChangeEvent: function () {

            $('select#ServerType').on('change', function (event, state) {
                var result = false;
                var returnValue = $(this).val();
                var showid = "";

                if (returnValue === "1") {
                    /* Fax Agent */
                    result = true;
                    $.sectionproperties.Hidden(this.id + "_FaxServer", result, true);
                    $.sectionproperties.Hidden(this.id + "_FaxAgent", result, false);
                }
                else if (returnValue === "2") {
                    /* Fax Server */
                    result = true;
                    $.sectionproperties.Hidden(this.id + "_FaxServer", result, false);
                    $.sectionproperties.Hidden(this.id + "_FaxAgent", result, true);
                }
                else {
                    $.sectionproperties.Hidden(this.id + "_FaxServer", true, true);
                    $.sectionproperties.Hidden(this.id + "_FaxAgent", true, true);
                }
            });
            $("select#RouteType").change();

            $('select#PortAssignMethod').on('change', function (event, state) {
                var result = false;
                var returnValue = $(this).val();
                var showid = "";

                if (returnValue === "Port Group") {
                    /* Port Group */
                    result = true;
                    $.sectionproperties.Hidden(this.id + "_PortNo", result, true);
                    $.sectionproperties.Hidden(this.id + "_PortGroup", result, false);
                }
                else if (returnValue === "Port") {
                    /* Port No */
                    result = true;
                    $.sectionproperties.Hidden(this.id + "_PortNo", result, false);
                    $.sectionproperties.Hidden(this.id + "_PortGroup", result, true);
                }
                else {
                    $.sectionproperties.Hidden(this.id + "_PortNo", true, true);
                    $.sectionproperties.Hidden(this.id + "_PortGroup", true, true);
                }
            });
            $("select#PortAssignMethod").change();
        },
        initTreeViewDomain: function (e) {
            $('#domain-ddl').val($('#dashboardText').text());
            $("#domain-id").val($('#dashboardID').val());

            if ($treeDomain == null) {
                var objDomainSelection = {};
                objDomainSelection.expandAll = true;
                objDomainSelection.declareType = "textbox";
                $treeDomain = treeview.init("domain", "domain-name", "domain-id", objDomainSelection);
            }
        },
        initTreeViewDomain2: function (e) {
            $('#domain2-ddl').val($('#dashboardText').text());
            $("#domain2-id").val($('#dashboardID').val());

            if ($treeDomain2 == null) {
                var objDomainSelection = {};
                objDomainSelection.expandAll = true;
                objDomainSelection.declareType = "textbox";
                $treeDomain2 = treeview.init("domain2", "domain2-name", "domain2-id", objDomainSelection);
            }
        },
        toggleConditionUserSelection: function (isUser, condition) {
            var controlId = "#txtCondition" + condition + "-Userbox";
            if (isUser) {
                $(controlId).show();
            } else {
                $(controlId).hide();
            }
        },
        toggleConditionDomainSelection: function (isDomain, condition) {
            var controlId = "#selectTreeViewDomain-obTree" + condition;
            if (isDomain) {
                $(controlId).show();
                if (condition == "1") {
                    $.outboundrouting.initTreeViewDomain();
                } else {
                    $.outboundrouting.initTreeViewDomain2();
                }
            } else {
                $(controlId).hide();
            }
        },
        toggleConditionOther: function (isOther, condition) {
            var controlId = "#selectTreeView-obTree" + condition;
            if (isOther) {
                $(controlId).show();
            } else {
                $(controlId).hide();
            }
        },
        conditionSelectionChangeEvent: function () {
            $('select#Condition1').on('change', function (event, state) {

                var returnValue = $(this).val();

                $.outboundrouting.toggleConditionDomainSelection(false, "1");
                $.outboundrouting.toggleConditionUserSelection(false, "1");
                $.outboundrouting.toggleConditionOther(false, "1");

                txtUserCondtion1Control.tagsinput('removeAll');
                $('#txtCondition1').val("");

                if (returnValue == "$$USER.DOMAIN_ID$$") {
                    $.outboundrouting.toggleConditionDomainSelection(true, "1");
                } else if (returnValue == "$$USER.USERID$$") {
                    $.outboundrouting.toggleConditionUserSelection(true, "1");
                } else {
                    $.outboundrouting.toggleConditionOther(true, "1");
                }
            });

            $('select#Condition2').on('change', function (event, state) {
                var returnValue = $(this).val();

                $.outboundrouting.toggleConditionDomainSelection(false, "2");
                $.outboundrouting.toggleConditionUserSelection(false, "2");
                $.outboundrouting.toggleConditionOther(false, "2");

                txtUserCondtion2Control.tagsinput('removeAll');
                $('#txtCondition2').val("");

                $('#txtCondition2').val("");
                $("#txtCondition2").prop('readonly', true);

                if (returnValue == "$$USER.DOMAIN_ID$$") {
                    $.outboundrouting.toggleConditionDomainSelection(true, "2");
                } else if (returnValue == "$$USER.USERID$$") {
                    $.outboundrouting.toggleConditionUserSelection(true, "2");
                } else {
                    $("#txtCondition2").prop('readonly', false);
                    $.outboundrouting.toggleConditionOther(true, "2");
                }

                if (returnValue == "0") {
                    $("#txtCondition2").prop('readonly', true);
                }
            });

        },
        faxAgentSelectionChanged: function (e) {
            $(e).on('change', function () {

                var faxagent = $('#AgentID').val();
                if (faxagent == null) {
                    var firstVal = $('#AgentID option')[0] ? $('#AgentID option')[0].value : '';
                    $('#AgentID').val(firstVal);
                }

                var assignMethod = $('#PortAssignMethod').val();
                if (assignMethod == null) {
                    var firstValAssignMethod = $('#PortAssignMethod option')[0] ? $('#PortAssignMethod option')[0].value : '';
                    $('#PortAssignMethod').val(firstValAssignMethod).change();
                }

                var portModel = {
                    "AgentId": $('#AgentID').val(),
                    "PortId": $('#PortNo').val()
                };
                
                /*console.log(portModel);*/
                fxcRequest.get('/Admin/OutboundRouting/GetPortNoOrPortGroup',
                    portModel,
                    function (data) {                        
                        $('#formSubmit').BindJson(data, '#', '');
                    },
                    function (error) {
                        console.log(error);
                    });
            });
        },
        /*3rd Level*/
        initThirdSectionHandler: function () {

            /* Third Level */
            $('#Link-ManageAlternativeNetworkRouting').on('click', function (e) {
				$.sectionproperties.ThirdLevel();
				if (firstAttemptNeworkRoute)
				{
					firstAttemptNeworkRoute = false;
					$.obAlt.network_init();
				}
				else {
					$('input[data-role="search-all-alternate-network-routing"]').val("");
					$.obAlt.network_initGrid();
				}
                
            });
            $('.btn-back3').on('click', function (e) {
                $.sectionproperties.SecondLevel($(e));
            });

            $('select#network_RouteType').on('change', function (event, state) {
                var result = false;
                var returnValue = $(this).val();
                var showid = "";

                if (returnValue === "1") {
                    /* Fax Agent */
                    result = true;
                    $.sectionproperties.Hidden(this.id + "_FaxServer", result, true);
                    $.sectionproperties.Hidden(this.id + "_FaxAgent", result, false);
                }
                else if (returnValue === "2") {
                    /* Fax Server */
                    result = true;
                    $.sectionproperties.Hidden(this.id + "_FaxServer", result, false);
                    $.sectionproperties.Hidden(this.id + "_FaxAgent", result, true);
                }
                else {
                    $.sectionproperties.Hidden(this.id + "_FaxServer", true, true);
                    $.sectionproperties.Hidden(this.id + "_FaxAgent", true, true);
                }
            });
            $("select#network_RouteType").change();

            $('select#network_PortAssignGroup').on('change', function (event, state) {
                var result = false;
                var returnValue = $(this).val();
                var showid = "";

                if (returnValue === "PortGroup") {
                    /* Port Group */
                    result = true;
                    $.sectionproperties.Hidden(this.id + "_PortNo", result, true);
                    $.sectionproperties.Hidden(this.id + "_PortGroup", result, false);
                }
                else if (returnValue === "Port") {
                    /* Port No */
                    result = true;
                    $.sectionproperties.Hidden(this.id + "_PortNo", result, false);
                    $.sectionproperties.Hidden(this.id + "_PortGroup", result, true);
                }
                else {
                    $.sectionproperties.Hidden(this.id + "_PortNo", true, true);
                    $.sectionproperties.Hidden(this.id + "_PortGroup", true, true);
                }
            });
            $("select#networkPortAssignGroup").change();
        }
    };

    /*-------------------------------------Alternative Network Route Setting------------------------------------------------*/
    var editNetworkTempData;
    var $NetworkPassIsEncrypted = false;
    var $NetworkTempPassword;
    var $NetworkPassIsEncrypted2 = false;
    var $NetworkTempPassword2;
    var setMoveHandler = true;

    var networkValidation = function () {

        $('#network_formSubmit').validate({
            ignore: ".ignored",
            rules: {
                'FaxAgent.Value': { required: true },
                network_PortAssignGroup: { requiredIf: ["network_RouteType", "1"] },
                network_PortNo: { requiredIf: ["network_PortAssignGroup", "Port"] },
                network_PortGroup: { requiredIf: ["network_PortAssignGroup", "Port Group"] },
                network_ServerIP: { required: true },
                network_RemoteUsername1: { required: true },
                network_RemotePassword1: { required: true }
            },
            submitHandler: function (form) {
                $.obAlt.network_save();
            }
        });
    };

    var network_resetfields = function () {
        $('#network_formSubmit').trigger("reset");
        $('#network_formSubmit').validate().resetForm();
        $('#AttemptID').val("0");
        
        $NetworkPassIsEncrypted = false;
        $NetworkPassIsEncrypted2 = false;
        
        if (editNetworkTempData != null) {
            $.obAlt.mapData(editNetworkTempData);
        } else {

            $('#Network_PortID').val("9999");
            $("#network_PortNo").val("9999");
            $("#network_PortGroup").val("9999");

            $("select#network_RouteType").val("1").change();
            $("select#network_PortAssignGroup").change();            
        }
    };
    
    var constructnetworksavemodel = function () {
        var portAssignMethod = $('#network_PortAssignGroup').val();
        var portId = "";
        if (portAssignMethod == "Port") {
            portId = $('#network_PortNo').val();
        } else {
            portId = $('#network_PortGroup').val();
        }

        return {
            "AttemptID": $('#AttemptID').val(),
            "OBRouteID": $('#OBRouteID').val(),
            "IsActive": $('#network_Active').prop('checked'),
            "ServerType": $('#network_RouteType').val(),
            "AgentID": $('#network_FaxAgent').val(),
            "PortAssignMethod": portAssignMethod,
            "PortID": portId,
            "PortNo": $('#network_PortNo').val(),
            "PortGroup": $('#network_PortGroup').val(),
            "ServerIP": $('#network_ServerIP').val(),
            "RemoteUsername1": $('#network_RemoteUsername1').val(),
            "RmtPwd1X": $('#network_RemotePassword1').val(),
            "RemoteUsername2": $('#network_RemoteUsername2').val(),
            "RmtPwd2X": $('#network_RemotePassword2').val(),
            "Pass1IsEncrypted": $NetworkPassIsEncrypted,
            "Pass2IsEncrypted": $NetworkPassIsEncrypted2
        };
    };

    $.obAlt = {
        network_init: function (e) {
            $.obAlt.network_createButtonClickHandler($('.View3 .btn-new'));
            $.obAlt.network_deleteButtonClickHandler($('.View3 .btn-delete'));
            $.obAlt.network_refreshButtonClickHandler($('.View3 .btn-refresh'));
            $.obAlt.network_searchHandler($('.View3 input[data-role="search-all-alternate-network-routing"]'));
            $.obAlt.network_searchButtonClickHandler($('.View3 .btn-Search'));
            $.obAlt.network_resetmodalHandler($('#network-add-edit-modal button[data-role="reset-modal-value"]'));
            $.obAlt.network_saveclosemodalHandler($('input[data-role="save-close-modal"]'));
            
            $.obAlt.network_faxAgentSelectionChanged($('#network_RouteType'));
            $.obAlt.network_faxAgentSelectionChanged($('#network_FaxAgent'));

            $.obAlt.resetPassword();
            $.obAlt.resetPassword2();
            $.obAlt.network_initGrid();
            networkValidation();
        },
        resetPassword: function (e) {
            $("#network_RemotePassword1").focus(function () {
                if ($NetworkPassIsEncrypted) {
                    $NetworkTempPassword = $("#network_RemotePassword1").val();
                    $("#network_RemotePassword1").val("");
                }
            });
            $("#network_RemotePassword1").keyup(function () {
                $NetworkPassIsEncrypted = false;
            });
            $("#network_RemotePassword1").focusout(function () {
                if ($NetworkPassIsEncrypted) {
                    $("#network_RemotePassword1").val($NetworkTempPassword);
                }
            });
        },
        resetPassword2: function (e) {
            $("#network_RemotePassword2").focus(function () {
                if ($NetworkPassIsEncrypted2) {
                    $NetworkTempPassword2 = $("#network_RemotePassword2").val();
                    $("#network_RemotePassword2").val("");
                }
            });
            $("#network_RemotePassword2").keyup(function () {
                $NetworkPassIsEncrypted2 = false;
            });
            $("#network_RemotePassword2").focusout(function () {
                if ($NetworkPassIsEncrypted2) {
                    $("#network_RemotePassword2").val($NetworkTempPassword2);
                }
            });
        },
        resetFieldsHandler: function (e) {
            editNetworkTempData = null;
            var getData = $("#gridNetwork").data("kendoGrid").dataSource.get($('#AttemptID').val());
            editNetworkTempData = getData;

            network_resetfields();
        },
        network_initGrid: function (e) {
            var id = $('#gridNetwork');
            
            var dataSource = {
                transport: {
                    read: {
                        url: '/Admin/OutboundRouting/ReadAlt',
                        dataType: "json",
                        type: "GET"
                    },
                    parameterMap: function (options) {

                        var result = {
                            OBRouteID: $('#OBRouteID').val(),
                            FilterFields: "AttemptNo,ServerTypeLabel,ServerNameDef",
                            Filter: $('input[data-role="search-all-alternate-network-routing"]').val(),
                            Skip: options.skip,
                            Take: options.take,
                            Page: options.page
                        };

                        if (options.sort && options.sort.length > 0) {
                            result.SortBy = options.sort[0].field;
                            result.Direction = options.sort[0].dir;
                        }

                        return result;
                    }
                },
                schema: {
                    data: "Records",
                    total: "Total",
                    model: {
                        id: "AttemptID"
                    }
                },
                serverPaging: true,
                serverSorting: true
            };

            var col = [
                {
                    selectable: true, width: "45px",
                    attributes: {
                        "class": "checkboxSelection"
                    }
                },
                {
                    attributes: {
                        "class": "disabledClickableRow checkboxSelection"
                    },
                    width: 60,
                    sortable: false,
                    filterable: {
                        cell: {
                            enabled: false
                        }
                    },
                    template: function (dataRow) {
                        var result = '<div class="k-move-up-row"><a class="grid-navIcon text-green-color nav-link waves-effect moveUp" data-id="' + dataRow.Id + '" id="moveUp-' + dataRow.Id + '" href="javascript:void(0)"><i class="mdi mdi-arrow-up-bold"></i></a>';
                        return result;
                    }
                },
                {
                    attributes: {
                        "class": "disabledClickableRow checkboxSelection"
                    },
                    width: 60,
                    sortable: false,
                    filterable: {
                        cell: {
                            enabled: false
                        }
                    },
                    template: function (dataRow) {
                        var result = '<div class="k-move-down-row"><a class="grid-navIcon text-blue-color nav-link waves-effect moveDown" data-id="' + dataRow.Id + '" id="moveDown-' + dataRow.Id + '" href="javascript:void(0)"><i class="mdi mdi-arrow-down-bold"></i></a>';
                        return result;
                    }
                },
                { field: 'AttemptID', hidden: true },
                { field: 'AttemptNo', title: $outboundResource.attemptNo, width: 150, sortable: true },
                {
                    field: "IsActive",
                    title: $outboundResource.isActiveLabel,
                    width: 100,
                    filterable: {
                        cell: {
                            enabled: false
                        }
                    },
                    template: '<div class="kendo-container"> <i #= IsActive == true ? \'class="mdi fxc-checkbox-true"\' : "" #></i> </div>'
                },
                { field: 'ServerTypeLabel', title: $outboundResource.serverType, width: 250, sortable: true },
                { field: 'ServerNameDef', title: $outboundResource.serverName, width: 350, sortable: true }
            ];

            var obj = {};
            obj.allowSelectMultipleRow = true;
            obj.customizeCheckbox = true;
            obj.onSelectionFn = $.obAlt.network_editButtonClickHandler;
            obj.dataSourceOnSuccessFn = $.obAlt.resetFieldsHandler;

            kendogridcustomization.init(id, dataSource, col, obj);

            if (setMoveHandler) {
                $.obAlt.network_swapClickHandler();
                setMoveHandler = false;
            }
        },
        getGridSelections: function (e) {
            var selectedId = [];
            var entityGrid = $('#gridNetwork').data("kendoGrid");
            var rows = entityGrid.select();

            rows.each(function (index, row) {
                var selectedItem = entityGrid.dataItem(row);
                selectedId[index] = selectedItem.id;
            });

            return selectedId;
        },
        network_createButtonClickHandler: function (e) {
			$(e).on('click', function () {
                editNetworkTempData = null;
                network_resetfields();
                $("#network-add-edit-modal .modal-header h4").text($areaResources.actionTitle.createNewEntry);
                $(".attempt-no").html('');
                $('#network-add-edit-modal').modal('show');
            });
        },
        network_editButtonClickHandler: function (dataItem) {
			$("#network-add-edit-modal .modal-header h4").text($areaResources.actionTitle.editEntry);
            $('#network-add-edit-modal').modal('show');
            editNetworkTempData = dataItem;
            network_resetfields();            
        },
        mapData: function (dataItem) {
            console.log(dataItem);

            $NetworkPassIsEncrypted = true;
            $NetworkPassIsEncrypted2 = true;

            $('#AttemptID').val(dataItem.id);
            $('#network_FaxAgent').val(dataItem.AgentID);

            $("#Network_PortID").val(dataItem.PortID);
            $("#network_PortNo").val(dataItem.PortID);
            $("#network_PortGroup").val(dataItem.PortID);

            $('#network_RouteType').val(dataItem.ServerType).change();
            
            $("#network_PortAssignGroup").val(dataItem.PortAssignMethod).change();

            $("#network_ServerIP").val(dataItem.ServerIP).change();
            $("#network_RemoteUsername1").val(dataItem.RmtUsn1).change();
            $("#network_RemotePassword1").val(dataItem.RmtPwd1).change();
            $("#network_RemoteUsername2").val(dataItem.RmtUsn2).change();
            $("#network_RemotePassword2").val(dataItem.RmtPwd2).change();
            $("#network_Active").prop('checked', dataItem.IsActive).change();
            $(".attempt-no").html('<b> (Attempt: ' + dataItem.AttemptNo +')</b>');
        },
        network_swapClickHandler: function (e) {
            /*Move Up Click Handler*/
            $("#gridNetwork tbody").on("click", "a.moveUp", function (e) {
                var tr = $(e.target).closest("tr");
                var row = $("#gridNetwork").data("kendoGrid").dataItem(tr);
                if (row != null) {
                    swal({
                        title: "",
						text: $globalMessages.swal.alert.moveUpConfirmation,
                        type: "info",
                        showCancelButton: true,
                        closeOnConfirm: false,
                        reverseButtons: true,
                        showLoaderOnConfirm: true
                    }, function () {
                        $.obAlt.network_swap(row.id, 2);
                    });
                }
            });

            $("#gridNetwork tbody").on("click", "a.moveDown", function (e) {
                var tr = $(e.target).closest("tr");
                var row = $("#gridNetwork").data("kendoGrid").dataItem(tr);
                if (row != null) {
                    swal({
                        title: "",
						text: $globalMessages.swal.alert.moveDownConfirmation,
                        type: "info",
                        showCancelButton: true,
                        closeOnConfirm: false,
                        reverseButtons: true,
                        showLoaderOnConfirm: true
                    }, function () {
                        $.obAlt.network_swap(row.id, 1);
                    });                    
                }
            });
        },
        network_deleteButtonClickHandler: function (e) {
            $(e).on('click', function () {
                $(this).blur();
                var ids = $.obAlt.getGridSelections();
                if (ids.length > 0) {
                    swal({
                        title: "",
						text: $globalMessages.swal.alert.deleteConfirmation,
                        type: "info",
                        showCancelButton: true,
                        closeOnConfirm: false,
                        reverseButtons: true,
                        showLoaderOnConfirm: true
                    }, function () {
                        $.obAlt.network_delete(ids);
                    });
                } else {
					swal("", $globalMessages.swal.alert.noItemSelected);
                }
            });
        },
        network_refreshButtonClickHandler: function (e) {
            $(e).on('click', function () {
                $(this).blur();
                $('input[data-role="search-all-alternate-network-routing"]').val("");
                $.obAlt.network_initGrid();
            });
        },
        
        network_searchButtonClickHandler: function (e) {
            $(e).on('click', function () {
                $.obAlt.network_initGrid();
            });
        },
        network_searchHandler: function (e) {
            $(e).keypress(function (event) {
                if (event.which === 13) {
                    $.obAlt.network_initGrid();
                }
            });
        },
        network_resetmodalHandler: function (e) {
            $(e).on('click', function () {
                network_resetfields();
            });
        },
        network_saveclosemodalHandler: function (e) {
            $(e).on('click', function () {
                $('#network-add-edit-modal input[name="modal-action"]').val('save & close');
            });
        },
        network_faxAgentSelectionChanged: function (e) {
            $(e).on('change', function () {

                var faxagent = $('#network_FaxAgent').val();
				if (faxagent == null && $('#network_FaxAgent option').length > 0) {
                    var firstVal = $('#network_FaxAgent option')[0].value;
                    $('#network_FaxAgent').val(firstVal);
                }

                var assignMethod = $('#network_PortAssignGroup').val();
				if (assignMethod == null && $('#network_FaxAgent option').length > 0) {
                    var firstValAssignMethod = $('#network_PortAssignGroup option')[0].value;
                    $('#network_PortAssignGroup').val(firstValAssignMethod).change();
                }

                var portModel = {
                    "AgentId": $('#network_FaxAgent').val(),
                    "PortId": $('#Network_PortID').val()
                };
                
                fxcRequest.get('/Admin/OutboundRouting/GetPortNoOrPortGroup',
                    portModel,
                    function (data) {
                        
                        $.sectionproperties.selectGenerator('network_PortNo', data.PortNo.Source, data.PortNo.Value, 0);
                        $.sectionproperties.selectGenerator('network_PortGroup', data.PortGroup.Source, data.PortGroup.Value, 0);
                    },
                    function (error) {
                        console.log(error);
                    });
            });
        },
        network_save: function () {
            fxcRequest.post('/Admin/OutboundRouting/SaveAlternative',
                constructnetworksavemodel(),
                function (data) {
                    $.obAlt.network_initGrid();
                    if (editNetworkTempData == null) {
                        network_resetfields();
                        $('#network_formSubmit').validate().resetForm();
                    }
                    
                    if ($('#network-add-edit-modal input[name="modal-action"]').val() === 'save & close') {
                        $('#network-add-edit-modal').modal('hide');
                        $('#network-add-edit-modal input[name="modal-action"]').val('');
                    }
                    swal($globalMessages.swal.success.title, $globalMessages.swal.success.text, "success");
                },
                null);
        },
        network_delete: function (ids) {
            fxcRequest.post('/Admin/OutboundRouting/DeleteAlternative',
                {
                    Ids: ids
                },
                function (data) {
                    $.obAlt.network_initGrid();
                    swal($globalMessages.swal.success.title, $globalMessages.swal.success.delete, "success");
                },
                null);
        },
        network_swap: function (id, moveCmd) {
            fxcRequest.post('/Admin/OutboundRouting/Swap',
                {
                    "Id": id,
                    "MoveCmd": moveCmd
                },
                function (data) {
                    $.obAlt.network_initGrid();
                    swal.close();
                }, null, false);
        }
     };
})(window.jQuery);