﻿(function ($) {
    var userDomainId;
    var editTempData;
	var $treeDomain;
    var domaindocumentvalidation = function () {
		$('#form-domain-documents').validate({
			ignoreTitle: true,
            rules: {
                DomainName: { required: true, noSpace: true },
                FolderName: { required: true, noSpace: true }
            },
            submitHandler: function (form) {
                $.folder.save();
            }
        });
    };

	var resetfields = function (e) {
        $('#form-domain-documents').trigger("reset");
        $('#form-domain-documents').validate().resetForm();

        $('#domain-ddl').val($('#dashboardText').text());
		$("#domain-id").val($('#dashboardID').val());
		treeview.selectNode($treeDomain, $("#domain-id").val());

        $('#FolderID').val('0');
        $('#VisibilityID').find('option').attr("selected", false);

		$.sectionproperties.Hidden("DocumentEntry", true);

		if (editTempData != null) {
			$('input[data-role="search-document-entry"]').val("");
			$.folder.initMoveDdl(editTempData.FolderID);
			if (editTempData.savedFolderId != null) {
                editTempData = $('#grid').data("kendoGrid").dataSource.get(editTempData.savedFolderId);
            }
            $.folder.mapData(editTempData);
        }
    };

    $.folder = {
        init: function (currentDomainId) {
            userDomainId = currentDomainId;
            $('.btn-save2').on('click', function () {
                $("#form-domain-documents").submit();
            });

            $.folder.createButtonClickHandler($('.View1 .btn-new'));
            $.folder.deleteButtonClickHandler($('.View1 .btn-delete'));
            $.folder.refreshButtonClickHandler($('.View1 .btn-refresh'));
            $.folder.searchHandler($('input[data-role="search-all-item"]'));
            $.folder.searchButtonClickHandler($('.View1 .btn-Search'));
			$.folder.resetHandler($('.View2 .btn-Reset2'));
			$.folder.backButtonClickHandler($('.View2 .btn-back2'));

            $.folder.initTreeViewMove();
            $.folder.initTreeViewDomain();
            $.folder.initGrid();

            domaindocumentvalidation();

            $.document.init();
		},
		initMoveDdl: function (folderId) {
			folderId = folderId || "";
			folderId = folderId + "";
			if (folderId.length > 0 && $("#moveDropDown").find("a.btn-action#" + folderId).length > 0)
			{
				$("#moveDropDown").find("a.btn-action").removeClass("Hidden");
				$("#moveDropDown").find("a.btn-action#" + folderId).addClass("Hidden");
			}

			if ($("#moveDropDown").find("a.btn-action:not(.Hidden)").length > 0) {
				$("#mainDropDown").attr("disabled", false);
			}
			else {
				$("#mainDropDown").attr("disabled", true);
			}
			
			
		},
        /*Btn Action*/
		backButtonClickHandler: function (e) {
			$(e).on('click', function (e) {
				$.sectionproperties.FirstLevelView();
                $.folder.initGrid();
                if ($("#gridDocument").data('kendoGrid') != null) {
                    $("#gridDocument").data('kendoGrid').dataSource.data([]);
                }
			});
		},
        createButtonClickHandler: function (e) {
            $(e).on('click', function () {
				$(".breadcrumb .add-edit-breadcrumb-item-folder").text($documentResource.createNewFolder);
                
                $.sectionproperties.SecondLevel();
                $.sectionproperties.Hidden("DocumentEntry", true);
                editTempData = null;
                resetfields();
            });
        },
        editButtonClickHandler: function (dataItem) {
			$(".breadcrumb .add-edit-breadcrumb-item-folder").text($documentResource.editFolder);
            
            $.sectionproperties.Hidden("DocumentEntry", false);
			$.sectionproperties.SecondLevel();
			editTempData = dataItem;
            resetfields();
        },
        deleteButtonClickHandler: function (e) {
			$(e).on('click', function () {
				$(this).blur();
                var ids = $.folder.getGridSelections();
                if (ids.length > 0) {
                    swal({
                        title: "",
                        text: $documentResource.swal.delFolder,
                        type: "info",
                        showCancelButton: true,
                        closeOnConfirm: false,
                        reverseButtons: true,
                        showLoaderOnConfirm: true
                    }, function () {
                        $.folder.delete(ids);
                    });
                } else {
                    swal("", $documentResource.swal.noFolder);
                }
            });
        },
        refreshButtonClickHandler: function (e) {
            $(e).on('click', function () {
                $('input[data-role="search-all-item"]').val("");
                $.folder.initGrid();
                $(this).blur();
            });
        },
        searchHandler: function (e) {
            $(e).keypress(function (event) {
                if (event.which === 13) {
                    $.folder.initGrid();
                }
            });
        },
        searchButtonClickHandler: function (e) {
            $(e).on('click', function () {
                $.folder.initGrid();
                $(this).blur();
            });
        },
        resetHandler: function (e) {
            $(e).on('click', function (e) {
                resetfields();
            });
        },
        /*End Btn Action*/
        /* Logic */
		mapData: function (dataItem) {
            $('#form-domain-documents').BindToForm(dataItem, '#', '');

            /*show doc grid*/
            $.sectionproperties.Hidden("DocumentEntry", false);
            $.document.initGrid();
        },
        getGridSelections: function (e) {
            var selectedId = [];
            var entityGrid = $('#grid').data("kendoGrid");
            var rows = entityGrid.select();

            rows.each(function (index, row) {
                var selectedItem = entityGrid.dataItem(row);
                selectedId[index] = selectedItem.id;
            });

            return selectedId;
		},
        /* End Logic */
        /*Post or Get Function*/
        initTreeViewMove: function (e) {
            /* Move Domain Treeview */
            var objMoveSelection = {};
            objMoveSelection.expandAll = true;
            objMoveSelection.declareType = "textbox";
            objMoveSelection.postSelectFn = $.folder.movedFolder;
            treeview.init("moveDomain", "moveDomain-name", "moveDomain-id", objMoveSelection);
        },
        initTreeViewDomain: function (e) {
            $('#domain-ddl').val($('#dashboardText').text());
            $("#domain-id").val($('#dashboardID').val());

            var objDomainSelection = {};
            objDomainSelection.expandAll = true;
            objDomainSelection.declareType = "textbox";
            $treeDomain = treeview.init("domain", "domain-name", "domain-id", objDomainSelection);
        },
		initGrid: function (reloadForm) {
			reloadForm = reloadForm || false;
            var id = $('#grid');

            var dataSource = {
                transport: {
                    read: {
                        url: '/admin/document/read',
                        dataType: "json",
                        type: "GET"
                    },
                    parameterMap: function (options) {

                        var result = {
                            FilterFields: "FolderName,VisibilityLabel",
                            Filter: $('input[data-role="search-all-item"]').val(),
                            Skip: options.skip,
                            Take: options.take,
                            Page: options.page
                        };

                        if (options.sort && options.sort.length > 0) {
                            result.SortBy = options.sort[0].field;
                            result.Direction = options.sort[0].dir;
                        }

                        return result;
                    }
                },
                schema: {
                    data: "Records",
                    total: "Total",
                    model: {
                        id: "FolderID"
                    }
                },
                /* To avoid form data disappeared after saved (If record is selected from page 2 onwards) */
                serverPaging: false,
                serverSorting: false
            };

            var col = [
                {
                    selectable: true, width: "45px",
                    attributes: {
                        "class": "checkboxSelection"
                    }
                },
                { field: 'FolderID', hidden: true },
                { field: 'FolderName', title: $documentResource.field.folderName, width: 350, sortable: true },
                {
                    field: "VisibilityLabel",
                    title: $documentResource.field.visibility,
                    width: 150,
                    template: function (dataRow) {
                        var icon = '<i class="mdi mdi-check"></i>';
                        var statusClass = dataRow.VisibilityID + "";

                        var result = '<div status="kendo-container">' +
                            '<span class="badge kendo-span-status badge-pill badge-visibility' + statusClass.toLowerCase() + '">' + dataRow.VisibilityLabel + '</span> ' +
                            '</div>';
                        return result;
                    }
                },
                { field: 'CrDateString', title: $documentResource.field.createDate, width: 300, sortable: true }
            ];

            var obj = {};
            obj.allowSelectMultipleRow = true;
            obj.customizeCheckbox = true;
            obj.onSelectionFn = $.folder.editButtonClickHandler;
			if (reloadForm)
			{
                obj.dataSourceOnSuccessFn = $.folder.resetEditForm;
			}
			
            kendogridcustomization.init(id, dataSource, col, obj);
        },
        delete: function (ids) {
            fxcRequest.post('/admin/Document/DeleteFolder',
                {
                    Ids: ids
                },
                function (data) {
                    $.folder.initGrid();

                    /*delete option for doc folder select and folder action button*/
                    $.each(ids, function (index, value) {
                        /*form ddl*/
                        var selectOptionId = '#DocFolderID option[value="' + value + '"]';
                        $(selectOptionId).remove();

                        /*grid move ddl*/
                        var selectMoveOptionId = '#moveDropDown div div.menu-scrollbar a#' + value;
                        $(selectMoveOptionId).remove();
                    });

                    swal($globalMessages.swal.success.title, $globalMessages.swal.success.delete, "success");
                });
        },
        movedFolder: function (domainId) {
            setTimeout(function () {

                $("#moveDomain-ddl").val("");
                $('#moveDomain').tree().unselectAll();
            }, 100);

            var ids = $.folder.getGridSelections();
            if (ids.length > 0) {
                fxcRequest.post('/admin/document/MoveFolder',
                    {
                        Ids: ids,
                        DomainId: domainId
                    },
                    function (data) {
                        $.folder.initGrid();

                        swal($globalMessages.swal.success.title, $globalMessages.swal.success.move, "success");
                    }, null, false);
            } else {
                swal("", $documentResource.swal.noFolder);
            }
        },
        save: function (e) {            
            var modelArr = $('#form-domain-documents').MapFormData();

            var saveObj = {};
            $.each(modelArr, function (index, formModel) {
                saveObj[formModel.Id] = formModel.Value;
            });

            saveObj.DomainId = $('#domain-id').val();

            fxcRequest.post('/admin/document/SaveFolder',
                saveObj,
                function (data) {
                    if (saveObj.DomainId == userDomainId) {
                        var savedFolderId = data.FolderID;

                        $('#FolderID').val(savedFolderId);
                        $("#moveDropDown div div.menu-scrollbar").html('');
						$("#moveDropDown div div.menu-scrollbar").html(data.MoveFolderActionHtml);
						$.sectionproperties.selectGenerator('DocFolderID', data.FolderSelectItem, "", 0);
                        $.folder.initGrid(true);

                    }
                    else {
                        $.sectionproperties.FirstLevelView();
                        $.folder.initGrid();
                    }

					swal($globalMessages.swal.success.title, $globalMessages.swal.success.text, "success");

                });
                
		},
		resetEditForm: function () {
			/*reload folder obj*/
			editTempData = {};
			var id = $('#FolderID').val();
			
			editTempData = $("#grid").data("kendoGrid").dataSource.get(id);

			$.folder.editButtonClickHandler(editTempData);
        }
    };

    /*------------------------------------------Document Entry---------------------------------------*/
    var editDocumentTempData;
    var tempEditorContent = "";
    var savedEditorContent;

    var customErrorPlacement = function (error, element) {
        var p = element.parent('div').parent();
        if (p.hasClass('form-group')) {
            error.appendTo(p);
        } else {
            error.insertAfter(element);
        }
    };

    var documententryvalidation = function () {
		$('#form-document-entry').validate({
			ignoreTitle: true,
            rules: {
				"DocumentModel.DocName": { required: true, noSpace: true }
            },
            errorPlacement: function (error, element) {
                var p = element.parent(".dropify-wrapper");
                if (p.length) {
                    error.insertAfter(p);
                }
                else {
                    error.insertAfter(element);
                }
            },
            submitHandler: function (form) {
                $.document.savedocumententry();
            }
        });

        $('#formBarcode').validate({
            rules: {
                BarcodeData: {
                    required: true
                },
                BarcodeSizeOther: {
                    required: true,
                    number: true,
                    min: 2,
                    max: 100
                }
            },
            errorPlacement: customErrorPlacement,
            submitHandler: function (form) {
                $.document.createBarcode();
            }
        });
    };

    var resetdocumententryfields = function (e) {
        $('#form-document-entry').trigger("reset");
        $('#form-document-entry').validate().resetForm();

        $('.dropify-clear').click();
        $.document.setEditorContent("");

        $('#DocTypeID').prop('disabled', false);
        $('.docuploadpanel').show();

        $('#DocumentIDX').val("0");
        $('#DocFolderID').val($('#FolderID').val());

        if (editDocumentTempData !== null) {
            $.document.mapData(editDocumentTempData);
        } else {
            $('#DocTypeID').val('1').change();
            tempEditorContent = null;
            savedEditorContent = null;
        }
    };

    $.document = {
        init: function (e) {

            $.document.createDocumentEntryButtonClickHandler($('.btn-add-gridDocument'));
            $.document.deleteDocumentEntryButtonClickHandler($('.btn-delete-gridDocument'));
            $.document.refreshDocumentEntryButtonClickHandler($('.btn-refresh-gridDocument'));
            $.document.searchDocumentEntryHandler($('input[data-role="search-document-entry"]'));
            $.document.searchDocumentEntryButtonClickHandler($('.View2 .btn-Search'));
            $.document.resetmodalDocumentEntryHandler($('.btn-Reset3'));

            $('#BarcodeSizeOther').mask('999');
            document.getElementById('BarcodeSize').onchange = function () {
                if ($('#BarcodeSize').val() === '0') {
                    $('div#BarcodeSizeOtherPanel').css('display', 'block');
                    $('#BarcodeSizeOther').val('');
                    $('#BarcodeSizeOther').focus();
                } else {
                    $('div#BarcodeSizeOtherPanel').css('display', 'none');
                }
            };

            $.document.initLevelButton();

            /*populate folder html*/
            $("#moveDropDown").html('');
            $("#moveDropDown").html($('#MoveFolderActionHtml').val());

            documententryvalidation();

            $.document.onChangeDocType();
            $.document.onChangeFileInput();
        },
        /*Btn Action*/
        initLevelButton: function (e) {
            /*Level 3*/
            $('.btn-back3').click(function (e) {
                $.sectionproperties.SecondLevel();
            });

            $('.btn-save3').on('click', function () {
                $("#form-document-entry").submit();
            });

            /*Level 4*/
            $('.btn-back4').click(function (e) {
                $.document.setEditorContent(tempEditorContent);
                $.sectionproperties.ThirdLevel();
            });

            $('.btn-save4').on('click', function () {
                savedEditorContent = $.document.getEditorContent();
                if (!savedEditorContent) {
                    $(".linkEditorDiv").addClass("blink_me");
                    var text = $documentResource.swal.coverPageNotEmpty;
                    swal("", text, "warning");
                    return false;
                }
                tempEditorContent = savedEditorContent;
                $.sectionproperties.ThirdLevel();
                $(".linkEditorDiv").removeClass("blink_me");
            });

            $('.btn-Reset4').on('click', function () {
                $.document.setEditorContent(tempEditorContent);
            });

            /*editor button*/
            $('.btn-insert-barcode').click(function (e) {
                $(formBarcode).submit();
            });

            $('.btn-insert-token').click(function (e) {

                var token = "$$" + $("#Token").val() + "$$";

                $.document.pasteEditorContent(token);

                $('#token-modal').modal('hide');
            });

            /*link*/
            $('#Link-CreateEditor').on('click', function (e) {
                $.sectionproperties.FourthLevel();
            });
        },
        createDocumentEntryButtonClickHandler: function (e) {
            $(e).on('click', function () {
				$(".breadcrumb .add-edit-breadcrumb-item-document").text($documentResource.createNewEntry);
                var allowValue = $('#AllowUpload').val();
                if (allowValue == "0") {
                    swal($globalMessages.swal.error.errorCap, $documentResource.swal.noPermission, "error");
                } else {
					var btn3text = " (" + $('#FolderName').val() + ')';
					$('.add-edit-breadcrumb-item-folder-id').text(btn3text);
                    $.sectionproperties.ThirdLevel();

                    editDocumentTempData = null;
                    resetdocumententryfields();
                }

            });
        },
		editdocumententryButtonClickHandler: function (dataItem) {
			$(".breadcrumb .add-edit-breadcrumb-item-document").text($documentResource.editEntry);
            var btn3text = "  (" + $('#FolderName').val() + ')';
			$('.add-edit-breadcrumb-item-folder-id').text(btn3text);

            $.sectionproperties.ThirdLevel();

            editDocumentTempData = dataItem;
            resetdocumententryfields();

        },
        deleteDocumentEntryButtonClickHandler: function (e) {
			$(e).on('click', function () {
				$(this).blur();
                var ids = $.document.getGridSelections();
                if (ids.length > 0) {
                    swal({
                        title: "",
                        text: $documentResource.swal.delDomainDoc,
                        type: "info",
                        showCancelButton: true,
                        closeOnConfirm: false,
                        reverseButtons: true,
                        showLoaderOnConfirm: true
                    }, function () {
                        $.document.delete(ids);
                    });
                } else {
                    swal("", $documentResource.swal.noDomainDoc);
                }
            });
        },
        refreshDocumentEntryButtonClickHandler: function (e) {
            $(e).on('click', function () {
                $('input[data-role="search-document-entry"]').val("");
                $.document.initGrid();
                $(this).blur();
            });
        },
        searchDocumentEntryButtonClickHandler: function (e) {
            $(e).on('click', function () {
                $.document.initGrid();
                $(this).blur();
            });
        },
        searchDocumentEntryHandler: function (e) {
            $(e).keypress(function (event) {
                if (event.which === 13) {
                    $.document.initGrid();
                }
            });
        },
        resetmodalDocumentEntryHandler: function (e) {
            $(e).on('click', function () {
                resetdocumententryfields();
            });
        },
        barcodeButtonClickHandler: function (e) {
            $('#formBarcode').trigger("reset");
            $('#barcode-modal').modal('show');
            $('div#BarcodeSizeOtherPanel').css('display', 'none');
        },
        /*End Btn Action*/
        /* Logic */
        onChangeTokenGroups: function (e) {
            fxcRequest.post('/User/DocIndex/GetTokenByTokenGroup',
                {
                    "SelectedTokenGroupId": e
                },
                function (data) {
                    $("#Token").html('');
                    $("#Token").append(data.DdlToken);
                },
                function (error) {
                    /*console.log(error);*/
                }, false);
        },
        onChangeDocType: function (e) {
            $("#DocTypeID").on('change', function () {
                if ($(this).val() == '2') {
                    $('div#docUploadpanel .text-danger').hide();
                    $('#DocumentUpload').prop('required', false);
                } else {
                    $('div#docUploadpanel .text-danger').show();
                    $('#DocumentUpload').prop('required', true);
                }

                $('#textBeforeLink').show();
                $('#Link-CreateEditor').text("Create Cover Page");

                /* editDoc */
                if ($('#DocumentIDX').val() != "0") {
                    $('#textBeforeLink').hide();
                    $('#Link-CreateEditor').text("Edit Cover Page");
                    }
            });
        },
        onChangeFileInput: function () {
            $("#DocumentUpload").on('change', function () {
                if (this.files.length > 0) {
                    $.document.setEditorContent("");
                    $('div.linkEditorDiv').addClass("disabled");
                }
            });

            /* Enable Editor if there's no documents 
             * Onchange event won't work in this so use dropify events
             */
            var drEvent = $('#DocumentUpload').dropify();

            drEvent.on('dropify.afterClear', function (event, element) {
                $('div.linkEditorDiv').removeClass("disabled");
            });
        },
        getGridSelections: function (e) {
            var selectedId = [];
            var entityGrid = $('#gridDocument').data("kendoGrid");
            var rows = entityGrid.select();

            rows.each(function (index, row) {
                var selectedItem = entityGrid.dataItem(row);
                selectedId[index] = selectedItem.id;
            });

            return selectedId;
        },
        getEditorContent: function (e) {
            var editor = $("#Content").data("kendoEditor");
            return editor.value();
        },
        setEditorContent: function (e) {
            var editor = $("#Content").data("kendoEditor");
            return editor.value(e);
        },
        pasteEditorContent: function (e) {
            var editor = $("#Content").data("kendoEditor");
            editor.exec("inserthtml", { value: e });
        },
        /* End Logic */
        /*Post or Get Function*/
        mapData: function (dataItem) {
            $('div.linkEditorDiv').addClass("disabled");

            fxcRequest.get('/Admin/Document/GetDocument',
                { "DocumentID": dataItem.id },
                function (data) {
                    swal.close();
                    $('#form-document-entry').BindToForm(data, '#', '');
                    $('#DocTypeID').val(data.DocTypeID).change();
                    tempEditorContent = data.Content;
                    savedEditorContent = data.Content;
                    $.document.setEditorContent(savedEditorContent);

                    if (data.Content) {
                        $('div.linkEditorDiv').removeClass("disabled");
                    }
                }, null, false);

            $('#DocTypeID').prop('disabled', true);
            $('.docuploadpanel').hide();
        },
        createBarcode: function (e) {
            var bd = $('#BarcodeData').val();
            var bs = $('#BarcodeSize').val();
            if ($('#BarcodeSize').val() === '0') {
                bs = $('#BarcodeSizeOther').val();
            }

            fxcRequest.get('/User/UserCommon/GenerateBarcodeBase64',
                {
                    "bd": bd,
                    "bs": bs
                },
                function (data) {
                    var img = '<img alt="bootstraps.png"  src="data:image/png;base64, ' + data.Base64String + '" />';
                    $.document.pasteEditorContent(img);
                });

            $('#barcode-modal').modal('hide');
        },
        savedocumententry: function () {
            var docTypeId = $('#DocTypeID').val();
            var attachDoc = $("#DocumentUpload").get(0).files.length;

            /* Edit Doc only */
            if ($('#DocumentIDX').val() == "0" && !savedEditorContent && docTypeId === "2" && attachDoc == 0) {
                $(".linkEditorDiv").addClass("blink_me");
                var text = $documentResource.coverPageEmptyWarning;
                swal("", text, "warning");
                return false;
            }

            var modelArr = $('#form-document-entry').MapFormData();
            var saveObj = {};
            var docModel = {};
            $.each(modelArr, function (index, formModel) {
                docModel[formModel.Id] = formModel.Value;
            });

            docModel.DomainIDX = $('#domain-id').val();
            if ($('#DocumentIDX').val() === "0") {
                docModel.DocumentIDX = "";
            }
            docModel.FolderID = $('#DocFolderID').val();
            docModel.DocTypeID = docTypeId;

            if (docModel.DocTypeID === "2" && attachDoc == 0) {
                $('.dropify-clear').click();
                docModel.Content = savedEditorContent;
            } else {
                docModel.Content = "";
            }

            saveObj.DocumentModel = docModel;

            /*console.log(saveObj);*/
            fxcRequest.upload('/Admin/Document/SaveDoc', $('#DocumentUpload'),
                saveObj,
				function (data) {
                    $.sectionproperties.SecondLevel();
                    $.document.initGrid();
                    editDocumentTempData = null;
                    resetdocumententryfields();
                    swal($globalMessages.swal.success.title, $globalMessages.swal.success.text, "success");
                });
        },
        delete: function (ids) {
            fxcRequest.post('/admin/Document/DeleteDocument',
                {
                    Ids: ids
                },
                function (data) {
                    $.document.initGrid();
                    swal($globalMessages.swal.success.title, $globalMessages.swal.success.text, "success");
                }, null, false);
        },
        initGrid: function (e) {
            var id = $('#gridDocument');

            var dataSource = {
                transport: {
                    read: {
                        url: '/Admin/Document/ReadDoc',
                        dataType: "json",
                        type: "GET"
                    },
                    parameterMap: function (options) {

                        var result = {
                            FolderID: $('#FolderID').val(),
                            Filter: $('input[data-role="search-document-entry"]').val(),
                            Skip: options.skip,
                            Take: options.take,
                            Page: options.page
                        };

                        if (options.sort && options.sort.length > 0) {
                            result.SortBy = options.sort[0].field;
                            result.Direction = options.sort[0].dir;
                        }

                        return result;
                    }
                },
                schema: {
                    data: "Records",
                    total: "Total",
                    model: {
                        id: "DocumentIDX"
                    }
                },
                serverPaging: true,
                serverSorting: true
            };

            var col = [
                {
                    selectable: true, width: "45px",
                    attributes: {
                        "class": "checkboxSelection"
                    }
                },
                { field: 'DocumentIDX', hidden: true },
                { field: 'DocName', title: $documentResource.field.documentName, width: 300, sortable: true },
                { field: 'DocTypeName', title: $documentResource.field.type, width: 250, sortable: true },
                {
                    field: "IsMerge",
					title: $documentResource.field.merged,
					hidden: true,
                    width: 120,
                    filterable: {
                        cell: {
                            enabled: false
                        }
                    },
                    template: '<div class="kendo-container"> <i #= IsMerge == true ? \'class="mdi fxc-checkbox-true"\' : "" #></i> </div>'
                },
                { field: 'Desc', title: $documentResource.field.description, width: 350 , sortable: true }
            ];

            var obj = {};
            obj.allowSelectMultipleRow = true;
            obj.customizeCheckbox = true;
            obj.onSelectionFn = $.document.editdocumententryButtonClickHandler;

            kendogridcustomization.init(id, dataSource, col, obj);
        },
        moveDoc: function (folderId) {
            var ids = $.document.getGridSelections();
            if (ids.length > 0) {
                swal({
                    title: "",
                    text: $documentResource.swal.moveDomainDoc,
                    type: "info",
                    showCancelButton: true,
                    closeOnConfirm: false,
                    reverseButtons: true,
                    showLoaderOnConfirm: true
                }, function () {
                    fxcRequest.post('/admin/document/MoveDocument',
                        {
                            Ids: ids,
                            FolderID: folderId
                        },
                        function (data) {
                            $.document.initGrid();
                            swal($globalMessages.swal.success.title, $globalMessages.swal.success.move, "success");
                        }, null, false);
                });
            } else {
                swal("", $documentResource.swal.noDomainDoc);
            }
        }
    };
})(window.jQuery);
