﻿(function ($) {
    var validation = function () {
        $('#formSubmit').validate({
			ignore: [],
			ignoreTitle: true,
            rules: {
                UserName: { required: true, noSpace: true },
                listUserSelected: { multiselectrequired: true }
            },
            messages: {
                listUserSelected: { multiselectrequired: $groupResource.validation.users }
            },
            submitHandler: function (form) {
                $.group.save();
            }
        });
    };

    var $grid, bind = false;
    var $data;
    var reset = true;

    $.group = {
        init: function (e) {
            validation();
            $.group.initTreeViewListBox();
            /*Btn Action*/
            $.group.createButtonClickHandler($(".btn-new-grid"));
            $.group.deleteButtonClickHandler($(".btn-delete-grid"));
            $.group.refreshButtonClickHandler($(".btn-refresh-grid"));
            $.group.searchPressEnter($('input[data-role="search-all-item"]'));
            $.group.searchButtonClickHandler($('.btn-search-grid'));

            /*Form*/
            $.group.resetButtonClickHandler($('#reset-group'));
            $.group.saveclosemodalHandler($('#saveClose-group'));
            $.group.initGrid();

            $.group.initTreeViewMove();
            $.group.initTreeViewDomain();
            
        },
        initGrid: function (e) {
            var id = $('#grid');

            var dataSource = {
                transport: {
                    read: {
                        url: '/Admin/Group/Read',
                        dataType: "json",
                        type: "GET"
                    },
                    parameterMap: function (options) {
                        /* Fix url param for sort values */
                        var result = {
                            Skip: options.skip,
                            Take: options.take,
                            Sort: options.sort,
                            SearchText: $('input[data-role="search-all-item"]').val()
                        };
                        if (options.sort && options.sort.length > 0) {
                            result.SortBy = options.sort[0].field;
                            result.Direction = options.sort[0].dir;
                        }
                        return result;
                    }
                },
                schema: {
                    data: "Records",
                    total: "Total",
                    model: {
                        id: "UserID"
                    }
                },
                serverPaging: false, /*Unable to retrieve data on edit 2nd page*/
                serverSorting: false  /*Unable to retrieve data on edit 2nd page*/
            };

            var col = [
                {
                    selectable: true, width: 45,
                    attributes: {
                        "class": "checkboxSelection"
                    }
                },
                { field: 'UserID', hidden: true },
                { field: 'UserName', title: $groupResource.field.name, sortable: true, minWidth: 200, width: 300 },
                { field: 'Desc', title: $groupResource.field.description, sortable: true, minWidth: 200, width: 400 },
                { field: 'IsUserActive', hidden: true },
                { field: 'InboundRoute', title: $groupResource.field.inboundRoute, sortable: true, minWidth: 200, width: 500 },
            ];

            var obj = {};
            obj.allowSelectMultipleRow = true;
            obj.onSelectionFn = $.group.editHandler;
            obj.dataSourceOnSuccessFn = $.group.resetFieldsHandler;
            var $grid = kendogridcustomization.init(id, dataSource, col, obj);
        },
        initTreeViewMove: function (e) {
            /* Move Domain Treeview */
            var objMoveSelection = {};
            objMoveSelection.expandAll = true;
            objMoveSelection.declareType = "textbox";
            objMoveSelection.postSelectFn = $.group.move;
            treeview.init("moveDomain", "moveDomain-name", "moveDomain-id", objMoveSelection);
        },
        /*Form*/
        initTreeViewDomain: function (e) {
            /* Text box: Domain Treeview */
            $("#Domain-id").val($('#dashboardID').val());
            var objDomainSelection = {};
            objDomainSelection.expandAll = true;
            objDomainSelection.declareType = "textbox";
            treeview.init("Domain", "Domain-name", "Domain-id", objDomainSelection);
        },
        initListView: function (e) {
            var listBoxID = "listUserSelection";
            var listBoxIDConnectWith = "listUserSelected";
            var obj = {
                blurForm: true,
                targetDiv: $("#formSubmit")
            };
            fxcRequest2.post('/Admin/Group/GetGroupMember',
                {
                    DomainId: e,
                    UserID: $('input[name="RecordId"]').val(),
                    GroupMember: $.group.getListDataSource($("#" + listBoxIDConnectWith)),
                    ResetField: reset
                },
                function (data) {
                    var returnObject = [];

                    var dataSourceSelection = {
                        data: data.UnassignedUser.Source
                    };

                    var objUserSelection = {};
                    objUserSelection.dataTextField = "Text";
                    objUserSelection.dataValueField = "Value";
                    objUserSelection.connectWith = listBoxIDConnectWith;
                    /*console.log("Reset Selection: " + reset);
                    console.log("static: " + !reset);*/
                    objUserSelection.staticSelectedListBox = !reset;

                    var dataSourceSelected = {
                        data: data.GroupUser.Source
                    };

                    returnObject = listbox.mutual(listBoxID, dataSourceSelection, objUserSelection, dataSourceSelected);

                    if (returnObject != null) {
                        $listBoxSelection = returnObject.listBoxSelection;
                        $listBoxSelected = returnObject.listBoxSelected;
                    }

                    reset = false;
                },
                obj);
        },
        initTreeViewListBox: function (e) {
            /* Action Forward to user Assign Pop Up*/
          $("#userDomain-id").val($('#dashboardID').val());
            var objUserSelection = {};
            objUserSelection.expandAll = true;
            objUserSelection.declareType = "textbox";
            objUserSelection.postSelectFn = $.group.initListView;
            treeview.init("userDomain", "userDomain-name", "userDomain-id", objUserSelection);
        },

        /*Btn Action*/
        createButtonClickHandler: function (e) {
            $(e).on('click', function () {
                $data = null;
                $('#modalGroup').modal('show');
                $.group.resetFields();
            });
        },
        editHandler: function (dataItem) {
            $('#modalGroup').modal('show');

            $data = dataItem;
            $.group.resetFields();
        },
        deleteButtonClickHandler: function (e) {
			$(e).on('click', function (x) {
				$(this).blur();
                $.group.delete();
            });
        },
        refreshButtonClickHandler: function (e) {
			$(e).on('click', function (x) {
				$(this).blur();
                $.group.refresh();
            });
        },
        searchButtonClickHandler: function (e) {
            $(e).on('click', function () {
                $.group.search(e);
            });
        },
        searchPressEnter: function (e) {
            $(e).on('keypress', function (enter) {
                if (enter.which === 13) {
                    $.group.search(e);
                }
            });
        },

        resetButtonClickHandler: function (e) {
            $(e).on('click', function () {
                $.group.resetFields();
            });
        },
        resetFieldsHandler: function (e) {
            
            $data = null;
            var getData = $("#grid").data("kendoGrid").dataSource.get($('input[name="RecordId"]').val());

            if (getData != undefined)
            {
                $data = getData;
                $.group.resetFields();
            }
        },
        saveclosemodalHandler: function (e) {
            $(e).on('click', function () {
                $('input[name="modal-action"]').val('save & close');
            });
        },

        /* Logic */

        getGridSelections: function (event) {
            var entityGrid = event.data("kendoGrid");
            var rows = entityGrid.select();
            var $selectedUser = [];
            rows.each(function (index, row) {
                var selectedItem = entityGrid.dataItem(row);
                $selectedUser[index] = selectedItem.UserID;
            });

            return $selectedUser;
        },
        getListDataSource: function (event) {
            var entityList = event.data("kendoListBox");
            var $selectedList = [];
            if (entityList != undefined)
            {            
                var rows = entityList.dataItems();

                $(rows).each(function (index, row) {
                    $selectedList[index] = row.Value;
                });
            }

            return $selectedList;
        },
        refresh: function (e) {
            $('input[data-role="search-all-item"]').val("");
            $.group.initGrid();
        },
        resetFields: function () {
            reset = true;
            $("#formSubmit").trigger("reset");
            $("#formSubmit").validate().resetForm();
            $(".modal-header h4#group").text($groupResource.createNewEntry);
            $('input[name="RecordId"]').val(0);
            $("#Label").attr("disabled", false);
            if ($data !== null) {
                /*console.log($data);*/
                $(".modal-header h4#group").text($groupResource.editEntry);
                $("#UserName").val($data.UserName);
                $("#Desc").val($data.Desc);
                $('input[name="RecordId"]').val($data.UserID);
            }
           
            /*Reselect Domain ID*/
            $("#Domain").tree().unselectAll();
            $("#Domain-id").val($('#dashboardID').val());
            var getData = $("#Domain").tree().getNodeById($("#Domain-id").val());

            if (getData != undefined) {
                $("#Domain").tree().select(getData);
            }

            /*Reselect User From ID*/
            $("#userDomain").tree().unselectAll();
            $("#userDomain-id").val($('#dashboardID').val());
            var getUserData = $("#userDomain").tree().getNodeById($("#userDomain-id").val());

            if (getUserData != undefined)
            {
                $("#userDomain").tree().select(getUserData);
            }
            
        },
        search: function (e) {
            $.group.initGrid();
        },
        /* End Logic */

        /*Post or Get Function*/
        delete: function (e) {

            var selectedItem = $.group.getGridSelections($("#grid"));

            if (selectedItem.length === 0) {
                swal("", $groupResource.swal.noUserGroup);
                return false;
            }

            swal({
                title: "",
                text: $groupResource.swal.delUserGroup,
                type: "info",
                showCancelButton: true,
                closeOnConfirm: false,
                reverseButtons: true,
                showLoaderOnConfirm: true
            }, function () {
                fxcRequest.post('/Admin/Group/Delete',
                    { Ids: selectedItem.join().split(',') },
                    function (data) {
                        $('#delete-modal').modal('hide');
                        swal($globalMessages.swal.done, $groupResource.swal.successDel, "success");
                        /* Refresh grid everytime after save*/
                        $.group.refresh();
                        $('#delete-modal').modal('hide');
                    }, function () {
                        swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnDelete, "error");
                    }, true);
            });
        },
        move: function (e) {

            var selectedItem = $.group.getGridSelections($("#grid"));

            setTimeout(function () {
                $("#moveDomain-ddl").val("");
                $('#moveDomain').tree().unselectAll();
            }, 100);

            if (selectedItem.length === 0) {
                swal("", $groupResource.swal.noUserGroup);
                return false;
            }

            fxcRequest.post('/Admin/Group/Move',
                {
                    Ids: selectedItem.join().split(','),
                    DomainId: e
                },
                function (data) {
                    $.toast({
                        heading: $globalMessages.toast.success,
                        text: $groupResource.swal.successMove,
                        position: 'top-right',
                        loaderBg: '#ff6849',
                        icon: 'success',
                        hideAfter: 3500,
                        stack: 6
                    });
                    /* Refresh grid everytime after save*/

                    $.group.refresh();

                },
                function (error) {
                    swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnMove, "error");
                },
                false);

        },
        save: function () {
            var idval = $('input[name="RecordId"]').val();
            fxcRequest.post('/admin/group/save',
                {
                    DomainId: $("#Domain-id").val(),
                    UserID: $('input[name="RecordId"]').val(),
                    UserName: $('#UserName').val(),
                    Desc: $('#Desc').val(),
                    GroupMember: $.group.getListDataSource($("#listUserSelected"))
                },
                function (data) {
                    $.group.initGrid();
					swal($globalMessages.swal.success.title, $globalMessages.swal.success.text, "success");

                    if ($('input[name="modal-action"]').val() === 'save & close') {
                        $('#modalGroup').modal('hide');
                        $('input[name="modal-action"]').val('');
                    }
                    
                },
                function (error) {
                    swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnSubmit, "error");
                });
        }
    };
})(window.jQuery);
