﻿(function ($) {
    var validation = function () {
        $('#formSubmit').validate({
            ignoreTitle: true,
            rules: {
                TemplateName: { required: true, noSpace: true },
                "Domain-ddl": { required: true, noSpace: true },
            },
            submitHandler: function (form) {
                $.template.save();
            }
        });
    };

    var $grid, bind = false;
    var $data;
    var saveAsNew = false;

    var faxTab = false;
    var emailTab = false;
    var httpTab = false;
    var ftpTab = false;
    var fileTab = false;
    var printTab = false;

    $.template = {
        init: function (e) {
            validation();

            /*Btn Action*/
            $.template.backButtonClickHandler($(".btn-back2"));
            $.template.createButtonClickHandler($(".btn-new-grid"));
            $.template.deleteButtonClickHandler($(".btn-delete-grid"));
            $.template.refreshButtonClickHandler($(".btn-refresh-grid"));
            $.template.searchPressEnter($('input[data-role="search-all-item"]'));
            $.template.searchButtonClickHandler($('.btn-search-grid'));
            /*$.template.tabButtonClickHandler($('a[data-bs-toggle="tab"]'));*/

            /*Form*/
            $.template.resetButtonClickHandler($('.btn-Reset2'));
            $.template.saveButtonClickHandler($('.btn-save2'));
            $.template.saveAsNewButtonClickHandler($('.btn-save-new'));
            $.template.initGrid();

            $.template.initTreeViewMove();
        },
        initGrid: function (e) {
            var id = $('#grid');

            var dataSource = {
                transport: {
                    read: {
                        url: '/Admin/Template/Read',
                        dataType: "json",
                        type: "GET"
                    },
                    parameterMap: function (options) {
                        /* Fix url param for sort values */
                        var result = {
                            Skip: options.skip,
                            Take: options.take,
                            Sort: options.sort,
                            SearchText: $('input[data-role="search-all-item"]').val()
                        };
                        if (options.sort && options.sort.length > 0) {
                            result.SortBy = options.sort[0].field;
                            result.Direction = options.sort[0].dir;
                        }
                        return result;
                    }
                },
                schema: {
                    data: "Records",
                    total: "Total",
                    model: {
                        id: "Id"
                    }
                },
                serverPaging: false,
                serverSorting: false
            };

            var col = [
                {
                    selectable: true, width: 45,
                    attributes: {
                        "class": "checkboxSelection"
                    }
                },
                { field: 'TemplateID', hidden: true },
                { field: 'TemplateName', title: $templateResource.text.name, minWidth: 300, width: 500 },
                { field: 'CrDate', title: $templateResource.text.dateCreated, minWidth: 300, width: 250 },
                {
                    field: "VisibilityLabel",
                    title: $templateResource.text.visibility,
                    width: 200,
                    template: function (dataRow) {
                        var icon = '<i class="mdi mdi-check"></i>';
                        var statusClass = dataRow.VisibilityID + "";

                        var result = '<div status="kendo-container">' +
                            '<span class="badge kendo-span-status badge-pill badge-visibility' + statusClass.toLowerCase() + '">' + dataRow.VisibilityLabel + '</span> ' +
                            '</div>';
                        return result;
                    }
                },
                { field: 'VisibilityID', hidden: true },
                { field: 'IsEditable', hidden: true },
                { field: 'DomainName', hidden: true }
            ];

            var obj = {};
            obj.allowSelectMultipleRow = true;
            obj.onSelectionFn = $.template.editHandler;
            var $grid = kendogridcustomization.init(id, dataSource, col, obj);
        },
        initTreeViewMove: function (e) {
            /* Move Domain Treeview */
            var objMoveSelection = {};
            objMoveSelection.expandAll = true;
            objMoveSelection.declareType = "textbox";
            objMoveSelection.postSelectFn = $.template.move;
            treeview.init("moveDomain", "moveDomain-name", "moveDomain-id", objMoveSelection);
        },

        /*Form*/
        initForm: function (e) {
            fxcRequest.get('/Admin/Template/GetData',
                {
                    TemplateID: e
                },
                function (data) {
                    /* map data to inputs*/
                    $data = data;
                    $.template.resetFields();
                },
                function (error) {
                    swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnSubmit, "error");
                });
        },
        initTreeViewDomain: function (e) {
            /* Text box: Domain Treeview */
            $("#Domain-id").val($('#dashboardID').val());
            var objDomainSelection = {};
            objDomainSelection.expandAll = true;
            objDomainSelection.declareType = "textbox";
            treeview.init("Domain", "Domain-name", "Domain-id", objDomainSelection);
        },

        /*Btn Action*/
        backButtonClickHandler: function (e) {
            $(e).on('click', function () {
                $.sectionproperties.FirstLevelView();
            });
        },
        createButtonClickHandler: function (e) {
            $(e).on('click', function () {
                $data = null;
                $.template.resetFields();
                $.sectionproperties.SecondLevel();
            });
        },
        editHandler: function (e) {
            $.template.initForm(e.TemplateID);
            $.sectionproperties.SecondLevel();
        },
        deleteButtonClickHandler: function (e) {
            $(e).on('click', function (x) {
                $(this).blur();
                $.template.delete();
            });
        },
        refreshButtonClickHandler: function (e) {
            $(e).on('click', function (x) {
                $.template.refresh();
                $(this).blur();
            });
        },
        searchButtonClickHandler: function (e) {
            $(e).on('click', function () {
                $.template.search(e);
            });
        },
        searchPressEnter: function (e) {
            $(e).on('keypress', function (enter) {
                if (enter.which === 13) {
                    $.template.search(e);
                }
            });
        },
        tabButtonClickHandler: function (e) {
            $(e).on('shown.bs.tab', function (h) {
                var target = $(h.target).attr("href");
                $.template.resetTab(target);
            });
        },

        resetButtonClickHandler: function (e) {
            $(e).on('click', function () {
                $.template.resetFields();
            });
        },
        saveButtonClickHandler: function (e) {
            $(e).on('click', function () {
                saveAsNew = false;
                $('#formSubmit').submit();
            });
        },
        saveAsNewButtonClickHandler: function (e) {
            $(e).on('click', function () {
                saveAsNew = true;
                $('#formSubmit').submit();
            });
        },

        /* Logic */
        refresh: function (e) {
            $('input[data-role="search-all-item"]').val("");
            $.template.initGrid();
        },
        resetFields: function () {
            $("#formSubmit").trigger("reset");
            $("#formSubmit").validate().resetForm();
            $("#Domain-id").val($('#dashboardID').val());
            $(".Add-Edit-header h4").text($areaResources.actionTitle.createNewEntry);
            $(".breadcrumb .add-edit-breadcrumb-item").text($areaResources.actionTitle.createNewEntry);
            $(".btn-save-new").hide();
            $('input[name="RecordId"]').val(0);
            if ($data !== null) {
                /*console.log($data);*/
                $('input[name="RecordId"]').val($data.TemplateID);
                $(".Add-Edit-header h4").text($areaResources.actionTitle.editEntry);
                $(".breadcrumb .add-edit-breadcrumb-item").text($areaResources.actionTitle.editEntry);
                $(".btn-save-new").show();

                $("#Desc").val($data.Desc);
                $("#TemplateName").val($data.TemplateName);
                $("#Domain-id").val($data.DomainID);
                $("#VisibilityID").val($data.VisibilityID);
            }

            if (!bind) {
                $.template.initTreeViewDomain();
                bind = true;
            }
            else {
                /*Reselect Domain ID*/
                $("#Domain").tree().unselectAll();
                var getData = $("#Domain").tree().getNodeById($("#Domain-id").val());

                if (getData != undefined) {
                    $("#Domain").tree().select(getData);
                }
            }

            faxTab = false;
            emailTab = false;
            httpTab = false;
            ftpTab = false;
            fileTab = false;
            printTab = false;

            var linkFaxTab = document.getElementById('faxLink');
            linkFaxTab.click();

            $.fax.initForm();
            $.email.initForm();
            $.http.initForm();
            $.ftp.initForm();
            $.file.initForm();
            $.print.initForm();

        },
        resetTab: function (target) {
            switch (target) {
                case "#FaxTab":
                    if (!faxTab) {
                        $.fax.initForm();
                        faxTab = true;
                    }
                    break;
                case "#EmailTab":
                    if (!emailTab) {
                        $.email.initForm();
                        emailTab = true;
                    }
                    break;
                case "#HttpTab":
                    if (!httpTab) {
                        $.http.initForm();
                        httpTab = true;
                    }
                    break;
                case "#FtpTab":
                    if (!ftpTab) {
                        $.ftp.initForm();
                        ftpTab = true;
                    }
                    break;
                case "#FileTab":
                    if (!fileTab) {
                        $.file.initForm();
                        fileTab = true;
                    }
                    break;
                case "#PrintTab":
                    if (!printTab) {
                        $.print.initForm();
                        PrintTab = true;
                    }
                    break;
                default:
                    break;
            }
        },
        search: function (e) {
            $.template.initGrid();
        },
        /* End Logic */

        /*Post or Get Function*/
        delete: function (e) {

            var selectedItem = $.template.getGridSelections($("#grid"));

            if (selectedItem.length === 0) {
                swal("", $templateResource.swal.notSelected);
                return false;
            }

            swal({
                title: "",
                text: $templateResource.swal.delete,
                type: "info",
                showCancelButton: true,
                closeOnConfirm: false,
                reverseButtons: true,
                showLoaderOnConfirm: true
            }, function () {
                fxcRequest.post('/Admin/Template/Delete',
                    { Ids: selectedItem.join().split(',') },
                    function (data) {
                        $('#delete-modal').modal('hide');
                        swal($globalMessages.swal.done, $templateResource.swal.deleteSuccess, "success");
                        /* Refresh grid everytime after save*/
                        $.template.refresh();
                        $('#delete-modal').modal('hide');
                    }, function () {
                        swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnDelete, "error");
                    }, true);
            });
        },
        getGridSelections: function (event) {
            var entityGrid = event.data("kendoGrid");
            var rows = entityGrid.select();
            var $selectedUser = [];
            rows.each(function (index, row) {
                var selectedItem = entityGrid.dataItem(row);
                $selectedUser[index] = selectedItem.TemplateID;
            });

            return $selectedUser;
        },
        move: function (e) {

            var selectedItem = $.template.getGridSelections($("#grid"));

            setTimeout(function () {
                $("#moveDomain-ddl").val("");
                $('#moveDomain').tree().unselectAll();
            }, 100);

            if (selectedItem.length === 0) {
                swal("", $templateResource.swal.notSelected);
                return false;
            }

            fxcRequest.post('/Admin/Template/Move',
                {
                    Ids: selectedItem.join().split(','),
                    DomainId: e
                },
                function (data) {
                    $.toast({
                        heading: 'Success',
                        text: $templateResource.swal.moveSuccess,
                        position: 'top-right',
                        loaderBg: '#ff6849',
                        icon: 'success',
                        hideAfter: 3500,
                        stack: 6
                    });
                    /* Refresh grid everytime after save*/
                    $.template.refresh();
                },
                function (error) {
                    swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnMove, "error");
                },
                false);
        },
        save: function () {
            fxcRequest.post('/Admin/Template/Save',
                {
                    TemplateID: saveAsNew ? '0' : $('input[name="RecordId"]').val(),
                    TemplateName: $('#TemplateName').val(),
                    VisibilityID: $("#VisibilityID").val(),
                    DomainID: $("#Domain-id").val(),
                    Desc: $("#Desc").val(),
                    FaxTab: $.fax.mapData(),
                    EmailTab: $.email.mapData(),
                    HttpTab: $.http.mapData(),
                    FtpTab: $.ftp.mapData(),
                    FileTab: $.file.mapData(),
                    PrintTab: $.print.mapData()
                },
                function (data) {
                    $.template.initForm(data.TemplateID);

                    $.template.refresh();

                    swal($globalMessages.swal.success.title, $globalMessages.swal.success.text, "success");
                },
                function (error) {
                    swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnSubmit, "error");
                });
        }
    };

    /*Fax Tab*/
    $.fax = {
        /*Post or Get Function*/
        initForm: function (e) {
            $("#FaxTab .div-template-fax").html("");
            $("#FaxTab .div-template-fax").addClass("divLoading");
            fxcRequest.post('/Admin/Template/GetFaxView',
                {
                    "TemplateID": $('input[name="RecordId"]').val()
                },
                function (data, textStatus, jqXHR) {
                    $("#FaxTab .div-template-fax").html(data);
                    $("#FaxTab .div-template-fax").removeClass("divLoading");
                    $.sectionproperties.initDisabledProperties();
                    $.fax.onChangeTextHandler($("#TxtFaxAddr"));
                    $("#TxtFaxAddr").change();

                }, function (error) {
                    swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnSubmit, "error");
                }, false);
        },

        /*Logic*/
        mapData: function (e) {
            var temp = {
                "TxtFaxBorderTxt": $('#TxtFaxBorderTxt').val(),
                "TxtFaxBorderTxt2": $('#TxtFaxBorderTxt2').val(),
                "TxtFaxBorderTxt3": $('#TxtFaxBorderTxt3').val(),
                "TxtFaxBorderTxt4": $('#TxtFaxBorderTxt4').val(),

                "DdlFaxLocation": $('#DdlFaxLocation').val(),
                "DdlFaxLocation2": $('#DdlFaxLocation2').val(),
                "DdlFaxLocation3": $('#DdlFaxLocation3').val(),
                "DdlFaxLocation4": $('#DdlFaxLocation4').val(),

                "TxtFaxSubject": $('#TxtFaxSubject').val(),
                "TxtFaxNotes": $('#TxtFaxNotes').val(),

                "DdlFaxCP": $('#DdlFaxCP').val(),
                "DdlFaxInclAtt": $('#DdlFaxInclAtt').prop("checked"),

                "DdlFaxPriority": $('#DdlFaxPriority').val(),
                "DdlFaxSendUsrPro": $('#DdlFaxSendUsrPro').prop("checked"),
                "TxtFaxAddr": $('#TxtFaxAddr').val(),
                "DdlFaxSendRaw": $('#DdlFaxSendRaw').val()
            };

            return temp;
        },

        onChangeTextHandler: function (e) {
            $(e).on('change', function () {
                var x = this;
                if (x.value.length) {
                    $("#DdlFaxSendRaw").attr("disabled", false);
                }
                else {
                    $("#DdlFaxSendRaw").attr("disabled", true);
                }
            });
        }
    };

    /*Email Tab*/
    $.email = {
        /*Post or Get Function*/
        initForm: function (e) {
            $("#EmailTab .div-template-email").html("");
            $("#EmailTab .div-template-email").addClass("divLoading");
            fxcRequest.post('/Admin/Template/GetEmailView',
                {
                    "TemplateID": $('input[name="RecordId"]').val()
                },
                function (data, textStatus, jqXHR) {
                    $("#EmailTab .div-template-email").html(data);
                    $("#EmailTab .div-template-email").removeClass("divLoading");

                    $.editor.initKendoEditor("#EdEmlBody");

                }, function (error) {
                    swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnSubmit, "error");
                }, false);
        },
        mapData: function (e) {
            var editor = $("#EdEmlBody").data("kendoEditor");

            var temp = {
                "TxtEmlBorderTxt": $('#TxtEmlBorderTxt').val(),
                "TxtEmlBorderTxt2": $('#TxtEmlBorderTxt2').val(),
                "TxtEmlBorderTxt3": $('#TxtEmlBorderTxt3').val(),
                "TxtEmlBorderTxt4": $('#TxtEmlBorderTxt4').val(),

                "DdlEmlLocation": $('#DdlEmlLocation').val(),
                "DdlEmlLocation2": $('#DdlEmlLocation2').val(),
                "DdlEmlLocation3": $('#DdlEmlLocation3').val(),
                "DdlEmlLocation4": $('#DdlEmlLocation4').val(),

                "TxtEmlFrom": $('#TxtEmlFrom').val(),
                "TxtEmlSubject": $('#TxtEmlSubject').val(),
                "TxtEmlImgFN": $('#TxtEmlImgFN').val(),
                "DdlEmlBodyFormat": $('#DdlEmlBodyFormat').val(),

                "EdEmlBody": editor.value()
            };

            return temp;
        }
    };

    /*HTTP Tab*/
    $.http = {
        /*Post or Get Function*/
        initForm: function (e) {
            $("#HttpTab .div-template-http").html("");
            $("#HttpTab .div-template-http").addClass("divLoading");
            fxcRequest.post('/Admin/Template/GetHttpView',
                {
                    "TemplateID": $('input[name="RecordId"]').val()
                },
                function (data, textStatus, jqXHR) {
                    $("#HttpTab .div-template-http").html(data);
                    $("#HttpTab .div-template-http").removeClass("divLoading");

                    $.http.httpHeadersButtonClickHandler($('#Link-HttpHeaders'));
                    $.http.addHeaderButtonClickHandler($('#Link-AddHttpHeaders'));
                    $.http.deleteHeaderButtonClickHandler($('#httpHeader-container a.remove'));
                    $.http.insertHeaderButtonClickHandler($('#httpHeader-modal .btn-insert-default'));

                    $.http.setHttpHeadersView();

                }, function (error) {
                    swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnSubmit, "error");
                }, false);
        },
        mapData: function (e) {
            var temp = {
                "TxtHttpBorderTxt": $('#TxtHttpBorderTxt').val(),
                "TxtHttpBorderTxt2": $('#TxtHttpBorderTxt2').val(),
                "TxtHttpBorderTxt3": $('#TxtHttpBorderTxt3').val(),
                "TxtHttpBorderTxt4": $('#TxtHttpBorderTxt4').val(),

                "DdlHttpLocation": $('#DdlHttpLocation').val(),
                "DdlHttpLocation2": $('#DdlHttpLocation2').val(),
                "DdlHttpLocation3": $('#DdlHttpLocation3').val(),
                "DdlHttpLocation4": $('#DdlHttpLocation4').val(),

                "DdlHttpMethod": $('#DdlHttpMethod').val(),
                "TxtHttpImgFN": $('#TxtHttpImgFN').val(),
                "TxtHttpReportQS": $('#TxtHttpReportQS').val(),
                "TxtHttpReportBody": $('#TxtHttpReportBody').val(),
                "HttpHeaders": $.http.mapHeaderData()
            };

            return temp;
        },
        setHttpHeadersView: function () {
            var totalHeaders = $('#httpHeader-container .httpHeader-row').length;

            var hasDefaultRecord = $('#httpHeader-container .httpHeader-row:first').find('.headerID').val() == 0;

            if (totalHeaders == 1 && hasDefaultRecord)
                $('#httpHeader-modal .btn-insert-default').html("Insert");
            else
                $('#httpHeader-modal .btn-insert-default').html("Update");

        },
        httpHeadersButtonClickHandler: function (e) {
            $(e).on('click', function () {
                $('#httpHeader-modal').modal('show');
            });
        },
        addHeaderButtonClickHandler: function (e) {
            $(e).on('click', function () {
                $.http.addHeaderInput();
            });
        },
        deleteHeaderButtonClickHandler: function (e) {
            $('#headerData').on('click', 'a.remove', function () {
                /*
                var totalHeaders = $('#httpHeader-container .httpHeader-row').length;

                if (totalHeaders == 1) {
                    $(this).parents('.httpHeader-row').find('.headerKey').val('');
                    $(this).parents('.httpHeader-row').find('.headerValue').val('');
                }
                else
                    $(this).parents('.httpHeader-row').remove();
                */
                $(this).parents('.httpHeader-row').remove();
            });
        },
        insertHeaderButtonClickHandler: function (e) {
            $(e).on('click', function () {
                var totalHeaders = $('#httpHeader-container .httpHeader-row').length;

                if (totalHeaders > 0)
                    $.http.validateHeaders();
                else {
                    swal({
                        title: "",
                        text: $templateResource.swal.deleteAllHeaders,
                        type: "warning",
                        showCancelButton: true
                    }, function () {
                        $.http.validateHeaders();
                    });
                }
            });
        },
        validateHeaders: function(e) {
            /* Add Validation */
            $("input.headerKey").each(function () {
                $(this).rules("add", {
                    required: true /*{
                            depends: function (element) {
                                var headerValue = $(element).parents('.httpHeader-row').find('.headerValue').val();

                                if (headerValue.length > 0)
                                    return true;

                                return false;
                            }
                        }*/
                    , noSpace: true
                });
            });

            if ($('#formSubmit').valid()) {
                if ($('#httpHeader-container .httpHeader-row:first').find('.headerKey').val())
                    $('#Link-HttpHeaders').text($templateResource.text.editHeaders);
                else
                    $('#Link-HttpHeaders').text($templateResource.text.addHeaders);

                $('#httpHeader-modal').modal('hide');
            }
        },
        mapHeaderData: function () {
            let _httpHeaderData = [];
            $('#httpHeader-container .httpHeader-row').map(function () {
                var headerID = $(this).find('.headerID').first().val();
                var headerKey = $(this).find('.headerKey').first().val();
                var headerValue = $(this).find('.headerValue').first().val();

                if (headerKey.length > 0) {
                    var headerObj = {};
                    headerObj['ID'] = headerID;
                    headerObj['Key'] = headerKey;
                    headerObj['Value'] = headerValue;
                    _httpHeaderData.push(headerObj);
                }
            });

            return _httpHeaderData;
        },
        addHeaderInput: function (headerID) {
            headerID = headerID || 0;

            var totalHeaders = $('#httpHeader-container .httpHeader-row').length;
            var newHeaderRowUID = Math.random().toString(36).substring(2, 15);

            var newHeaderRowHtml = '<div class="row form-group httpHeader-row">' +
                '<div class="col-5">' +
                '<input type="hidden" name="HeaderID-' + newHeaderRowUID + '" value="' + headerID + '" class="headerID">' +
                '<input type="text" name="HeaderKey-' + newHeaderRowUID + '" class="form-control headerKey" title="Enter Header Key">' +
                '</div>' +
                '<div class="col-6">' +
                '<input type="text" name="HeaderValue-' + newHeaderRowUID + '" class="form-control headerValue" title="Enter Header Value">' +
                '</div>' +
                '<div class="col-1">' +
                '<a class="imageSizeTopBarIcons nav-link color-red waves-effect remove" href="#" title="Click to delete header"><i class="fa fa-times fa-lg"></i></a>' +
                '</div>' +
                '</div>';

            $('#httpHeader-container').append(newHeaderRowHtml);
        },
        resetFields: function () {
            $('#httpHeader-container').html('');
            $.http.addHeaderInput();
        }
    };

    /*FTP Tab*/
    $.ftp = {
        /*Post or Get Function*/
        initForm: function (e) {
            $("#FtpTab .div-template-ftp").html("");
            $("#FtpTab .div-template-ftp").addClass("divLoading");
            fxcRequest.post('/Admin/Template/GetFtpView',
                {
                    "TemplateID": $('input[name="RecordId"]').val()
                },
                function (data, textStatus, jqXHR) {
                    $("#FtpTab .div-template-ftp").html(data);
                    $("#FtpTab .div-template-ftp").removeClass("divLoading");

                }, function (error) {
                    swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnSubmit, "error");
                }, false);
        },
        mapData: function (e) {
            var temp = {
                "TxtFtpBorderTxt": $('#TxtFtpBorderTxt').val(),
                "TxtFtpBorderTxt2": $('#TxtFtpBorderTxt2').val(),
                "TxtFtpBorderTxt3": $('#TxtFtpBorderTxt3').val(),
                "TxtFtpBorderTxt4": $('#TxtFtpBorderTxt4').val(),

                "DdlFtpLocation": $('#DdlFtpLocation').val(),
                "DdlFtpLocation2": $('#DdlFtpLocation2').val(),
                "DdlFtpLocation3": $('#DdlFtpLocation3').val(),
                "DdlFtpLocation4": $('#DdlFtpLocation4').val(),

                "TxtFtpImgFN": $('#TxtFtpImgFN').val(),
                "TxtFtpReportFN": $('#TxtFtpReportFN').val(),
                "TxtFtpReportBody": $('#TxtFtpReportBody').val()
            };

            return temp;
        }
    };

    /*File Tab*/
    $.file = {
        /*Post or Get Function*/
        initForm: function (e) {
            $("#FileTab .div-template-file").html("");
            $("#FileTab .div-template-file").addClass("divLoading");
            fxcRequest.post('/Admin/Template/GetFileView',
                {
                    "TemplateID": $('input[name="RecordId"]').val()
                },
                function (data, textStatus, jqXHR) {
                    $("#FileTab .div-template-file").html(data);
                    $("#FileTab .div-template-file").removeClass("divLoading");

                }, function (error) {
                    swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnSubmit, "error");
                }, false);
        },
        mapData: function (e) {
            var temp = {
                "TxtFileBorderTxt": $('#TxtFileBorderTxt').val(),
                "TxtFileBorderTxt2": $('#TxtFileBorderTxt2').val(),
                "TxtFileBorderTxt3": $('#TxtFileBorderTxt3').val(),
                "TxtFileBorderTxt4": $('#TxtFileBorderTxt4').val(),

                "DdlFileLocation": $('#DdlFileLocation').val(),
                "DdlFileLocation2": $('#DdlFileLocation2').val(),
                "DdlFileLocation3": $('#DdlFileLocation3').val(),
                "DdlFileLocation4": $('#DdlFileLocation4').val(),

                "TxtFileImgFN": $('#TxtFileImgFN').val(),
                "TxtFileReportFN": $('#TxtFileReportFN').val(),
                "TxtFileReportBody": $('#TxtFileReportBody').val()
            };

            return temp;
        }
    };

    /*Print Tab*/
    $.print = {
        /*Post or Get Function*/
        initForm: function (e) {
            $("#PrintTab .div-template-print").html("");
            $("#PrintTab .div-template-print").addClass("divLoading");
            fxcRequest.post('/Admin/Template/GetPrintView',
                {
                    "TemplateID": $('input[name="RecordId"]').val()
                },
                function (data, textStatus, jqXHR) {
                    $("#PrintTab .div-template-print").html(data);
                    $("#PrintTab .div-template-print").removeClass("divLoading");

                }, function (error) {
                    swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnSubmit, "error");
                }, false);
        },
        mapData: function () {
            var temp = {
                "TxtPrintBorderTxt": $('#TxtPrintBorderTxt').val(),
                "TxtPrintBorderTxt2": $('#TxtPrintBorderTxt2').val(),
                "TxtPrintBorderTxt3": $('#TxtPrintBorderTxt3').val(),
                "TxtPrintBorderTxt4": $('#TxtPrintBorderTxt4').val(),

                "DdlPrintLocation": $('#DdlPrintLocation').val(),
                "DdlPrintLocation2": $('#DdlPrintLocation2').val(),
                "DdlPrintLocation3": $('#DdlPrintLocation3').val(),
                "DdlPrintLocation4": $('#DdlPrintLocation4').val(),

                "DdlPrintWith": $('#DdlPrintWith').val(),
                "TxtPrintBPBody": $('#TxtPrintBPBody').val()
            };

            return temp;
        }
    };
})(window.jQuery);
