﻿(function ($) {
    var dataForm;
    var profileFormInit = false;
    var initModalPassword = false;
    var btnCreate = true;
    var getErrorMsg = [];

    var profileTab = true;
    var generalSettingTab = false;
    var faxSettingTab = false;
    var permissionTab = false;
    var smtpRelayTab = false;
    var exchangeIntegrationTab = false;

    var validation = function () {
        /*add validator method for username that accept letters and numbers only.*/
        $.validator.addMethod("specialChars", function (value, element) {
            return this.optional(element) || /^[\w.@!#$%^&*_+-=:";',.<>?]+$/i.test(value);
        }, $globalMessages.validation.noSpecialChar);

        $('#formUserProfile').validate({
			ignore: '.ignored',
			ignoreTitle: true,
            rules: {
                "TotalGrid-profile": {
                    required: true,
                    min: 1
                },
                Username: { required: true, specialChars: true, noSpace: true },
                Password: { required: true, passwordFormat: true },
                'UserProfile.PrimaryAddress': { required: true, noSpace: true },
                'Enable2FAProvider': {
                    required: {
                        depends: function (element) {
                            return $('#Enable2FA').prop("checked");
                        }
                    }
                },
            },
            messages: {
                'TotalGrid-profile': {
                    required: $globalMessages.validation.gridMinLength,
                    min: $globalMessages.validation.gridMinLength
                },
                Username: { specialChars: $userResource.validation.username },
                'UserProfile.PrimaryAddress': {
                    required: $userResource.validation.minPrimaryEmail
                }
            },
            invalidHandler: function (event, validator) {
                /* 'this' refers to the form*/
                var errors = validator.numberOfInvalids();

                if (errors) {
                    getErrorMsg.push(validator);
                }
            },
            submitHandler: function (form) {
                return false;
            }
        });
        $('#formUserGeneralSetting').validate({
			ignore: ".ignored",
			ignoreTitle:true,
            rules: {
                "GeneralPwdSenderFrm.Value": { email: true },
                "GeneralNotificationFrm.Value": { email: true },
                "GeneralDeliveryFrm.Value": { email: true },
                "SendXmitRetryDelayFax.Value": { number: true },
                "SendXmitRetryDelayFaxRaw.Value": { number: true },
                "SendXmitRetryDelayEmail.Value": { number: true },
                "SendXmitRetryDelayFtp.Value": { number: true },
                "SendXmitRetryDelayFile.Value": { number: true },
                "SendXmitRetryDelayPrinter.Value": { number: true },
                "SendXmitMxAttemptFax.Value": { number: true }
            },
            messages: {

            },
            invalidHandler: function (event, validator) {
                /* 'this' refers to the form*/
                var errors = validator.numberOfInvalids();

                if (errors) {
                    getErrorMsg.push(validator);
                }
            },
            submitHandler: function (form) {
                false;
            }
        });
        $('#formUserFaxSetting').validate({
			ignore: ".ignored",
			ignoreTitle: true,
            rules: {
            },
            messages: {

            },
            invalidHandler: function (event, validator) {
                /* 'this' refers to the form*/
                var errors = validator.numberOfInvalids();

                if (errors) {
                    getErrorMsg.push(validator);
                }
            },
            submitHandler: function (form) {
                return false;
            }
        });
        $('#formUserPermission').validate({
			ignore: ".ignored",
			ignoreTitle: true,
            rules: {
            },
            messages: {
            },
            invalidHandler: function (event, validator) {
                /* 'this' refers to the form*/
                var errors = validator.numberOfInvalids();

                if (errors) {
                    getErrorMsg.push(validator);
                }
            },
            submitHandler: function (form) {
                return false;
            }
        });
        $('#formUserSMTPRelay').validate({
			ignore: ".ignored",
			ignoreTitle: true,
            rules: {
                "EmailSendPort.Value": { checkRequired: "EmailSendServer.Value" },
                "EmailSendAuthPwd.Value": { checkRequired: "EmailSendAuthUsn.Value" },
                "EmailSendTimeout.Value": { number: true }
            },
            messages: {
            },
            invalidHandler: function (event, validator) {
                /* 'this' refers to the form*/
                var errors = validator.numberOfInvalids();

                if (errors) {
                    getErrorMsg.push(validator);
                }
            },
            submitHandler: function (form) {
                return false;
            }
        });
        $('#formUserExchangeIntegration').validate({
			ignore: ".ignored",
			ignoreTitle: true,
            rules: {
            },
            messages: {
            },
            invalidHandler: function (event, validator) {
                /* 'this' refers to the form*/
                var errors = validator.numberOfInvalids();

                if (errors) {
                    getErrorMsg.push(validator);
                }
            },
            submitHandler: function (form) {
                return false;
            }
        });
    };

    $.users = {
        init: function (e) {
            /*Btn Action*/
            validation();

            $.form.init();
            $.users.tabButtonClickHandler($('a[data-bs-toggle="tab"]'));

            $('.info-tooltip').tooltip();
        },
        initAdvance: function (e) {
            $.users.initTreeViewMove();
            $.users.initGrid();
            $.users.actionButtonClickHandler($('.btn-action-grid'));
            $.users.createButtonClickHandler($(".btn-new-grid"));
            $.users.deleteButtonClickHandler($(".btn-delete-grid"));
            $.users.refreshButtonClickHandler($(".btn-refresh-grid"));
            $.users.searchPressEnter($('input[data-role="search-all-item"]'));
            $.users.searchButtonClickHandler($('.btn-search-grid'));
        },
        initGrid: function (e) {
            var id = $('#grid');

            var dataSource = {
                transport: {
                    read: {
                        url: '/Admin/UserSetting/Read',
                        dataType: "json",
                        type: "GET"
                    },
                    parameterMap: function (options) {
                        /* Fix url param for sort values */
                        var result = {
                            Skip: options.skip,
                            Take: options.take,
                            SearchText: $('input[data-role="search-all-item"]').val()
                        };
                        if (options.sort && options.sort.length > 0) {
                            result.SortBy = options.sort[0].field;
                            result.Direction = options.sort[0].dir;
                        }
                        return result;
                    }
                },
                schema: {
                    data: "Records",
                    total: "Total",
                    model: {
                        id: "UserId"
                    }

                },
                serverPaging: true,
                serverSorting: true
            };

            var col = [
                {
                    selectable: true, width: 45,
                    attributes: {
                        "class": "checkboxSelection"
                    }
                },
                { field: 'Id', hidden: true },
                { field: 'UserName', title: $userResource.field.userName, minWidth: 250, width: 300, sortable: true },
                { field: 'DomainName', title: $userResource.field.domainName, minWidth: 150, width: 200, sortable: true },
                {
                    field: "Status",
                    title: $userResource.field.status,
                    width: 150,
                    template: function (dataRow) {
						var Status = dataRow.IsUserActive ? "1" : "0";

                        var result = '<div class="kendo-container">' +
                            '<span class="badge kendo-span-status badge-pill badge-status' + Status.trim().toLowerCase() + ' "> '
                            + '             <i class="mdi mdi-check kendo-check-icon-status' + Status.trim().toLowerCase() + '"></i> '
                            + '             <i class="mdi mdi-window-close kendo-window-close-icon-status' + Status.trim().toLowerCase() + '"></i> '
                            + '             ' + dataRow.Status + ' '
                            + '         </span>';

                        if (dataRow.IsLocked === true)
                            result += '<span class="fa fa-lock"></span>'

                        result += '</div>';
                        return result;
                    }
                },
                {
                    field: 'ExternalAuth',
                    title: $userResource.field.externalAuth,
                    minWidth: 100, width: 200,
                    sortable: true,
					template: '<div class="kendo-container kendo-container-checkbox"> <i #= IsExternalAuth  ? \'class="mdi fxc-checkbox-true"\' : "" #></i> </div>'
                },
                { field: 'Role', title: $userResource.field.role, minWidth: 300, width: 250, sortable: true },
                {
                    field: 'InboundRoute',
                    title: $userResource.field.inboundRoute,
                    minWidth: 350,
                    width: 350,
                    sortable: true,
                    attributes: { 'style': 'white-space: nowrap', 'title': '#=data.InboundRoute#' }
                },
                { field: 'Secret', hidden: true },
                {
                    field: 'GroupInboundRoute',
                    title: $userResource.field.didGroupInboundRoute,
                    minWidth: 350,
                    width: 350,
                    sortable: true,
                    attributes: { 'style': 'white-space: nowrap', 'title': '#=data.GroupInboundRoute#' }
                }
            ];

            var obj = {};
            obj.allowSelectMultipleRow = true;

            obj.onSelectionFn = $.users.editHandler;

            var $grid = kendogridcustomization.init(id, dataSource, col, obj);
        },
        initTreeViewMove: function (e) {
            /* Move Domain Treeview */
            var objMoveSelection = {};
            objMoveSelection.expandAll = true;
            objMoveSelection.declareType = "textbox";
            objMoveSelection.postSelectFn = $.users.move;
            treeview.init("moveDomain", "moveDomain-name", "moveDomain-id", objMoveSelection);
        },

        /*Btn Action*/
        actionButtonClickHandler: function (e) {
            $(e).on('click', function () {
                var btnTemp = this;
                commandID = $(this).data('command');
                var selectedItem = $.users.getGridSelections($("#grid"));

                if (selectedItem.length === 0) {
                    swal("", $userResource.swal.noUser);
                    return false;
                }

                switch (commandID) {
                    case 603: /*Reset Password*/
                        $("#modalPassword").modal('show');
                        /*Initialize PopUp Modal Reset on first click*/
                        if (!initModalPassword) {
                            $.password.init();
                            initModalPassword = true;
                        }
                        $.password.actionResetPassword();
                        $(this).blur();
                        return false;
                    /*break;*/
                    default:
                }

                $.users.performAction(commandID, selectedItem);

                $(this).blur();
            });
        },
        createButtonClickHandler: function (e) {
            $(e).on('click', function (x) {
                btnCreate = true;
                generalSettingTab = false;
                faxSettingTab = false;
                permissionTab = false;
                smtpRelayTab = false;
                exchangeIntegrationTab = false;

                $.sectionproperties.TabToForm("TabToFormDiv", "ProfileTab", true);

                $("#defaultSelectedID").val("");

                $.form.reset();
                $.sectionproperties.Hidden("EditSection", false);
                $.sectionproperties.Hidden("CreateSection", true);
                $.sectionproperties.SecondLevel();
            });
        },
        deleteButtonClickHandler: function (e) {
			$(e).on('click', function (x) {
				$(this).blur();
                $.users.delete();
            });
        },
        editHandler: function (dataItem) {
            var selectedID = dataItem === null ? "" : dataItem.Id;

            if (dataItem.Role === 'DISPATCH' ||
                dataItem.Role === 'RENDERER' ||
                dataItem.Role === 'FAXAGENT') {
                handleServiceApiKeys(dataItem);
                return;
            }

            generalSettingTab = false;
            faxSettingTab = false;
            permissionTab = false;
            smtpRelayTab = false;
            exchangeIntegrationTab = false;

            $.sectionproperties.TabToForm("TabToFormDiv", "ProfileTab", false);

            $("#defaultSelectedID").val(selectedID);

            $.form.reset();
            $.sectionproperties.SecondLevel();
            var linkFirstTab = document.getElementById('navProfileTab');
            linkFirstTab.click();
           
            $.sectionproperties.Hidden("EditSection", true);
            $.sectionproperties.Hidden("CreateSection", false);
            $.sectionproperties.Disabled("EditSection", true);
            btnCreate = false;
        },
        tabButtonClickHandler: function (e) {
			$(e).on('shown.bs.tab', function (h) {
                var target = $(h.target).attr("href"); /* activated tab*/
				$.users.resetTab(target);
            });
        },
        refreshButtonClickHandler: function (e) {
            $(e).on('click', function (x) {
                $.users.refresh();
                $(this).blur();
            });
        },
        searchButtonClickHandler: function (e) {
            $(e).on('click', function () {
                $.users.search(e);
            });
        },
        searchPressEnter: function (e) {
            $(e).on('keypress', function (enter) {
                if (enter.which === 13) {
                    $.users.search(e);
                }
            });
        },
        /*End Btn Action*/

        /* Logic */
        refresh: function (e) {
            $('input[data-role="search-all-item"]').val("");
            $.users.initGrid();
        },
        search: function (e) {
            $.users.initGrid();
        },
        /* End Logic */

        /*Post or Get Function*/
        delete: function (e) {

            var selectedItem = $.users.getGridSelections($("#grid"));

            if (selectedItem.length === 0) {
                swal("", $userResource.swal.noUser);
                return false;
            }

            swal({
                title: "",
                text: $userResource.swal.delUser + " \n\n" + $userResource.swal.delUserDesc,
                type: "info",
                showCancelButton: true,
                closeOnConfirm: false,
                reverseButtons: true,
                showLoaderOnConfirm: true
            }, function () {
                fxcRequest.post('/Admin/UserSetting/Delete',
                    { Ids: selectedItem.join().split(',') },
                    function (data) {
                        swal($globalMessages.swal.done, $userResource.swal.delSuccess, "success");
                        /* Refresh grid everytime after save*/
                        $.users.refresh();
                    }, function () {
                        swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnDelete, "error");
                    }, true);
            });
        },
        getGridSelections: function (event) {
            var entityGrid = event.data("kendoGrid");
            var rows = entityGrid.select();
            var $selectedUser = [];
            rows.each(function (index, row) {
                var selectedItem = entityGrid.dataItem(row);
                $selectedUser[index] = selectedItem.Id;
            });

            return $selectedUser;
        },
        move: function (e) {
            var selectedItem = $.users.getGridSelections($("#grid"));

            setTimeout(function () {
                $("#moveDomain-ddl").val("");
                $('#moveDomain').tree().unselectAll();
            }, 100);

            if (selectedItem.length === 0) {
                swal("", $userResource.swal.noUser);
                return false;
            }

            fxcRequest.post('/Admin/UserSetting/Move',
                {
                    Ids: selectedItem.join().split(','),
                    DomainId: e
                },
                function (data) {
                    $.toast({
                        heading: $globalMessages.toast.success,
                        text: $userResource.swal.moveSuccess,
                        position: 'top-right',
                        loaderBg: '#ff6849',
                        icon: 'success',
                        hideAfter: 3500,
                        stack: 6
                    });
                    /* Refresh grid everytime after save*/

                    $.users.refresh();
                },
                function (error) {
                    swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnMove, "error");
                },
                false);
        },
        performAction: function (command, selectedItem) {
            var successMsg = $(".btn-action[data-command='']").data('successmsg');
            fxcRequest.post('/Admin/UserSetting/ExecuteAction',
                {
                    Ids: selectedItem.join().split(','),
                    Action: Number(command)
                },
                function (data) {
                    $.users.initGrid();
                    $.toast({
                        heading: $globalMessages.toast.success,
                        text: successMsg,
                        position: 'top-right',
                        loaderBg: '#ff6849',
                        icon: 'success',
                        hideAfter: 3500,
                        stack: 6
                    });
                    if (command === 602) {
                        fxcUserConn.onUpdateInactive(selectedItem.join().split(','), false);
                    }
                    else if (command === 604 || command === 605 || command === 606) {
                        for (var i = 0; i < selectedItem.length; i++) {
                            fxcUserConn.onUpdateUser(selectedItem[i], true, true);
                        }
                    }
                },
                function (error) {
                    swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnSubmit, "error");
                },
                false);
        },
        
		resetTab: function (target) {
            switch (target) {
                case "#GeneralSettingsTab":
                    if (!generalSettingTab) {
                        $.generalSetting.initForm();
                        generalSettingTab = true;
                    }
                    break;
                case "#FaxSettingsTab":
                    if (!faxSettingTab) {
                        $.faxSetting.initForm();
                        faxSettingTab = true;
                    }
                    break;
                case "#PermissionTab":
                    if (!permissionTab) {
                        $.permission.initForm();
                        permissionTab = true;
                    }
                    break;
                case "#SMTPRelayTab":
                    if (!smtpRelayTab) {
                        $.smtpRelay.initForm();
                        smtpRelayTab = true;
                    }
                    break;
                case "#ExchangeIntegrationTab":
                    if (!exchangeIntegrationTab) {
                        $.exchangeIntegration.initForm();
                        exchangeIntegrationTab = true;
                    }
                    break;
				case "#DelegationTab":
					$('input[data-role="search-delegation-item"]').val("");
                    $.delegation.initGrid();
                    $.sectionproperties.Hidden("DelegationTable", false);
                    $.sectionproperties.Hidden("DelegationForm", true);
                    break;
                default:
                    break;
            }
        }
    };
    var handleServiceApiKeys = function (dataItem) {
        $('#toggleSecret').unbind('click');
        $('#update-modalApiKeys').unbind('click');

        $('#ClientId').val(dataItem.Id);
        $('#ClientSecret').val(dataItem.Secret);

        $('#modalApiKeys').modal('show');
        $('#toggleSecret').click(function () {
            var secret = document.getElementById('ClientSecret');
            if ($(this).is(":checked")) secret.type = "text";
            else secret.type = "password";
        });
        $('#update-modalApiKeys').click(function () { updateClientCredentials(); });
    };
    var updateClientCredentials = function () {
        fxcRequest.get('/ClientCredential',
            {
                ClientId: $('#ClientId').val()
            },
            function (data) {
                $('#ClientSecret').val(data);
            }, function () { });
    };
    var modalPasswordValidation = function () {
        $("#formModalPassword").validate({
            ignoreTitle: true,
            rules: {
                NewPassword: {
                    required: true,
                    passwordFormat: true
                },
                ConfirmPassword: {
                    equalTo: "#NewPassword",
                    required: true
                }
            },
            messages: {
                ConfirmPassword: {
                    equalTo: $userResource.validation.pwdNotMatch
                }
            },
            submitHandler: function (form) {
                $.password.save();
            }
        });
    };
    $.password = {
        init: function (dataItem) {
            /*Btn Action*/
            modalPasswordValidation();
            $.password.resetPasswordButtonClickHandler($("#BtnResetmodalPassword"));
            $.password.saveclosemodalHandler($("#BtnSaveClosemodalPassword"));
        },

        /*Btn Action*/
        resetPasswordButtonClickHandler: function (e) {
            $(e).on('click', function () {
                $.password.actionResetPassword();
            });
        },
        saveclosemodalHandler: function (e) {
            $(e).on('click', function () {
                $('input[name="modalPassword-action"]').val('save & close');
            });
        },
        /*End Btn Action*/

        /* Logic */
        actionResetPassword: function (e) {
            $("#formModalPassword").trigger("reset");
            $("#formModalPassword").validate().resetForm();
        },
        save: function (e) {
            var idval = 0;
            var successMsg = $(".btn-action[data-command='603']").data('successmsg');
            var selectedItems = $.users.getGridSelections($("#grid"));
            fxcRequest.post('/Admin/UserSetting/ResetPassword',
                {
                    Ids: selectedItems.join().split(','),
                    Password: $('#ConfirmPassword').val()
                },
                function (data) {
                    if ($('input[name="modalPassword-action"]').val() === 'save & close') {
                        $("#modalPassword").modal('hide');
                        $('input[name="modalPassword-action"]').val('');
                    }

                    $.users.initGrid();
                    $.toast({
                        heading: $globalMessages.toast.success,
                        text: successMsg,
                        position: 'top-right',
                        loaderBg: '#ff6849',
                        icon: 'success',
                        hideAfter: 3500,
                        stack: 6
                    });
                },
                function (error) {
                    swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnSubmit, "error");
                },
                false);
        }
        /* End Logic */
    };

    $.form = {
        init: function (dataItem) {
            /*Btn Action*/
            $.form.resetButtonClickHandler($(".btn-Reset2"));
            $.form.backButtonClickHandler($(".btn-back2"));
            $.form.saveButtonClickHandler($(".btn-save2"));
        },

        /*Btn Action*/
        resetButtonClickHandler: function (e) {
            $(e).on('click', function () {
                $.form.reset();
            });
        },
        backButtonClickHandler: function (e) {
            $(e).on('click', function () {
                $.form.back();
            });
        },
        saveButtonClickHandler: function (e) {
            $(e).on('click', function () {
                $.form.multipleSubmissionForm();
            });
        },
        /*End Btn Action*/

        /* Logic */
        back: function (e) {

            $.sectionproperties.FirstLevelView();

            btnCreate = true;
            generalSettingTab = false;
            faxSettingTab = false;
            permissionTab = false;
            smtpRelayTab = false;
            exchangeIntegrationTab = false;

            $.sectionproperties.TabToForm("TabToFormDiv", "ProfileTab", true);

            $("#defaultSelectedID").val("");

            $.sectionproperties.Hidden("ExchangeIntegrationLink", true);
            $.sectionproperties.Hidden("DelegationLink", true);
        },
        modelData: function (e) {
            var GeneralSettingModel = $('#completeGeneralTab').val() == "true" ? $("#formUserGeneralSetting").MapFormData() : [];
            var FaxSettingModel = $('#completeFaxTab').val() == "true" ? $("#formUserFaxSetting").MapFormData() : [];
            var PermissionModel = $('#completePermissionTab').val() == "true" ? $("#formUserPermission").MapFormData() : [];
            var SMTPRelayModel = $('#completeSMTPTab').val() == "true" ? $("#formUserSMTPRelay").MapFormData() : [];
            var ExchangeModel = $('#completeExchangeTab').val() == "true" ? $("#formUserExchangeIntegration").MapFormData() : [];

            var data = GeneralSettingModel.concat(FaxSettingModel, PermissionModel, SMTPRelayModel, ExchangeModel);
            var formData = {
                "UserId": $("#defaultSelectedID").val(),
                "DomainID": $('#domain-id').val(),
                "UserProfile": $.profile.modelData(),
                "FormData": data,
                "GeneralSettingActive": data
            };
            if (ExchangeModel.length) {
                formData.ExchangeModel = { ExchangePasswordIsEncrypted: $("#ExchangePasswordIsEncrypted").val() };
            }
            return formData;
        },
        multipleSubmissionForm: function () {
            getErrorMsg = [];
            if (profileTab) {
                $('#formUserProfile').submit();
            }
            if (generalSettingTab) {
                $('#formUserGeneralSetting').submit();
            }
            if (faxSettingTab) {
                $('#formUserFaxSetting').submit();
            }
            if (permissionTab) {
                $('#formUserPermission').submit();
            }
            if (smtpRelayTab) {
                $('#formUserSMTPRelay').submit();
            }
            if (exchangeIntegrationTab) {
                $('#formUserExchangeIntegration').submit();
            }

            if (getErrorMsg[0] != null) {
                $("#Password").val("");
                $.sectionproperties.ActiveTab("TabToFormDiv", $(getErrorMsg[0].errorList[0].element).parent().closest('.tab-pane').attr("id"));
                $('html, body').animate({
                    scrollTop: $(getErrorMsg[0].errorList[0].element).offset().top - 200
                }, 1000);
            } else {
                $.form.saveHandler(btnCreate);
            }
        },
		reset: function (e) {
            $.profile.reset();

            if (generalSettingTab) {
                $.generalSetting.reset(btnCreate);
            }

            if (faxSettingTab) {
                $.faxSetting.reset(btnCreate);
            }

            if (permissionTab) {
                $.permission.reset(btnCreate);
            }

            if (smtpRelayTab) {
                $.smtpRelay.reset(btnCreate);
            }

            if (exchangeIntegrationTab) {
                $.exchangeIntegration.reset(btnCreate);
            }

            generalSettingTab = false;
            faxSettingTab = false;
            permissionTab = false;
            smtpRelayTab = false;
            exchangeIntegrationTab = false;
            if (!btnCreate) {
                var target = $('a[data-bs-toggle="tab"].active').attr("href"); /* get activated tab*/
                $.users.resetTab(target);
            }
        },
        saveHandler: function (e) {
            if (e) {
                $.form.create();
            }
            else {
                $.form.save();
            }
        },
        /* End Logic */

        save: function (e) {
            if ($('#completeProfileTab').val() == "true") {
                $.address.save(true);
                var postData = $.form.modelData();
                fxcRequest.post('/Admin/UserSetting/Save',
                    postData,
                    function (data) {
                        $.profile.enable2FAProvider(),
                        fxcUserConn.onUpdateUser(postData.UserId, true, postData.UserProfile.IsActive);
                        swal($globalMessages.swal.success.title, $userResource.swal.saveSucess, "success");
                    }, function (error) {
                        swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnSubmit, "error");
                    }, true);
            }
            else {
                swal($globalMessages.swal.warningTitle, $userResource.validation.stillLoading, "warning");
            }
        },
        create: function (e) {
            $.address.save(true);
            $("#defaultSelectedID").val("");
            generalSettingTab = false;
            faxSettingTab = false;
            permissionTab = false;
            smtpRelayTab = false;
            exchangeIntegrationTab = false;
            fxcRequest.post('/Admin/Manage/Profile/Create',
                $.profile.modelData(),
                function (data) {
                    $.users.initGrid();
                    $.profile.enable2FAProvider(),
                    swal($globalMessages.swal.success.title, $userResource.swal.saveSucess, "success");
                    $.form.back();

                }, function (error) {
                    swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnSubmit, "error");
                }, true);
            /*Post Fn*/
        }
    };
})(window.jQuery);
