﻿(function ($) {
	var setIsRtl = $("html[dir]").attr("dir") === "rtl" ? true : false;
    var tour = {
        id: "admin-network-faxagent-licenseports-hopscotch",
        steps: [
            {
                target: "btn-save-LicensePort",
                title: "",
                content: $globalMessages.uiGuide.buttonSaveChanges,
                placement: "bottom",
                arrowOffset: "250",
                xOffset: "-256",
                yOffset: "-2",
				isRtl: setIsRtl
            },
            {
                target: "btn-reset-LicensePort",
                title: "",
                content: $globalMessages.uiGuide.buttonRefreshView,
                placement: "bottom",
                arrowOffset: "250",
                xOffset: "-256",
				yOffset: "-2",
				isRtl: setIsRtl
            },
            {
                target: "ul li a[data-command='transferTo']",
                title: "",
                content: $faxAgentResource.uiGuide.selectedUnlicensedPort,
                placement: "left",
                yOffset: "-12",
				xOffset: "2",
				isRtl: setIsRtl
            },
            {
                target: "ul li a[data-command='transferFrom']",
                title: "",
                content: $faxAgentResource.uiGuide.selectedLicensedPort,
                placement: "left",
                yOffset: "-12",
				xOffset: "2",
				isRtl: setIsRtl
            },
            {
                target: "ul li a[data-command='transferAllTo']",
                title: "",
                content: $faxAgentResource.uiGuide.allUnlicensedPort,
                placement: "left",
                yOffset: "-12",
				xOffset: "2",
				isRtl: setIsRtl
            },
            {
                target: "ul li a[data-command='transferAllFrom']",
                title: "",
                content: $faxAgentResource.uiGuide.allLicensedPort,
                placement: "left",
                yOffset: "-12",
				xOffset: "2",
				isRtl: setIsRtl
            }
        ],
        showPrevButton: true
    };
    $.faxAgentLicensePortsUiGuide = {
        init: function (tourBtn) {
            $.sharedUiGuide.init({ startTourBtn: tourBtn, tour: tour });
        }
    };
})(window.jQuery);