﻿(function ($) {
    $.networkFaxAgentUiGuide = {
        init: function (opts) {
            $.faxAgentUserConfigUiGuide.init(opts.startTourBtn);

            this.addTabBtnClickListener(opts.tabBtn, function () {
                $(opts.startTourBtn).unbind('click');
                hopscotch.endTour();
                var tab = $(this).attr('href');

                switch ($.networkFaxAgentUiGuide.getTabName(tab)) {
                    case 'ConfigurationTab':
                        $.faxAgentUserConfigUiGuide.init(opts.startTourBtn);
                        break;
                    case 'PortsTab':
                        $.faxAgentPortsUiGuide.init(opts.startTourBtn);
                        break;
                    case 'DialingRulesTab':
                        $.faxAgentDialingRulesUiGuide.init(opts.startTourBtn);
                        break;
                    case 'AgentMonitorTab':
                        $.faxAgentMonitorUiGuide.init(opts.startTourBtn);
                        break;
                    case 'PortsGroupTab':
                        $.faxAgentPortsGroupUiGuide.init(opts.startTourBtn);
                        break;
                    case 'LicensePortsTab':
                        $.faxAgentLicensePortsUiGuide.init(opts.startTourBtn);
                        break;
                    case 'AgentGroupTab':
                        $.faxAgenAgentGroupUiGuide.init(opts.startTourBtn);
                }
            });
        },
        addTabBtnClickListener: function (el, fn) {
            $(el).on('click', fn);
        },
        getTabName: function (attr) {
            return name = attr.split('#')[1];
        }
    };
})(window.jQuery);