﻿(function ($) {
    var licensePortsValidation = function () {
        $('#formSubmit-licensePorts').validate({
            ignore: [],
            rules: {
                /*listLicensedPort: { multiselectrequired: true }*/
            },
            submitHandler: function (form) {
                $.faxAgent_licensePorts.save();
            }
        });
    };
    $.faxAgent_licensePorts = {
        init: function (e) {
            /*Form*/
            $.faxAgent_licensePorts.resetFormButtonClickHandler($('#btn-reset-LicensePort'));
            $.faxAgent_licensePorts.saveButtonClickHandler($('#btn-save-LicensePort'));
            licensePortsValidation();

            $.faxAgent_licensePorts.ddlOnChange();
        },

        initListView: function (e) {
            var listBoxID = "listUnlicensedPort";
            var listBoxIDConnectWith = "listLicensedPort";
            fxcRequest.get('/Admin/FaxAgentLicensePorts/Read',
                {
                    UserID: "",
                    AgentID: $('#FaxAgentList_Value').val()
                },
                function (data) {
                    $("#listUnlicensedPort-span").text(data.TotalAllowPorts);

                    var returnObject = [];
                    var dataSourceSelection = {
                        data: data.UnlicensedPortList.Source
                    };

                    var objUserSelection = {};
                    objUserSelection.dataTextField = "Text";
                    objUserSelection.dataValueField = "Value";
                    objUserSelection.connectWith = listBoxIDConnectWith;
                    objUserSelection.customCounter = "#listUnlicensedPort-span";

                    var dataSourceSelected = {
                        data: data.LicensedPortList.Source
                    };

                    returnObject = listbox.mutual(listBoxID, dataSourceSelection, objUserSelection, dataSourceSelected);

                    if (returnObject != null) {
                        $listBoxSelection = returnObject.listBoxSelection;
                        $listBoxSelected = returnObject.listBoxSelected;
                    }
                },
                function (error) {
                    swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnLoad, "error");
                });
        },

        /*Btn Action*/
        resetFormButtonClickHandler: function (e) {
			$(e).on('click', function () {
				$(this).blur();
                $.faxAgent_licensePorts.resetFields();
            });
        },
        saveButtonClickHandler:function(e){
            $(e).on('click', function () {
                $('#formSubmit-licensePorts').submit();
            });
        },

        /*Logic*/
        ddlOnChange: function (e) {
            $("#listUnlicensedPort").on('change', function (event, state) {
                alert("da");
            });
        },

        resetFields: function (data) {
            $("#formSubmit-licensePorts").trigger("reset");
            $("#formSubmit-licensePorts").validate().resetForm();
            $.faxAgent_licensePorts.initListView();            
        },
        save: function () {
            swal({
                title: "",
                text: $faxAgentResource.swal.affectPort,
                type: "info",
                showCancelButton: true,
                closeOnConfirm: false,
                reverseButtons: true,
                showLoaderOnConfirm: true
            }, function () {
                var array = new Array();
                var licensePortsList = $('#listLicensedPort option');

                $.each(licensePortsList, function (i, e) {
                    var value = e.value;
                    var text = e.text;

                  object = { "Text": text, "Value": value };
                    array[i] = object;
                });

                fxcRequest.post('/Admin/FaxAgentLicensePorts/Save',
                     {
                         "AgentID": $('#FaxAgentList_Value').val(),
                         "LicensedPortList":
                             {
                                 "IsSet": '',
                                 "Source": array,
                                 "Value": ''
                             }
                     },
                    function (data) {
                        $.faxAgent_licensePorts.initListView();
                        swal($globalMessages.swal.success.title, $globalMessages.swal.success.text, "success");
                    }, null);
            });
        }
    };
})(window.jQuery);
