﻿(function ($) {
    var validation = function () {
        $('#formSubmit-port').validate({
            rules: {
                AnswerRings: { required: true, number: true },
                DialTimeOut: { required: true, number: true },
                ToneDetectDigits: { required: true, number: true },
                ToneWaitTimeOut: { required: true, number: true },
                GreetingWavFile: { required: true }
            },
            submitHandler: function (form) {
                $.faxAgent_ports.saveForm();
            }
        });
    };

    var $grid, bind = false;
    var $data;
    $.faxAgent_ports = {
        init: function (e) {
            validation();
            /*Btn Action*/
            $.faxAgent_ports.refreshButtonClickHandler($(".btn-refresh-Port"));
            $.faxAgent_ports.searchPressEnter($('input[data-role="search-Port-detail"]'));
            $.faxAgent_ports.searchButtonClickHandler($('.btn-search-Port'));
            $.faxAgent_ports.saveButtonClickHandler($('.btn-save-Port'));

            /*Form*/
            $.faxAgent_ports.resetFormButtonClickHandler($('#BtnResetPort'));
            $.faxAgent_ports.saveFormCloseModalHandler($('#BtnSaveClosePort'));
            $.faxAgent_ports.saveFormAllModalHandler($('#BtnSaveAllPort'));

            $.faxAgent_ports.ddlOnChange();
            /*$.faxAgent_ports.checkAllHandler();*/
        },
        initGrid: function (e) {
            var id = $('.grid-Port');

            var dataSource = {
                transport: {
                    read: {
                        url: '/Admin/FaxAgentPort/Read',
                        dataType: "json",
                        type: "GET"
                    },
                    parameterMap: function (options) {
                        /* Fix url param for sort values */
                        var result = {
                            Skip: options.skip,
                            Take: options.take,
                            SearchText: $('input[data-role="search-Port-detail"]').val(),
                            AgentID: $('#FaxAgentList_Value').val()
                        };
                        if (options.sort && options.sort.length > 0) {
                            result.SortBy = options.sort[0].field;
                            result.Direction = options.sort[0].dir;
                        }
                        return result;
                    }
                },
                schema: {
                    data: function (response) {
                        $("#customBox-Port").val(response.Utilization);
                        return response.Records;
                    },
                    total: "Total",
                    model: {
                        id: "ChannelID"
                    }
                },
                serverPaging: false,
                serverSorting: false
            };

            var col = [
                { field: 'AgentID', hidden: true },
                { field: 'ChannelID', hidden: true },
				{
					attributes: {
						"class": "clickableColLink"
					},
					field: 'ModuleNo', sortable: true, width: 120, title: $faxAgentResource.field.module
				},
				{ field: 'PortNo', title: $faxAgentResource.field.port, type: 'number', width: 100, sortable: true,},
                {
                    field: "Enabled",
                    title: $faxAgentResource.field.enabled,
                    width: 110,
                    filterable: {
                        cell: {
                            enabled: false
                        }
                    },
                    template: '<div class="kendo-container kendo-container-checkbox"> <i #= Enabled == true ? \'class="mdi fxc-checkbox-true"\' : "" #></i> </div>'
                },
                {
                    attributes: {
                        "class": "checkboxSelection"
                    },
                    field: "SendEnabled",
                    title: $faxAgentResource.field.sendEnabled,
                    filterable: {
                        cell: {
                            enabled: false
                        }
                    },
                    sortable: false,
                    width: 250,
                    headerTemplate: '<input type="checkbox" id="check-all-send" class="k-checkbox" data-box="send-enabled-box" /><label for="check-all-send" class="k-checkbox-label k-no-text check-all-boxes"></label> <span class="p-l-25">Send Enabled</span>',
                    template: '<div class="custom-checkbox"><input class="k-checkbox-custom rrf send-enabled-box" #= SendEnabled == true ? \'checked="checked"\' : "" # data-role="checkbox" data-id="#= ChannelID #" id="SendEnabled-#= ChannelID #" type="checkbox"> '
                        + '     <label for="SendEnabled-#= ChannelID #" class="k-checkbox-custom-label k-no-text"></label></div>'
                },
                { field: 'EnabledTxt', hidden: true },
                {
                    attributes: {
                        "class": "checkboxSelection"
                    },
                    field: "ReceiveEnabled",
                    title: $faxAgentResource.field.receiveEnabled,
                    filterable: {
                        cell: {
                            enabled: false
                        }
                    },
                    sortable: false,
                    width: 250,
                    headerTemplate: '<input type="checkbox" id="check-all-receive" class="k-checkbox" data-box="receive-enabled-box" /><label for="check-all-receive" class="k-checkbox-label k-no-text check-all-boxes"></label> <span class="p-l-25">Receive Enabled</span>',
                    template: '<div class="custom-checkbox"><input class="k-checkbox-custom rrf receive-enabled-box" #= ReceiveEnabled == true ? \'checked="checked"\' : "" # data-role="checkbox" data-id="#= ChannelID #" id="ReceiveEnabled-#= ChannelID #" type="checkbox"> '
                        + '     <label for="ReceiveEnabled-#= ChannelID #" class="k-checkbox-custom-label k-no-text"></label></div>'
                },
                {
                    attributes: {
                        "class": "checkboxSelection"
                    },
                    field: "ToneDetectEnabled",
                    title: $faxAgentResource.field.toneDetectEnabled,
                    filterable: {
                        cell: {
                            enabled: false
                        }
                    },
                    sortable: false,
                    width: 250,
                    headerTemplate: '<input type="checkbox" id="check-all-tonedetect" class="k-checkbox" data-box="tonedetect-enabled-box" /><label for="check-all-tonedetect" class="k-checkbox-label k-no-text check-all-boxes"></label> <span class="p-l-25">Tone Detect Enabled</span>',
                    template: '<div class="custom-checkbox"><input class="k-checkbox-custom rrf tonedetect-enabled-box" #= ToneDetectEnabled == true ? \'checked="checked"\' : "" # data-role="checkbox" data-id="#= ChannelID #" id="ToneDetectEnabled-#= ChannelID #" type="checkbox"> '
                        + '     <label for="ToneDetectEnabled-#= ChannelID #" class="k-checkbox-custom-label k-no-text"></label></div>'
                }
            ];

            var obj = {};
            obj.disablePageable = true;
            obj.allowSelectMultipleRow = true;
            obj.customizeCheckbox = true;
            obj.onSelectionFn = $.faxAgent_ports.editHandler;
            obj.onDataBoundExtraFn = $.faxAgent_ports.checkAllHandler;

            var $grid = kendogridcustomization.init(id, dataSource, col, obj);
        },
        initForm: function (e) {
            fxcRequest.get('/Admin/FaxAgentPort/GetPort',
               {
                   ChannelID: e,
                   AgentID: $('#FaxAgentList_Value').val()
               },
               function (data) {
                   /* map data to inputs */
                   $data = data;
                   $.faxAgent_ports.resetFields(data);
               },
               function (error) {
                   swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnSubmit, "error");
               });
        },
        ddlOnChange: function (e) {
            $("#GreetingType").on('change', function (event, state) {
                $("#formSubmit-port").validate().resetForm();
                var GreetingWavFile = $(this).val() == "WavFile" ? $data.GreetingType == "WavFile" ? $data.GreetingWavFile : "" : "Not Applicable";
                var disabledGreetingWavFile = $(this).val() == "WavFile" ? false: true;
                $("#GreetingWavFile").val(GreetingWavFile);
                $("#GreetingWavFile").prop("disabled", disabledGreetingWavFile);
                $("#formSubmit-port").valid();
            });
            $("#HeaderStyle").on('change', function (event, state) {
                var HeaderCustomStr = $(this).val() == "Custom" ? $data.HeaderStyle == "Custom" ? $data.HeaderCustomStr : "" : "Not Applicable";
                var disabledHeaderCustomStr = $(this).val() == "Custom" ? false : true;
                $("#HeaderCustomStr").val(HeaderCustomStr);
                $("#HeaderCustomStr").prop("disabled", disabledHeaderCustomStr);
            });
        },

        /*Btn Action*/
        createButtonClickHandler: function (e) {
            $(e).on('click', function () {
                $data = null;
                $.faxAgent_ports.resetFields($data);
                $('#modalDocStore').modal('show');
            });
        },
        editHandler: function (e) {
            $.faxAgent_ports.initForm(e.ChannelID);
            $('#Port-modal').modal('show');
        },
        deleteButtonClickHandler: function (e) {
            $(e).on('click', function (x) {
                $.faxAgent_ports.delete();
            });
        },
        refreshButtonClickHandler: function (e) {
            $(e).on('click', function (x) {
                $.faxAgent_ports.refresh();
                $(this).blur();
            });
        },
        saveButtonClickHandler: function (e) {
			$(e).on('click', function () {
				$(this).blur();
                $.faxAgent_ports.saveGrid(e);
            });
        },
        searchButtonClickHandler: function (e) {
            $(e).on('click', function () {
                $.faxAgent_ports.search(e);
            });
        },
        searchPressEnter: function (e) {
            $(e).on('keypress', function (enter) {
                if (enter.which === 13) {
                    $.faxAgent_ports.search(e);
                }
            });
        },

        resetFormButtonClickHandler: function (e) {
            $(e).on('click', function () {
                $.faxAgent_ports.resetFields($data);
            });
        },
        saveFormAllModalHandler: function (e) {
            $(e).on('click', function () {
                $("#ApplyAll").val(true);
            });
        },
        saveFormCloseModalHandler: function (e) {
            $(e).on('click', function () {
                $('input[name="Ports-modal-action"]').val('save & close');
            });
        },

        /* Logic */
        getGridSelections: function (event) {
            var Addresses = [];
            $.each($('.grid-Port').data('kendoGrid').dataSource.data(), function (key, value) {
                Addresses.push({
                    AgentID: value.AgentID,
                    ChannelID: value.ChannelID,
                    ModuleNo: value.ModuleNo,
                    PortNo: value.PortNo,

                    Enabled: value.Enabled,
                    EnabledTxt: value.EnabledTxt,

                    SendEnabled: value.SendEnabled,
                    ReceiveEnabled: value.ReceiveEnabled,
                    ToneDetectEnabled: value.ToneDetectEnabled
                });
            });
            return Addresses;
        },
        refresh: function (e) {
            $("#searchBox-Port").val("");
            $.faxAgent_ports.initGrid();
        },
        resetFields: function (data) {
            $("#formSubmit-port").trigger("reset");
            $("#formSubmit-port").validate().resetForm();
            $("#ApplyAll").val(false);
            if (data !== null) {
                /*console.log(data);*/
                $("#LabelPortConfig").text(data.LabelPortConfig);
                $("#AnswerRings").val(data.AnswerRings);
                $("#DialTimeOut").val(data.DialTimeOut);
                $("#GreetingWavFile").val(data.GreetingWavFile);
                $("#HeaderStyle").val(data.HeaderStyle);
                $("#ChannelID").val(data.ChannelID);
                $("#LocalCSID").val(data.LocalCSID);
                $("#ToneDetectDigits").val(data.ToneDetectDigits);
                $("#ToneWaitTimeOut").val(data.ToneWaitTimeOut);
                $("#HeaderCustomStr").val(data.HeaderCustomStr);
                $.sectionproperties.selectGenerator('GreetingType', data.GreetingTypeSelectList, data.GreetingType, 0);
                $.sectionproperties.selectGenerator('HeaderStyle', data.HeaderStyleSelectList, data.HeaderStyle, 0);
                $("#GreetingType").change();
                $("#HeaderStyle").change();
            }
        },
        search: function (e) {
            var val = $("#searchBox-Port").val() != null ?$("#searchBox-Port").val().trim() : "" ;
            var grid = $(".grid-Port").data("kendoGrid");
            
            if (val) {
              var filters = [];

              $.each(grid.options.columns, function (index, value) {
                var checkCellEnabled = typeof value.filterable === 'undefined' ? true : value.filterable.cell.enabled;
                var checkCellType = value.type === 'number' ? "eq" : "contains";
                if (!value.hidden && checkCellEnabled) {
                  var filter = {
                    field: value.field,
                    operator: checkCellType,
                    value: val
                  };
                  filters.push(filter);
                }
              });
                grid.dataSource.filter({
                    logic: "or",
                    filters: filters
                });
            }
            else {
                grid.dataSource.filter({
                    logic: "or",
                    filters: []
                });
            }
        },
        /* End Logic */

        /*Post or Get Function*/
        saveGrid: function (e) {
            fxcRequest.post('/admin/FaxAgentPort/Save',
                { Records: $.faxAgent_ports.getGridSelections() },
                function (data) {
					console.log("OK");
                    swal($globalMessages.swal.success.title, $globalMessages.swal.success.text, "success");
                    /* Refresh grid everytime after save*/
                    $.faxAgent_ports.refresh();
                }, function () {
					console.log("OK");
                    swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnSubmit, "error");
                }, true);
        },

        saveForm: function () {
            console.log($data);
            fxcRequest.post('/admin/FaxAgentPort/SaveConfiguration',
                {
                    ApplyAll: $("#ApplyAll").val(),
                    ChannelID: $("#ChannelID").val(),
                    AgentID: $('#FaxAgentList_Value').val(),
                    AnswerRings: $("#AnswerRings").val(),
                    DialTimeOut: $("#DialTimeOut").val(),
                    HeaderStyle: $("#HeaderStyle").val(),
                    LocalCSID: $("#LocalCSID").val(),
                    ToneDetectDigits: $("#ToneDetectDigits").val(),
                    ToneWaitTimeOut: $("#ToneWaitTimeOut").val(),
                    GreetingType: $("#GreetingType").val(),
                    GreetingWavFile: $("#GreetingWavFile").val(),
                    HeaderCustomStr: $("#HeaderCustomStr").val(),
                    PortNo: $data.PortNo
                },
                function (data) {
                    if ($("#ChannelID").val() > 0)
                        $.faxAgent_ports.initForm($("#ChannelID").val());

                    $.faxAgent_ports.refresh();
                    if ($('input[name="Ports-modal-action"]').val() === 'save & close') {
                        $('#Port-modal').modal('hide');
                        $('input[name="Ports-modal-action"]').val('');
                    }
                    swal($globalMessages.swal.success.title, $globalMessages.swal.success.text, "success");
                },
                function (error) {
                    swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnSubmit, "error");
                });
        },
        checkAllHandler: function () {
            var sendEnabledBox = 'tbody tr td input.send-enabled-box';
            var receiveEnabledBox = 'tbody tr td input.receive-enabled-box';
            var tonedetectEnabledBox = 'tbody tr td input.tonedetect-enabled-box';
            var sendEnabledRow = 'thead tr th input[data-box=send-enabled-box].k-checkbox';
            var receiveEnabledRow = 'thead tr th input[data-box=receive-enabled-box].k-checkbox';
            var tonedetectEnabledRow = 'thead tr th input[data-box=tonedetect-enabled-box].k-checkbox';

            $('thead tr th input[type=checkbox]').prop('checked', false);
            $('thead tr th input[type=checkbox]').click(function (e) {
                var isChecked = getProp($(this));
                var box = $(this).data('box');
                $('input.' + box).prop('checked', isChecked);
                $('input.' + box).trigger('change');
            });

            $(sendEnabledBox).click(function (e) {
                toggleHeaderCheckBox(sendEnabledRow, sendEnabledBox, getProp($(this)));
            });

            $(receiveEnabledBox).click(function (e) {
                toggleHeaderCheckBox(receiveEnabledRow, receiveEnabledBox, getProp($(this)));
            });

            $(tonedetectEnabledBox).click(function (e) {
                toggleHeaderCheckBox(tonedetectEnabledRow, tonedetectEnabledBox, getProp($(this)));
            });

            var getProp = function (el) {
                return el.prop('checked').toString() === 'true' ? true : false;
            };

            var isAllRowCheckBoxEnabled = function (el) {
                var isAllRowEnabled = true;
                el.each(function () {
                    isAllRowEnabled = getProp($(this));
                    if (!isAllRowEnabled) return isAllRowEnabled;
                });
                return isAllRowEnabled;
            };

            var toggleHeaderCheckBox = function (headerCheckBoxEl, allRowCheckBoxEl, isChecked) {
                var isAllRowEnabled = isAllRowCheckBoxEnabled($(allRowCheckBoxEl));
                var isCheckAllEnabled = getProp($(headerCheckBoxEl));

                if (isAllRowEnabled)
                    $(headerCheckBoxEl).prop('checked', isChecked);
                else {
                    if (isCheckAllEnabled)
                        $(headerCheckBoxEl).prop('checked', false);
                }
            };

            isAllRowCheckBoxEnabled($(sendEnabledBox)) && $(sendEnabledRow).prop('checked', true);
            isAllRowCheckBoxEnabled($(receiveEnabledBox)) && $(receiveEnabledRow).prop('checked', true);
            isAllRowCheckBoxEnabled($(tonedetectEnabledBox)) && $(tonedetectEnabledRow).prop('checked', true);
        }
    };
})(window.jQuery);