﻿(function ($) {
    var $grid;
    var portsGroupValidation = function () {
        $('#formSubmit-portGroup').validate({
            ignore: [],
			ignoreTitle: true,
            rules: {
                txtGrpName: { required: true, noSpace: true },
                listAssignedPortGroup: { multiselectrequired: true }
            },
            submitHandler: function (form) {
                $.faxAgent_portsGroup.save();
            }
        });
    };
    $.faxAgent_portsGroup = {
        init: function (e) {
            /*Btn Action*/
            $.faxAgent_portsGroup.createButtonClickHandler($(".btn-create-PortsGroup"));
            $.faxAgent_portsGroup.deleteButtonClickHandler($(".btn-delete-PortsGroup"));
            $.faxAgent_portsGroup.refreshButtonClickHandler($(".btn-refresh-PortsGroup"));
            $.faxAgent_portsGroup.searchPressEnter($('input[data-role="search-PortsGroup-detail"]'));
            $.faxAgent_portsGroup.searchButtonClickHandler($('.btn-search-PortsGroup'));
            /*Form*/
            $.faxAgent_portsGroup.resetButtonClickHandler($('#BtnResetdefault'));
            $.faxAgent_portsGroup.saveclosemodalHandler($('#BtnSaveClosedefault'));
            portsGroupValidation();
        },
        initGrid: function (e) {
            var id = $('.grid-PortsGroup');

            var dataSource = {
                transport: {
                    read: {
                        url: '/Admin/FaxAgentPortsGroup/Read',
                        dataType: "json",
                        type: "GET"
                    },
                    parameterMap: function (options) {
                        /* Fix url param for sort values */
                        var result = {
                            Skip: options.skip,
                            Take: options.take,
                            SearchText: $('input[data-role="search-PortsGroup-detail"]').val(),
                            AgentID: $('#FaxAgentList_Value').val()
                        };
                        if (options.sort && options.sort.length > 0) {
                            result.SortBy = options.sort[0].field;
                            result.Direction = options.sort[0].dir;
                        }
                        return result;
                    }
                },
                schema: {
                    data: "Records",
                    total: "Total",
                    model: {
                        id: "Id"
                    }
                },
                serverPaging: true,
                serverSorting: true
            };

            var col = [
                {
                    selectable: true,
                    width: 45,
                    filterable: {
                        cell: {
                            enabled: false
                        }
                    },
                    attributes: {
                        "class": "checkboxSelection"
                    }
                },
                { field: 'Id' },
                { field: 'AgentID', hidden: true },
                { field: 'ChannelGrpName', title: $faxAgentResource.field.groupName, sortable: true },
                { field: 'ChannelGrpDesc', title: $faxAgentResource.field.groupDescription, sortable: true },
                { field: 'TotalCount', type: "number", title: $faxAgentResource.field.totalCount, sortable: true }
            ];

            var obj = {};
            obj.disablePageable = true;
            obj.allowSelectMultipleRow = true;
            obj.onSelectionFn = $.faxAgent_portsGroup.editHandler;
            obj.dataSourceOnSuccessFn = $.faxAgent_portsGroup.resetFieldsHandler;
            var $grid = kendogridcustomization.init(id, dataSource, col, obj);
        },
        initListView: function (e) {
            var listBoxID = "listUnassignedPortGroup";
            var listBoxIDConnectWith = "listAssignedPortGroup";

            fxcRequest.get('/Admin/FaxAgentPortsGroup/ReadList',
                {
                    ChannelGrpID: $('#ChannelGrpID').val(),
                    AgentID: $('#FaxAgentList_Value').val()
                },
                function (data) {
                    var returnObject = [];
                    var dataSourceSelection = {
                        data: data.UnassignedPorts.Source
                    };

                    var objUserSelection = {};
                    objUserSelection.dataTextField = "Text";
                    objUserSelection.dataValueField = "Value";
                    objUserSelection.connectWith = listBoxIDConnectWith;

                    var dataSourceSelected = {
                        data: data.GroupPorts.Source
                    };

                    returnObject = listbox.mutual(listBoxID, dataSourceSelection, objUserSelection, dataSourceSelected);

                    if (returnObject != null) {
                        $listBoxSelection = returnObject.listBoxSelection;
                        $listBoxSelected = returnObject.listBoxSelected;
                    }
                },
                function (error) {
                    swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnLoad, "error");
                });
        },

        /*Btn Action*/
        createButtonClickHandler: function (e) {
            $(e).on('click', function () {
                $data = null;
                $.faxAgent_portsGroup.resetFields();
                $('#modalfaxAgent_portsGroup').modal('show');
            });
        },
        editHandler: function (e) {
            $data = e;
            $.faxAgent_portsGroup.resetFields();
            $('#modalfaxAgent_portsGroup').modal('show');
        },
        deleteButtonClickHandler: function (e) {
            $(e).on('click', function (x) {
				$(this).blur();
                $.faxAgent_portsGroup.delete();
            });
        },
        refreshButtonClickHandler: function (e) {
            $(e).on('click', function (x) {
                $.faxAgent_portsGroup.refresh();
                $(this).blur();
            });
        },
        searchButtonClickHandler: function (e) {
            $(e).on('click', function () {
                $.faxAgent_portsGroup.search(e);
            });
        },
        searchPressEnter: function (e) {
            $(e).on('keypress', function (enter) {
                if (enter.which === 13) {
                    $.faxAgent_portsGroup.search(e);
                }
            });
        },

        resetButtonClickHandler: function (e) {
            $(e).on('click', function () {
                $.faxAgent_portsGroup.resetFields();
            });
        },
        saveclosemodalHandler: function (e) {
            $(e).on('click', function () {
                $('input[name="portGroup-modal-action"]').val('save & close');
            });
        },
        /*End Btn Action*/

        /* Logic */
        refresh: function (e) {
            $('input[data-role="search-PortsGroup-detail"]').val("");
            $.faxAgent_portsGroup.initGrid();
        },
        resetFields: function () {
            $("#formSubmit-portGroup").trigger("reset");
            $("#formSubmit-portGroup").validate().resetForm();
            $(".modal-header h4#portGroup").text($faxAgentResource.createNewEntry);
            $('input[name="ChannelGrpID"]').val("");
            if ($data) {
                $(".modal-header h4#portGroup").text($faxAgentResource.editEntry);
                $('input[name="ChannelGrpID"]').val($data.Id);
                $('#txtGrpName').val($data.ChannelGrpName);
                $('#txtGrpDesc').val($data.ChannelGrpDesc);
            }

            $.faxAgent_portsGroup.initListView();
        },
        resetFieldsHandler: function (e) {
            $data = null;
            var getData = $(".grid-PortsGroup").data("kendoGrid").dataSource.get($('input[name="ChannelGrpID"]').val());
            $data = getData;

            $.faxAgent_portsGroup.resetFields();
        },
        search: function (e) {
            /*iF only server sorting & pagination is turned on
            $.faxAgent_portsGroup.initGrid();*/

            var val = $('input[data-role="search-PortsGroup-detail"]').val() != null ? $('input[data-role="search-PortsGroup-detail"]').val().trim() : "";
            var grid = $(".grid-PortsGroup").data("kendoGrid");

            if (val) {
              var filters = [];

              $.each(grid.options.columns, function (index, value) {

                var checkCellEnabled = typeof value.filterable === 'undefined' ? true : value.filterable.cell.enabled;
                var checkCellType = value.type === 'number' ? "eq" : "contains";
                if (!value.hidden && checkCellEnabled) {
                  var filter = {
                    field: value.field,
                    operator: checkCellType,
                    value: val
                  };
                  filters.push(filter);
                }
              });
                grid.dataSource.filter({
                    logic: "or",
                    filters: filters
                });
            }
            else {
                grid.dataSource.filter({
                    logic: "or",
                    filters: []
                });
            }
        },
        /* End Logic */

        /*Post or Get Function*/
        delete: function (e) {
            var selectedItem = $.faxAgent_portsGroup.getGridSelections($(".grid-PortsGroup"));

            if (selectedItem.length === 0) {
                swal("", $faxAgentResource.swal.noPortGroup);
                return false;
            }

            swal({
                title: "",
                text: $faxAgentResource.swal.delPortGroup,
                type: "info",
                showCancelButton: true,
                closeOnConfirm: false,
                reverseButtons: true,
                showLoaderOnConfirm: true
            }, function () {
                fxcRequest.post('/Admin/FaxAgentPortsGroup/Delete',
                    { Ids: selectedItem.join().split(',') },
                    function (data) {
                        swal($globalMessages.swal.done, $faxAgentResource.swal.successPortGroup, "success");
                        /* Refresh grid everytime after save*/
                        $.faxAgent_portsGroup.refresh();
                    }, function () {
                        swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnSubmit, "error");
                    }, true);
            });
        },
        getGridSelections: function (event) {
            var entityGrid = event.data("kendoGrid");
            var rows = entityGrid.select();
            var $selectedUser = [];
            rows.each(function (index, row) {
                var selectedItem = entityGrid.dataItem(row);
                $selectedUser[index] = selectedItem.Id;
            });

            return $selectedUser;
        },
        save: function () {
            var item = $('#listAssignedPortGroup');
            var optionList = item["0"].options;
            var selected = new Array();

            $.each(optionList, function (i, e) {
                var value = e.value;
                selected[i] = value;
            });

            fxcRequest.post('/Admin/FaxAgentPortsGroup/Save',
                {
                    "ChannelGrpID": $('#ChannelGrpID').val(),
                    "AgentID": $('#FaxAgentList_Value').val(),
                    "SelectedGroupPorts": selected,
                    "ChannelGrpName": $('#txtGrpName').val(),
                    "ChannelGrpDesc": $('#txtGrpDesc').val()
                },
                function (data) {
                    $.faxAgent_portsGroup.refresh();
                    if ($('input[name="portGroup-modal-action"]').val() === 'save & close') {
                        $('#modalfaxAgent_portsGroup').modal('hide');
                        $('input[name="portGroup-modal-action"]').val('');
                    }
                    swal($globalMessages.swal.success.title, $globalMessages.swal.success.text, "success");
                },
                function (error) {
                    swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnSubmit, "error");
                });
        }
    };
})(window.jQuery);
