﻿(function ($) {
    /*interval*/
    var t;
    var rowAdditionalObj = null;
    var rowAdditionalObj2 = null;
    var gridId = "#grid";

    $.msgqueue = {
        init: function (e) {
            $.msgqueue.msgTypeSelectionChangedHandler($('#AddrTypeList_Value'));
            $.msgqueue.actionsSelectionChangedHandler($('#ActionList_Value'));
            $.msgqueue.refreshButtonClickHandler($('.btn-refresh'));
            $.msgqueue.searchHandler($('#searchBox-grid'));
            $.msgqueue.searchButtonClickHandler($('.btn-search-grid'));
            $.msgqueue.refreshIntervalSelectionChanged($('#RefreshTimeIntervalList_Value'));
            $('#RefreshTimeIntervalList_Value').change();
            $.msgqueue.initGrid();
        },
        initContextMenu: function () {
            $.contextMenu('destroy', ".ctxmenuMsg");
            $.contextMenu({
                selector: '.ctxmenuMsg',
                trigger: 'right',
                items: {
                    "1": { name: "View Message Info", icon: "fa-info" }
                },
                className: "messageContextMenu",
                callback: function (key, options) {
                    var uid = options.$trigger.attr("data-uid");
                    var row = $("tr[data-uid='" + uid + "']");
                    var dataItem = $(gridId).data("kendoGrid").dataItem(row);

                    if (rowAdditionalObj !== null) {
                        dataItem.rowAdditionalObj = rowAdditionalObj;
                    }
                    dataItem.rowAdditionalObj.HideImageTab = true;
                    $.messageviewer.showMessageViewerMessageQueue(dataItem);
                }
            });

            if ($showDotContextMenu) {
                $.contextMenu('destroy', ".dotcontextMenu");
                $.contextMenu({
                    selector: '.dotcontextMenu',
                    trigger: 'left',
                    items: {
                        "1": { name: "View Message Info", icon: "fa-info" }
                    },
                    callback: function (key, options) {
                        var uid = options.$trigger.attr("data-uid");
                        var row = $("tr[data-uid='" + uid + "']");
                        var dataItem = $(gridId).data("kendoGrid").dataItem(row);

                        if (rowAdditionalObj !== null) {
                            dataItem.rowAdditionalObj = rowAdditionalObj;
                        }
                        dataItem.rowAdditionalObj.HideImageTab = true;
                        $.messageviewer.showMessageViewerMessageQueue(dataItem);
                    }
                });
            }
        },
        initGrid: function (e) {
            $.msgqueue.setRefreshInterval();
            var refreshPage = $('#IsMessageQueue').val();
            if (refreshPage != "true") {
                return false;
            }

            var dt = new Date();
            var time = dt.getHours() + ":" + dt.getMinutes() + ":" + dt.getSeconds();

            var id = $(gridId);

            var addrTypeID = $('#AddrTypeList_Value').val();

            var dataSource = {
                transport: {
                    read: {
                        url: '/Admin/MessageQueue/Read',
                        dataType: "json",
                        type: "GET"
                    },
                    parameterMap: function (options) {

                        var result = {
                            AddrTypeID: addrTypeID,
                            Filter: $('input[data-role="search-all-item"]').val(),
                            Skip: options.skip,
                            Take: options.take,
                            Page: options.page
                        };

                        if (options.sort && options.sort.length > 0) {
                            result.SortBy = options.sort[0].field;
                            result.Direction = options.sort[0].dir;
                        }

                        return result;
                    }
                },
                schema: {
                    data: "Records",
                    total: "Total",
                    model: {
                        id: "Msgtransmitid"
                    }
                },
                serverPaging: true,
                serverSorting: true
            };

            var col = [];

            col.push({
                selectable: true,
                width: 45,
                attributes: {
                    "class": "checkboxSelection"
                }
            });

            if ($showDotContextMenu) {
                col.push({
                    field: "",
                    title: "",
                    width: 30,
                    attributes: {
                        "class": "checkboxSelection"
                    },
                    sortable: false,
                    template: function (dataRow) {
                        var result = '<span class="dotcontextMenu" data-uid="#= uid #"><i class="fa fa-ellipsis-v" style="padding:0px 5px;"></i></span>';
                        return result;
                    }
                });
            }

            col.push(
                { field: 'Msgtransmitid', hidden: true },
                { field: 'MessageID', title: $queueResource.field.messageId, width: 200, sortable: true, hidden: !$showColMessageId },
                { field: 'MsgNo', title: $queueResource.field.messageNo, width: 200, sortable: true },
                {
                    field: "Ispause",
                    title: $queueResource.field.paused,
                    width: 150,
                    filterable: {
                        cell: {
                            enabled: false
                        }
                    },
                    template: '<div class="kendo-container"> <i #= Ispause == true ? \'class="mdi fxc-checkbox-true"\' : "" #></i> </div>'
                },
                { field: 'PortNo', title: $queueResource.field.portNumber, width: 180, sortable: true },
                { field: 'Boardid', title: $queueResource.field.module, width: 200, sortable: true },
                { field: 'Serverip', title: $queueResource.field.server, width: 200, sortable: true },
                { field: 'Agentid', title: $queueResource.field.faxAgent, width: 200, sortable: true },
                {
                    field: "IsReady",
                    title: $queueResource.field.isReady,
                    width: 150,
                    filterable: {
                        cell: {
                            enabled: false
                        }
                    },
                    template: '<div class="kendo-container"> <i #= IsReady == true ? \'class="mdi fxc-checkbox-true"\' : "" #></i> </div>'
                },
                { field: 'Priority', title: $queueResource.field.priority, width: 150, sortable: true },
                { field: 'Scheduledate', title: $queueResource.field.dateScheduled, width: 200, sortable: true },
                { field: 'Address', title: $queueResource.field.address, width: 200, sortable: true },
                { field: 'Crdate', title: $queueResource.field.dateCreated, width: 200, sortable: true },
                { field: 'Pickeddate', title: $queueResource.field.processingDate, width: 200, sortable: true },
                { field: 'OpSizeBytes', title: $queueResource.field.fileSize, width: 150, sortable: true },
                { field: 'PageCount', title: $queueResource.field.pageCount, width: 180, sortable: true }
            );

            var obj = {};
            obj.allowSelectMultipleRow = true;
            obj.customizeCheckbox = true;
            if ($enableDoubleClick) {
                obj.doubleClickFn = $.messageviewer.showMessageViewerMessageQueue;
            }
            else {
                obj.onSelectionFn = $.messageviewer.showMessageViewerMessageQueue;
            }

            obj.rowClass = "ctxmenuMsg";
            rowAdditionalObj = { "RefreshLocation": $('#MessageHubRefreshFlag').val() };
            rowAdditionalObj2 = { "RefreshLocation": $('#MessageHubRefreshFlag').val() };

            obj.rowAdditionalObj = rowAdditionalObj2;

            kendogridcustomization.init(id, dataSource, col, obj);

            /*column to show/hide*/
            var dynamicCol = ["PortNo", "Boardid", "Serverip", "Agentid"];
            if (addrTypeID == "2") {
                /*fax*/
                $.each(dynamicCol, function (index, value) {
                    $(gridId).data("kendoGrid").showColumn(value);
                });
            } else {
                $.each(dynamicCol, function (index, value) {
                    $(gridId).data("kendoGrid").hideColumn(value);
                });
            }

            $.msgqueue.initContextMenu();
        },
        getGridSelections: function (arg) {
            var selectedId = [];
            var entityGrid = $(gridId).data("kendoGrid");
            var rows = entityGrid.select();

            rows.each(function (index, row) {
                var selectedItem = entityGrid.dataItem(row);
                selectedId[index] = selectedItem.id;
            });
            return selectedId;
        },
        msgTypeSelectionChangedHandler: function (e) {
            $(e).on('change', function () {
                $.msgqueue.initGrid();
            });
        },
        actionsSelectionChangedHandler: function (e) {
            $(e).on('change', function () {
                var ids = $.msgqueue.getGridSelections();

                var selectedAction = parseInt($('#ActionList_Value').val());

                if (ids.length > 0 && !isNaN(selectedAction)) {
                    var message = "";
                    switch (selectedAction) {
                        case 107:
                            message = $queueResource.alert.pause;
                            break;
                        case 108:
                            message = $queueResource.alert.resume;
                            break;
                        case 106:
                            message = $queueResource.alert.cancel;
                            break;
                        case 114:
                            message = $queueResource.alert.purge;
                            break;
                        case 115:
                            message = $queueResource.alert.reschedule;
                            break;
                        case 116:
                            message = $queueResource.alert.restart;
                            break;
                        case 117:
                            message = $queueResource.alert.forceReschedule;
                            break;
                        case 118:
                            message = $queueResource.alert.forceRestart;
                            break;
                        default:
                    }

                    swal({
                        title: "",
                        text: message,
                        type: "info",
                        showCancelButton: true,
                        closeOnConfirm: false,
                        reverseButtons: true,
                        showLoaderOnConfirm: true
                    }, function () {
                        $.msgqueue.executeAction(selectedAction);
                    });
                }
                else
                    swal("", $queueResource.swal.noMessage);
                $('#ActionList_Value').prop('selectedIndex', 0);
            });
        },
        setRefreshInterval: function () {
            /*console.log(t);*/
            clearInterval(t);
            /*console.log('---message queue clearInterval---');
            console.log(t);*/

            var refreshPage = $('#IsMessageQueue').val();
            if (refreshPage == "true") {
                var intervalVal = Number($('#RefreshTimeIntervalList_Value').val()) * 1000;

                if (intervalVal === 0)
                    clearInterval(t);
                else
                    t = setInterval(function () { $.msgqueue.initGrid(); }, intervalVal);
            }
        },
        refreshIntervalSelectionChanged: function (e) {
            $(e).on('change', function () {
                $.msgqueue.setRefreshInterval();
            });
        },
        executeAction: function (action) {
            var model = {
                "Ids": $.msgqueue.getGridSelections(),
                "Re": "queue",
                "ActionType": Number(action),
                "AddrTypeId": Number($('#AddrTypeList_Value').val())
            };

            fxcRequest.post('/Admin/MessageQueue/ExecuteAction',
                model,
                function (data) {
                    $.msgqueue.initGrid();
                    var selectedAction = parseInt(action);

                    switch (selectedAction) {
                        case 107:
                            swal($globalMessages.swal.success.title, $queueResource.swal.success.pause, "success");
                            break;
                        case 108:
                            swal($globalMessages.swal.success.title, $queueResource.swal.success.resume, "success");
                            break;
                        case 106:
                            swal($globalMessages.swal.success.title, $queueResource.swal.success.cancel, "success");
                            break;
                        case 114:
                            swal($globalMessages.swal.success.title, $queueResource.swal.success.purge, "success");
                            break;
                        case 115:
                            swal($globalMessages.swal.success.title, $queueResource.swal.success.reschedule, "success");
                            break;
                        case 116:
                            swal($globalMessages.swal.success.title, $queueResource.swal.success.reset, "success");
                            break;
                        case 117:
                            swal($globalMessages.swal.success.title, $queueResource.swal.success.forceSchedule, "success");
                            break;
                        case 118:
                            swal($globalMessages.swal.success.title, $queueResource.swal.success.forceReset, "success");
                            break;
                        default:
                            break;
                    }
                });
        },
        refreshButtonClickHandler: function (e) {
            $(e).on('click', function () {
                $('input[data-role="search-all-item"]').val('');
                $.msgqueue.initGrid();
                $(this).blur();
            });
        },
        searchButtonClickHandler: function (e) {
            $(e).on('click', function () {
                $.msgqueue.initGrid();
            });
        },
        searchHandler: function (e) {
            $(e).keypress(function (event) {
                if (event.which == 13) {
                    $.msgqueue.initGrid();
                }
            });
        },
        refreshMessageFromHub: function (model) {
            var refreshFlag = $('#MessageHubRefreshFlag').val();
            if (model != null && model.RefreshLocation == refreshFlag) {
                /*console.log('refreshMessageFromHub :' + model.RefreshLocation);*/
                $.msgqueue.initGrid();
            }
        }
    };
})(window.jQuery);