﻿(function ($) {
    var importUserValidation = function () {

        $('#formSubmit').validate({
            ignore: ".ignored",
            ignoreTitle: true,
            errorPlacement: function (error, element) {
                var p = element.parent(".dropify-wrapper");
                if (p.length) {
                    error.insertAfter(p);
                }
                else {
                    error.insertAfter(element);
                }
            },
            rules: {
                ImportFile: {
                    required: true,
                    noSpace: true
                },
                TableName: {
                    required: true,
                    noSpace: true
                },
                ControlFile: {
                    required: true,
                    noSpace: true
                },
                UserPassword: {
                    required: true,
                    noSpace: true,
                    passwordFormat: true
                },
                RoutePriority: {
                    number: true,
                    noSpace: true
                },
                RouteLength: {
                    number: true,
                    noSpace: true
                }
            },
            submitHandler: function (form) {
                if (errorMsg !== '') {
                    $('#ImportFile-error').html('*Invalid File. ' + errorMsg);
                    $('#ImportFile-error').show();
                } else {
                    /* 1 = CSV, 2 = accdb,mdb */
                    if ($('#FileType').val() === '2') {
                        if ($('#TableName').val() !== '')
                            $.importuser.AccessFileReader('#ImportFile');
                    } else {
                        $.importuser.import();
                    }
                }
            }
        });
        $('#formSubmit-FaxcoreHeader').validate({
            rules: {
            },
            messages: {

            },
            submitHandler: function (form) {
                $.importuser.save();
            }
        });
    };

    var fileType;
    var FileList = {
        'Header': {},
        'Content': "",
        'HeaderList': "",
        'Data': [],
        'Path': "",
        'FullFile': ""
    };
    var errorMsg = '';
    $.importuser = {
        init: function (e) {

            $('#Domain-ddl').val($('#dashboardText').text());
            $("#Domain-id").val($('#dashboardID').val());

            var objDomainSelection = {};
            objDomainSelection.expandAll = true;
            objDomainSelection.declareType = "textbox";
            treeview.init("obTree", "DomainName", "DomainID", objDomainSelection);

            $.sectionproperties.FirstLevel($('.btn-back2'));
            $.importuser.importHandler($('.btn-import'));
            $.importuser.resetHandler($('.btn-Reset'));
            $.importuser.saveHandler($('.btn-save2'));

            importUserValidation();
            $.importuser.default();

            $('#ImportFile').on('change', function () {

                fileType = this.files[0] === undefined ? '' : this.files[0].name.split('.').pop();
                errorMsg = '';
                $('#ImportFile-error').html('');
                $('#ImportFile-error').hide();

                if (fileType === 'csv') {
                    $('#FileType').val(1);
                    $('#FileType').trigger('change');
                    $.importuser.CSVFileReader(this);
                }
                if (fileType === 'accdb' || fileType === 'mdb') {
                    $('#FileType').val(2);
                    $('#FileType').trigger('change');
                    $('#TableName').val('');
                }
            });

            $('.info-tooltip').tooltip();

            $.importuser.resetfields();
        },
        default: function () {
            fxcRequest.get('/Admin/ImportUsers/Default',
                null,
                function (data) {
                    $.sectionproperties.selectGenerator('PreferAddressType', data.PreferAddressType.Source, 1, 0);
                    $.sectionproperties.selectGenerator('UserRole', data.UserRole.Source, data.UserRole.Value, 0);
                },
                function (error) {
                    swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnSelect, "error");
                }
            );
        },
        getFileProperty: function (input) {
            var name = document.getElementById(input);
            var type = input === 'ControlFile' ? '' : name.files.item(0).type.toString().toLowerCase();
            var path = (input === 'ControlFile' || type === 'csv') ? $('#' + input).val() : FileList.Path;
            try {
                return {
                    'name': name.files.item(0).name,
                    'size': name.files.item(0).size,
                    'type': type,
                    'Path': path,
                    'FileData': FileList.Data,
                    'FullFile': FileList.FullFile
                };
            }
            catch (err) {
                return "";
            }
        },
        constructmodel: function (e) {
            var imports;
            var formColumnHeaderData = JSON.stringify($("#formSubmit-FaxcoreHeader").serializeArray());
            switch (e) {
                case 0:
                    return {
                        'FormColumnHeaderData': formColumnHeaderData,
                        'DomainID': $('#DomainID').val(),
                        'DomainName': $('#DomainName').val(),
                        'FileSelected': $.importuser.getFileProperty("ImportFile"),
                        'HeaderFormat': $('#HeaderFormat').val(),
                        'ControlFile': $.importuser.getFileProperty("ControlFile"),
                        'FileType': $('#FileType').val(),
                        'HasHeader': $('#Header').prop('checked'),
                        'DelimiterFormat': $('#DelimiterFormat').val(),
                        'CustomDelimiterFormat': $('#CustomDelimiterFormat').val(),
                        'TableName': $('#TableName').val(),
                        'UserPassword': $('#UserPassword').val(),
                        'UserRole': $('#UserRole').val(),
                        'FileAttachmentFormat': $('#FileAttachmentFormat').prop('checked'),
                        'ReceiveNotification': $('#ReceiveNotification').prop('checked'),
                        'SendNotification': $('#SendNotification').prop('checked'),
                        'Authentication': $('#Authentication').val(),
                        'RouteField': $('#RouteField').val(),
                        'RoutePriority': $('#RoutePriority').val(),
                        'PrefixRoute': $('#PrefixAppendRoute').val(),
                        'RouteLength': $('#RouteLength').val()
                    };
                /*break;*/
                default:
                    break;
            }
        },
        resetfields: function () {
            $('#formSubmit').trigger("reset");
            $("#obTree").tree().unselectAll();
            $("#DomainID").val($('#dashboardID').val());
            var getUserData = $("#obTree").tree().getNodeById($("#DomainID").val());

            if (getUserData != undefined) {
                $("#obTree").tree().select(getUserData);
            }

            /* Remove uploaded file */
            var drop = $('#ImportFile').dropify({ allowedFileExtensions: ['csv', 'txt', 'mdb', 'accdb'] });
            drop = drop.data('dropify');
            drop.resetPreview();
            drop.clearElement();

            $('#HeaderFormat').val(1);
            $('#FileType').val(1);
            $('#UserPassword').val('');
            $('#UserRole').selectedIndex = 4;

            $('input#Header').bootstrapSwitch('state', true);
            $('input#ReceiveNotification').bootstrapSwitch('state', false);
            $('input#SendNotification').bootstrapSwitch('state', false);

            $('#RouteField').val('');
            $('#PrefixAppendRoute').val('');
            /*$('#RoutePriority').val('');
              $('#RouteLength').val('');*/

            if ($('.HiddenFileType1').hasClass('hide')) {
                $('.HiddenFileType1').removeClass('hide');
                $('.HiddenFileType2').addClass('hide');
            }

            $('#DelimiterFormat').val('CSVDelimited').change();
        },

        /* BTN Action */
        importHandler: function (e) {

            $(e).on('click', function () {
                $("#formSubmit").submit();
            });
        },
        resetHandler: function (e) {
            $(e).on('click', function () {
                $.importuser.resetfields();
            });
        },
        saveHandler: function (e) {
            $(e).on('click', function () {
                $("#formSubmit-FaxcoreHeader").submit();
            });
        },
        CSVFileReader: function (Selectedfile) {
            fxcRequest.upload('/Admin/ImportUsers/Upload', $(Selectedfile),
                {
                    TableName: 'User'
                },
                function (data) {
                    FileList.HeaderList = data.HeaderList;
                    FileList.Data = data.FileSelected.FileData;
                    FileList.Path = data.FileSelected.Path;
                    FileList.FullFile = data.FullFile;

                    $.importuser.isValidImportedFile();
                }, showLoader = false);
        },
        AccessFileReader: function (Selectedfile) {
            fxcRequest.upload('/Admin/ImportUsers/Upload', $(Selectedfile),
                {
                    TableName: $('#TableName').val()
                },
                function (data) {
                    FileList.HeaderList = data.HeaderList;
                    FileList.Data = data.FileSelected.FileData;
                    FileList.Path = data.FileSelected.Path;
                    FileList.FullFile = data.FullFile;

                    $.importuser.isValidImportedFile();
                    swal.close();
                    $.importuser.import();

                }, showLoader = false);
        },
        getFileData: function (Selectedfile) {
            var file = Selectedfile.files[0];

            var reader = new FileReader();
            reader.onload = function () {

                var arrayBuffer = this.result,
                    array = new Uint8Array(arrayBuffer),
                    binaryString = String.fromCharCode.apply(null, array);

                var tempfilearray = binaryString.split('\n');
                for (i = 0; i < tempfilearray.length; i++) {
                    if (i == 1) {
                        binaryString = tempfilearray[i] + '[';
                    } else if (i > 1) {
                        if (i == tempfilearray.length - 1) {
                            binaryString = binaryString + tempfilearray[i];
                        }
                        else {
                            binaryString = binaryString + tempfilearray[i] + '\n';
                        }
                    }
                }
                FileList.Data = binaryString;
            };
            reader.readAsArrayBuffer(file);
        },
        isValidImportedFile: function () {
            var usersList = JSON.parse(FileList.FullFile);
            var length = usersList.length;
            var message = '';

            for (var i = 0; i < length; i++) {
                if ((usersList[i].UserName == null || usersList[i].UserName == '') && message.indexOf('UserName') === -1) message += 'UserName, ';
                if ((usersList[i].Email == null || usersList[i].Email == '') && message.indexOf('Email') === -1) message += 'Email, ';
                if ((usersList[i].PreferAddressType == null || usersList[i].PreferAddressType == '') && message.indexOf('PreferAddressType') === -1) message += 'PreferAddressType, ';
            }

            if (message.length > 0) {
                var errorCount = message.split(",").length == 2 ? 'is' : 'are';
                var column = errorCount == 'are' ? ' values ' : ' value ';
                errorMsg = message.substring(0, message.length - 2) + column + errorCount + ' required.';
            }
        },
        PopulateCSVValue: function (ContentList) {
            $.sectionproperties.selectGeneratorUsingArray('Header_UserName', ContentList, "UserName", 0);
            $.sectionproperties.selectGeneratorUsingArray('Header_DisplayName', ContentList, "DisplayName", 0);
            $.sectionproperties.selectGeneratorUsingArray('Header_FirstName', ContentList, "FirstName", 0);
            $.sectionproperties.selectGeneratorUsingArray('Header_MiddleName', ContentList, "MiddleName", 0);
            $.sectionproperties.selectGeneratorUsingArray('Header_LastName', ContentList, "LastName", 0);
            $.sectionproperties.selectGeneratorUsingArray('Header_CompanyName', ContentList, "CompanyName", 0);
            $.sectionproperties.selectGeneratorUsingArray('Header_Email', ContentList, "Email", 0);
            $.sectionproperties.selectGeneratorUsingArray('Header_Fax', ContentList, "Fax", 0);
            $.sectionproperties.selectGeneratorUsingArray('Header_Http', ContentList, "Http", 0);
            $.sectionproperties.selectGeneratorUsingArray('Header_FTP', ContentList, "FTP", 0);
            $.sectionproperties.selectGeneratorUsingArray('Header_File', ContentList, "File", 0);
            $.sectionproperties.selectGeneratorUsingArray('Header_Printer', ContentList, "Printer", 0);
            $.sectionproperties.selectGeneratorUsingArray('Header_Mobile', ContentList, "Mobile", 0);
            $.sectionproperties.selectGeneratorUsingArray('Header_FaxRaw', ContentList, "FaxRaw", 0);
            $.sectionproperties.selectGeneratorUsingArray('Header_Phone', ContentList, "Phone", 0);
            $.sectionproperties.selectGeneratorUsingArray('Header_Route', ContentList, "Route", 0);
            $.sectionproperties.selectGeneratorUsingArray('Header_Description', ContentList, "Desc", 0);
            $.sectionproperties.selectGeneratorUsingArray('Header_Password', ContentList, "Password", 0);
            $.sectionproperties.selectGeneratorUsingArray('Header_Role', ContentList, "Role", 0);
            $.sectionproperties.selectGeneratorUsingArray('Header_FileFormat', ContentList, "FileFormat", 0);
            $.sectionproperties.selectGeneratorUsingArray('Header_PreferAddressType', ContentList, "PreferAddressType", 0);
            $.sectionproperties.selectGeneratorUsingArray('Header_ReceiveNotify', ContentList, "ReceiveNotify", 0);
            $.sectionproperties.selectGeneratorUsingArray('Header_SendNotify', ContentList, "SendNotify", 0);
            $.sectionproperties.selectGeneratorUsingArray('Header_Authentication', ContentList, "Authentication", 0);
            $.sectionproperties.selectGeneratorUsingArray('Header_RouteField', ContentList, "RouteField", 0, true);
            $.sectionproperties.selectGeneratorUsingArray('Header_RoutePriority', ContentList, "RoutePriority", 0, true);
            $.sectionproperties.selectGeneratorUsingArray('Header_RoutePrefix', ContentList, "RoutePrefix", 0, true);
            $.sectionproperties.selectGeneratorUsingArray('Header_RouteLength', ContentList, "RouteLength", 0, true);
            $.sectionproperties.selectGeneratorUsingArray('Header_LocalCSID', ContentList, "LocalCSID", 0);
            $.sectionproperties.selectGeneratorUsingArray('Header_LocalCallerID', ContentList, "LocalCallerID", 0);
            $.sectionproperties.selectGeneratorUsingArray('Header_CoverPage', ContentList, "CoverPage", 0);
            $.sectionproperties.selectGeneratorUsingArray('Header_Priority', ContentList, "Priority", 0);
            $.sectionproperties.selectGeneratorUsingArray('Header_LocalNumber', ContentList, "LocalNumber", 0);
        },
        /* Post or Get Request */
        import: function () {
            $.sectionproperties.SecondLevel();
            $.importuser.PopulateCSVValue(FileList.HeaderList);
        },
        save: function () {
            $.sectionproperties.FirstLevelView();
            fxcRequest.post('/Admin/ImportUsers/Import',
                $.importuser.constructmodel(0),
                function (data) { 
                    swal($globalMessages.swal.success.title, data.result, "success");
                },
                function (error) {
                    swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnImport, "error");
                }
            );
        }
    };
})(window.jQuery);
