﻿var interval = 60;
var maxTime = "23:00";
var purgeTime = $("#PurgeTime");

var purgesettingsValidation = function () {
    $('#formSubmit').validate({
		ignoreTitle: true,
		rules: {
			PurgeTime: {
				required: true,
				noSpace: true
			},
			PurgeDay: {
				required: true,
				number: true
			}
        },
		errorPlacement: function (error, element) {
			var p = element.parent('span').parent();
			if (p.hasClass('form-control')) {
				error.appendTo(p);
			} else {
				error.insertAfter(element);
			}
		},
        submitHandler: function (form) {

            if ($('input[name="form-action"]').val() === '1')
                $.purgesettings.save();
            else
                $.purgesettings.applyall();
        }
    });
};
$.purgesettings = {
    init: function (e) {
        $("#PurgeDay").mask('999999999999999999999999');

        $('.btn-save').on('click', function () {
            $('input[name="form-action"]').val("1");
            $("#formSubmit").submit();
        });

        $('.btn-apply-all').on('click', function () {
            $('input[name="form-action"]').val("2");
            $("#formSubmit").submit();
        });

        $.purgesettings.initDateTime();

        purgesettingsValidation();
    },
    initDateTime: function (e) {
        purgeTimeControl = purgeTime.kendoTimePicker({
            interval: interval,
			format: "HH:mm"
        }).data("kendoTimePicker");

        purgeTimeControl.max(maxTime);
    },
    save: function () {
        $("#PurgeTime").val($.purgesettings.formatTime(purgeTime));

        var formData = JSON.stringify($("#formSubmit").serializeArray());
        fxcRequest.post('/Admin/PurgeSettings/Save'
            , {
                FormData: formData,
                Action: 1,
                IsActive: $('#IsActive').prop('checked'),
				LastPurgeDate: $('#LastPurgeDate').val(),
				PurgeTime: $("#PurgeTime").val(),
				PurgeDay: $("#PurgeDay").val(),
            }
            , function () {
                var days = $('#PurgeDay').val();
                $('#PurgeDay').prop('title', $purgeResource.purgeDataOlderThanJS + " " + days + " " + $purgeResource.days);
                swal($globalMessages.swal.success.title, $globalMessages.swal.success.text, "success");
            }
            , function (error) {
                swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnSubmit, "error");
            });
    },
    /* Logic */
    formatTime: function (control) {
        var time = control.data("kendoTimePicker").value();

        if (time == null && control.val().length > 0) {
            control.kendoTimePicker({
                value: control.val()
            });
        }

        if (time != null) {
            var hour = time.getHours();
            var minutes = time.getMinutes();

            hour = ("0" + hour).slice(-2);
            minutes = ("0" + minutes).slice(-2);
            return hour + ":" + minutes;
        } else {
            return control.val();
        }
    },
    applyall: function () {
        $("#PurgeTime").val($.purgesettings.formatTime(purgeTime));

        var formData = JSON.stringify($("#formSubmit").serializeArray());
        fxcRequest.post('/Admin/PurgeSettings/Save'
            , {
                FormData: formData,
                Action: 2,
                IsActive: $('#IsActive').prop('checked'),
                LastPurgeDate: $('#LastPurgeDate').val(),
				PurgeTime: $("#PurgeTime").val(),
                PurgeDay: $("#PurgeDay").val()
            }
            , function (data) {
                swal($globalMessages.swal.success.title, $purgeResource.swal.succesApply, "success");
            }
            , function (error) {
                swal($globalMessages.swal.error.errorCap, $purgeResource.swal.errOnApply, "error");
            });
    },
};