﻿(function ($) {
    var defaultFormat = $("#defaultDateFormat").val() + " " + $("#defaultTimeFormat").val();
    var defaultStartDate = moment().startOf('day').format(defaultFormat);
    var defaultEndDate = moment().endOf('day').format(defaultFormat);

    var drPicker;

    var linkClass = '.Link';
    var selectedApiUrl = null;
    var selectedExportApiUrl = null;
    var selectedViewControl = null;
    var selectedViewName = '';
    var selectedShowDomain = 0;
    var gridId = '#grid';
    var reportGrid;
    var selectedExportType = '';

    var reportGroupList;
    var reportViewList;

    var groupTemplate;
    var reportLinkTemplate;
    var maxPdfClientExportData = 500;
    var maxExcelClientExportData = 40000;
    var maxCsvClientExportData = 100000;
    var requestModel;
    var reportTitle;
    
    $.adminReports = {
        init: function () {
            $('#ReportGroupList').hide();
            $('#notAvailableContent').hide();

            $.adminReports.getReportList();
            $.sectionproperties.FirstLevel($('.btn-back2'));
            $.adminReports.generateClickHandler($('#view1GenerateBtn'));
            $.adminReports.exportToPdfHandler($('#exportPdfBtn'));
            $.adminReports.exportToExcelHandler($('#exportExcelBtn'));
            $.adminReports.exportToCsvHandler($('#exportCsvBtn'));
            $.adminReports.searchBtnHandler($('#searchButtonReport'));
            $.adminReports.searchPressEnter($('#searchBoxReport'));
        },
        /*Btn Action*/
        searchBtnHandler: function (e) {
            $(e).click(function () {
                $.adminReports.getReportList($('#searchBoxReport').val());
            });
        },
        searchPressEnter: function (e) {
            $(e).on('keypress', function (enter) {
                if (enter.which === 13) {
                    $.adminReports.getReportList($(this).val());
                }
            });
        },
        linkClickHandler: function (e) {
            $(e).on('click', function () {
                $.sectionproperties.SecondLevel();

                /*determine view and post url*/
                selectedApiUrl = $(this).data('apiurl');
                selectedExportApiUrl = $(this).data('exportapiurl');
                selectedViewName = $(this).data('reportview');

                var title = $(this).text();

                $('.reportview-breadcrumb-item').text(title);                
                
                $('.reportview').hide();
                selectedViewControl = $('.' + selectedViewName);

                selectedDomain = $(this).data('showDomain');

                if (selectedDomain) {
                    $('#domain-label', selectedViewControl).html($adminReportUtilResource.Domain + " : <b>" + $('#domainName').val() + "</b>");
                    $('#includeSubDomain-wrapper input').prop("checked", false);
                    $('#includeSubDomain-wrapper').show();
                } else {
                    $('#domain-label', selectedViewControl).text("");
                    $('#includeSubDomain-wrapper').hide();
                }

                selectedViewControl.show();

                $('.domainuserselection', selectedViewControl).on('click', function () {
                    $('#modal-ReportUserSelection').modal('show');
                });

                if ($('#Domain.TreeView', selectedViewControl).length > 0) {
                    $.adminReports.initTreeViewDomain();
                }

                $.adminReports.initDateTime($('#reportrange', selectedViewControl));

                if ($('#filter-dropdown', selectedViewControl).length > 0) {
                    $('.faxcoreContent', selectedViewControl).css('overflow', 'visible');

                    /* Prevent dropdown to be closed when clicking inside the menu */
                    $('#filter-dropdown .dropdown-menu, #modal-ReportUserSelection', selectedViewControl).on('click', function (e) {
                        e.stopPropagation();
                    });

                    $(document).delegate("#filter-dropdown .select2-results__option", "click", function (e) {
                        e.stopPropagation();
                    });

                    /* Open dropdown on load */
                    setTimeout(function () {
                        $('#filter-dropdown .dropdown-toggle', selectedViewControl).click();
                    }, 50);

                    /* Add disabled view to grid when dropdown is opened */
                    $('#filter-dropdown', selectedViewControl).on({
                        "show.bs.dropdown": function () {
                            $(gridId, selectedViewControl).addClass("k-state-disabled");
                        },
                        "hide.bs.dropdown": function () {
                            $(gridId, selectedViewControl).removeClass("k-state-disabled");
                        }
                    });
                }
                
                if (selectedViewName == "Default") {
                    $('#includeSubDomain_Default').prop('checked', false).change();

                    if (selectedApiUrl == '/api/owner/report') {
                        $('#userInput').show();
                    } else {
                        $('#userInput').hide();
                    }
                }
                else if (selectedViewName == "FaxHistory")
                {
                    let currentDomainId = $('#domainId').val();
                    $.faxHistoryReport.initUsers(currentDomainId);
                }
                else {
                    $('#userInput').hide();
                }   

                var currentGrid = $(gridId, selectedViewControl);
                var isGridInit = currentGrid.data("kendoGrid") != null;
                if (currentGrid && isGridInit) {
                    currentGrid.data("kendoGrid").destroy();
                    currentGrid.empty();
                    currentGrid.removeClass();
                }
            });
        },
        generateClickHandler: function (e) {
            $(e).on('click', function () {

                $.adminReports.populateFormData();

            });
        },
        exportToPdfHandler: function (e) {
            $(e).click(function () {

                selectedExportType = '.pdf';

                var gridData = $(gridId, selectedViewControl).data('kendoGrid');
                if (!$.adminReports.isEmptyGrid(gridData)) {
                    $.adminReports.disableExportButton();
                    var total = gridData.dataSource.total();
                    if (total > maxPdfClientExportData) {

                        $.adminReports.serverExport(gridData);

                    } else {
                        $.adminReports.serverExport(gridData, true);
                    }
                }
            });
        },
        exportToExcelHandler: function (e) {
            $(e).click(function () {

                selectedExportType = '.xlsx';

                var gridData = $(gridId, selectedViewControl).data('kendoGrid');
                if (!$.adminReports.isEmptyGrid(gridData)) {
                    $.adminReports.disableExportButton();
                    var total = gridData.dataSource.total();
                    if (total > maxExcelClientExportData) {

                        $.adminReports.serverExport(gridData);

                    } else {
                        gridData.saveAsExcel();
                        $.adminReports.disableExportButton(false);
                    }
                }
            });
        },
        exportToCsvHandler: function (e) {
            $(e).click(function () {

                selectedExportType = '.csv';
                var gridData = $(gridId, selectedViewControl).data('kendoGrid');
                if (!$.adminReports.isEmptyGrid(gridData)) {
                    $.adminReports.disableExportButton();
                    var total = gridData.dataSource.total();
                    if (total > maxCsvClientExportData) {
                        console.log(gridData);
                        $.adminReports.serverExport(gridData);
                    } else {
                        console.log(gridData);
                        $.adminReports.kendoGridToCSV(gridData);
                    }
                }
            });
        },
        /*End Btn Action*/
        /* Logic */
        disableExportButton: function (disable) {
            if (typeof disable === "undefined") {
                disable = true;
            }
            $('#view1ExportBtn').prop('disabled', disable);
        },
        initGrid: function (gridControl, apiUrl, reportview, requestModel) {

            /*retrive column from reportViewList*/
            var filterArray = $.grep(reportViewList, function (obj, index) {
                return obj.Url === apiUrl;
            });
            
            var viewObj = filterArray[0];
            var col = viewObj.Column;
            reportTitle = viewObj.Title;
            
            /*init kendo grid*/
            var id = gridControl;

            var dataSource = {
                transport: {
                    read: {
                        beforeSend: function (xhr) {
                            xhr.setRequestHeader('AuthorizeId', $('#authcode').val());
                        },
                        url: '/Admin/Report/Read',
                        dataType: "json",
                        type: "POST"
                    },
                    parameterMap: function (options) {
                        
                        if (!requestModel) {
                            requestModel = {};
                        }
                        requestModel.FileData = {};
                        requestModel.Skip = options.skip;
                        requestModel.Take = options.take;
                        requestModel.Page = options.page;
                        requestModel.Sort = options.sort; 
                        if (options.sort !== undefined && options.sort.length >= 0 && options.sort[0] !== undefined && options.sort[0] !== null) {
                            requestModel.Direction = options.sort[0].dir;
                        }

                        if (options.sort && options.sort.length > 0) {
                            requestModel.SortBy = options.sort[0].field;
                        }
                        var dataparams = new Array();
                        $.each(requestModel, function (key, obj) {
                            
                            if (obj) {
                                if (obj.constructor === {}.constructor) {
                                    $.each(obj, function (sub, internal) {
                                        dataparams.push({
                                            name: key + '.' + sub,
                                            value: internal
                                        });
                                    });
                                } else {
                                    dataparams.push({
                                        name: key,
                                        value: obj
                                    });
                                }
                            }

                        });
                        
                        requestModel['RequestParams'] = dataparams;
                        requestModel['AuthorizeId'] = $('#authcode').val();
                        requestModel['ApiUrl'] = apiUrl;
                        
                        return requestModel;
                    }
                },
                schema: {
                    data: function (response) {
                        var jsonObj = JSON.parse(response);
                        var data = [];
                        if (jsonObj.Data && jsonObj.Data.Records) {
                            data = jsonObj.Data.Records;
                        }
                        return data;
                    },
                    total: function (response) {
                        var jsonObj = JSON.parse(response);
                        var total = 0;
                        if (jsonObj.Data && jsonObj.Data.Total) {
                            total = jsonObj.Data.Total;
                        }
                        return total;
                    },
                    model: {
                        id: "Id"
                    }
                },
                serverPaging: true,
                serverSorting: true
            };

            var obj = {};
            obj.pdfSettings = {
                allPages: true,
                fileName: reportview + 'Report.pdf',
                paperSize: $('#pageType').val(),
                repeatHeaders: true,
                forcePageBreak: '.page-break',
                margin: '1cm',
                scale: 0.4
            };
            obj.excelSettings = {
                allPages: true,
                fileName: reportview + 'Report.xlsx'
            };

            obj.excelExport = $.adminReports.excelServerExport;

            kendogridcustomization.init(id, dataSource, col, obj);
            
        },
        initDateTime: function (e, parentEl) {
            var start = moment().startOf('day');
            var end = moment().endOf('day');
            var parentEl = $('#filter-dropdown', selectedViewControl).length ? "." + selectedViewName + " #filter-dropdown" : "";

            function setDateCallback(start, end, chosenLabel) {
                var label = start.format(defaultFormat) + ' - ' + end.format(defaultFormat);
                if (chosenLabel !== 'Custom Range') label = chosenLabel;
                var control = $('span', $(e));
                control.html(label);
            }

            $(e).daterangepicker({
                startDate: defaultStartDate,
                endDate: defaultEndDate,
                ranges: {
                    'Today': [moment().startOf('day'), moment().endOf('day')],
                    'Last 7 Days': [moment().subtract(6, 'days').startOf('day'), moment().endOf('day')]
                },
                timePicker: true,
                timePickerIncrement: 1,
                timePickerSeconds: true,
                locale: {
                    format: defaultFormat
                },
                parentEl: parentEl
            }, setDateCallback);

            setDateCallback(start, end, "Today");

            drPicker = $(e).data('daterangepicker');
        },
        getReportApiUrl: function (url) {
            return $("#ReportApiBaseUrl").val() + url;
        },
        generateTemplate: function (data) {
            
            var sectionId = '#ReportGroup';

            if (!groupTemplate) {
                var template = $(sectionId);
                groupTemplate = template[0].outerHTML;
            }
            
            if (!reportLinkTemplate) {
                var linkTemplate = $('#Link');
                reportLinkTemplate = linkTemplate[0].outerHTML;
            }
            
            /*Generate Html*/
            $('#ReportGroupList').html('');
            for (j = 0; j < data.length; j++) {
                $('#ReportGroupList').append(groupTemplate);
            }

            /*Bind Value*/
            for (j = 0; j < data.length; j++) {
                var group = data[j];
                var container = $('.ReportGroup')[j];
                
                /*set title*/
                var Title = $('#Title', $(container));
                Title.text(group.Title);
                var urls = group.Urls;

                $.adminReports.mapLink(urls, container, reportLinkTemplate);
                
            }
        },
        mapLink: function (urls, container, reportLinkTemplate) {
            /*set report list*/
            var reportLinks = $('#ReportLinks', $(container));
            reportLinks.html('');
            
            for (i = 0; i < urls.length; i++) {
                reportLinks.append(reportLinkTemplate);
            }

            for (i = 0; i < urls.length; i++) {
                var urlObj = urls[i];
                var linkcontainer = $(linkClass, $(reportLinks))[i];
                
                $(linkcontainer).text(urlObj.Title);
                $(linkcontainer).data('apiurl', urlObj.Url);
                $(linkcontainer).data('exportapiurl', urlObj.ExportUrl);
                $(linkcontainer).data('reportview', urlObj.View);
                $(linkcontainer).data('showDomain', urlObj.ShowDomain);
            }
        },
        isEmptyGrid: function (data) {
            if (data == null || data.dataItems().length === 0) {
                swal($globalMessages.swal.alert.oops, $adminReportUtilResource.swalEmptyGrid, "warning");
                return true;
            }
            return false;
        },
        removeMaxHeight: function () { /*fix for overlapping pager footer in pdf output*/
            reportGrid.find('.k-grid-content').css('max-height', '');
        },
        populateFormData: function () { 
            /*Get control from specific form*/
            var form = $('form', selectedViewControl);

            var start = drPicker.startDate.format('YYYY-MM-DD HH:mm:ss');
            var end = drPicker.endDate.format('YYYY-MM-DD HH:mm:ss');

            requestModel = {
                StartDate: start,
                EndDate: end,
                UsrID: $('#userId').val(),
                DmnID: $('#domainId').val(),
                TestDataSize: 300000,
                TimeZone: $('#userTimeZone').val(),
                DateFormat: $('#userDateFormat').val(),
                TimeFormat: $('#userTimeFormat').val()
                /*TestDataSize: 300000*/
            };

            if (selectedViewName == "Default") {
                requestModel.IncludeSubDomain = $('#includeSubDomain_Default').is(":checked");

                if (selectedApiUrl == '/api/owner/report') {
                    requestModel.Status = $('#Status', selectedViewControl).val();
                    requestModel.MsgDirection = $('#MsgDirection', selectedViewControl).val();
                    requestModel.IncludeNotify = $('#Notification', selectedViewControl).val();
                    requestModel.SenderName = $('#SenderName', selectedViewControl).val();
                    requestModel.MsgNo = $('#MessageNo', selectedViewControl).val();
                    requestModel.RecpName = $('#RecipientName', selectedViewControl).val();
                    requestModel.RecpAddr = $('#RecipientAddress', selectedViewControl).val();
                    requestModel.User = $('#User', selectedViewControl).val();

                } else {
                    requestModel.RStatus = $('#Status', selectedViewControl).val();
                    requestModel.RMsgDirection = $('#MsgDirection', selectedViewControl).val();
                    requestModel.RInclNotify = $('#Notification', selectedViewControl).val();
                    requestModel.RSenderName = $('#SenderName', selectedViewControl).val();
                    requestModel.RMsgNo = $('#MessageNo', selectedViewControl).val();
                    requestModel.RRecpName = $('#RecipientName', selectedViewControl).val();
                    requestModel.RRecpAddr = $('#RecipientAddress', selectedViewControl).val();
                }
            }
            else if (selectedViewName == "Top10") {
                requestModel.Top10ReportSelection = $('#Top10ReportSelection', selectedViewControl).val();
                requestModel.IncludeSubDomain = $('#includeSubDomain_Top10').is(":checked");
            }
            else if (selectedViewName == "DomainFax") {
                requestModel.DomainID = $('#Domain-id', selectedViewControl).val();
                requestModel.UserID = $('#userSelect', selectedViewControl).val();
                requestModel.MsgDirection = $('#MsgDirection', selectedViewControl).val();
                requestModel.IncludeSubDomain = $('#includeSubDomain_DomainFax').is(":checked");
            }
            else if (selectedViewName == "Activity") {
                requestModel.IncludeSubDomain = $('#includeSubDomain_Activity').is(":checked");
            }
            else if (selectedViewName == "FaxHistory") {
                requestModel.UserID = $('#userSelect_FaxHistory', selectedViewControl).val();
                requestModel.FaxNumber = $('#faxNumber_FaxHistory', selectedViewControl).val();
                requestModel.IncludeSubDomain = $('#includeSubDomain_FaxHistory').is(":checked");
            }
            
            reportGrid = $(gridId, selectedViewControl);
            $.adminReports.initGrid(reportGrid, selectedApiUrl, selectedViewName, requestModel);
        },
        kendoGridToCSV: function (grid) { /* source: https://daveaglick.com/posts/how-i-export-kendo-grids-to-excel-or-csv
             Get access to basic grid data*/
            var datasource = grid.dataSource;
            var originalPageSize = datasource.pageSize();
            var originalPage = datasource.page();
            var nl = '\n';
            /* Remove the success function since we don't care about what happens after we get the data
             (and the prototype success function causes problems when we copy the datasource over from the grid)*/
            datasource.success = function (data) {
                var csv = '';

                /* Add the header row*/
                for (var i = 0; i < grid.columns.length; i++) {
                    var title = grid.columns[i].title,
                        field = grid.columns[i].field;
                    if (typeof field === "undefined") { continue; /* no data! */ }
                    if (typeof title === "undefined") { title = field; }

                    title = title.replace(/"/g, '""');
                    csv += '"' + title + '"';
                    if (i < grid.columns.length - 1) {
                        csv += ",";
                    }
                }
                csv += nl;
                var $data = JSON.parse(data);
                /* Add each row of data*/
                $.each($data.Data.Records, function (index, row) {
                    /* Do a first pass to parse any dates (may eventually need to parse other types of received values here)*/
                    for (var i = 0; i < grid.columns.length; i++) {
                        var fieldName = grid.columns[i].field;
                        if (typeof fieldName === "undefined") { continue; }
                        if (typeof row[fieldName] === "string" && row[fieldName].lastIndexOf("/Date(", 0) === 0) {
                            row[fieldName] = kendo.parseDate(row[fieldName]);
                        }
                    }

                    /* Now generate the actual values*/
                    for (var k = 0; k < grid.columns.length; k++) {
                        var actualfieldName = grid.columns[k].field;
                        if (typeof actualfieldName === "undefined") { continue; }

                        /* Get the template and use it to get the display value*/
                        var tmpl = grid._cellTmpl(grid.columns[k], {});
                        var kt = kendo.template(tmpl);
                        value = kt(row);

                        /* Strip any HTML (needs to be inclosed in an outer tag to work)
                         Also strip any elements with the 'no-export' class
                         Also remove any label elements since they get used often in links*/
                        var html = $('<div>' + value + '</div>');
                        html.find('.label').remove();
                        html.find('.no-export').remove();
                        value = html.text().trim();

                        /* Format for CSV (escape quotes and add the comma)*/
                        value = value.replace(/"/g, '""');
                        csv += '"' + value + '"';
                        if (k < grid.columns.length - 1) {
                            csv += ",";
                        }
                    }
                    csv += nl;
                });

                /* Send the CSV content back to the server to generate a download link
                postToURL("/CsvToExcel", { data: csv });*/
                var csvBlob = new Blob([csv], { type: encodeURI('text/csv;base64,') });

                /*window.open(kendo.htmlEncode('data:text/csv;charset=utf-8,') + kendo.htmlEncode(csv));*/

                /*var dataUri = encodeURI('data:text/csv;base64,') + csv;*/

                kendo.saveAs({
                    /*dataURI: dataUri,*/
                    dataURI: csvBlob,
                    fileName: reportTitle + '.csv'
                });

                /*enable button*/
                $.adminReports.disableExportButton(false);

                /* Reset back to original values and reset the datasource*/
                datasource.pageSize(originalPageSize);
                datasource.page(originalPage);
                delete datasource.success;

                /* Reset the datasource now that we're done*/
                datasource._dequeueRequest();
                datasource.view();
            };

            /* Increase page size to cover all the data and then trigger fetching and processing of all the data*/
            datasource.pageSize(datasource.total());
            datasource.view();
        },
        excelServerExport: function (e) {
            /*override gridData.saveAsExcel method to cater pdf server export (this method provide Workbook data)*/
            /*determine server/client export for excel*/

            /*Prevent the default behavior which will prompt the user to save the generated file.*/
            e.preventDefault();
            /*var serverExportUrl = $.adminReports.getReportApiUrl(selectedExportApiUrl);*/
            var serverExportUrl = '/Admin/Report/ServerExport';
            var exportMessage = $adminReportUtilResource.ExportMsg;
            

            var sheet = e.workbook.sheets[0];
            var columns = sheet.columns;

            /*reset col with*/
            for (j = 0; j < columns.length; j++) {
                
                e.workbook.sheets[0].columns[j] = { autoWidth: true };
            }
            
            var dataURL = new kendo.ooxml.Workbook(e.workbook).toDataURL();

            /*Strip the data URL prologue.*/
            var filedata = {};
            filedata.Base64 = dataURL.split(";base64,")[1];
            filedata.ContentType = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
            
            var gridData = $(gridId, selectedViewControl).data('kendoGrid');
            if (!$.adminReports.isEmptyGrid(gridData)) {

                var total = gridData.dataSource._total;

                var filename = reportTitle;
                filedata.FileName = filename;
                filedata.FileExt = selectedExportType;
                if (selectedExportType == '.xlsx') {
                    if (total > maxExcelClientExportData) {

                        filedata.RequestObj = requestModel;
                        
                        /*Post the base64 encoded content to the server which can save it.*/
                        fxcRequest.post(serverExportUrl,
                            filedata,
                            function (data) {
                                
                            }, null, false, null, [{ name: "AuthorizeId", value: $('#authcode').val() }]);

                        swal(exportMessage);

                    } else {
                        /*download file*/
                        swal.close();

                        kendo.saveAs({
                            dataURI: dataURL,
                            fileName: filename + filedata.FileExt
                        });
                    }

                } else if (selectedExportType == '.pdf') { 
                    
                    /*PDF*/
                    fxcRequest.post(serverExportUrl,
                        filedata,
                        function (data) {
                            
                        }, null, false, null, [{ name: "AuthorizeId", value: $('#authcode').val() }]);

                    swal(exportMessage);

                } else if (selectedExportType == '.csv') {
                    /*CSV*/
                    fxcRequest.post(serverExportUrl,
                        filedata,
                        function (data) {
                            
                        }, null, false, null, [{ name: "AuthorizeId", value: $('#authcode').val() }]);

                    swal(exportMessage);
                }
            }

            
        },
        serverExport: function (gridData, isReturnFile) {
            
            swal({
                title: $adminReportUtilResource.swalServerExport,
                text: $adminReportUtilResource.swalProcData,
                imageUrl: '/Content/img/ajax-loading2.gif',
                showConfirmButton: false,
                closeOnClickOutside: false
            });

            var dataSource = gridData.dataSource;

            var newRequestModel = requestModel;
            
            newRequestModel.FileData = { "IsServerExport" : true };
            newRequestModel.Take = dataSource.total();

            var url = dataSource.transport.options.read.url;

            /*retrive column from reportViewList*/
            var filterArray = $.grep(reportViewList, function (obj, index) {
                return obj.Url === selectedApiUrl;
            });

            var viewObj = filterArray[0];
            var col = viewObj.Column;
            var pageOrientation = viewObj.PageOrientation;
            var fontSize = viewObj.FontSize;
            var margins = viewObj.Margins;
            var scaleFactor = viewObj.ScaleFactor;
            var title = viewObj.Title;

            /*set export url*/
            var serverExportUrl = '/Admin/Report/ServerExport';
            var filename = title;

            var filedata = {};
            filedata.FileName = filename;
            filedata.FileExt = selectedExportType;
            filedata.Column = col;

            var dataparams = new Array();
            $.each(newRequestModel, function (key, obj) {

                if (obj) {
                    if (obj.constructor === {}.constructor) {
                        $.each(obj, function (sub, internal) {
                            dataparams.push({
                                name: key + '.' + sub,
                                value: internal
                            });
                        });
                    } else {
                        dataparams.push({
                            name: key,
                            value: obj
                        });
                    }
                }
                
            });
            
            filedata.RequestParams = dataparams;
            filedata.AuthorizeId = $('#authcode').val();
            filedata.ApiUrl = selectedApiUrl;

            if (pageOrientation) {
                filedata.PageOrientation = pageOrientation;
            }

            if (fontSize) {
                filedata.FontSize = fontSize;
            }

            if (margins) {
                filedata.Margins = margins;
            }

            if (scaleFactor) {
                filedata.ScaleFactor = scaleFactor;
            }

            if (isReturnFile) {
                filedata.IsReturnFile = true;
            } else {
                filedata.IsReturnFile = false;
            }

            $.adminReports.exportRawData(serverExportUrl, filedata, filedata.IsReturnFile);
        },
        initTreeViewDomain: function (e) {
            /* Text box: Domain Treeview */
            $("#Domain-id").val($('#dashboardID').val());
            var objDomainSelection = {};
            objDomainSelection.expandAll = true;
            objDomainSelection.declareType = "textbox";
            objDomainSelection.postSelectFn = $.adminReports.initUsers;
            var $treeview = treeview.init("Domain", "Domain-name", "Domain-id", objDomainSelection);
            
            $treeview.on('dataBound', function (e) {
                $('#Domain.TreeView').css('width', $('#Domain-ddl').innerWidth() + 'px');
            });

            $(window).resize(function () {
                $('#Domain.TreeView').css('width', $('#Domain-ddl').innerWidth() + 'px');

                if ($('#userSelect').hasClass("select2-hidden-accessible")) {
                    // Select2 has been initialized
                    $('#userSelect').select2('close');
                }
            });
        },
        initUsers: function (currentDomainId) {
            $('#userSelect').val(null);

            $("#userSelect").select2({
                placeholder: "All",
                allowClear: true,
                selectOnClose: true,
                language: {
                    // You can find all of the options in the language files provided in the
                    // build. They all must be functions that return the string that should be
                    // displayed.
                    errorLoading: function () {
                        return "Searching...";
                    }
                },
                dropdownParent: $('#filter-dropdown', selectedViewControl).length ? $('#filter-dropdown', selectedViewControl) : "",
                ajax: {
                    url: "/Common/GetUser/?Type=1&Areas=Admin",
                    dataType: 'json',
                    data: function (params) { /* page is the one-based page number tracked by Select2 */
                        var query = {
                            DomainId: currentDomainId,
                            SearchText: params.term,
                            Page: params.page || 1,
                            Limit: 15
                        }

                        /* Query parameters will be ?search=[term]&type=public */
                        return query;
                    },
                    processResults: function (data, params) {
                        params.page = params.page || 1;
                        var more = (params.page * data.Size) < data.Total /* whether or not there are more results available */

                        var items = $.map(data.UserList, function (obj) {
                            return {
                                id: obj.Id,
                                text: obj.UserName
                            };
                        });

                        /* notice we return the value of more so Select2 knows if more results can be loaded */
                        return {
                            results: items,
                            pagination: { more: more }
                        };
                    }
                }
            }).on('select2:open', function () {
                /* Prevent dropdown open at above */
                var selectInput = $('#select2-userSelect-container').parents('.select2-container');
                selectInput.removeClass('select2-container--above').addClass('select2-container--below');

                $('.select2-dropdown--above').attr('id', 'fix');
                $('#fix').removeClass('select2-dropdown--above');
                $('#fix').addClass('select2-dropdown--below');
            })
            .on('select2:unselecting', function () {
                /*Prevent dropdown being opened when unselect */
                $(this).data('unselecting', true);
            }).on('select2:opening', function (e) {
                if ($(this).data('unselecting')) {
                    $(this).removeData('unselecting');
                    e.preventDefault();
                }
            });
        },
        /* End Logic */
        /*Post or Get Function*/
        getReportList: function (filter) {

            var model = {};
            if (filter) {
                model['RequestParams'] = [{
                    name: 'filter',
                    value: filter
                }];
            }
            
            model['AuthorizeId'] = $('#authcode').val();
            model['ApiUrl'] = '/api/report/grouplist';

            fxcRequest.post('/Admin/Report/Read',
                model,
                function (data) {
                    data = JSON.parse(data);

                    if (data && data.Status && data.Status == "Success") {
                        reportGroupList = data.Data;

                        if (reportGroupList.length > 0) {
                            $.adminReports.toggleAvailableReport(true);
                        } else {
                            $.adminReports.toggleAvailableReport(false);
                        }

                        /*merge all view*/
                        reportViewList = [];
                        for (j = 0; j < reportGroupList.length; j++) {
                            var group = reportGroupList[j];
                            reportViewList = reportViewList.concat(group.Urls);
                        }
                                                
                        $.adminReports.generateTemplate(reportGroupList);
                        $.adminReports.linkClickHandler($(linkClass));
                    } else {
                        $.adminReports.toggleAvailableReport(false);
                    }
                }, null, false, null, [{ name: "AuthorizeId", value: $('#authcode').val() }]);
        },
        toggleAvailableReport: function (isAvailable) {
            if (isAvailable) {
                $('#ReportGroupList').show();
                $('#notAvailableContent').hide();
            } else {
                $('#ReportGroupList').hide();
                $('#notAvailableContent').show();
            }
        },
        exportRawData: function (url, model, isReturnFile) {

            if (!isReturnFile) {
                swal($adminReportUtilResource.ExportMsg);
            }

            fxcRequest.post(url,
                model,
                        function (data) {
                            
                            if (isReturnFile) {

                                if (data.Status === "Success") {
                                    swal.close();
                                    var dataURL = data.Data.DataUri;

                                    kendo.saveAs({
                                        dataURI: dataURL,
                                        fileName: data.Data.FileName + data.Data.FileExt
                                    });

                                } else {
                                    swal("ERROR!", data.Message, "error");
                                }

                            }
                            $.adminReports.disableExportButton(false);
                        }, null, false);
        }

    };

    $.faxHistoryReport = {
        initUsers: function (currentDomainId) {
            $('#userSelect_FaxHistory').val(null);

            $("#userSelect_FaxHistory").select2({
                placeholder: "All",
                allowClear: true,
                selectOnClose: true,
                language: {
                    // You can find all of the options in the language files provided in the
                    // build. They all must be functions that return the string that should be
                    // displayed.
                    errorLoading: function () {
                        return "Searching...";
                    }
                },
                dropdownParent: $('#filter-dropdown', selectedViewControl).length ? $('#filter-dropdown', selectedViewControl) : "",
                ajax: {
                    url: "/Common/GetUser/?Type=1&Areas=Admin",
                    dataType: 'json',
                    data: function (params) { /* page is the one-based page number tracked by Select2 */
                        var query = {
                            DomainId: currentDomainId,
                            SearchText: params.term,
                            Page: params.page || 1,
                            Limit: 15
                        }

                        /* Query parameters will be ?search=[term]&type=public */
                        return query;
                    },
                    processResults: function (data, params) {
                        params.page = params.page || 1;
                        var more = (params.page * data.Size) < data.Total /* whether or not there are more results available */

                        var items = $.map(data.UserList, function (obj) {
                            return {
                                id: obj.Id,
                                text: obj.UserName
                            };
                        });

                        /* notice we return the value of more so Select2 knows if more results can be loaded */
                        return {
                            results: items,
                            pagination: { more: more }
                        };
                    }
                }
            }).on('select2:open', function () {
                /* Prevent dropdown open at above */
                var selectInput = $('#select2-userSelect-container').parents('.select2-container');
                selectInput.removeClass('select2-container--above').addClass('select2-container--below');

                $('.select2-dropdown--above').attr('id', 'fix');
                $('#fix').removeClass('select2-dropdown--above');
                $('#fix').addClass('select2-dropdown--below');
            })
                .on('select2:unselecting', function () {
                    /*Prevent dropdown being opened when unselect */
                    $(this).data('unselecting', true);
                }).on('select2:opening', function (e) {
                    if ($(this).data('unselecting')) {
                        $(this).removeData('unselecting');
                        e.preventDefault();
                    }
                });
        },
    }

}) (window.jQuery);