﻿(function ($) {
	var setIsRtl = $("html[dir]").attr("dir") === "rtl" ? true : false;
    var tour = {
        id: "user-addressbook-default-hopscotch",
        steps: [
            {
                target: "button.btnNew",
                title: "",
                content: $globalMessages.uiGuide.buttonNew,
                placement: "bottom",
                xOffset: "5",
				yOffset: "-3",
				isRtl: setIsRtl
            },
            {
                target: "action-delete-grid",
                title: "",
                content: $globalMessages.uiGuide.buttonDelete,
                placement: "bottom",
                xOffset: "-12",
				yOffset: "-3",
				isRtl: setIsRtl
            },
            {
                target: "action-refresh-grid",
                title: "",
                content: $globalMessages.uiGuide.buttonRefresh,
                placement: "bottom",
                xOffset: "-12",
				yOffset: "-3",
				isRtl: setIsRtl
            },
            {
                target: "action-import",
                title: "",
                content: $globalMessages.uiGuide.buttonImportContact,
                placement: "bottom",
                xOffset: "-12",
				yOffset: "-3",
				isRtl: setIsRtl
            },
            {
                target: "mainDropDown",
                title: "",
                content: $globalMessages.uiGuide.buttonAction,
                placement: "bottom",
                xOffset: "6",
				yOffset: "-3",
				isRtl: setIsRtl
            },
            {
                target: "searchBox-grid",
                title: "",
                content: $globalMessages.uiGuide.buttonSearch,
                placement: "left",
                yOffset: "-12",
				xOffset: "2",
				isRtl: setIsRtl
            }
        ],
        showPrevButton: true
    };
    $.addressBookDefaultUiGuide = {
        init: function (opts) {
            $.sharedUiGuide.init({ startTourBtn: opts.tourBtn, tour: tour });
            $.sharedUiGuide.addClickListener(opts.btns, function () {
                hopscotch.endTour();
                $('#pageGuideBtn').unbind('click');
            });
        }
    };
})(window.jQuery);