﻿(function ($) {
    var $grid;
    var gridId = "#grid";
    var prevNav = {};

    $.addressBook = {
        init: function (e) {
            $.addressBook.initGrid($(gridId));
            $.addressBook.backButtonClickHandler();
            $.contact.createButtonClickHandler($("#btnAddContact"), true);
            $.contactGroup.createButtonClickHandler($("#btnAddGroup"), true);

            $.addressBook.deleteButtonClickHandler($('#action-delete-grid'));
            $.addressBook.importButtonClickHandler($('#action-import'));
            $.addressBook.moveToButtonClickHandler($('#mainDropDown'));
            $.addressBook.refreshButtonClickHandler($('#action-refresh-grid'));
            $.addressBook.searchPressEnter($('#searchBox-grid'));
            $.addressBook.searchButtonClickHandler($('#searchButton'));

            $.addressBook.searchPressEnter($('#searchBox-domain'));
            $.addressBook.searchButtonClickHandler($('#searchButton-domain'));

            $.addressBook.actionButtonClickHandler($('.btn-action'));
        },
        initGrid: function (e) {

            var addressBookId = $('input#addressBookId').val() + "";
            var addressBookName = $('input#addressBookName').val() + "";
            var addressBookType = $('#addressBook').val();
            var isExternal = $('#isExternal').val();
            var pageSize = parseInt($("#pageSize").val());

            /* Define if Domain AddressBook */
            if ($('#addressBook').val() === "domain")
                isDomainAddrBook = true;
            else
                isDomainAddrBook = false;
            /* End */

            var hideVisibility = false;
            var hideOwner = true;
            var hideAddress = true;
            var hideAddressType = true;
            var hideContactType = false;
            var hidePreferAddress = false;
            
            var id = e;
            /*search control*/
            var searchText = $("#searchBox-grid").val();
            if ("domainContactGrid" === e[0].id) {
                searchText = $('#searchBox-domain').val();
            }

            var dataSource;
            var obj;
            var col;

            /* External Address Book */
            if (isExternal == "True") {
                var url = "/User/Contact/ExternalList";

                dataSource = {
                    transport: {
                        read: {
                            url: url,
                            dataType: "json",
                            type: "GET"
                        },
                        parameterMap: function (options) {
                            var result = {
                                Id: addressBookId,
                                addressBookType: addressBookType,
                                SearchText: $("#searchBox-grid").val()
                            };

                            return result;
                        }
                    },
                    schema: {
                        data: "ContactList",
                        total: "Count",
                        model: {
                            id: "ContactId",
                            fields: {
                                DisplayName: { editable: false, type: "string", validation: { required: true } },
                                CompanyName: { editable: false, type: "string" },
                                Address: { editable: false, type: "string" },
                                AddressType: { editable: false, type: "string" },
                                NotifyAddress: { editable: true, type: "string" }
                            }
                        }
                    }
                };

                obj = {};
                obj.pageSize = pageSize;

                col = [
                    { field: "DisplayName", title: $areaResources.grid.displayName, width: 150 },
                    { field: "CompanyName", title: $areaResources.grid.companyName, width: 150 },
                    { field: "Address", title: $areaResources.grid.ddress, width: 150 },
                    { field: "AddressType", title: $areaResources.grid.addressType, width: 125 },
                    { field: "NotifyAddress", title: $areaResources.grid.notifyAddress, width: 125 }
                ];
            }
            /* Personal/Internal(Domain) Address Book */
            else {
                var serverPaging = true;
                var serverSorting = true;

                var url2 = "/User/Contact/List";

                if (addressBookType == "exchange") {
                    serverPaging = false;
                    serverSorting = false;
                    url2 = "/User/Contact/ExchangeContactList";
                }

                dataSource = {
                    transport: {
                        read: {
                            url: url2,
                            dataType: "json",
                            type: "GET"
                        },
                        parameterMap: function (options) {
                            /* Fix url param for sort values */
                            var result = {
                                SearchText: searchText,
                                AddressBookId: addressBookId,
                                AddressBookType: addressBookType,
                                Page: options.page,
                                Take: options.take,
                                Skip: options.skip
                            };
                            if (options.sort && options.sort.length > 0) {
                                result.SortBy = options.sort[0].field;
                                result.Direction = options.sort[0].dir;
                            }

                            return result;
                        }
                    },
                    schema: {
                        data: "ContactList",
                        total: "Count",
                        model: {
                            id: "ContactId",
                            fields: {
                                DisplayName: { editable: true, type: "string", validation: { required: true } },
                                ContactType: { editable: true, type: "string" },
                                ContactTypeId: { editable: true, type: "string" },
                                FirstName: { editable: true, type: "string" },
                                LastName: { editable: true, type: "string" },
                                CompanyName: { editable: true, type: "string" },
                                PreferAddress: { editable: true, type: "string" },
                                Visibility: { editable: true, type: "string" },
                                Owner: { editable: false, nullable: false, type: "string" },
                                Address: { editable: false, type: "string" },
                                AddressType: { editable: false, type: "string" }
                            }
                        }
                    },
                    serverPaging: serverPaging,
                    serverSorting: serverSorting
                };
                obj = {};
                col = [];

                obj.pageSize = pageSize;

                var NewHidden = false;
                var DeleteHidden = false;
                var ImportHidden = false;
                var MoveHidden = false;
                var ActionCustomHidden = false;

                /* Determine if shared contacts */
                if (addressBookId == 0) {
                    hideVisibility = true;
                    hideOwner = false;

                    NewHidden = true;
                    DeleteHidden = true;
                    ImportHidden = true;
                    MoveHidden = true;
                    ActionCustomHidden = true;
                }
                else if ($("#addressBook").val().indexOf('exchange') >= 0) {
                    hideAddress = false;
                    hideAddressType = false;
                    hideContactType = true;
                    hidePreferAddress = true;
                    hideVisibility = true;
                    NewHidden = true;
                    DeleteHidden = true;
                    ImportHidden = true;
                    MoveHidden = true;
                    ActionCustomHidden = true;
                }
                else {

                    /* Disable select in Domain Address Book */
                    if (!isDomainAddrBook) {
                        obj.onSelectionFn = $.addressBook.editHandler;
                        selectable = true;

                        var x = {
                            selectable: true,
                            width: "45px",
                            attributes: {
                                "class": "checkboxSelection"
                            }
                        };

                        col.push(x);
                    }
                }

                $.sectionproperties.Hidden("NewBtn", NewHidden);
                $.sectionproperties.Hidden("DeleteBtn", DeleteHidden);
                $.sectionproperties.Hidden("ImportBtn", ImportHidden);
                $.sectionproperties.Hidden("MoveBtn", MoveHidden);
                $.sectionproperties.Hidden("ActionCustomBtn", ActionCustomHidden);

                col.push(
                    { field: "DisplayName", title: $areaResources.grid.displayName, width: 150 },
                    { field: "ContactType", title: $areaResources.grid.contactType, width: 150, hidden: hideContactType },
                    { field: "FirstName", title: $areaResources.grid.firstname, width: 150 },
                    { field: "LastName", title: $areaResources.grid.lastname, width: 125 },
                    { field: "CompanyName", title: $areaResources.grid.companyName, width: 125 },
                    { field: "PreferAddress", title: $areaResources.grid.preferDeliveryAddress, width: 250, hidden: hidePreferAddress },
                    {
                        field: "Visibility",
						title: $areaResources.grid.visibility,
                        width: 150,
                        template: function (dataRow) {
                            var icon = '<i class="mdi mdi-check"></i>';
							var statusClass = dataRow.VisibilityID + "";

                            var result = '<div status="kendo-container">' +
                                '<span class="badge kendo-span-status badge-pill badge-visibility' + statusClass.toLowerCase() + '">' + dataRow.Visibility + '</span> ' +
                                '</div>';
                            return result;
                        },
                        hidden: hideVisibility
                    },
                    { field: "Owner", title: $areaResources.grid.owner, width: 150, hidden: hideOwner },
                    { field: "ContactTypeId", hidden: true },
                    { field: "Address", title: $areaResources.grid.address, width: 150, hidden: hideAddress },
                    { field: "AddressType", title: $areaResources.grid.addressType, width: 150, hidden: hideAddressType }
                );
            }
            
            obj.onDataBoundExtraFn = $.addressBook.grid_dataBound;
            $grid = kendogridcustomization.init(id, dataSource, col, obj);
        },
        grid_dataBound: function () {
            var editBtn = document.getElementById('action-edit');
            if (editBtn) editBtn.disabled = false;
        },

        /*Btn Action*/
        importButtonClickHandler: function (e) {
			$(e).on('click', function (x) {
				$('#SelectedAddressBook').val($('#addressBookId').val());
				$('#SelectedAddressBookType').val($("#addressBook").val());
				var addressBook = $('#addressBook').val();

				if (addressBook == 'domain') {
					$('#SelectedAddressBookDomain').val($("#ConfiguredDomainID").val());
				}

				$.importcontact.resetAddressBook();
                $.sectionproperties.ThirdLevel(e);
            });
        },
        moveToButtonClickHandler: function (e) {
			$("#moveDropDown").html("");
			$.addressBook.getMoveToActions();
        },
        refreshButtonClickHandler: function (e) {
            $(e).on('click', function (event) {
                $.addressBook.refresh();
                $(this).blur();
            });
        },
        searchButtonClickHandler: function (e) {
            $(e).on('click', function () {
                $.addressBook.search(e);
            });
        },
        searchPressEnter: function (e) {
            $(e).on('keypress', function (enter) {
                if (enter.which === 13) {
                    $.addressBook.search(e);
                }
            });
        },
        deleteButtonClickHandler: function (e) {
            $(e).on('click', function (enter) {
                $(this).blur();
                $.addressBook.delete();
            });
        },
        backButtonClickHandler: function (e) {
            $('.btn-back2, .btn-back3, .btn-back5').on('click', function (e) {
                $.sectionproperties.FirstLevelView(this);
                
                /* Refresh grid everytime after save*/
                /*$.addressBook.refresh();*/

                /* when adding contact or contactGroup */
                if ($(this).hasClass('btn-back2') || $(this).hasClass("btn-back5")) {
                    if ($(this).hasClass("btn-back5")) {
                        var contactGroupDetailGrid = $("#gridContactGroupDetails").data('kendoGrid');

						if (contactGroupDetailGrid)
							contactGroupDetailGrid.dataSource.data([]);
					}
					$.addressBook.refresh();
                }
            });
            $('.btn-back4').on('click', function (e) {
                $.sectionproperties.ThirdLevel(this);
            });
        },
        actionButtonClickHandler: function (e) {
            $(e).on('click', function () {
                commandID = $(this).data('command');

                var $selectedContacts = $.addressBook.getGridSelections($(gridId));

                if ($selectedContacts.length === 0) {
                    swal("", $areaResources.swal.noContactSelected);
                    return false;
                }

                var confirmationMsg = $(this).data('confirmationmsg');
                if (confirmationMsg) {
                    swal({
                        title: "",
                        text: confirmationMsg,
                        type: "info",
                        showCancelButton: true,
                        reverseButtons: true
                    }, function () {
                        $.addressBook.performAction(commandID, $selectedContacts);
                    });
                }
                else {
                    $.addressBook.performAction(commandID, $selectedContacts);
                }

                $(this).blur();
            });

        },

        /* Logic */
        refresh: function (e) {
            /*$grid.data("kendoGrid").dataSource.read();
            $grid.data("kendoGrid").refresh();*/

            /*Refresh grid by getting new data from database source*/
            var addressBook = $('#addressBook').val();
            var grid;

            if (addressBook == 'domain') {
                $('#searchBox-domain').val("");
                $.domainAddressBook.initGrid($('#domainContactGrid'));
            }
            else {
                $('#searchBox-grid').val("");
                $.addressBook.initGrid($(gridId));
            }
        },
        search: function (e) {
            var isExternal = $('#isExternal').val();
            var addressBookType = $('#addressBook').val();

            if (isExternal == "True" || addressBookType == "exchange") {
                var addressBook = e.attr('id');
                var val = $("#searchBox-grid").val();
                var grid = $("#grid").data("kendoGrid");

                if (val) {
                    var filters = [];

                    $.each(grid.options.columns, function (index, value) {
                        var filter = {
                            field: value.field,
                            operator: "contains",
                            value: val
                        };
                        filters.push(filter);
                    });
                    grid.dataSource.filter({
                        logic: "or",
                        filters: filters
                    });
                } else {
                    grid.dataSource.filter({
                        logic: "or",
                        filters: []
                    });
                }
            }
            else if (addressBookType == 'domain') {
                var selectedGrid = $(gridId);
                if ("searchBox-domain" === e[0].id || "searchButton-domain" === e[0].id) {
                    selectedGrid = $('#domainContactGrid');
                }
                $.addressBook.initGrid(selectedGrid);
            }
            else {
                $.addressBook.initGrid($(gridId));
            }

        },
		editHandler: function (dataItem) {
			
            if (dataItem.ContactTypeId == "2") {
                $.contactGroup.editHandler(dataItem);
                return false;
            }
            else {
                $.contact.editHandler(dataItem);
            }
        },

        /*Post or Get Function*/
        delete: function (e) {
            var addressBook = $('#addressBook').val();
            var grid;

            if (addressBook == 'domain') {
                grid = $("#domainContactGrid").data("kendoGrid");
            }
            else {
                grid = $("#grid").data("kendoGrid");
            }

            var selectedItem = grid.select();

            if (selectedItem.length === 0) {
                swal("", $areaResources.swal.noContactSelected);
                return false;
            }

            var contactList = new Array();

            selectedItem.each(
                function () {
                    var dataItem = grid.dataItem($(this));
                    contactList.push(dataItem.Id);
                }
            );
			console.log(contactList);
            swal({
                title: "",
                text: $areaResources.swal.deleteContacts,/* "Are you sure you want to delete selected contact(s)?",*/
                type: "info",
                showCancelButton: true,
                closeOnConfirm: false,
                reverseButtons: true,
                showLoaderOnConfirm: true
            }, function () {
				fxcRequest.post('/User/Contact/Delete',
					{ contactList: contactList },
					function (data) {
						swal($globalMessages.swal.done, $areaResources.swal.contactsDeleted, "success");
						
						/* Refresh grid everytime after save*/
						$.addressBook.refresh();
					}, function () {
						swal($globalMessages.swal.error.title, $globalMessages.swal.error.errorOnDelete, "error");
					}, true);
            });
        },
		getMoveToActions: function () {
            var addressBookId = parseInt($('input#addressBookId').val());
			var addressBook = $('input#addressBook').val();
			var addressBookDomainId = addressBook == 'domain' ? $("input#addressBookDomainId").val(): "";
            var url;

			fxcRequest.get("/User/AddressBook/List",
                {
                    addressBookId: addressBookId,
					addressBook: addressBook,
					domainId: addressBookDomainId
                },
                function (data) {
                    $.each(data, function (index, item) {
						$('#moveDropDown').append('<a class="dropdown-item btn-default" onclick="$.addressBook.moveContacts(\'' + item.Id + '\', \'' + item.Name + '\')">' + item.Name + '</a>');
					});

					if (!$("div#moveDropDown").children().length) {
						$("button#mainDropDown").prop('disabled', true);
					}
					else {
						$("button#mainDropDown").prop('disabled', false);
					}

                    /*Reset slimscroll ddl*/
                    custom.setDropDownMenu($('#moveDropDown'));
                },
                function (error) {
                    swal("ERROR!", 'An error occured upon get', "error");
                });
        },
        moveContacts: function (id, name) {
            var addressBook = $('#addressBook').val();
            var grid;

            if (addressBook == 'domain') {
                grid = $("#domainContactGrid").data("kendoGrid");
            }
            else {
                grid = $("#grid").data("kendoGrid");
            }

            var selectedItem = grid.select();

            if (selectedItem.length === 0) {
                swal("", $areaResources.swal.noContactSelected);
                return false;
            }

            var contactList = new Array();

            selectedItem.each(
                function () {
                    var dataItem = grid.dataItem($(this));
                    contactList.push(dataItem.Id);
                }
            );

            fxcRequest.post('/User/Contact/Move',
                {
                    contactList: contactList,
                    addressBookId: id
                },
                function (data) {
                    $.toast({
                        heading: 'Success',
                        text: $areaResources.toast.contactsMovedSuccess,
                        position: 'top-right',
                        loaderBg: '#ff6849',
                        icon: 'success',
                        hideAfter: 3500,
                        stack: 6
                    });
                    /* Refresh grid everytime after save*/
                    if (addressBook == 'domain') {
                        $.domainAddressBook.initGrid($('#domainContactGrid'));
                    }
                    else {
                        $.addressBook.refresh();
                    }
                },
                function (error) {
                    swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnMove, "error");
                },
                false);
        },
        getGridSelections: function (event) {
            var entityGrid = event.data("kendoGrid");
            var rows = entityGrid.select();
            var $selectedContacts = [];
            rows.each(function (index, row) {
                var selectedItem = entityGrid.dataItem(row);
                $selectedContacts[index] = { 'ContactId': selectedItem.Id };

            });

            return $selectedContacts;
        },

        performAction: function (command, $selectedContacts) {
            var successType = $(".btn-action[data-command='" + command + "']").data('successtype');
            var successMsg = $(".btn-action[data-command='" + command + "']").data('successmsg');

            var contactIds = $.map($selectedContacts, function (contact) {
                return contact.ContactId;
            });

            var data = {
                ContactIds: contactIds,
                Action: command
            };
            var postLoader = false;

            switch (successType) {
                case "Toast":
                    postLoader: false;
                    break;
                case "Swal":
                    postLoader: true;
                    break;
                default:

            }

            fxcRequest.post('/User/AddrBook/ExecuteAction'
                , data
                , function (data) {
                    $.addressBook.refresh();

                    switch (successType) {
                        case "Toast":
                            $.toast({
                                heading: 'Success',
                                text: successMsg,
                                position: 'top-right',
                                loaderBg: '#ff6849',
                                icon: 'success',
                                hideAfter: 3500,
                                stack: 6
                            });
                            break;
                        case "Swal":
                            swal($globalMessages.swal.success.title, successMsg, "success");                            
                            break;
                        default:

                    }
                }
                , function (error) {
                    swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnSubmit, "error");
                }, postLoader);
        },
    };
})(window.jQuery);
