﻿(function ($) {
    var $gridRec, $gridContact, $gridUser;
    var $contactTree, $contactTreeMobile, $userTree, $userTreeMobile;
    var userTreeCall = false;
    var contactTreeCall = false;
    var gridRecID = "#gridRecipient";
    var gridContactID = "#gridContact";
    var gridUserID = "#gridUser";
    var totalRec = "#recipient_GridDocumentTotal";
    var recpGridData, domainId, searchText, addrBookID, contactcat;
    var contactTab = false;
    var userTab = false;
    var selectedFilter = 0;
	var adHocData;
    var constructModel = function () {
        arry = {};
        var recpData = $.newmessage_recipient.getExistingRecpData();

        recpArry = {
            "RecipientName": $('#recipient_name').val(),
            "RecipientCompany": $('#recipient_company').val(),
            "RecipientEmail": $('#recipient_email').val(),
            "RecipientDelivery": $('#RecipientDelivery').val(),
            "RecipientFaxNumber": $('#recipient_faxNumber').val(),
            "RecipientAddressEmail": $('#recipient_addressEmail').val(),
			"RecipientAddress": $('#recipient_address').val(),
            "RecipientPhoneNumber": $('#recipient_phonenumber').val(),
			"RecipientServer": $('#recipient_server').val(),
			"RecipientUrl": $('#recipient_addressUrl').val(),
            "RecipientPath": $('#recipient_path').val(),
            "RecipientUserID": $('#recipient_userID').val(),
            "RecipientUserPassword": $('#recipient_userPassword').val(),
            "RecipientPrinter": $('#recipient_printer').val(),
            "RecipientFormat": $("#recipient_Format").prop('checked'),
            "RecipientAddAddressBook": $("#recipient_addAdrressBook").prop('checked'),
            "RecipientDDLAddAdrressBook": $('#recipient_ddlAddAdrressBook').val()
        };

        var arry = {
            RecepientModel: recpArry,
            RecpGridData: recpData,
            DelegatorID: $('#DelegatorID').val(),
            DelgProID: $('#DelgProID').val()
        };
        /*console.log(arry);*/
        return arry;
    };

    var constructAddFaxRecpModel = function () {
        arry = {};
        var recpData = $.newmessage_recipient.getExistingRecpData();

        var recpNumberExt = $('#RecpNumberExt').val();

        var recpArry = {
            "RecipientDelivery": $('#RecpRawFax').prop('checked') ? 9 : 2,
            "RecipientFaxNumber": addNumberInput.getNumber(intlTelInputUtils.numberFormat.E164) + recpNumberExt, /* $('#RecpNumber').val(),*/ /* Fax */
            "RecipientAddress": $('#RecpNumber').val() + recpNumberExt /* Raw Fax */
        };

        var arry = {
            RecepientModel: recpArry,
            RecpGridData: recpData,
            DelegatorID: $('#DelegatorID').val(),
            DelgProID: $('#DelgProID').val()
        };
        /*console.log(arry);*/
        return arry;
    };

    /* Validation */
    $.newmessage_recipient = {
        /* initialization */
        init: function (e) {
            /*$('#recipient_faxNumber').mask('');*/
            /* $.newmessage_recipient.onChangeRawFaxCheckbox($('#RecpRawFax'));*/

			adHocData = e;
			$.newmessage_recipient.resetFieldsAdHoc();

            var data = { "RecpList": [], "UserList": [] };
            $.newmessage_recipient.initgrid($(gridRecID), e);
			$.newmessage_recipient.initTab();

            $('#add-recipientAdHoc').on('click', function () {
				$("#SubmitType").val("2");
                $(".validation-NewMessage").submit();
            });

            $('#btn_recAddFaxRecp').on('click', function () {
                $("#SubmitType").val("3");
                $(".validation-NewMessage").submit();
            });

            $('#RecpNumber, #RecpNumberExt').keyup(function (e) {
                if (e.which == 13) {
                    $('#btn_recAddFaxRecp').trigger('click');
                }
            });

			/*filter*/
			var recfilter = e.DdlRecpAddrType.Source;
			var optAll = [{ Disabled: false, Group: null, Selected: false, Text: $newMessage.all, Value: "0" }];
			var updArray = $.merge(optAll, recfilter);
            $.sectionproperties.selectGenerator('RecDdlABFilter', updArray, 0, 0);

            $.newmessage_recipient.modalBtnClickHandler($("#MsgRecipient [data-target]"));
            $.newmessage_recipient.modalAddHocBtnClickHandler($('#btn_recAddHocDDL'));
        },
        initTab: function (e) {
            $('#MsgRecipientModal .modal').on('shown.bs.modal', function (h) {
                var target = $(h.target).attr("id"); /* activated modal*/
                switch (target) {
                    case "addContacts":
                        if (!contactTab) {
                            var objContact = {};
                            objContact.postSelectFn = $.newmessage_recipient.getContact;
                            objContact.dataSource = "/Common/ConfigureAddrBook?delegatorID=" + $('input#DelegatorID').val();
                            objContact.reselectChild = true;
                            objContact.selectFirstNode = true;
                            objContact.lazyLoading = true;

                            $contactTree = treeview.init("recContactTree", "recContactName", "recContactID", objContact);

                            /* Mobile */
                            var objAddBook = {};
                            objAddBook.postSelectFn = $.newmessage_recipient.selectContactAddBook;
                            objAddBook.dataSource = "/Common/ConfigureAddrBook?delegatorID=" + $('input#DelegatorID').val();
                            objAddBook.reselectChild = true;
                            objAddBook.selectFirstNode = true;
                            objAddBook.lazyLoading = true;
                            objAddBook.declareType = "textbox";
                            
                            $contactTreeMobile = treeview.init("recAddBookTree", "recAddBook-name", "recAddBook-id", objAddBook);         

                            treeview.mapState($contactTree, $contactTreeMobile, true);
                            
                            contactTab = true;
						}
						else
						{
							$(gridContactID).data("kendoGrid").clearSelection();
						}
						
                        break;
                    case "addUsers":
                        if (!userTab) {

                            var objUser = {};
                            objUser.postSelectFn = $.newmessage_recipient.getGridUser;
                            objUser.selectFirstNode = true;
                            objUser.expandAll = true;

                            $userTree = treeview.init("recUserTree", "recUserName", "recUserID", objUser);
                            
                            /* Mobile */
                            var objDomain = {};
                            objDomain.postSelectFn = $.newmessage_recipient.selectUserDomain;
                            objDomain.selectFirstNode = true;
                            objDomain.expandAll = true;
                            objDomain.declareType = "textbox";

                            $userTreeMobile = treeview.init("domain", "domain-name", "domain-id", objDomain);

                            treeview.mapState($userTree, $userTreeMobile);

                            userTab = true;
						}
						else {
							$(gridUserID).data("kendoGrid").clearSelection();
						}
                        break;
					default:
						$.newmessage_recipient.resetFieldsAdHoc();
                        break;
                }
            });
        },
        initgrid: function (e, data) {
            var id = e;

            var dataSource = {
                data: data.RecpList,

                schema: {
                    model: {
                        id: "Id"
                    }
                }
			};
            var columns = [];
            columns = [
                {
                    field: "Status",
                    title: " ",
                    width: "60px",
                    sortable: false,
                    template: function (dataRow) {
                        var result = '<a class="imageSizeTopBarIcons nav-link color-red waves-effect remove" data-id="' + dataRow.uid + '" id="del-' + dataRow.uid + '" href="javascript:void(0)" title="' + $globalMessages.grid.delTooltip + '"><i class="fa fa-times"></i></a>';
                        return result;
                    }
                },
                { field: "id", title: $globalMessages.grid.id, hidden: true },
                { field: "Name", title: $areaResources.grid.name, width: "150px" },
                { field: "CompanyName", title: $areaResources.grid.companyName, width: "150px" },
                { field: "DisplayAddr", title: $areaResources.grid.displayAddress, width: "150px" },
                { field: "EncryptStatus", title: $areaResources.grid.encStatus, hidden: true },
                { field: "NotifyList", title: $areaResources.grid.notifyEmail, hidden: true },
                { field: "NotifyListVM", title: $areaResources.grid.notifyEmail, width: "150px" },
                {
                    field: "IsRRSOn",
                    title: $globalMessages.grid.ns,
                    width: "45px",
                    sortable: false,
                    template: '<div class="custom-checkbox"><input class="k-checkbox-custom rrs" #= IsRRSOn == true ? \'checked="checked"\' : "" # data-role="checkbox" data-id="#= uid #" id="send-#= uid #" type="checkbox" title=> '
                        + '     <label for="send-#= uid #" class="k-checkbox-custom-label k-no-text" title="' + $globalMessages.grid.nstooltip + '">' + $globalMessages.grid.nstooltip + '</label></div>'
                },
                {
                    field: "IsRRFOn",
                    title: $globalMessages.grid.ne,
                    width: "45px",
                    sortable: false,
                    template: '<div class="custom-checkbox"><input class="k-checkbox-custom rrf" #= IsRRFOn == true ? \'checked="checked"\' : "" # data-role="checkbox" data-id="#= uid #" id="error-#= uid #" type="checkbox"> '
                        + '     <label for="error-#= uid #" class="k-checkbox-custom-label k-no-text" title="' + $globalMessages.grid.netooltip + '">' + $globalMessages.grid.netooltip + '</label></div>'
                }
            ];

            var obj = {};
            obj.selectable = true;
            obj.totalInputType = totalRec;
            obj.customizeCheckbox = true;
            $gridRec = kendogridcustomization.init(id, dataSource,
                columns, obj);

            $.newmessage_recipient.delete();
        },
        initgridContact: function (e, data, currentAddBookId) {
            contactTreeCall = true;
            var getData = $contactTreeMobile.getNodeById(currentAddBookId);
            if (getData != undefined) {
                $contactTreeMobile.unselectAll();
                $contactTreeMobile.select(getData);
            }

            if (data != null) {
                contactcat = data.category;

                if (data.id != null) {
                    $('input[data-role="search-contact"]').val('');
                    searchText = "";
                    addrBookID = data.id;
                }
            }

            var id = e;

            var dataSource = {
                transport: {
                    read: {
                        url: "/Common/GetUser",
                        dataType: "json",
                        type: "GET"
                    },
                    parameterMap: function (options) {

                        var sortBy = "";
                        var direction = "";
                        if (options.sort != null && options.sort.length > 0) {
                            var s = options.sort[0];
                            sortBy = s.field;
                            direction = s.dir;
                        }

                        var result = {
                            Type: "4",
                            Category: Number(contactcat),
                            AddrBookID: addrBookID,
							SearchText: $('input[data-role="search-contact"]').val(),
                            Page: options.page,
                            Limit: options.pageSize,
                            SortBy: sortBy,
                            Direction: direction,
                            SelectedFilter: selectedFilter
                        };
                        return result;
                    }
                },
                schema: {
                    data: "UserAddrBookList",
                    total: "Total",
                    model: {
                        id: "Id"
                    }
                },
                serverPaging: true,
                serverSorting: true
            };

            var columns = [];
            columns = [
                {
                    selectable: true, width: "45px",
                    attributes: {
                        "class": "checkboxSelection"
                    }
                },
                { field: "SelectableContact", title: $areaResources.grid.contactName, width: "500px" },
                { field: "AddressID", title: $areaResources.grid.addressId, hidden: true },
                { field: "Address", title: $areaResources.grid.address, hidden: true },
                { field: "Seq", title: "Seq", hidden: true },
                { field: "AddressTypeID", title: "AddressTypeID", hidden: true },
                { field: "CompanyName", title: "CompanyName", hidden: true },
                { field: "DisplayName", title: "DisplayName", hidden: true },
                { field: "CanonicalAddress", title: "CanonicalAddress", hidden: true },
                { field: "EncryptStatus", title: "EncryptStatus", hidden: true },
                { field: "DisplayAddress", title: "DisplayAddress", hidden: true },
                { field: "IsRRSOn", title: "IsRRSOn", hidden: true },
                { field: "IsRRFOn", title: "IsRRFOn", hidden: true },
                { field: "ContactTypeID", title: "ContactTypeID", hidden: true },
                { field: "NotifyAddress", title: "NotifyAddress", hidden: true },
                { field: "ContactID", title: "ContactID", hidden: true },
                { field: "AddrBookID", title: "AddrBookID", hidden: true }
            ];

            var obj = {};
            obj.allowSelectMultipleRow = true;
            $gridContact = kendogridcustomization.init(id, dataSource, columns, obj);

            contactTreeCall = false;
        },
        initgridUser: function (e, data, currentDomainId) {
            var id = e;

            userTreeCall = true;

            var getData = $userTreeMobile.getNodeById(currentDomainId);
            if (getData != undefined) {
                $userTreeMobile.unselectAll();
                $userTreeMobile.select(getData);
            }

            if (data != null && data.id != null) {
                $('input[data-role="search-user"]').val('');
                searchText = "";
                domainId = data.id;
            }

            var dataSource = {
                transport: {
                    read: {
						url: "/User/NewMessage/GetMultiUser",
                        dataType: "json",
                        type: "GET"
                    },
                    parameterMap: function (options) {
                        var result = {
                            DomainId: domainId,
                        };
                        if (options.sort && options.sort.length > 0) {
                            result.SortBy = options.sort[0].field;
                            result.Direction = options.sort[0].dir;
                        }
                        return result;
                    }
                },
                schema: {
                    data: "Records",
                    total: "Total",
                    model: {
                        id: "UserID"
                    }
                },
                serverPaging: false,
                serverSorting: false
            };

            var columns = [];
            columns = [
                { field: "checkboxSelection", selectable: true, width: "45px", sortable: false },
                { field: "UserID", title: "ID", hidden: true },
                { field: "Name", title: $areaResources.grid.name, width: "500px" }
            ];

            var obj = {};
            obj.allowSelectMultipleRow = true;
            $gridUser = kendogridcustomization.init(id, dataSource, columns, obj);

            userTreeCall = false;
        },
        selectContactAddBook: function (currentAddBookId) {
            if (!contactTreeCall) {
                var getData = $contactTree.getNodeById(currentAddBookId);
                if (getData != undefined) {
                    $contactTree.unselectAll();
                    $contactTree.select(getData);
                }

                contactTreeCall = false;
            }
        },
        selectUserDomain: function (currentDomainId) {
            if (!userTreeCall) {
                var getData = $userTree.getNodeById(currentDomainId);
                if (getData != undefined) {
                    $userTree.unselectAll();
                    $userTree.select(getData);
                }

                userTreeCall = false;
            }            
        },
        /*rebind checkbox value*/
        rebindCheckboxValue: function (arr) {
            $.each(arr, function (index, value) {
                var iderrstr = "input#error-" + value.Seq;
                $(iderrstr).prop('checked', value.IsRRFOn);

                var idsendstr = "input#send-" + value.Seq;
                $(idsendstr).prop('checked', value.IsRRSOn);
            });
        },
        delete: function (e) {
            $("#gridRecipient .k-grid-content").on("click", "a.remove", function (e) {

                var tr = $(e.target).closest("tr");
                var row = $("#gridRecipient").data("kendoGrid").dataItem(tr);
                if (row != null) {
                    $('#gridRecipient').data("kendoGrid").dataSource.remove(row);
                }
            });
        },
        /*Post or Get Back */
        modalBtnClickHandler: function (e) {
            $(e).on('click', function () {
                var recpModal = $(this).attr("data-target");
                $(recpModal).modal('show');
            });
        },
        modalAddHocBtnClickHandler: function (e) {
            $(e).on('click', 'a', function () {
                var $this = $(this);
                var deliveryType = $this.data('id');

                $('#addHoc').modal('show');

                $('#addHoc').on('shown.bs.modal', function () {
                    $('#RecipientDelivery').val(deliveryType);
                    $('#RecipientDelivery').change();
                });
            });
        },
        getGridUser: function (e, obj) {
            $.newmessage_recipient.initgridUser($(gridUserID), obj, e);
        },
        searchUserHandler: function (e) {
            $(e).keypress(function (event) {  
                if (event.which == 13) {
                    searchText = $(this).val();
                    domainId = $('#recUserID').val();
					$(gridUserID).data("kendoGrid").dataSource.filter({
						filters: [
							{
								field: "Name",
								operator: "contains",
								value: searchText
							}
						]
                    });
                    return false;
                }
            });
		},
		searchUserButtonClickHandler: function (e) {
			$(e).on('click', function () {
				searchText = $('input[data-role="search-user"]').val();
				domainId = $('#recUserID').val();
				$(gridUserID).data("kendoGrid").dataSource.filter({
					filters: [
						{
							field: "Name",
							operator: "contains",
							value: searchText
						}
					]
				});
				$(this).blur();
			});
		},
        getContact: function (e, obj) {
            $.newmessage_recipient.initgridContact($(gridContactID), obj, e);
        },
        searchContactHandler: function (e) {
            $(e).keypress(function (event) {
                if (event.which == 13) {
                    searchText = $(this).val();
                    $.newmessage_recipient.getContact();
                    return false;
                }
            });
		},
		searchContactButtonClickHandler: function (e) {
			$(e).on('click', function () {
				searchText = $('input[data-role="search-contact"]').val();
				$.newmessage_recipient.getContact();
				$(this).blur();
			});
		},
        onChangeFilter: function (e) {

            selectedFilter = e;
            $.newmessage_recipient.getContact();
        },
        onChangeAddAB: function (e) {

            var addAb = $('#recipient_addAdrressBook').bootstrapSwitch('state');
            if (addAb) {
                $("#ddlAddAdrressBookPanel").show();
            } else {
                $("#ddlAddAdrressBookPanel").hide();
            }
        },
        onChangeRawFaxCheckbox: function (e) {
            $(e).on('change', function () {
                if ($(this).prop('checked'))
                    $('#RecpNumber').val('');
                else
                    $('#RecpNumber').val(adHocData.Recipient_faxNumber);
            });            
        },
        resetFieldsAdHoc: function () {
            var e = adHocData;
			$(".validation-NewMessage #addHoc").find('input:text').val('');
            $(".validation-NewMessage #addHoc").find('input:password').val('');

            var emailFormat = true;
            if (e.UserPreferFileFormatHtml === "PDF") {
				emailFormat = true;
			}
            else if (e.UserPreferFileFormatHtml === "TIF") {
				emailFormat = false;
			}

			$('#recipient_Format').bootstrapSwitch('state', emailFormat);
			$('#recipient_addAdrressBook').bootstrapSwitch('state', false);
            
			var ddlRecpAddrTypeHtml = e.DdlRecpAddrTypeHtml;

			$("#RecipientDelivery").html('');
			$("#RecipientDelivery").append(ddlRecpAddrTypeHtml);
            $('#RecipientDelivery').change();

            $("#btn_recAddHocDDL").html('');
            $('#RecipientDelivery option').each(function () {
                if (this.value == 9 && this.selected) {
                    $('#RecpRawFax').prop('checked', true);
                }

                $("#btn_recAddHocDDL").append('<a data-id="' + this.value + '" class="dropdown-item" >' + this.text + '</a>');
            });

            $('#RecpRawFax').change();

			$("#recipient_printer").html('');
			$("#recipient_printer").append(e.DdlPrinterHtml);

			$('#recipient_faxNumber').val(e.Recipient_faxNumber);

			$("#ddlAddAdrressBookPanel").hide();
			$("#recipient_ddlAddAdrressBook").html('');
			$("#recipient_ddlAddAdrressBook").append(e.DdlAddToAddrBkHtml);
            $('#recipient_ddlAddAdrressBook').change();

            $('#RecpNumber').val('');
            $('#RecpNumberExt').val('');
        },

        /*TODO save Message*/
        save: function () {
            $("#SubmitType").val("");
            fxcRequest.post('/User/NewMessage/AdHocUser',
                constructModel()
                , function (data) {
                    $.newmessage_recipient.initgrid($(gridRecID), data);
					/*Save Successfully only reset add hoc form*/
                    $('#addHoc').modal('hide');
					$.newmessage_recipient.resetFieldsAdHoc();
                }
                , function (error) {
                    swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnSubmit, "error");
                }, false);
        },

        addUserBtnClickHandler: function (e) {
            $(e).on('click', function () {
				$.newmessage_recipient.addRecpFromInternal();
            });
        },
        addContactBtnClickHandler: function (e) {
            $(e).on('click', function () {
				$.newmessage_recipient.addRecpFromAddrBook();
            });
        },
        getGridSelection: function (grid) {
            var gridSelection = [];
            if (grid != null) {
                var rows = grid.select();
                rows.each(function (e, row) {
                    var selectedItem = grid.dataItem(row);
                    gridSelection[e] = selectedItem.id;
                });
            }
            return gridSelection;
        },
        getGridSelectionToAddressObj: function (grid) {
            var addressObj = [];
            if (grid != null) {
                var rows = grid.select();
                rows.each(function (e, row) {
                    var selectedItem = grid.dataItem(row);

                    var address = {
                        "Id": selectedItem.id,
                        "SelectableContact": selectedItem.SelectableContact,
                        "AddressID": selectedItem.AddressID,
                        "Address": selectedItem.Address,
                        "Seq": selectedItem.Seq,
                        "AddressTypeID": selectedItem.AddressTypeID,
                        "CompanyName": selectedItem.CompanyName,
                        "DisplayName": selectedItem.DisplayName,
                        "CanonicalAddress": selectedItem.CanonicalAddress,
                        "DisplayAddress": selectedItem.DisplayAddress,
                        "IsRRSOn": selectedItem.IsRRSOn,
                        "IsRRFOn": selectedItem.IsRRFOn,
                        "ContactTypeID": selectedItem.ContactTypeID,
                        "NotifyAddress": selectedItem.NotifyAddress,
                        "ContactID": selectedItem.ContactID,
                        "Cat": selectedItem.Cat,
                        "AddrBookID": selectedItem.AddrBookID,
                        "EncryptStatus": Number(selectedItem.EncryptStatus)
                    };
                    addressObj[e] = address;
                });
            }
            return addressObj;
        },
        getGridData: function (grid) {
            var gridSelection = [];
            if (grid != null) {
                var rows = grid.dataSource.data();
                $.each(rows, function (index, value) {
                    gridSelection[index] = value.id;
                });
            }
            return gridSelection;
        },
        getExistingRecpData: function (e) {
            var recpgrid = $('#gridRecipient').data("kendoGrid");
            var rows = recpgrid.dataSource.data();
            /* checkbox databind Already Fix at kendo grid
             * 
             * 
            $.each(rows, function (index, value) {
                var iderrstr = "input#error-" + value.Seq;
                var errChckVal = $(iderrstr).prop('checked');
                value.IsRRFOn = errChckVal;

                var idsendstr = "input#send-" + value.Seq;
                var sendChckVal = $(idsendstr).prop('checked');
                value.IsRRSOn = sendChckVal;
            });
            *
            */

            recpGridData = JSON.stringify(rows);
            return recpGridData;
        },
        addRecpFromInternal: function (e) {

            var grid = $(gridUserID).data("kendoGrid");
            var arr1 = $.newmessage_recipient.getGridSelection(grid);

            if (arr1.length === 0) {
                swal("", $areaResources.swal.noAddrrSelected);
                return false;
            }

            $.newmessage_recipient.getExistingRecpData();

            fxcRequest.post('/User/NewMessage/AddRecpFromInternal',
                {
                    "SelectedUserId": arr1,
                    "RecpGridData": recpGridData,
                    "DelegatorID": $('input#DelegatorID').val()
                },
                function (data) {
					$.newmessage_recipient.initgrid($(gridRecID), data);
                    $(gridUserID).data("kendoGrid").clearSelection();

                    console.log(data);
                },
                function (error) {
                    /*console.log(error);*/
                }, false);

            $('#addUsers').modal('hide');
        },
        addRecpFromAddrBook: function (e) {

            var cGrid = $(gridContactID).data("kendoGrid");
            var addresses = $.newmessage_recipient.getGridSelectionToAddressObj(cGrid);
            var ids = $.newmessage_recipient.getGridSelection(cGrid);
            if (ids.length === 0) {
                swal("", $areaResources.swal.noAddrrSelected);
                return false;
            }

            $.newmessage_recipient.getExistingRecpData();

            fxcRequest.post('/User/NewMessage/AddRecpFromAddrBook',
                {
                    "SelectedAddress": addresses,
                    "RecpGridData": recpGridData,
                    "DelegatorID": $('input#DelegatorID').val()
                },
                function (data) {
                    $.newmessage_recipient.initgrid($(gridRecID), data);
					$(gridContactID).data("kendoGrid").clearSelection();
                },
                function (error) {
                    /*console.log(error);*/
                }, false);

            $('#addContacts').modal('hide');
        },
        addFaxRecp: function () {
            $("#SubmitType").val("");
            fxcRequest.post('/User/NewMessage/AdHocUser',
                constructAddFaxRecpModel()
                , function (data) {
                    $.newmessage_recipient.initgrid($(gridRecID), data);
                    $.newmessage_recipient.resetFieldsAdHoc();
                }
                , function (error) {
                    swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnSubmit, "error");
                }, false);
        },
    };
})(window.jQuery);