﻿(function ($) {
	/*Cannot be a share FN as switch is not working*/
	var form = $(".validation-NewMessage").show();
	var defaultDateTime = $("#defaultDateFormat").val() + " " + $("#defaultTimeFormat").val();

    $(".validation-NewMessage").steps({
        /* Appearance */
        headerTag: "h6",
        bodyTag: "section",
        /* Labels */
        labels: {
            finish: $newMessage.button.submit,
            next: $newMessage.button.next,
            previous: $newMessage.button.previous,
            loading: $newMessage.button.loading
        },
        /*contentContainerTag: "div",
        actionContainerTag: "div",
        stepsContainerTag: "div",
        cssClass: "wizard",
        stepsOrientation: $.fn.steps.stepsOrientation.horizontal, */

        /* Templates */
        titleTemplate: '<span class="step">#index#</span> #title#',
        loadingTemplate: '<span class="spinner"></span> #text#',

        /* Behaviour 
        autoFocus: false,
        enableAllSteps: false,
        enableKeyNavigation: true,
        enablePagination: true,
        suppressPaginationOnFocus: true,
        enableContentCache: true,
        enableCancelButton: true,
        enableFinishButton: true,
        preloadContent: false,
        showFinishButtonAlways: false,
        forceMoveForward: false,
        saveState: false,
        startIndex: 0, */

        /* Transition Effects */
        transitionEffect: "fade",
        /*transitionEffectSpeed: 200,*/

        /* Events */
        onStepChanging: function (event, currentIndex, newIndex) {
            /*Fires before the step changes and can be used to prevent step changing by returning false. Very useful for form validation.*/
            $("#SubmitType").val("");

            /* Forced accordian to expand if there is tracking */
            $.msgSender.toggleTrackingMandatoryField();
            /**/

            if (currentIndex > newIndex) {
                /*Remove override validation for current page*/
                form.find(".body:eq(" + currentIndex + ") input[type=hidden].RequiredField.override").removeClass("override");

            }
            else {
                /*Override validation for current page*/
                form.find(".body:eq(" + currentIndex + ") input[type=hidden].RequiredField").addClass("override");
            }
            return currentIndex > newIndex || (currentIndex < newIndex
                && (
                    form.find(".body:eq(" + newIndex + ") label.error").remove(),
                    form.find(".body:eq(" + newIndex + ") .error").removeClass("error")),
                form.validate().settings.ignore = ".ignored, :disabled,:hidden:not(input[type=hidden].RequiredField.override)",
                form.valid());
        },
        onStepChanged: function (event, currentIndex, priorIndex) {
            /*Fires after the step has change.*/

            /*Find all grid for upcoming page and reset height*/
            form.find(".body:eq(" + currentIndex + ") .k-grid").each(function () {
                kendogridcustomization.customizeGridHeight($(this));
            });
        },
        onFinishing: function (event, currentIndex) {
            $("#SubmitType").val("");
            /*Fires before finishing and can be used to prevent completion by returning false. Very useful for form validation.*/
            return form.validate().settings.ignore = ".ignored, :disabled", form.valid();
        },
        onFinished: function (event, currentIndex) {
            /*	Fires after completion.*/
            $.newmessage.save(".validation-NewMessage");
        },


    });

    var recipientAddHocValidation = function (element, params) {
        /*this validator will return valid if all params meet expected condition, otherwise invalid*/
        /*this validator is specific for this format*/
        var sampleParamObj = {
            id: "", /*id of control element*/
            values: [""], /*an array for accepted value for this element*/
            validateType: "" /*validateType: 
                1 (required if control value not in accepted value array)
                2 (required if not empty)
                */
        };

        var valid = false;/*true is valid, can submit*/
        var resultParams = [];

        if (params && params.length > 0) {
            for (var i = 0; i < params.length; i++) {

                var param = params[i];

                var controlId = param.id;
                var controlAcceptedValues = param.values;
                var validateType = param.validateType;

                var control = $('#' + param.id);
                if (control) {
                    switch (validateType) {
                        case "1":
                            /*required if control value not in accepted value array*/
                            var controlActualValue = control.val();
                            var indexInArray = $.inArray(controlActualValue, controlAcceptedValues);
                            valid = indexInArray > -1;
                            if (valid) {
                                resultParams.push(valid);
                            }

                            break;
                        case "2":
                            /*required if not empty*/
                            var value = $(element).val();
                            valid = (value.length && control.val().length) || (control.val().length === 0);
                            if (valid) {
                                resultParams.push(valid);
                            }

                            break;
                        default:
                            break;
                    }

                    if (!valid) {
                        break;
                    }

                } else {
                    break;
                }

            }

            /*valid if all params meet expected condition, otherwise invalid*/
            valid = params.length === resultParams.length;
        }

        return valid;
    };

	var newMessageValidation = function () {
		$('.validation-NewMessage').validate({
			ignore: ".ignored",
			ignoreTitle: true,
			rules: {
				/* Step 1 */
				sender_from: {
					required: function (element) {
						var SubmitType = $("#SubmitType").val();
						switch (SubmitType) {
							case "":
								/* Add Recipient From Add Hoc --> bind to bottom gridview */
								return true;
							default:
								return false;
						}
                    },
                    noSpace: true
				},
				sender_delayuntil: { fxcDateFormat: [defaultDateTime] },
				approval_note: {
					required: function (element) {
						var SubmitType = $("#SubmitType").val();
						switch (SubmitType) {
							case "":
								if ($("#approval_note").hasClass("RequiredField")) {
									return true;
								}
								else {
									return false;
                                }
							default:
								return false;
						}
                    },
                    noSpace: true
				},

				/* Step 2 -Document */
				document_GridDocumentTotal: {
					required: function (element) {
						var SubmitType = $("#SubmitType").val();
						switch (SubmitType) {
							case "":
								/* Add Recipient From Add Hoc --> bind to bottom gridview */
								return true;
							default:
								return false;
						}
					},
					min: function (element) {
						var SubmitType = $("#SubmitType").val();
						switch (SubmitType) {
							case "":
								/* Add Recipient From Add Hoc --> bind to bottom gridview */
								return 1;
							default:
								return 0;
						}
					}
				},
				/* Step 3 - Recipient - add function */
				recipient_name: {
					required: function (element) {
						var SubmitType = $("#SubmitType").val();
						switch (SubmitType) {
							case "2":
								/* Add Recipient From Add Hoc --> bind to bottom gridview */
								return true;
							default:
								return false;
						}
                    },
                    noSpace: true
				},
				RecipientDelivery: {
					required: function (element) {
						var SubmitType = $("#SubmitType").val();
						switch (SubmitType) {
							case "2":
								/* Add Recipient From Add Hoc --> bind to bottom gridview */
								return true;
							default:
								return false;
						}
					}
				},
				recipient_faxNumber: {
					required: function (element) {
						var SubmitType = $("#SubmitType").val();
						switch (SubmitType) {
							case "2":
								/* Add Recipient From Add Hoc --> bind to bottom gridview */
								return true;
							default:
								return false;
						}
                    },
                    noSpace: true
				},
				recipient_addressEmail: {
					required: function (element) {
						var SubmitType = $("#SubmitType").val();
						switch (SubmitType) {
							case "2":
								/* Add Recipient From Add Hoc --> bind to bottom gridview */
								return true;
							default:
								return false;
						}
					},
                    email: true,
                    noSpace: true
				},
				recipient_address: {
					required: function (element) {
						var SubmitType = $("#SubmitType").val();
						switch (SubmitType) {
							case "2":
								/* Add Recipient From Add Hoc --> bind to bottom gridview */
								return true;
							default:
								return false;
						}
                    },
                    noSpace: true
				},
				recipient_path: {
					required: function (element) {
						var SubmitType = $("#SubmitType").val();
						switch (SubmitType) {
							case "2":
								/* Add Recipient From Add Hoc --> bind to bottom gridview */
								return true;
							default:
								return false;
						}
                    },
                    noSpace: true
                },
                recipient_addressUrl: {
                    required: function (element) {
                        var SubmitType = $("#SubmitType").val();
                        switch (SubmitType) {
                            case "2":
                                /* Add Recipient From Add Hoc --> bind to bottom gridview */
                                var params = [
                                    {
                                        id: "RecipientDelivery",
                                        values: ["4", "3"],
                                        validateType: "1"
                                    }
                                ];
                                
                                return recipientAddHocValidation($(element), params);
                            default:
                                return false;
                        }
                    },
                    noSpace: true
                },
				recipient_userID: {
                    required: function (element) {
                        var SubmitType = $("#SubmitType").val();
                        switch (SubmitType) {
                            case "2":
                                /* Add Recipient From Add Hoc --> bind to bottom gridview */
                                var params = [
                                    {
                                        id: "RecipientDelivery",
                                        values: ["4", "5", "3"],
                                        validateType: "1"
                                    },
                                    {
                                        id: "recipient_userPassword",
                                        values: [],
                                        validateType: "2"
                                    }
                                ];

                                var valid = recipientAddHocValidation($(element), params);
                                return !valid;
                            default:
                                return false;
                        }
                    }
				},
                recipient_userPassword: {
                    required: function (element) {
                        var SubmitType = $("#SubmitType").val();
                        switch (SubmitType) {
                            case "2":
                                /* Add Recipient From Add Hoc --> bind to bottom gridview */
                                var params = [
                                    {
                                        id: "RecipientDelivery",
                                        values: ["4", "5", "3"],
                                        validateType: "1"
                                    },
                                    {
                                        id: "recipient_userID",
                                        values: [],
                                        validateType: "2"
                                    }
                                ];

                                var valid = recipientAddHocValidation($(element), params);
                                return !valid;
                            default:
                                return false;
                        }
                    }
                },

				recipient_GridDocumentTotal: {
					required: function (element) {
						var SubmitType = $("#SubmitType").val();
						switch (SubmitType) {
							case "":
								/* Add Recipient From Add Hoc --> bind to bottom gridview */
								return true;
							default:
								return false;
						}
					},
					min: function (element) {
						var SubmitType = $("#SubmitType").val();
						switch (SubmitType) {
							case "":
								/* Add Recipient From Add Hoc --> bind to bottom gridview */
								return 1;
							default:
								return 0;
						}
					}
				},
			},

			messages: {
				/* Step 1 */
                sender_delayuntil: { fxcDateFormat: $newMessage.validation.fxcDateFormat },

				/* Step 2 -Document */
				document_GridDocumentTotal: {
                    required: $newMessage.validation.gridMinLength,
                    min: $newMessage.validation.gridMinLength
				},

				/* Step 3 - Recipient - add function */
				recipient_GridDocumentTotal: {
                    required: $newMessage.validation.gridMinLength,
                    min: $newMessage.validation.gridMinLength
				},
			},

			submitHandler: function (form) {
				var SubmitType = $("#SubmitType").val();
				switch (SubmitType) {
					case "2":
						/* Add Recipient From Add Hoc --> bind to bottom gridview */
						$.newmessage_recipient.save();
						break;
					default:
				}
			},
		});
    };

	$.newmessage = {
		init: function (e) {
			newMessageValidation();
			$.newmessage.initNewMessageForm();
			$.newmessage.initDateTime();

			$('#RecipientDelivery').on('change', function () {
				$('.validation-NewMessage').validate().resetForm();
			});
		},
		initDateTime: function (e) {
			/*website: http://www.daterangepicker.com/ */
			var obj = {};

			obj.minDate = $("#MinDate").val();
			fxcDateTimePicker.init('#sender_delayuntil', defaultDateTime, obj);
		},
		initNewMessageForm: function (e) {
			fxcRequest.get('/User/NewMessage/GetNewMessage',
				{
					"DelegatorID": $('#DelegatorID').val(),
					"DelgProID": $('#DelgProID').val(),
					"Rf": $('#Rf').val(),
					"Umid": $('#Umid').val(),
					"Des": $('#Des').val(),
					"Mid": $('#Mid').val(),
				},
				function (data) {
					var newMsgForm = data.NewMessageModel;

					$('#ReceiveForward').val(data.ReceiveForward);
                    $('#SourceMsgID').val(data.SourceMsgID);

                    if (newMsgForm.DelgInfo != null) {
                        $('.View1 .breadcrumb-item:first-of-type').append('<span class="badge badgeDisplay badge-small-text">' + newMsgForm.DelgInfo + '</span>');
                    }

					$.msgSender.init(newMsgForm);
					$.newmessage_document.init(newMsgForm);
					$.newmessage_recipient.init(newMsgForm);
				},
				function (error) {
					/* console.log(error);*/
				});
		},
		getGridData: function (grid) {
			var gridSelection = [];
			if (grid != null) {
				var rows = grid.dataSource.data();
				$.each(rows, function (index, value) {
					gridSelection[index] = value.id;
				});
			}
			return gridSelection;
		},

		/*Post or Get Back */
        save: function () {

			var docData = $.newmessage_document.getExistingDocData();
			var recpData = $.newmessage_recipient.getExistingRecpData();

			var formData = JSON.stringify($("#newmsgform").serializeArray());

			var newmsgmodel = {
				"TxtFrom": $('#sender_from').val(),
				"TxtCompany": $('#sender_company').val(),
				"TxtSubject": $('#sender_subject').val(),
				"TxtNotes": $('#sender_notes').val(),
				"TxtBillingCode": $('#sender_billingcode').val(),
				"TxtApprovalReq": $('#approval_note').val(),

				"ChkNotifyFailed": $('#sender_notifyfailure').prop('checked'),
				"ChkNotifySuccess": $('#sender_notifysuccess').prop('checked'),
				"ChkNotifyBatch": $('#sender_notifysummary').prop('checked'),
				"ChkHold": $('#sender_notifypreview').prop('checked'),

				"DdlPriority": { "Value": $('#sender_priority').val() },
				"DtpDelay": $("#sender_delayuntil").val()
			};

			$("#SubmitType").val("");
			fxcRequest.post('/User/NewMessage/SendWebMessage',
				{
					"NewMessageModel": newmsgmodel,
					"FormData": formData,
					"RecpGridData": recpData,
					"DocGridData": docData,
					"DelegatorID": $('#DelegatorID').val(),
					"DelgProID": $('#DelgProID').val(),
					"ReceiveForward": $('#ReceiveForward').val(),
					"Rf": $('#Rf').val(),
					"SourceMsgID": $('#SourceMsgID').val(),
					"Mid": $('#Mid').val(),
				}
                , function (data) {
                    $.newmessage_document.stopExpiringSessionTimer();

					var msg = "Message " + data.MsgNo + " Created.";

					swal({
                        title: $newMessage.swal.success.title,
						text: msg,
						type: "success",
						showConfirmButton: true
					}, function (e) {
						window.setTimeout(function () {
							var checkFwdMessage = ($('#ReceiveForward').val().toLowerCase() === 'true');
							if (checkFwdMessage)
							{
								window.close();
							}
                            else {
                                var delegatorid = $('#DelegatorID').val();
                                var delgproid = $('#DelgProID').val();

                                var inboxUrl = "/user/msg/?id=1002&name=Outbox";

                                if (delegatorid != "" & delgproid != "") {
                                    var linkID = "#df" + delegatorid + delgproid + '1002';
                                    inboxUrl = $(linkID).attr("value");
                                }

								fxcontent.load(inboxUrl);
							}
						}, 10);

					});
				});
		},
	};
})(window.jQuery);