﻿(function ($) {

    $.msgSender = {
        init: function (e) {
            $('#sender_from').val(e.TxtFrom);

            $("#sender_notifysummary").change(function () {
                var disabledSelection = false;
                if ($(this).is(":checked"))
                    disabledSelection = true;
                $("#sender_notifysuccess").attr("Disabled", disabledSelection);
                $("#sender_notifyfailure").attr("Disabled", disabledSelection);

            });
            $('#sender_from').val(e.TxtFrom);
            $('#sender_company').val(e.TxtCompany);
            $('#sender_subject').val(e.TxtSubject);
            $('#sender_notes').val(e.TxtNotes);
            $('#sender_billingcode').val(e.TxtBillingCode);

            $('#sender_notifyfailure').prop('checked', e.ChkNotifyFailed);
            /*0*/
            if (e.HfMSF == "0") {
                $('#sender_notifyfailure').prop('disabled', true);
            }

            $('#sender_notifysuccess').prop('checked', e.ChkNotifySuccess);
            /*0*/
            if (e.HfMSS == "0") {
                $('#sender_notifysuccess').prop('disabled', true);
            }

            $('#sender_notifysummary').prop('checked', e.ChkNotifyBatch).change();
            /*1*/
            if (e.HfMSB == "0") {
                $('#sender_notifysummary').prop('disabled', true);
            }

            var tracking = e.Tracking;
            var trackingInfoForm = tracking.TrackingInfoHtml;
            $("#trackingInfoForm").html('');
            $("#trackingInfoForm").append(trackingInfoForm);
            
            /*update rules*/
            var allinput = $("#trackingInfoForm input");
            var isRequired = false;
            $.each(allinput, function (index, control) {
                
                var errMsg = $(control).data("errmessage");
                
                var regexFormat = $(control).attr("pattern");
                if (regexFormat != null) {
                    $(control).rules("add", {
                        required: $(control).prop('required'),
                        regex: regexFormat,
                        messages: {
                            regex: errMsg,
                            required: $globalMessages.validation.required,
                            minlength: errMsg,
                            maxlenght: errMsg
                        }
                    });
                }

                var maskFormat = $(control).data("inputmask");
                if (maskFormat != null) {
                    $(control).rules("add", {
                        required: $(control).prop('required'),
                        messages: {
                            required: $globalMessages.validation.required,
                            minlength: errMsg,
                            maxlenght: errMsg
                        }
                    });

                    $(control).mask(maskFormat);
                }

                if (!isRequired) {
                    isRequired = $(control).prop('required');
                }

            });
            /*end update rules*/

            var ddlPriorityHtml = e.DdlPriorityHtml;
            $("#sender_priority").html('');
            $("#sender_priority").append(ddlPriorityHtml);

            var ddlPriorityval = e.DdlPriority.Value;
            $("#sender_priority").val(ddlPriorityval);

            this.toggleTrackingMandatoryField();
        },
        toggleTrackingMandatoryField: function () {
            /* Forced accordian to expand if there is mandatory tracking */
            var mandatoryField = $('input[required], select[required]', $('#trackingInfoForm'));
            if (mandatoryField.length > 0) {
                $('#collapseTwo').collapse('show');
            }
        }
    };
})(window.jQuery);