﻿(function ($) {
	var setIsRtl = $("html[dir]").attr("dir") === "rtl" ? true : false;
    var tour = {
        id: "user-newcontact-hopscotch",
        steps: [
            {
                target: "DisplayName",
                title: "",
				content: $_contacts.uiGuide.fieldRequired,
                placement: "bottom",
				yOffset: "-3",
				isRtl: setIsRtl
            },
            {
                target: "btn-collapseContact",
                title: "",
				content: $_contacts.uiGuide.toggleAddSetting,
                placement: "top",
                fixedElement: true,
                xOffset: "18",
				yOffset: "12",
				isRtl: setIsRtl
            },
            {
                target: "view1SaveBtn",
                title: "",
				content: $_contacts.uiGuide.buttonSave,
                placement: "bottom",
                arrowOffset: "250",
                xOffset: "-230",
                yOffset: "-2",
				zindex: 51,
				isRtl: setIsRtl
            },
            {
                target: "view1ResetBtn",
                title: "",
				content: $_contacts.uiGuide.buttonReset,
                placement: "bottom",
                arrowOffset: "250",
                xOffset: "-230",
                yOffset: "-2",
				zindex: 51,
				isRtl: setIsRtl
            }
        ],
        showPrevButton: true,
        onPrev: function () {
            if (hopscotch.isActive)
                $.sharedUiGuide.scrollToFixedPlacementTarget(hopscotch.getCurrTour(), hopscotch.getCurrStepNum(), hopscotch.getCurrTarget());
        },
        onNext: function () {
            if (hopscotch.isActive)
                $.sharedUiGuide.scrollToFixedPlacementTarget(hopscotch.getCurrTour(), hopscotch.getCurrStepNum(), hopscotch.getCurrTarget());
        }
    };
    $.newContactUiGuide = {
        init: function (tourBtn) {
            $.sharedUiGuide.init({ startTourBtn: tourBtn, tour: tour });
        }
    };
})(window.jQuery);