﻿(function ($) {
	var setIsRtl = $("html[dir]").attr("dir") === "rtl" ? true : false;
    var tour = {
        id: "user-newcontactgroup-hopscotch",
        steps: [
            {
                target: "GroupName",
                title: "",
                content: $globalMessages.uiGuide.fieldRequiredDisplayName,
                placement: "bottom",
				yOffset: "-3",
				isRtl: setIsRtl
			},
			{
				target: ".btn-addContact",
				title: "",
				content: $globalMessages.uiGuide.buttonNew,
				placement: "bottom",
				xOffset: "-13",
				yOffset: "-3",
				isRtl: setIsRtl
			},
			{
				target: "#action-delete-contactlist",
				title: "",
				content: $globalMessages.uiGuide.buttonDelete,
				placement: "bottom",
				xOffset: "-13",
				yOffset: "-3",
				isRtl: setIsRtl
			},
            {
                target: "view1SaveBtn",
                title: "",
                content: $globalMessages.uiGuide.buttonSave,
                placement: "bottom",
                arrowOffset: "250",
                xOffset: "-230",
                yOffset: "-2",
				zindex: 51,
				isRtl: setIsRtl
			},
			{
				target: "view1ResetBtn",
				title: "",
				content: $globalMessages.uiGuide.buttonReset,
				placement: "bottom",
				arrowOffset: "250",
				xOffset: "-230",
				yOffset: "-2",
				zindex: 51,
				isRtl: setIsRtl
			}
        ],
        showPrevButton: true
    };
    $.newContactGroupUiGuide = {
        init: function (tourBtn) {
            $.sharedUiGuide.init({ startTourBtn: tourBtn, tour: tour });
        }
    };
})(window.jQuery);