﻿(function ($) {
	var setIsRtl = $("html[dir]").attr("dir") === "rtl" ? true : false;
	var tour = {
		id: "user-newmessage-adddocs-hopscotch",
		steps: [
			{
				target: "#newmsgform-t-0 span.step",
				title: "",
				content: $newMessage.uiGuide.buttonStep1,
				placement: "bottom",
				xOffset: "-6",
				yOffset: "-3",
				isRtl: setIsRtl
			},
			{
				target: "#btnBrowse",
				title: "",
				content: $newMessage.uiGuide.buttonUploadFile,
				placement: "bottom",
				xOffset: "-10",
				yOffset: "0",
				isRtl: setIsRtl
			},
			{
				target: "#docTreeBtn",
				title: "",
				content: $newMessage.uiGuide.buttonOpenExisting,
				placement: "bottom",
				xOffset: "-2",
				yOffset: "0",
				onNext: function () {
					$('#btnOnline').click();
				},
				isRtl: setIsRtl
			},
			{
				target: "#btnOnline",
				title: "",
				content: $newMessage.uiGuide.buttonOpenCloudStorage,
				placement: "right",
				xOffset: "-13",
				yOffset: "-10",
				zindex: 1100,
				delay: "5",
				isRtl: setIsRtl
			},
			{
				target: "a[href='#previous']",
				title: "",
				content: $newMessage.uiGuide.buttonPrevious,
				placement: "top",
				arrowOffset: "246px",
				xOffset: "-231",
				yOffset: "1",
				onPrev: function () {
					$('#btnOnline').click();
				},
				isRtl: setIsRtl
			},
			{
				target: "a[href='#next']",
				title: "",
				content: $newMessage.uiGuide.buttonNext,
				placement: "top",
				arrowOffset: "246px",
				xOffset: "-246",
				yOffset: "1",
				isRtl: setIsRtl
			}
		],
		showPrevButton: true
	};
	$.newMessageAddDocsUiGuide = {
		init: function (tourBtn) {
			$.sharedUiGuide.init({ startTourBtn: tourBtn, tour: tour });
		}
	};
})(window.jQuery);
