﻿(function ($) {
	var setIsRtl = $("html[dir]").attr("dir") === "rtl" ? true : false;
    var tour = {
        id: "user-newmessage-addrecipient-hopscotch",
        steps: [
            {
                target: "#newmsgform-t-0 span.step",
                title: "",
				content: $newMessage.uiGuide.buttonStep1,
                placement: "bottom",
                xOffset: "-6",
				yOffset: "-3",
				isRtl: setIsRtl
            },
            {
                target: "#newmsgform-t-1 span.step",
                title: "",
				content: $newMessage.uiGuide.buttonStep2,
                placement: "bottom",
                xOffset: "-6",
				yOffset: "-3",
				isRtl: setIsRtl
            },
			{
				target: "#btn_recAddHoc",
				title: "",
				content: $newMessage.uiGuide.buttonAddRecipient,
				placement: "bottom",
				xOffset: "-10",
				yOffset: "0",
				isRtl: setIsRtl
			},
			{
				target: "#btn_recAddContacts",
				title: "",
				content: $newMessage.uiGuide.buttonAddContacts,
				placement: "bottom",
				xOffset: "-2",
				yOffset: "0",
				onNext: function () {
					$('#btnOnline').click();
				},
				isRtl: setIsRtl
			},
			{
				target: "#btn_recAddUsers",
				title: "",
				content: $newMessage.uiGuide.buttonAddUsers,
				placement: "right",
				xOffset: "-13",
				yOffset: "-10",
				zindex: 1100,
				delay: "5",
				isRtl: setIsRtl
			},
            {
                target: "a[href='#finish']",
                title: "",
				content: $newMessage.uiGuide.buttonFinish,
                placement: "top",
                arrowOffset: "246px",
                xOffset: "-246",
				yOffset: "1",
				isRtl: setIsRtl
            }
        ],
        showPrevButton: true
    };
    $.newMessageAddRecipientUiGuide = {
        init: function (tourBtn) {
            $.sharedUiGuide.init({ startTourBtn: tourBtn, tour: tour });
        }
    };
})(window.jQuery);