﻿(function ($) {
    var defaultFormat = $("#defaultDateFormat").val() + " " + $("#defaultTimeFormat").val();
    var defaultStartDate = moment().startOf('day').format(defaultFormat);
    var defaultEndDate = moment().endOf('day').format(defaultFormat);
    var reportGrid;
    var drPicker;
    var self;

    var maxPdfClientExportData = 500;
    var maxExcelClientExportData = 40000;
    var maxCsvClientExportData = 100000;
    var requestModel;
    var selectedExportType = '';

    $.userReport = {
        options: {},
        init: function (opts) {
            self = this;
            self.options = opts;
            reportGrid = $(opts.gridId);
            self.initDateTime(opts.dateRangeCtrl);
            self.setActionBtnHandler(opts.actionBtn);
            self.setGenerateReportBtnHandler(opts.generateBtn);
            self.exportToPdfHandler(opts.exportPdfBtn);
            self.exportToExcelHandler(opts.exportExcelBtn);
            self.exportToCsvHandler(opts.exportCsvBtn);
            self.initGrid();
        },
        initGrid: function () {
            var id = self.options.gridId;
            var start = drPicker.startDate.format(defaultFormat);
            var end = drPicker.endDate.format(defaultFormat);
            var pageType = $('#pageType').val();

            var dataSource = {
                transport: {
                    read: {
                        url: '/user/report/read',
                        dataType: "json",
                        type: "GET"
                    },
                    parameterMap: function (options) {
                        var result = {
                            StartDate: start,
                            EndDate: end,
                            MsgType: $('#Direction').val(),
                            Skip: options.skip,
                            Take: options.take,
                            Page: options.page,
                            Sort: options.sort
                        };
                        if (options.sort && options.sort.length > 0) {
                            result.SortBy = options.sort[0].field;
                            result.Direction = options.sort[0].dir;
                        }
                        requestModel = result;
                        return result;
                    }
                },
                schema: {
                    data: "Records",
                    total: "Total",
                    model: {
                        id: "MsgTransactionId",
                        fields: {
                            MsgTransactionId: { type: "string" },
							MessageId: { type: "string" },
							MessageNo: { type: "string" },
                            Direction: { type: "string" },
                            DialNumber: { type: "string" },
                            CompleteDate: { type: "string" },
                            PagesDelivered: { type: "string" },
                            FaxResult: { type: "string" },
                            LocalId: { type: "string" },
                            CallerId: { type: "string" },
                            RemoteId: { type: "string" }
                        }
                    }
                },
                serverPaging: true,
                serverSorting: true
            };

            var col = [
				{ field: 'MsgTransactionId', hidden: true },
				{ field: 'MessageId', hidden: true },
				{ field: 'MessageNo', title: $userReportResource.colMsgNo, width: 150, sortable: true },
				{ field: 'Direction', title: $userReportResource.colDirection, width: 150, sortable: true },
				{ field: 'DialNumber', title: $userReportResource.colDialNo, width: 150, sortable: true },
				{ field: 'CompleteDate', title: $userReportResource.colCompletedDate, width: 200, sortable: true },
				{ field: 'PagesDelivered', title: $userReportResource.colPagesDelivered, width: 200, sortable: true },
				{ field: 'FaxResult', title: $userReportResource.colFaxResult, width: 150, sortable: true },
				{ field: 'LocalId', title: $userReportResource.colLocalId, width: 150, sortable: true },
				{ field: 'CallerId', title: $userReportResource.colCallerId, width: 150, sortable: true },
				{ field: 'RemoteId', title: $userReportResource.colRemoteId, width: 150, sortable: true }
            ];

            var obj = {};
            obj.pdfSettings = {
                allPages: true,
                fileName: 'Report.pdf',
                paperSize: pageType,
                repeatHeaders: true,
                forcePageBreak: '.page-break',
                margin: '1cm',
                scale: 0.4
            };
            obj.excelSettings = {
                allPages: true,
                fileName: 'Report.xlsx'
            };
            kendogridcustomization.init(id, dataSource, col, obj);
        },
        initDateTime: function (e) {
            var start = moment().startOf('day');
            var end = moment().endOf('day');

            function setDateCallback(start, end, chosenLabel) {
				if ($(e).closest("html[dir]").length > 0 && $(e).closest("html[dir]").attr("dir") === "rtl" )
				{
					$(".faxcore-MesageType").children(".daterangepicker").addClass("rtl");
					$(".faxcore-MesageType").children(".daterangepicker").removeClass("ltr");
				}
                var label = start.format(defaultFormat) + ' - ' + end.format(defaultFormat);
                if (chosenLabel !== 'Custom Range') label = chosenLabel;
                $('#reportrange span').html(label);
            }
			var openDirection = $(e).closest("html[dir]").length > 0 && $(e).closest("html[dir]").attr("dir") === "rtl"  ? "left": "right";
			$(e).daterangepicker({
				parentEl: ".faxcore-MesageType",
				opens: openDirection,
                startDate: defaultStartDate,
                endDate: defaultEndDate,
                ranges: {
                    'Today': [moment().startOf('day'), moment().endOf('day')],
                    'Last 7 Days': [moment().subtract(6, 'days').startOf('day'), moment().endOf('day')]
                },
                timePicker: true,
                timePickerIncrement: 1,
                timePickerSeconds: true,
				locale: {
					"format": defaultFormat,
					"separator": " - ",
					"applyLabel": $userReportResource.dateTimeApplyLabel,
					"cancelLabel": $userReportResource.dateTimeCancelLabel,
					"fromLabel": $userReportResource.dateTimeFromLabel,
					"toLabel": $userReportResource.dateTimeToLabel,
					"customRangeLabel": $userReportResource.dateTimeCustomLabel,
					"weekLabel": $userReportResource.dateTimeWeekLabel,
					"daysOfWeek": [
						$userReportResource.dateTimeSunday,
						$userReportResource.dateTimeMonday,
						$userReportResource.dateTimeTuesday,
						$userReportResource.dateTimeWednesday,
						$userReportResource.dateTimeThursday,
						$userReportResource.dateTimeFriday,
						$userReportResource.dateTimeSaturday
					],
					"monthNames": [
						$userReportResource.dateTimeJanuary,
						$userReportResource.dateTimeFebruary,
						$userReportResource.dateTimeMarch,
						$userReportResource.dateTimeApril,
						$userReportResource.dateTimeMay,
						$userReportResource.dateTimeJune,
						$userReportResource.dateTimeJuly,
						$userReportResource.dateTimeAugust,
						$userReportResource.dateTimeSeptember,
						$userReportResource.dateTimeOctober,
						$userReportResource.dateTimeNovember,
						$userReportResource.dateTimeDecember
					],
					"firstDay": 1
				}
            }, setDateCallback);
            setDateCallback(start, end, "Today");

            drPicker = $(e).data('daterangepicker');

        },
        setActionBtnHandler: function (e) {
            $(e).click(function () {
                var command = $(this).data('command');

                if (command === 200) {
                    var text = $(this).data('text');
                    var direction = $(this).data('direction');

                    $('#TlbbtnDirection').html(text);
                    $('#Direction').val(direction);
                }
            });
        },
        setGenerateReportBtnHandler: function (e) {
            $(e).click(function () {
                self.initGrid();
            });
        },
        exportToPdfHandler: function (e) {
            $(e).click(function () {
                selectedExportType = '.pdf';
                var gridData = reportGrid.data('kendoGrid');
                if (!self.isEmptyGrid(gridData)) {
                    self.disableButtons();
                    var total = gridData.dataSource.total();
                    if (total > maxPdfClientExportData) {
                        $.userReport.serverExport(gridData);
                    } else {
                        $.userReport.serverExport(gridData, true);
                    }
                }
            });
        },
        exportToExcelHandler: function (e) {
            $(e).click(function () {
                selectedExportType = '.xlsx';
                var gridData = reportGrid.data("kendoGrid");
                if (!self.isEmptyGrid(gridData)) {
                    self.disableButtons();
                    var total = gridData.dataSource.total();
                    if (total > maxExcelClientExportData) {
                        $.userReport.serverExport(gridData);
                    } else {
                        gridData.saveAsExcel();
                        self.enableButtons();
                    }
                }
            });
        },
        exportToCsvHandler: function (e) {
            $(e).click(function () {
				selectedExportType = '.csv';
				
                var gridData = reportGrid.data('kendoGrid');
                if (!self.isEmptyGrid(gridData)) {
                    self.disableButtons();
                    var total = gridData.dataSource.total();
                    if (total > maxCsvClientExportData) {
                        $.userReport.serverExport(gridData);
                    } else {
                        self.kendoGridToCSV(gridData);
                        self.enableButtons();
                    }
                }
            });
        },
        isEmptyGrid: function (data) {
            if (data.dataItems().length === 0) {
                swal($globalMessages.swal.alert.oops, $userReportResource.swalEmptyGrid, "warning");
                return true;
            }
            return false;
        },
        disableButtons: function () {
            $(self.options.generateBtn).prop('disabled', true);
            $(self.options.exportBtn).prop('disabled', true);
        },
        enableButtons: function () {
            $(self.options.generateBtn).prop('disabled', false);
            $(self.options.exportBtn).prop('disabled', false);
        },
        removeMaxHeight: function () { /*fix for overlapping pager footer in pdf output*/
            reportGrid.find('.k-grid-content').css('max-height', '');
        },
        expandLoadingPdfMask: function () {
            $('.k-loading-pdf-mask').find('.k-grid.k-widget').css('right', '0px');
        },
        kendoGridToCSV: function (grid) { /* source: https://daveaglick.com/posts/how-i-export-kendo-grids-to-excel-or-csv
             Get access to basic grid data*/
            var datasource = grid.dataSource;
            var originalPageSize = datasource.pageSize();
            var originalPage = datasource.page();

            /* Remove the success function since we don't care about what happens after we get the data
             (and the prototype success function causes problems when we copy the datasource over from the grid)*/
            datasource.success = function (data) {
                var csv = '';

                /* Add the header row*/
                for (var i = 0; i < grid.columns.length; i++) {
                    var title = grid.columns[i].title,
						field = grid.columns[i].field;
					if (!grid.columns[i].hidden === true)
					{
						if (typeof field === "undefined") { continue; /* no data! */ }
						if (typeof title === "undefined") { title = field; }

						title = title.replace(/"/g, '""');
						csv += '"' + title + '"';
						if (i < grid.columns.length - 1) {
							csv += ",";
						}
					}
                }
                csv += "\n";
                
                /* Add each row of data*/
                $.each(data.Records, function (index, row) {
                    /* Do a first pass to parse any dates (may eventually need to parse other types of received values here)*/
                    for (var i = 0; i < grid.columns.length; i++) {
                        var fieldName = grid.columns[i].field;
                        if (typeof fieldName === "undefined") { continue; }
                        if (typeof row[fieldName] === "string" && row[fieldName].lastIndexOf("/Date(", 0) === 0) {
                            row[fieldName] = kendo.parseDate(row[fieldName]);
                        }
                    }

                    /* Now generate the actual values*/
					for (var k = 0; k < grid.columns.length; k++) {
						if (!grid.columns[k].hidden === true) {
							var actualfieldName = grid.columns[k].field;
							if (typeof actualfieldName === "undefined") { continue; }

							/* Get the template and use it to get the display value*/
							var tmpl = grid._cellTmpl(grid.columns[k], {});
							var kt = kendo.template(tmpl);
							value = kt(row);

							/* Strip any HTML (needs to be inclosed in an outer tag to work)
							 Also strip any elements with the 'no-export' class
							 Also remove any label elements since they get used often in links*/
							var html = $('<div>' + value + '</div>');
							html.find('.label').remove();
							html.find('.no-export').remove();
							value = html.text().trim();

							/* Format for CSV (escape quotes and add the comma)*/
							value = value.replace(/"/g, '""');
							csv += '"' + value + '"';
							if (k < grid.columns.length - 1) {
								csv += ",";
							}
						}
                    }
                    csv += "\n";
                });

                /* Send the CSV content back to the server to generate a download link
                postToURL("/CsvToExcel", { data: csv });*/
                var csvBlob = new Blob([csv], { type: encodeURI('text/csv;base64;') });

                /*window.open(kendo.htmlEncode('data:text/csv;charset=utf-8,') + kendo.htmlEncode(csv));*/

                /*var dataUri = encodeURI('data:text/csv;base64,') + csv;*/

                kendo.saveAs({
                    /*dataURI: dataUri,*/
                    dataURI: csvBlob,
                    fileName: 'Report.csv'
                });

                /* Reset back to original values and reset the datasource*/
                datasource.pageSize(originalPageSize);
                datasource.page(originalPage);
                delete datasource.success;

                /* Reset the datasource now that we're done*/
                datasource._dequeueRequest();
                datasource.view();
            };

            /* Increase page size to cover all the data and then trigger fetching and processing of all the data*/
            datasource.pageSize(datasource.total());
            datasource.view();
        },
        serverExport: function (gridData, isReturnFile) {

            swal({
                title: $userReportResource.swalServerExport,
                text: $userReportResource.swalProcData,
                imageUrl: '/Content/img/ajax-loading2.gif',
                showConfirmButton: false,
                closeOnClickOutside: false
            });

            var dataSource = gridData.dataSource;

            var newRequestModel = requestModel;

            newRequestModel.FileData = { "IsServerExport": true };
            newRequestModel.Take = dataSource.total();

            var url = dataSource.transport.options.read.url;
            var col = [
				{ field: 'MsgTransactionId', hidden: true },
				{ field: 'MessageId', hidden: true },
				{ field: 'MessageNo', title: $userReportResource.colMsgNo, width: '100', sortable: true },
				{ field: 'Direction', title: $userReportResource.colDirection, width: '80', sortable: true },
				{ field: 'DialNumber', title: $userReportResource.colDialNo, width: '130', sortable: true },
				{ field: 'CompleteDate', title: $userReportResource.colCompletedDate, width: '160', sortable: true },
				{ field: 'PagesDelivered', title: $userReportResource.colPagesDelivered, width: '130', sortable: true },
				{ field: 'FaxResult', title: $userReportResource.colFaxResult, width: '100', sortable: true },
				{ field: 'LocalId', title: $userReportResource.colLocalId, width: '100', sortable: true },
				{ field: 'CallerId', title: $userReportResource.colCallerId, width: '120', sortable: true },
				{ field: 'RemoteId', title: $userReportResource.colRemoteId, width: '100', sortable: true }
            ];
            
            var pageOrientation = 'Landscape';
            var fontSize;
            var margins;
			var scaleFactor;
			var title = $userReportResource.title;

            var direction = $('#Direction').val();
			if (direction == 'inbound') {
				title = $userReportResource.reportInbound;
			} else if (direction == 'outbound') {
				title = $userReportResource.reportOutbound;
			} else {
				title = $userReportResource.reportBoth;
            }

            /*set export url*/
            var serverExportUrl = '/User/Report/ServerExport';
            var filename = title;

            var filedata = {};
            filedata.FileName = filename;
            filedata.FileExt = selectedExportType;
            filedata.Column = col;

            var dataparams = new Array();
            $.each(newRequestModel, function (key, obj) {

                if (obj) {
                    if (obj.constructor === {}.constructor) {
                        $.each(obj, function (sub, internal) {
                            dataparams.push({
                                name: key + '.' + sub,
                                value: internal
                            });
                        });
                    } else {
                        dataparams.push({
                            name: key,
                            value: obj
                        });
                    }
                }

            });

            filedata.RequestParams = dataparams;
            filedata.AuthorizeId = $('#authcode').val();
            filedata.ApiUrl = url;

            if (pageOrientation) {
                filedata.PageOrientation = pageOrientation;
            }

            if (fontSize) {
                filedata.FontSize = fontSize;
            }

            if (margins) {
                filedata.Margins = margins;
            }

            if (scaleFactor) {
                filedata.ScaleFactor = scaleFactor;
            }

            if (isReturnFile) {
                filedata.IsReturnFile = true;
            } else {
                filedata.IsReturnFile = false;
            }

            $.userReport.exportRawData(serverExportUrl, filedata, filedata.IsReturnFile);
        },
        exportRawData: function (url, model, isReturnFile) {

            if (!isReturnFile) {
                swal($userReportResource.ExportMsg);
            }

            fxcRequest.post(url,
                {
                    "querymodel": model,
                    "griQuery": requestModel
                },
                function (data) {
                    
                    if (isReturnFile) {

                        if (data.Status === "Success") {
                            swal.close();
                            var dataURL = data.Data.DataUri;

                            kendo.saveAs({
                                dataURI: dataURL,
                                fileName: data.Data.FileName + data.Data.FileExt
                            });

                        } else {
                            swal("ERROR!", data.Message, "error");
                        }

                    }
                    self.enableButtons();
                }, null, false);
        }
    };
})(window.jQuery || $);