﻿var $grid, bind = false;
var reset = true;
var gridId = "#grid";
var $ids = [""];
var refreshBasicSearch;
var $listBoxSelection, $listBoxSelected = null;
var commandID = null;
var defaultDateTime = $("#defaultDateFormat").val() + " " + $("#defaultTimeFormat").val();
var rowAdditionalObj = null;
var rowAdditionalObj2 = null;

var validation = function () {
    $('#formSubmit').validate({
        rules: {
            FromDate: { fxcDateFormat: [defaultDateTime] },
            ToDate: { fxcDateFormat: [defaultDateTime] }
        },
        messages: {
            FromDate: { fxcDateFormat: $.validator.messages.dateFormat },
            ToDate: { fxcDateFormat: $.validator.messages.dateFormat }
        },
        submitHandler: function (form) {
            $('#search-advanced-modal').modal('hide');
            $.messages.search(2);
        }
    });
    $('#formUserSelection').validate({
        ignore: [],
        rules: {
            listUserSelected: { multiselectrequired: true }
        },
        messages: {
            listUserSelected: { multiselectrequired: $.validator.messages.required }
        },
        submitHandler: function (form) {
            $selectedOwner = $.messages.getGridSelections($(gridId));
            ids = $.messages.getListDataSource($("#listUserSelected"));
            $.messages.performAction(commandID, $selectedOwner);
        }
    });
};

$.messages = {
    init: function (e) {
        validation();

		$.messages.advancedLinkClickHandler($(".btn-search-advanced"));
		$.messages.searchAdvanceButtonClickHandler($("#searchAdvanceButton"));
        $.messages.resetButtonClickHandler($(".btn-Reset"));
        $.messages.searchLinkClickHandler($(".btn-search-action"));
        $.messages.searchPressEnter($('input[data-role="search-all-item"]'));

        $.messages.searchUserSelectionButtonClickHandler($("#btn-userSelectionSearchButton"));
        $.messages.searchUserSelectionPressEnter($('input[data-role="search-active-user"]'));


        $.messages.actionButtonClickHandler($('.btn-action'));

        $.messages.searchModalButtonClickHandler($("button[data-role='search-modal']"));
        $.messages.resetModalButtonClickHandler($("button[data-role='reset-modal-value']"));

        $.messages.resetUserSlectionButtonClickHandler($('#BtnResetuserSelection'));

        $.messages.resetPage();

        $.messages.initDateTime();

        $.messages.resetModal();

        /*Set Fax Number As Default Search*/
		$.messages.setSearch($(".btn-search-action"), $("#btn-search-fax"));
		$.messages.initGrid($(gridId), refreshBasicSearch, true);
    },
    initContextMenu: function () {
        $.contextMenu('destroy', ".ctxmenuMsg");
        $.contextMenu({
            selector: '.ctxmenuMsg',
            trigger: 'right',
            items: {
                "1": { name: "View Message Info", icon: "fa-info" },
                "2": { name: "Split Message", icon: "fa-split" }
            },
            className: "messageContextMenu",
            callback: function (key, options) {
                var uid = options.$trigger.attr("data-uid");
                var row = $("tr[data-uid='" + uid + "']");
                var dataItem = $(gridId).data("kendoGrid").dataItem(row);
                if (key === "1") {
                    if (rowAdditionalObj !== null) {
                        dataItem.rowAdditionalObj = rowAdditionalObj;
                    }
                    dataItem.rowAdditionalObj.HideImageTab = true;
                    $.messageviewer.showMessageViewer(dataItem);
                } else if (dataItem.MsgPageCount > 1) {
                    $('#BtnViewMessage').attr('data-uid', uid);
                    $('#BtnSubmitSplit').attr('data-uid', uid);

                    $('#splitPages').text($splitresource.pages + ' ' + dataItem.MsgPageCount);
                    $('#splitInput').val('1-' + dataItem.MsgPageCount);
                    
                    $('#split-modal').modal('show');
                } else {
                    swal($globalMessages.swal.error.title, $splitresource.unable, "error");
                }
            }
        });

        if ($showDotContextMenu) {
            $.contextMenu('destroy', ".dotcontextMenu");
            $.contextMenu({
                selector: '.dotcontextMenu',
                trigger: 'left',
                items: {
                    "1": { name: "View Message Info", icon: "fa-info" },
                    "2": { name: "Split Message", icon: "fa-split" }
                },
                callback: function (key, options) {
                    var uid = options.$trigger.attr("data-uid");
                    var row = $("tr[data-uid='" + uid + "']");
                    var dataItem = $(gridId).data("kendoGrid").dataItem(row);

                    if (key === "1") {
                        if (rowAdditionalObj !== null) {
                            dataItem.rowAdditionalObj = rowAdditionalObj;
                        }
                        dataItem.rowAdditionalObj.HideImageTab = true;
                        $.messageviewer.showMessageViewer(dataItem);
                    } else if (dataItem.MsgPageCount > 1) {
                        $('#BtnViewMessage').attr('data-uid', uid);
                        $('#BtnSubmitSplit').attr('data-uid', uid);

                        $('#splitPages').text($splitresource.pages + ' ' + dataItem.MsgPageCount);
                        $('#splitInput').val('1-' + dataItem.MsgPageCount);
                        
                        $('#split-modal').modal('show');
                    } else {
                        swal($globalMessages.swal.error.title, $splitresource.unable, "error");
                    }
                }
            });
        }
    },
    initDateTime: function (e) {
        /*website: http://www.daterangepicker.com/ */
        let fromDateObj = {};
        fromDateObj.parentEl = "#search-advanced-modal";

        fxcDateTimePicker.init('input#FromDate', defaultDateTime, fromDateObj);

        let toDateObj = {};
        toDateObj.parentEl = "#search-advanced-modal";
        toDateObj.startDate = moment().startOf('day').set({ hour: 23, minute: 59, second: 59 });

        fxcDateTimePicker.init('input#ToDate', defaultDateTime, toDateObj);
    },
	initGrid: function (e, isBasicSearch, emptyGrid) {
		emptyGrid = emptyGrid || false;
        refreshBasicSearch = isBasicSearch;
        $(gridId).removeClass("hide");
        var url = "/User/Search/Read";
        var obj = {};
		var col = [];
		var visibilityUsername = parseInt($("#isStandardUser").val()) > 0 ? true : false;

        col.push({
            selectable: true,
            width: 45,
            attributes: {
                "class": "checkboxSelection"
            }
        });

        if ($showDotContextMenu) {
            col.push({
                field: "",
                title: "action",
                width: 30,
                attributes: {
                    "class": "checkboxSelection"
                },
                headerAttributes: {
                    class: "k-header-label k-no-text"
                },
                sortable: false,
                template: function (dataRow) {
                    var result = '<span class="dotcontextMenu" data-uid="#= uid #"><i class="fa fa-ellipsis-v" style="padding:0px 5px;"></i></span>';
                    return result;
                }
            });
        }

        col.push(
            {
                field: 'MsgTypeLabel',
                title: "MsgTypeLabel",
                sortable: false,
                width: 45,
                attributes: {
                    "class": "checkboxSelection"
                },
                headerAttributes: {
                    class: "k-header-label k-no-text"
                },
                template: function (dataRow) {
                    var msgType = dataRow.MsgType == 1 ? "Outbound" : "Inbound";
                    var result = '<span data-msgtype="' + dataRow.MsgType + '" title="' + dataRow.MsgTypeLabel + '"><i class="mdi mdi-' + msgType + '" style="padding:0px 5px;"></i></span>';
                    return result;
                }
            },
            { field: 'MessageID', title: $AdvancedSearch.grid.msgId, minWidth: 155, width: 155, sortable: true, hidden: !$showColMessageId },
			{ field: 'MsgNo', title: $AdvancedSearch.grid.msgNo, minWidth: 100, width: 100, sortable: true },
			{ field: 'CrDate', title: $AdvancedSearch.grid.crDate, minWidth: 200, width: 200 },
			{ field: 'Subject', title: $AdvancedSearch.grid.subject, minWidth: 200, width: 200 },
			{ field: 'Username', title: $AdvancedSearch.grid.username, minWidth: 200, width: 200, sortable: true, hidden: visibilityUsername},
			{ field: 'SenderName', title: $AdvancedSearch.grid.sender, minWidth: 200, width: 200, sortable: true },
			{ field: 'RecipientList', title: $AdvancedSearch.grid.recipient, minWidth: 200, width: 200, sortable: true },
            {
				field: "Status",
				title: $AdvancedSearch.grid.status,
                width: 250,
                template: function (dataRow) {
                    var MsgStatus = dataRow.MsgStatus + "";
					var MsgStatusLabel = dataRow.Status + "";
                    var result = '<div class="kendo-container">' +
                        '<span class="badge kendo-span-status badge-pill badge-' + MsgStatus + ' "> '
						+ '             <i class="mdi mdi-check kendo-check-icon-msgstatus' + MsgStatus + '"></i> '
						+ '             <i class="mdi mdi-window-close kendo-window-close-icon-msgstatus' + MsgStatus + '"></i> '
                        + '             ' + MsgStatusLabel + ' '
                        + '         </span>' +
                        '</div>';
                    return result;
                }
            },
			{ field: 'MsgPageCount', title: $AdvancedSearch.grid.pages, minWidth: 100, width: 100, sortable: true },
			{ field: 'MsgTrackingValue', title: $AdvancedSearch.grid.tracking, minWidth: 200, width: 200, sortable: true },
			{ field: 'Address', title: $AdvancedSearch.grid.address, minWidth: 200, width: 250, sortable: true });

        var id = e;
		var dataSource = {
            transport: {
                read: {
                    url: url,
                    dataType: "json",
                    type: "GET"
                },
                parameterMap: function (options) {
                    isBasicSearch = isBasicSearch == 1 ? true : false;
                    var usrRole = $("#defaultUserRole").val();

                    var Domain = 0;
                    var UserName = "";
                    var FixUserName = false;

                    if (usrRole == 'STANDARDUSER') {
                        DomainID = 0;
                        UserName = "";
                        FixUserName = false;
                    }
                    else {
                        DomainID = $("#DomainID").prop('checked');
                        UserName = $("#UserName").val();
                        FixUserName = $("#FixUsername").prop('checked');
                    }

                    var result = {
                        IsBasicSearch: isBasicSearch,
                        DomainID: DomainID,
                        UserName: UserName,
                        FixUserName: FixUserName,
                        FromDate: $("#FromDate").val(),
                        ToDate: $("#ToDate").val(),
                        MsgNo: $("#MsgNo").val(),
                        FixMsgNo: $('#FixMsgNo').prop('checked'),
                        MsgId: $("#MsgId").val(),
                        FixMsgId: $('#FixMsgId').prop('checked'),
                        TrackValue: $('#TrackValue').val(),
                        FixTrackValue: $('#FixTrackValue').prop('checked'),
                        RecpName: $('#RecpName').val(),
                        FixRecpName: $('#FixRecpName').prop('checked'),
                        FaxAddr: $("#FaxAddr").val(),
                        FixFaxAddr: $('#FixFaxAddr').prop('checked'),
                        Email: $("#Email").val(),
                        FixEmail: $('#FixEmail').prop('checked'),
                        LocalCSID: $("#LocalCSID").val(),
                        FixLocalCSID: $('#FixLocalCSID').prop('checked'),
                        Subject: $("#Subject").val(),
                        FixSubject: $('#FixSubject').prop('checked'),
                        Status: $("#Status").val(),
                        MsgType: $("#MsgType").val(),
                        IsFailed: $("#IsFailed").val(),
                        IsHeld: $("#IsHeld").val(),
                        RoutingInfo: $("#RoutingInfo").val(),
                        FixRoutingInfo: $('#FixRoutingInfo').prop('checked'),
                        IsPrinted: $("#IsPrinted").val(),
                        IsSave: $("#IsSave").val(),
                        Skip: options.skip,
						Take: emptyGrid? 0:options.take,
                        Page: options.page
                    };

                    if (options.sort && options.sort.length > 0) {
                        result.SortBy = options.sort[0].field;
                        result.Direction = options.sort[0].dir;
                    }

                    return result;
                }
            },
            schema: {
                data: "Records",
                model: {
                    id: "MessageID"
                },
				total: emptyGrid ? "" :"Total"
            },
			change: function (data) {
                /*Triggered once data load completed*/
                if (data.items.length) {
                    $('#btn-ActionCustom').prop('disabled', false);
                }
            },
            serverPaging: true,
            serverSorting: true
        };

        if ($enableDoubleClick) {
            obj.doubleClickFn = $.messageviewer.showMessageViewer;
        }
        else {
            obj.onSelectionFn = $.messageviewer.showMessageViewer;
        }
        obj.rowClass = "ctxmenuMsg";

        rowAdditionalObj = {
            "RefreshLocation": $('#MessageHubRefreshFlag').val(),
            'IsSearchMsg': 'true'
        }
        rowAdditionalObj2 = {
            "RefreshLocation": $('#MessageHubRefreshFlag').val(),
            'IsSearchMsg': 'true'
        };

        obj.rowAdditionalObj = rowAdditionalObj2;
        $grid = kendogridcustomization.init(id, dataSource,
            col, obj);

        $.messages.initContextMenu();
    },
    initListView: function (e) {
        $('input[data-role="search-active-user"]').val("");
        var listBoxID = "listUserSelection";
        var listBoxIDConnectWith = "listUserSelected";

        fxcRequest.post('/User/Search/GetActiveUser',
            {
                DomainID: e,
                SearchText: "",/* $('input[data-role="search-active-user"]').val()*/
                GroupMember: $.messages.getListDataSource($("#" + listBoxIDConnectWith)),
                ResetField: reset
            },
            function (data) {
                var returnObject = [];

                var dataSourceSelection = {
                    data: data.ActiveUserModel.ActiveUserList.Source
                };

                var objUserSelection = {};
                objUserSelection.dataTextField = "Text";
                objUserSelection.dataValueField = "Value";
                objUserSelection.connectWith = listBoxIDConnectWith;
                objUserSelection.staticSelectedListBox = !reset;

                var dataSourceSelected = {
                    data: data.ActiveUserModel.SelectedUserList.Source
                };

                returnObject = listbox.mutual(listBoxID, dataSourceSelection, objUserSelection, dataSourceSelected);

                if (returnObject != null) {
                    $listBoxSelection = returnObject.listBoxSelection;
                    $listBoxSelected = returnObject.listBoxSelected;
                }

                reset = false;
            },
            function (error) {
                swal('ERROR', 'error on load', 'error');
            }, false);

    },
    initTreeViewAction: function (e) {
        /* Action Forward to user // Assign Pop Up*/
        $("#userDomain-id").val($('#defaultDomainID').val());
        var objUserSelection = {};
        objUserSelection.expandAll = true;
        objUserSelection.declareType = "textbox";
        objUserSelection.postSelectFn = $.messages.initListView;
        treeview.init("userDomain", "userDomain-name", "userDomain-id", objUserSelection);
    },

    /*Btn Action*/

    actionButtonClickHandler: function (e) {
        $(e).on('click', function () {
            var btnTemp = this;

            commandID = $(this).data('command');

            var $selectedOwner = $.messages.getGridSelections($(gridId));

            if ($selectedOwner.length === 0) {
                swal("", $areaResources.swal.noMsgSelected);
                return false;
            }
            else if (commandID === 115 && $selectedOwner.length > 1) {
                swal("", $areaResources.swal.multipleMsgSelected);
                return false;
            }

            switch (commandID) {
                case 115: /*Forward to User*/
                    $.messages.showSendMsgWin('f', $selectedOwner[0].UserMsgID, $selectedOwner[0].MessageID);
                    $(gridId).click();
                    return false;
                case 103: /*Forward to User*/
                    $("#userSelection").text($areaResources.actionTitle.forwardToUsers);
                    $("#BtnSaveuserSelection").val($areaResources.actionTitle.forward);
                    $("#user-selection-modal").modal('show');
                    $.messages.resetUserSelection();
                    return false;
                case 111: /*Assign to User*/
                    $("#userSelection").text($areaResources.actionTitle.assignToUsers);
                    $("#BtnSaveuserSelection").val($areaResources.actionTitle.assign);
                    $("#user-selection-modal").modal('show');
                    $.messages.resetUserSelection();
                    return false;
                default:

            }

            var confirmationMsg = $(this).data('confirmationmsg');
            if (confirmationMsg) {
                swal({
                    title: "",
                    text: confirmationMsg,
                    type: "info",
                    showCancelButton: true,
                    reverseButtons: true
                }, function () {
                    $.messages.performAction(commandID, $selectedOwner);
                });
            }
            else {
                $.messages.performAction(commandID, $selectedOwner);
            }

            $(this).blur();
        });

    },
    advancedLinkClickHandler: function (e) {
        $(e).on('click', function (x) {
            $('#search-advanced-modal').modal('show');
        });
	},
	searchAdvanceButtonClickHandler: function (e) {
		$(e).on('click', function (x) {
			$.messages.search(1);
			$(this).blur();
		});
	},
    resetButtonClickHandler: function (e) {
        $(e).on('click', function (x) {
            $.messages.resetPage();
            $.messages.resetModal();
        });
    },
    resetUserSlectionButtonClickHandler: function (e) {
        $(e).on('click', function (x) {
            $.messages.resetUserSelection();
        });
    },
    searchLinkClickHandler: function (e) {
        $(e).on('click', function (x, y) {
            $.messages.setSearch($(e), $(this));
        });
    },
    searchPressEnter: function (e) {
        $(e).on('keypress', function (enter) {
            if (enter.which === 13) {
                $.messages.search(1);
            }
        });
    },
    refreshMessageFromHub: function (model) {
        var refreshFlag = $('#MessageHubRefreshFlag').val();
        if (model != null && model.RefreshLocation == refreshFlag) {
            $.messages.search(1);
        }
    },
    searchUserSelectionButtonClickHandler: function (e) {
        $(e).on('click', function (x, y) {
            $.messages.searchUserSelection();
        });
    },
    searchUserSelectionPressEnter: function (e) {
        $(e).on('keypress', function (event) {
            if (event.which === 13) {
                $.messages.searchUserSelection();
                event.preventDefault();
            }
        });
    },

    /*Pop Up Modal*/
    searchModalButtonClickHandler: function (e) {
        $(e).on('click', function (x) {
            $('#formSubmit').submit();
        });
    },
    resetModalButtonClickHandler: function (e) {
        $(e).on('click', function (x) {
            $.messages.resetModal();
        });
    },

    /* Logic */

    getGridSelections: function (event) {
        var entityGrid = event.data("kendoGrid");
        var rows = entityGrid.select();
        var $selectedOwner = [];
        rows.each(function (index, row) {
            var selectedItem = entityGrid.dataItem(row);
            $selectedOwner[index] = { 'MessageID': selectedItem.MessageID, 'UserMsgID': selectedItem.UserMsgID };

        });

        return $selectedOwner;
    },
    getListDataSource: function (event) {
        var entityList = event.data("kendoListBox");
        $ids = [];
        if (entityList != undefined) {
            var rows = entityList.dataItems();
            $(rows).each(function (index, row) {
                $ids[index] = row.Value;
            });
        }
        return $ids;
    },
    performAction: function (command, $selectedOwner) {
        var successType = $(".btn-action[data-command='" + command + "']").data('successtype');
        var successMsg = $(".btn-action[data-command='" + command + "']").data('successmsg');
        var selectedUser = $(".btn-action[data-command='" + command + "']").data('selecteduser');

        var data = {
            Ids: $ids,
            OwnerMsgList: $selectedOwner,
            Action: command
        };
        var postLoader = false;

        switch (successType) {
            case "Toast":
                postLoader: false;
                break;
            case "Swal":
                postLoader: true;
                break;
            default:

        }

        fxcRequest.post('/User/Search/ExecuteAction'
            , data
            , function (data) {
                $.messages.initGrid($(gridId), refreshBasicSearch);
                switch (successType) {
                    case "Toast":
                        $.toast({
                            heading: 'Success',
                            text: successMsg,
                            position: 'top-right',
                            loaderBg: '#ff6849',
                            icon: 'success',
                            hideAfter: 3500,
                            stack: 6
                        });
                        break;
                    case "Swal":
                        swal($globalMessages.swal.success.title, successMsg, "success");
                        $("#user-selection-modal").modal('hide');
                        break;
                    default:

                }
            }
            , function (error) {
                swal($globalMessages.swal.error.errorCap, $globalMessages.swal.error.errorOnSubmit, "error");
            }, postLoader);
    },
    resetModal: function (e) {
        $('#formSubmit').trigger("reset");
        $("#formSubmit").validate().resetForm();
    },
    resetPage: function (e) {
        $('#search-advanced-modal').modal('hide');
        $(gridId).addClass("hide");

        /*Reset All Field*/
        $('input[data-role="search-all-item"]').val("");

        /*Diabled Action Button*/
        $('#btn-ActionCustom').prop('disabled', true);
    },
    resetUserSelection: function (e) {
        reset = true;
        $("#formUserSelection").trigger("reset");
        $("#formUserSelection").validate().resetForm();
        if (!bind) {
            $.messages.initTreeViewAction();
            bind = true;
        }
        else {
            /*Reselect User From ID*/
            $("#userDomain").tree().unselectAll();
            $("#userDomain-id").val($('#defaultDomainID').val());
            var getUserData = $("#userDomain").tree().getNodeById($("#userDomain-id").val());

            if (getUserData != undefined) {
                $("#userDomain").tree().select(getUserData);
            }
        }

    },
    setSearch: function (e, currentElement) {
        var searchResult = $(currentElement).attr("data-search");
        $('input[data-role="search-all-item"]').val("");
        $('input[data-role="search-all-item"]').attr("placeholder", searchResult);
        $('input[data-role="search-all-item"]').attr("title", searchResult);
        $(e).removeClass("selected");
        $(currentElement).addClass("selected");
    },
    search: function (isBasicSearch) {
        var searchType = $(".btn-search-action.selected").attr("data-role");
        switch (isBasicSearch) {
            case 1:
                /*Basic Search*/
                $.messages.resetModal();
                var searchValue = $('input[data-role="search-all-item"]').val();
                switch (searchType) {
                    case "1":
                        /*Search by Fax Number*/
                        $("#FaxAddr").val(searchValue);
                        break;
                    case "2":
                        /*Search by User*/
                        $("#UserName").val(searchValue);
                        break;
                    case "3":
                        /*Search by Message Number*/
                        $("#MsgNo").val(searchValue);
                        break;
                    case "4":
                        /*Search by Tracking Number*/
                        $("#TrackValue").val(searchValue);
                        break;
                    case "5":
                        /*Search by Subject*/
                        $("#Subject").val(searchValue);
                        break;
                    case "10":
                        /*Search by Message Id*/
                        $("#MsgId").val(searchValue);
                        break;
                    default:
                }
                break;
            case 2:
                /*Advanced Search*/
                var getSearchValue = "";
                switch (searchType) {
                    case "1":
                        /*Search by Fax Number*/
                        getSearchValue = $("#FaxAddr").val();
                        break;
                    case "2":
                        /*Search by User*/
                        getSearchValue = $("#UserName").val();
                        break;
                    case "3":
                        /*Search by Message Number*/
                        getSearchValue = $("#MsgNo").val();
                        break;
                    case "4":
                        /*Search by Tracking Number*/
                        getSearchValue = $("#TrackValue").val();
                        break;
                    case "5":
                        /*Search by Subject*/
                        getSearchValue = $("#Subject").val();
                        break;
                    case "10":
                        /*Search by Message Id*/
                        getSearchValue = $("#MsgId").val();
                        break;
                    default:
                }
                $('input[data-role="search-all-item"]').val(getSearchValue);
                break;
            default:
        }
        $.messages.initGrid($(gridId), isBasicSearch);
    },
    searchUserSelection: function (e) {
        /*$.messages.initListView();*/

        var listBoxSelection = $("#listUserSelection").getKendoListBox();
        var searchString = $('input[data-role="search-active-user"]').val();

        listBoxSelection.dataSource.filter({ field: "Text", operator: "contains", value: searchString });
    },
    showSendMsgWin: function (rfType, umid, mid) {

        //url += '?DelegationID=' + delegatorID + '&DelegationProf=' + delgProID;

        var url = '/User/Message?rf=' + rfType + '&umid=' + umid + '&mid='
            + mid;

        $.messages.showWin(url, '800', '580', rfType, 'yes');
    },
    showWin: function (winUrl, width, height, winName, resize) {
        var winPopup;
        var url = winUrl;
        var name = winName;

        var features = 'width=' + width + ',height=' + height + ',resizable=' + resize + ',scrollbars=no,toolbar=no,location=no,directories=no,status=no,menubar=no,copyhistory=no';
        winPopup = window.open(url, name, features);
        if (name == "PrintLocalPDF") {
            winPopup.print();
        }
        winPopup.focus();
    }
};