﻿(function ($) {
	var setIsRtl = $("html[dir]").attr("dir") === "rtl" ? true : false;
    var tour = {
        id: "user-search-hopscotch",
        steps: [
            {
                target: "btn-ActionCustom",
                title: "",
                content: $globalMessages.uiGuide.buttonAction,
                placement: "bottom",
                xOffset: "12",
                yOffset: "-3",
				zindex: 101,
				isRtl: setIsRtl
            },
            {
                target: "advancedSearchFilterDropdown",
                title: "",
                content: $globalMessages.uiGuide.changeSearchFilter,
                placement: "right",
                xOffset: "-8",
                yOffset: "-13",
				zindex: 71,
				isRtl: setIsRtl
            },
            {
                target: "searchAllItemTextbox",
                title: "",
                content: $globalMessages.uiGuide.buttonSearch,
                placement: "left",
                xOffset: "12",
                yOffset: "-13",
				zindex: 71,
				isRtl: setIsRtl
            },
            {
                target: "searchAdvanceButton",
                title: "",
                content: $globalMessages.uiGuide.buttonSearchGrid,
                placement: "left",
                xOffset: "12",
                yOffset: "-13",
				zindex: 51,
				isRtl: setIsRtl
            },
            {
                target: "view1ResetBtn",
                title: "",
                content: $globalMessages.uiGuide.buttonReset,
                placement: "bottom",
                arrowOffset: "250",
                xOffset: "-230",
                yOffset: "-2",
                zindex: 51,
				isRtl: setIsRtl
            }
        ],
        showPrevButton: true
    };
    $.userSearchUiGuide = {
        init: function (opts) {
            $.sharedUiGuide.init({ startTourBtn: opts.tourBtn, tour: tour });
        }
    };
})(window.jQuery);