﻿(function ($) {

    $.inboundRoute = {
        init: function (e) {

            $('.btn-refresh').on('click', function () {
                $.inboundRoute.initGrid();
            });

            $.inboundRoute.initGrid();
        },
        initGrid: function (e) {

            var id = $('#InboundRoutingGrid');

            var dataSource = {
                transport: {
                    read: {
                        url: '/User/InboundRouting/Populate',
                        dataType: "json",
                        type: "GET"
                    }
                },
                schema: {
                    data: "Records",
                    total: "Total",
                    model: {
                        id: "IBRouteID"
                    }
                }
            };

            col = [
                {
                    field: "IsActive",
                    title: $settingsResource.grid.isActive,
                    sortable: false,
                    width: 120,
                    template: '<div class="kendo-container"> <i #= IsActive == true ? \'class="mdi fxc-checkbox-true"\' : "" #></i> </div>'
                },
                {
                    field: "IsRestrict",
                    title: $settingsResource.grid.isRestrict,
                    sortable: false,
                    width: 150,
					template: '<div class="kendo-container"> <i #= IsRestrict == true ? \'class="mdi fxc-checkbox-true"\' : "" #></i> </div>'
                },
                {
                    field: "AllowLoopBack",
                    title: $settingsResource.grid.allowLoopBack,
                    sortable: false,
                    width: 200,
					template: '<div class="kendo-container"> <i #= AllowLoopBack == true ? \'class="mdi fxc-checkbox-true"\' : "" #></i> </div>'
                },
                { field: "Priority", title: $settingsResource.grid.priority, width: 150 },
                { field: "RouteByStringExpr", title: $settingsResource.grid.routeByString, width: 350 }
            ];

            obj = {};

            var $grid = kendogridcustomization.init(id, dataSource, col, obj);
        }
    };
})(window.jQuery);