﻿(function ($) {
    var updateMode = false, closeDialog = false, selectedPrimaryChckBox = "", selectedPrimaryChckBoxValue = "";
    var $PassIsEncrypted = false;
    var $TempPassword;
    var tempdataItemAddress;
    var updateIdentityEmail = false, updateFromGrid = false;
    var userPreferFileFormatHtml = "PDF";
    var _profilevalidation = function () {
        $('#form-AddressProfile').validate({
            rules: {
                'personalinfo.DisplayName': { required: true, noSpace: true },
                'personalinfo.FirstName': { required: true, noSpace: true },
                'personalinfo.LastName': { required: true, noSpace: true },
                AddressDdlPrimaryEmail: { required: true }
            },
            messages: {
                AddressDdlPrimaryEmail: {
                    required: $settingsResources.minPrimaryEmail
                }
            },
            submitHandler: function (form) {
                $.personalinfo.Save(0);
            }
        });
    };

    var _NewAddressesvalidation = function () {
        $('#form-AddressDialog').validate({
            ignoreTitle: true,
            rules: {
                AddressDialog_Email: { required: true, email: true },
                AddressDialog_Address: { required: true, noSpace: true },
                AddressDialog_AddressUrl: { required: true, noSpace: true },
                AddressDialog_Number: { required: true, noSpace: true },
                AddressDialog_Path: { required: true, noSpace: true },
                AddressDialog_Printer: { required: true, noSpace: true },
                AddressDialog_LogonUID: { checkRequired: "AddressDialog_LogonPWD" },
                AddressDialog_LogonPWD: { checkRequired: "AddressDialog_LogonUID" }
            },
            submitHandler: function (form) {

                $.personalinfo.AddNewRecords();

            }
        });
    };

    var _EmailOTPValidation = function () {
        $('#EmailOTPform').validate({
			ignoreTitle: true,
            rules: {
                'Code': { required: true, noSpace: true }
            },
            submitHandler: function (form) {
                $.personalinfo.ValidateEmailOTP();
            }
        });
    };

    var _GoogleOTPValidation = function () {
        $('#GoogleOTPform').validate({
			ignoreTitle: true,
            rules: {
                'Code': { required: true, noSpace: true }
            },
            submitHandler: function (form) {
                $.personalinfo.ValidateGoogleOTP();
            }
        });
    };

    var _DisableGoogleOTPValidation = function () {
        $('#form-DisabledGoogleOTP').validate({
			ignoreTitle: true,
            rules: {
                'Code': { required: true, noSpace: true }
            },
            submitHandler: function (form) {
                $.personalinfo.DisableGoogleOTP();
            }
        });
    };

    var _DisableEmailOTPValidation = function () {
        $('#form-DisabledEmailOTP').validate({
			ignoreTitle: true,
            rules: {
                'Code': { required: true, noSpace: true }
            },
            submitHandler: function (form) {
                $.personalinfo.DisableEmailOTP();
            }
        });
    };

    var _ManagePasswordValidation = function () {
        $('#form-ManagePassword').validate({
			ignoreTitle: true,
            rules: {
                CurrentPasswordtxt: { required: true },
                NewPasswordtxt: { required: true, passwordFormat: true },
                ConfirmNewPasswordtxt: {
                    required: true,
                    equalTo: "#NewPasswordtxt"
                }
            },
            messages: {
                /*CurrentPasswordtxt: { required: '*This field is required.' },
                NewPasswordtxt: { required: '*This field is required.' },*/
                ConfirmNewPasswordtxt: {
                    /*required: '*This field is required.',*/
                    equalTo: $.validator.messages.passNotMatch
                }
            },
            submitHandler: function (form) {
                $.personalinfo.UpdatePassword();
            }
        });
    };

    var ResetField = function () {
        $('#AuthentificationCodetxt').val('');
        $('#EmailOTPCodetxt').val('');
        $('#VerificationGoogleNotxt').val('');
        $('#VerificationEmailNotxt').val('');
    };

    var ResetPasswordField = function () {
        $('#CurrentPasswordtxt').val('');
        $('#NewPasswordtxt').val('');
        $('#ConfirmNewPasswordtxt').val('');
    };

    $.personalinfo = {
        init: function (e) {
            $.personalinfo.gridAction();
            $.personalinfo.ClickHandlerAction();
            $.personalinfo.Hide();
            $.personalinfo.Disabled();
            $.personalinfo.Validation();
            $.personalinfo.ResetPassword();
            $.personalinfo.GetUserAction(0);

            $.fileFormat.init();

            /*Show All Action Button*/
            $(".btnGridAction").removeClass("hide");

            $('#AddressDialog_AddressType').on('change', function () {
                $('#form-AddressDialog').validate().resetForm();
                $('#AddressDialog_Number').val($('#AddressDialog_Number').attr("data-defaultTelco"));
                $('#AddressDialog_AddressType').attr("disabled", false);
            });
        },
        initGrid: function (e) {

            var id = $('#grid');

            var dataSource = {
                transport: {
                    read: {
                        url: '/User/UserProfile/GetAddressList',
                        dataType: "json",
                        type: "GET"
                    }
                },
                schema: {
                    data: function (data) {
                        $.personalinfo.populateEmailData(data.Records);
                        return data.Records;
                    },
                    total: "Total",
                    model: {
                        id: "AddressID",
                        fields: {
                            NOR: { type: 'bool' },
                            NOS: { type: 'bool' },
                            IsPrimary: { type: 'bool' },
                            IsRemoved: { type: 'bool' },
                            AddressTypeName: { type: 'string' },
                            DisplayAddress: { type: 'string' }
                        }
                    }
                }
            };

            var col = [
                {
                    selectable: true, width: "45px",
                    attributes: {
                        "class": "checkboxSelection"
                    }
                },
                {
                    attributes: {
                        "class": "checkboxSelection"
                    },
                    field: "NOR",
                    title: $settingsResources.grid.nor,
                    width: 65,
                    template: '<div class="custom-checkbox"><input class="k-checkbox-custom rrs" #= NOR == true ? \'checked="checked"\' : "" # data-role="checkbox" data-id="#= AddressID #" id="nor-#= AddressID #" type="checkbox"> '
                        + '    <label for="nor-#= AddressID #" class="k-checkbox-custom-label k-no-text" aria-label="' + $settingsResources.grid.norTooltip +'">'+ $settingsResources.grid.norTooltip +'</label></div>'
                },
                {
                    attributes: {
                        "class": "checkboxSelection"
                    },
                    field: "NOS",
                    title: $settingsResources.grid.nos,
                    width: 65,
                    template: '<div class="custom-checkbox"><input class="k-checkbox-custom rrf" #= NOS == true ? \'checked="checked"\' : "" # data-role="checkbox" data-id="#= AddressID #" id="nos-#= AddressID #" type="checkbox"> '
                        + '     <label for="nos-#= AddressID #" class="k-checkbox-custom-label k-no-text" aria-label="' + $settingsResources.grid.nosTooltip +'">'+$settingsResources.grid.nosTooltip+'</label></div>'
                },
                {
                    attributes: {
                        "class": "checkboxSelection"
                    },
                    field: "IsPrimary",
                    title: $settingsResources.grid.primary,
                    width: 103,
                    template: '<div class="custom-checkbox"><input class="k-checkbox-custom rrf" #= IsPrimary == true ? \'checked="checked"\' : "" # data-role="checkbox" data-id="#= AddressID #" id="primary-#= AddressID #" type="checkbox"> '
                        + '     <label for="primary-#= AddressID #" class="k-checkbox-custom-label k-no-text" aria-label="' + $settingsResources.grid.primaryTooltip + '">' + $settingsResources.grid.primaryTooltip +'</label></div>'
                },
                { field: 'rowNumber', hidden: true },
                { field: 'AddressID', hidden: true },
                { field: 'IsRemoved', hidden: true },
                { field: 'AddressTypeName', title: $areaResources.grid.addressType, width: 150 },
                { field: 'RowDisplayAddress', title: $areaResources.grid.address, width: 450 },
                { field: 'DisplayAddress', hidden: true },
                { field: 'TxtAddr', hidden: true },
                { field: 'TxtTelco', hidden: true },
                { field: 'TxtUid', hidden: true },
                { field: 'TxtPwd', hidden: true },
                { field: 'TxtPwdIsEncrypted', hidden: true },
                { field: 'TxtSvr', hidden: true },
                { field: 'TxtPath', hidden: true },
                { field: 'DdlPrinterName', hidden: true },
                { field: 'DdlPrinterValue', hidden: true },
                { field: 'DdlFormat', title: $settingsResources.grid.format, sortable: true, width: 80 },
            ];

            var obj = {};
            obj.customizeCheckbox = true;
            obj.allowSelectMultipleRow = true;
            obj.customizeCheckboxFn = $.personalinfo.GridChecboxActionHandler;

            obj.onSelectionFn = $.personalinfo.editPersonalInfoGrid;

            kendogridcustomization.init(id, dataSource, col, obj);
        },
        gridAction: function () {
            $.personalinfo.populateValue();
            $.personalinfo.initGrid();
        },
        ClickHandlerAction: function () {
            $.personalinfo.editProfileButtonClickHandler('.faxcore-edit-action');
            $.personalinfo.cancelProfileButtonClickHandler('.faxcore-cancel-action');
            $.personalinfo.DeleteAddresses('.btn-delete');
            $.personalinfo.TwoFactor_Authentication_View('.btn-factorAuthentication');
            $.personalinfo.AddAsNew('.btnNew');
            $.personalinfo.AuthentificationOnChange_View('#TwoAuthenticationProvider');
            $.personalinfo.AuthenticateSwitchHandler('#AllowTwoFactor');
            $.personalinfo.BackToProfile_View('#TwoAuth-btn');
            $.personalinfo.VerifyGoogleTwoFactorAuthCode('#VerifyGoogleAuth-btn');
            $.personalinfo.VerifyEmailTwoFactorAuthCode('#btn-confirmcode');
            $.personalinfo.DisabledGoogleOTPClickHandler('#DisableGoogleAuth-modal button[data-role="verify-modal-value"]');
            $.personalinfo.DisabledEmailOTPClickHandler('#DisableEmailAuth-modal button[data-role="verify-modal-value"]');
            $.personalinfo.ConfirmSendEmailClickHandler('#EmailOTPform .btn-confirmemail');
            $.personalinfo.AddRecords($('#AddressDialog-modal button[data-role="save-modal"]'));
            $.personalinfo.savePasswordClickHandler('#managePassword-modal button[data-role="save-modal"]');
            $.personalinfo.SaveProfileButtonClickHandler('#profileEdit-View .faxcore-save-info-action');

            $.personalinfo.applyFileFormatButtonClickHandler($(".btn-applyfileformat-grid"));

            $('#BtnAddNewAddressDialog').on('click', function (click) {
                click.preventDefault();
                updateMode = false;
                closeDialog = false;
                $('#form-AddressDialog').submit();
            });

            $('#BtnAddCloseAddressDialog').on('click', function (click) {
                click.preventDefault();
                updateMode = false;
                closeDialog = true;
                $('#form-AddressDialog').submit();
            });

            $('#BtnUpdateAddressDialog').on('click', function (click) {
                updateMode = true;
                closeDialog = true;
                $('#form-AddressDialog').submit();
            });

            $('.btn-managePassword').on('click', function (click) {
                $('.info-tooltip').tooltip();

                $('#managePassword-modal').modal('show');
                ResetPasswordField();
                $('#form-ManagePassword').validate().resetForm();
            });

            $('#AddressDialog-modal button[data-role="reset-modal-value"]').on('click', function (click) {
                var selectedId = $('#HfAddressID').val() || "0";
                if (selectedId !== "0") {
                    var dataArr = $("#grid").data("kendoGrid").dataSource.data();

                    dataArr = $.grep(dataArr, function (n, i) {
                        return n.AddressID.toString() === selectedId;
                    });

                    $.personalinfo.editPersonalInfoGrid(dataArr[0]);
                } else {
                    $.personalinfo.resetFields();
                }
            });
        },
        Hide: function () {
            $.sectionproperties.HideElements("#profileEdit-View", true);
            $.sectionproperties.HideElements(".TwoFactorAuthentication-View", true);
            $.sectionproperties.HideElements("#GoogleVerify-View", true);
            $.sectionproperties.HideElements("#EmailVerify-View", true);
            $.sectionproperties.HideElements(".faxcore-cancel-action", true);
            $.sectionproperties.HideElements("#TwoAuthenticationProvider", true);
        },
        Disabled: function () {
            $('#TwoAuthenticationProvider').prop('disabled', true);
        },
        Validation: function () {
            _NewAddressesvalidation();
            _profilevalidation();
            _EmailOTPValidation();
            _GoogleOTPValidation();
            _DisableEmailOTPValidation();
            _DisableGoogleOTPValidation();
            _ManagePasswordValidation();
        },

        /*Start Two Factor Authenticatator*/
        TwoFactor_Authentication_View: function (e) {
            $(e).on('click', function () {
                $.personalinfo.GetUserAction(0);
                $.sectionproperties.HideElements(".Addresses-Grid", true);
                $.sectionproperties.HideElements(".TwoFactorAuthentication-View", false);
            });
        },
        AuthenticateSwitchHandler: function (e) {
            $('#AllowTwoFactor').on('switchChange.bootstrapSwitch', function (e) {
                $.personalinfo.GetUserAction(1);
            });
        },
        GetUserAction: function (e) {
            var action = parseInt(e);
            fxcRequest.post('/User/UserProfile/GetiDUser',
                null,
                function (data) {
                    var auth = parseInt(data.TwoFactorEnabled);
                    switch (action) {
                        case 0: /*populate*/
                            $.sectionproperties.HideElements("#GoogleVerify-View", true);
                            $.sectionproperties.HideElements("#EmailVerify-View", true);
                            $('#AllowTwoFactor').bootstrapSwitch('state', auth);
                            if (auth == 1) {
                                $.sectionproperties.HideElements("#twofactor_lbl", true);
                                $.sectionproperties.HideElements("#twofactor_enablelbl", false);
                                $.sectionproperties.HideElements("#TwoAuthenticationProvider", true);
                            } else {
                                $.sectionproperties.HideElements("#twofactor_lbl", false);
                                $.sectionproperties.HideElements("#twofactor_enablelbl", true);
                                $.sectionproperties.HideElements("#TwoAuthenticationProvider", true);
                            }
                            break;
                        case 1: /*switch change action Handler*/
                            var checked = $('#AllowTwoFactor').prop('checked');
                            if (auth == 1) {
                                if (checked == false) {
                                    if (data.TwoFactorProvider == "googletwofactorauthenticator") {
                                        $.personalinfo.switchActionHandler(0);
                                    }
                                    else if (data.TwoFactorProvider == "emailtwofactor") {
                                        $.personalinfo.switchActionHandler(1);
                                    }
                                }
                            } else {
                                if (checked == false) {
                                    $.personalinfo.switchActionHandler(2);
                                } else {
                                    $.personalinfo.switchActionHandler(3);
                                }
                            }
                            break;
                    }
                },
                function (error) {
                    /*console.log(error);*/
                },
                false
            );
        },

        switchActionHandler: function (e) {
            switch (e) {
                case 0:  /*show Disable Google Auth pop up*/
                    $('#DisableGoogleAuth-modal').modal('show');
                    break;
                case 1:  /*show Disable Google Auth pop up*/
                    $('#DisableEmailAuth-modal').modal('show');
                    $('#EmailAuthCode-hidden').val(1);
                    $.personalinfo.EmailTwoFactorAuth();
                    break;
                case 2:
                    $('#TwoAuthenticationProvider').val('0');
                    $.sectionproperties.HideElements("#TwoAuthenticationProvider", true);
                    $('#TwoAuthenticationProvider').change();
                    break;
                case 3:
                    $('#TwoAuthenticationProvider').val('0');
                    $.sectionproperties.HideElements("#TwoAuthenticationProvider", false);
                    $('#TwoAuthenticationProvider').change();
                    $('#TwoAuthenticationProvider').prop("disabled", false);
                    break;
            }
        },

        /*get selected provider*/
        AuthentificationOnChange_View: function (e) {
            $(e).on('change', function () {
                var provider = parseInt($(e).val());
                switch (provider) {
                    case 0:
                        $.sectionproperties.HideElements("#GoogleVerify-View", true);
                        $.sectionproperties.HideElements("#EmailVerify-View", true);
                        break;
                    case 1:
                        $.personalinfo.GoogleTwoFactorAuth();
                        $.sectionproperties.HideElements("#GoogleVerify-View", false);
                        $.sectionproperties.HideElements("#EmailVerify-View", true);
                        $.sectionproperties.HideElements("#VerifyGoogleAuth-btn", false);
                        break;
                    case 2:
                        $.sectionproperties.HideElements("#EmailOTP", true);
                        $.sectionproperties.HideElements("#GoogleVerify-View", true);
                        $.sectionproperties.HideElements("#EmailVerify-View", false);
                        $.sectionproperties.HideElements("#btn-confirmcode", false);
                        break;
                }
                $('#GoogleOTPform').validate().resetForm();
            });
        },
        /*get user Primary email*/

        /*Back to profile View*/
        BackToProfile_View: function (e) {
            $(e).on('click', function () {
                $.sectionproperties.HideElements(".Addresses-Grid", false);
                $.sectionproperties.HideElements(".TwoFactorAuthentication-View", true);
				kendogridcustomization.customizeGridHeight($('#grid'));
            });
        },
        /*Two Factor Api*/
        GoogleTwoFactorAuth: function (e) {
            fxcRequest.get('/User/UserProfile/EnableGoogleTwoFactorAuthenticatorSetup',
                null,
                function (data) {
                    $('#SecretKey-hidden').val(data.SecretKey);
                    $("#qrUrl").html("");
                    $("#qrUrl").kendoQRCode({
                        value: data.BarcodeUrl,
                        errorCorrection: "M"
                    });
                },
                function (error) {
                    /*console.log(error);*/
                }
            );
        },
        ConfirmSendEmailClickHandler: function (e) {
            $(e).on('click', function () {
                $.personalinfo.EmailTwoFactorAuth();
                $.sectionproperties.HideElements("#EmailOTP", false);
                $.sectionproperties.HideElements("#GoogleVerify-View", true);
                $.sectionproperties.HideElements("#EmailVerify-View", false);
                $.sectionproperties.HideElements("#btn-confirmcode", false);
            });
        },
        EmailTwoFactorAuth: function (e) {
            fxcRequest.get('/User/UserProfile/SendEmailAuthCode',
                null,
                function (data) {
                    if (data.Result == 'true') {
                        var value = $('#EmailAuthCode-hidden').val();
                        if (value != '1' && value != 1) {
                            swal($globalMessages.swal.success.title, $settingsResources.emailCodeSent, "success");
                        }
                        $('#EmailAuthCode-hidden').val(0);
                    }
                    else if (data.Result == 'false') {
                        swal($globalMessages.swal.error.errorCap, $settingsResources.swal.emailTwoFactAuthFailed, "error");
                    }
                },
                function (error) {
                    /*console.log(error);*/
                }
            );
        },

        /*Verify Google Two Factor Authentication Code*/
        VerifyGoogleTwoFactorAuthCode: function (e) {
            $(e).on('click', function () {
                $('#GoogleOTPform').submit();
            });
        },
        ValidateGoogleOTP: function () {
            fxcRequest.post('/User/UserProfile/VerifyGoogleAuthCode',
                $.personalinfo.constructmodel(3),
                function (data) {
                    if (data.Result == 'true') {
                        swal($globalMessages.swal.success.title, $settingsResources.codeVerified, "success");
                        $.personalinfo.GetUserAction(0);
                        $('#TwoAuth-btn').click();
                    }
                    else if (data.Result == 'false') {
                        swal($globalMessages.swal.error.title, $settingsResources.codeNotValid, "error");
                    }
                    ResetField();
                },
                function (error) {
                    /*console.log(error);*/
                }
            );
        },

        /*Disable Google Auth*/
        DisabledGoogleOTPClickHandler: function (e) {
            $(e).on('click', function () {
                $('#TwoFactorDisableNo-hidden').val(1);
                $('#form-DisabledGoogleOTP').submit();
            });
        },
        DisableGoogleOTP: function () {
            fxcRequest.post('/User/UserProfile/DisabledGoogleTwoFactor',
                $.personalinfo.constructmodel(5),
                function (data) {
                    if (data.Result == 'true') {
                        $('#DisableGoogleAuth-modal').modal('hide');
                        swal($globalMessages.swal.success.title, $settingsResources.disabledSuccess, "success");
                        $.personalinfo.GetUserAction(0);
                        $('#TwoAuth-btn').click();
                        ResetField();
                    }
                    else if (data.Result == 'false') {
                        swal($globalMessages.swal.error.title, $settingsResources.codeNotValid, "error");
                    }
                    ResetField();
                },
                function (error) {
                    /*console.log(error);*/
                }
            );
        },

        /*Verify Email Factor Authentication Code*/
        VerifyEmailTwoFactorAuthCode: function (e) {
            $(e).on('click', function () {
                $('#EmailOTPform').submit();
            });
        },
        ValidateEmailOTP: function () {
            fxcRequest.post('/User/UserProfile/VerifyEmailAuthCode',
                $.personalinfo.constructmodel(3),
                function (data) {
                    if (data.Result == 'true') {
                        swal($globalMessages.swal.success.title, $settingsResources.codeVerified, "success");
                        $.personalinfo.GetUserAction(0);
                        $('#TwoAuth-btn').click();
                    } else if (data.Result == 'false') {
                        swal($globalMessages.swal.error.title, $settingsResources.codeNotValid, "error");
                    }
                    ResetField();
                },
                function (error) {
                    /*console.log(error);*/
                }
            );
        },
        /*Disable Email Atuh*/
        DisabledEmailOTPClickHandler: function (e) {
            $(e).on('click', function () {
                $('#TwoFactorDisableNo-hidden').val(2);
                $('#form-DisabledEmailOTP').submit();
            });
        },
        DisableEmailOTP: function () {
            fxcRequest.post('/User/UserProfile/DisableEmailAuthCode',
                $.personalinfo.constructmodel(5),
                function (data) {
                    if (data.Result == 'true') {
                        $('#DisableEmailAuth-modal').modal('hide');
                        swal($globalMessages.swal.success.title, $settingsResources.disabledSuccess, "success");
                        $.personalinfo.GetUserAction(0);
                        $('#TwoAuth-btn').click();
                        ResetField();
                    } else if (data.Result == 'false') {
                        swal($globalMessages.swal.error.title, $settingsResources.codeNotValid, "error");
                    }
                    ResetField();
                },
                function (error) {
                    /*console.log(error);*/
                }
            );
        },

        /*Manage Password*/
        UpdatePassword: function (e) {
            fxcRequest.post('/User/UserProfile/changePassword',
                $.personalinfo.constructmodel(4),
                function (data) {
                    swal($globalMessages.swal.success.title, $settingsResources.updateSuccess, "success");
                    $('#managePassword-modal').modal('hide');
                    ResetPasswordField();
                },
                function (error) {
                    /*console.log(error);*/
                }
            );
        },
        ResetPassword: function (e) {
            $("#AddressDialog_LogonPWD").focus(function () {
                if ($PassIsEncrypted) {
                    $TempPassword = $("#AddressDialog_LogonPWD").val();
                    $("#AddressDialog_LogonPWD").val("");
                }
            });
            $("#AddressDialog_LogonPWD").keyup(function () {
                $PassIsEncrypted = false;
            });
            $("#AddressDialog_LogonPWD").focusout(function () {
                if ($PassIsEncrypted) {
                    $("#AddressDialog_LogonPWD").val($TempPassword);
                }

            });
        },
        /*Manage Password*/

        editProfileButtonClickHandler: function (e) {
            $(e).on('click', function () {
                $.personalinfo.disabledGrid(true);

                $.sectionproperties.HideElements("#profileInfo-View", true);
                $.sectionproperties.HideElements("#profileEdit-View", false);
                $.sectionproperties.HideElements(".faxcore-edit-action", true);
                $.sectionproperties.HideElements(".faxcore-cancel-action", false);
                $("select#Address_AddressType").change();
            });
        },
        cancelProfileButtonClickHandler: function (e) {
            $(e).on('click', function () {
                $('#form-AddressProfile').validate().resetForm();
                $.personalinfo.disabledGrid(false);
                $.personalinfo.populateValue();
                $.sectionproperties.HideElements("#profileInfo-View", false);
                $.sectionproperties.HideElements("#profileEdit-View", true);
                $.sectionproperties.HideElements(".faxcore-edit-action", false);
                $.sectionproperties.HideElements(".faxcore-cancel-action", true);
            });
        },
        constructmodel: function (e) {
            var dataItem = $('#grid').data("kendoGrid");
            var datalist = [];

            switch (e) {
                case 0:
                    /*Save user contact*/
                    return {
                        'UserContact': {
                            'DisplayName': $('#DisplayNametxt').val(),
                            'FirstName': $('#FirstNametxt').val(),
                            'LastName': $('#LastNametxt').val(),
                            'PreferAddressTypeID': $('#Address_AddressType').val(),
                            'PrimaryEmail': $('#AddressDdlPrimaryEmail option:selected').text(),
                            'PrimaryEmailAddressID': $('#AddressDdlPrimaryEmail option:selected').val()
                        },
                        'AddressListString': JSON.stringify(datalist),
                        'Choice': 'UserContact'
                    };
                case 1: /*Save user ContactAddress*/
                    /*Add As New*/

                    datalist = $.personalinfo.BindData(dataItem.dataSource.data());
                    return {
                        'UserContact': {
                            'PreferAddressTypeID': $('#Address_AddressType').val(),
                            'PrimaryEmail': $('#AddressDdlPrimaryEmail option:selected').text(),
                            'PrimaryEmailAddressID': $('#AddressDdlPrimaryEmail option:selected').val(),
                            'SelectedPrimaryChckBox': selectedPrimaryChckBox,
                            'SelectedPrimaryChckBoxValue': selectedPrimaryChckBoxValue.toString()
                        },
                        'AddressListString': JSON.stringify(datalist),
                        'Choice': 'ContactAddress'
                    };
                case 2: /*Save user ContactAddress and user contact*/
                    /*Add As New*/
                    datalist = $.personalinfo.BindData(dataItem.dataSource.data());
                    return {
                        'UserContact': {
                            'DisplayName': $('#DisplayNametxt').val(),
                            'FirstName': $('#FirstNametxt').val(),
                            'LastName': $('#LastNametxt').val(),
                            'PreferAddressTypeID': $('#Address_AddressType').val(),
                            'PrimaryEmail': $('#AddressDdlPrimaryEmail option:selected').text(),
                            'PrimaryEmailAddressID': $('#AddressDdlPrimaryEmail option:selected').val()
                        },
                        'AddressListString': JSON.stringify(datalist),
                        'Choice': 'All'
                    };
                case 3:
                    /*Verify Two Factor Authentication Code*/
                    var value = $('#TwoAuthenticationProvider').val();
                    switch (value) {
                        case '0':
                            break;
                        case '1':
                            return {
                                'SecretKey': $('#SecretKey-hidden').val(),
                                'Code': $('#AuthentificationCodetxt').val(),
                                'RememberMe': 'false',
                                'RememberBrowser': 'false'
                            };
                        case '2':
                            return {
                                'Code': $('#EmailOTPCodetxt').val()
                            };
                    }
                    break;
                case 4:
                    /*Update Password*/
                    return {
                        'OldPassword': $('#CurrentPasswordtxt').val(),
                        'NewPassword': $('#NewPasswordtxt').val(),
                        'ConfirmPassword': $('#ConfirmNewPasswordtxt').val()
                    };
                case 5:
                    /*Disable Two Factor Authentication Code*/

                    var twotFactorValue = $('#TwoFactorDisableNo-hidden').val();
                    switch (twotFactorValue) {
                        case '0':
                            break;
                        case '1':
                            return {
                                'Code': $('#VerificationGoogleNotxt').val(),
                                'RememberMe': 'false',
                                'RememberBrowser': 'false'
                            };
                        case '2':
                            return {
                                'Code': $('#VerificationEmailNotxt').val()
                            };
                    }
            }
        },
        populateValue: function () {
            fxcRequest.get('/User/UserProfile/PersonalInfo',
                "",
                function (data) {
                    $.personalinfo.Helper_GetEmptyString('DisplayNamelbl/lbl,DisplayNametxt/txt', data.DisplayName);
                    $.personalinfo.Helper_GetEmptyString('FirstNamelbl/lbl,FirstNametxt/txt', data.FirstName);
                    $.personalinfo.Helper_GetEmptyString('LastNamelbl/lbl,LastNametxt/txt', data.LastName);
                    $.personalinfo.Helper_GetEmptyString('PreferAddressNamelbl/lbl', data.PerferAddressName);
                    $.personalinfo.Helper_GetEmptyString('PreferEmaillbl/lbl', $('#UserPrimaryEmail').val().trim());
                    $('#EmailVerifylbl').html($('#UserPrimaryEmail').val().trim());

                    $('#UserNametxt').val(data.UserName);

                    $('#AddressDialog_AddressType').html('');
                    $('#AddressDialog_AddressType').html(data.AddressTypeOptions);

                    $('#AddressDialog_Printer').html('');
                    $('#AddressDialog_Printer').html(data.PrinterOptions);

                    $('.btn-update-addressDialog').css("display", "none");

                    userPreferFileFormatHtml = data.UserPreferFileFormatHtml;

                    var stateFormat = userPreferFileFormatHtml == 'PDF';
                    $('#AddressDialog_Format').bootstrapSwitch('state', stateFormat);

                    $.sectionproperties.selectGenerator('Address_AddressType', data.PreferedAddressType.Source, data.PreferedAddressType.Value, 0);
                },
                function (error) {
                    /*console.log(error);*/
                }
            );
        },
        editPersonalInfoGrid: function (dataItem) {
            tempdataItemAddress = dataItem;
            var txtTelco = dataItem.TxtTelco || '';
            $('.btn-update-addressDialog').css("display", "block");
            $('#form-AddressDialog').trigger("reset");
            $('#form-AddressDialog').validate().resetForm();
            $('#BtnUpdateAddressDialog').show();

            /*console.log(tempdataItemAddress);*/
            $('#HfAddressID').val(dataItem.AddressID);

            $('#AddressDialog_AddressType').val(dataItem.AddressTypeID);
            $('#AddressDialog_AddressType').change();

            if (dataItem.AddressID == $('#AddressDdlPrimaryEmail option:selected').val() || (dataItem.AddressTypeID == $('#Address_AddressType').val() && dataItem.IsPrimary)) {
                $('#AddressDialog_AddressType').attr("disabled", true);
            }
            else {
                $('#AddressDialog_AddressType').attr("disabled", false);
            }

            $('#AddressDialog_Email').val(dataItem.TxtEmail);
            $('#AddressDialog_Address').val(dataItem.TxtAddr);
            $('#AddressDialog_AddressUrl').val(dataItem.TxtUrl);
            $('#AddressDialog_Number').val(txtTelco);
            $('#AddressDialog_Server').val(dataItem.TxtSvr);
            $('#AddressDialog_Path').val(dataItem.TxtPath);
            $('#AddressDialog_LogonUID').val(dataItem.TxtUid);
            $('#AddressDialog_LogonPWD').val(dataItem.TxtPwd);
            $PassIsEncrypted = dataItem.TxtPwdIsEncrypted;
            $('#AddressDialog_Printer').val(dataItem.DdlPrinterValue);

            var stateFormat = dataItem.DdlFormat == 'PDF';
            $('#AddressDialog_Format').bootstrapSwitch('state', stateFormat);

            $('#AddressDialog_ReceiveNotification').prop('checked', dataItem.NOR);
            $('#AddressDialog_SendNotification').prop('checked', dataItem.NOS);

            $('#AddressDialog-modal').modal('show');
        },
        GridChecboxActionHandler: function (dataItem, e) {

            selectedPrimaryChckBox = dataItem.AddressID;
            selectedPrimaryChckBoxValue = dataItem.IsPrimary;

            var valid = true;
            var rawId = e[0].id;
            var arr = rawId.split("-");

            if (arr[0] == "primary") {
                valid = $.personalinfo.validateContactAddress(dataItem);
            }

            if (valid) {
                var dataSource = $('#grid').data("kendoGrid").dataSource.data();
                for (i = 0; i < dataSource.length; i++) {
                    if (dataSource[i].uid == dataItem.uid) {
                        dataSource[i].NOS = dataItem.NOS;
                        dataSource[i].NOR = dataItem.NOR;
                        dataSource[i].IsPrimary = dataItem.IsPrimary;
                    }
                }
                /*console.log($.personalinfo.BindData(dataSource));*/
                var obj = $.personalinfo.BindData(dataSource);
                /*console.log(obj.NOR);*/
                $.personalinfo.Save(1, "");
            }
        },
        validateContactAddress: function (dataItem) {
            var valid = true;
            var addrType = $('#Address_AddressType').val();
            var allData;

            if (dataItem != null) {
                /*validate checkbox action*/
                var cbAddrType = dataItem.AddressTypeID;

                /*check at least have 1 primary Primary*/
                var all = $('#grid').data("kendoGrid").dataSource.data();
                var filterall = $.grep(all, function (n, i) {
                    return n.IsPrimary;
                });

                if (filterall.length == 0) {
                    swal("", $settingsResources.select1Address);
                    $.personalinfo.initGrid();
                    valid = false;
                } else {
                    /*check base on click cb*/
                    if (cbAddrType == "1") {
                        /*$('#UserPrimaryEmail').val().trim(); $('#AddressDdlPrimaryEmail').val().trim();*/
                        var newPrimaryEmailAddID = $('#AddressDdlPrimaryEmail option:selected').val();
                        var isPrimary = newPrimaryEmailAddID == dataItem.AddressID;
                        if (isPrimary) {
                            swal("", $settingsResources.addressIsYourEmail);
                            $.personalinfo.initGrid();
                            valid = false;
                        }
                    } else {
                        allData = $('#grid').data("kendoGrid").dataSource.data();
                        var filterData;                        
                        if (addrType == cbAddrType) {
                            filterData = $.grep(allData, function (n, i) {
                                return n.AddressTypeID == cbAddrType && n.IsPrimary;
                            });
                        } else {
                            filterData = $.grep(allData, function (n, i) {
                                return n.AddressTypeID == cbAddrType;
                            });
                        }

                        if (filterData.length == 0) {
                            var ddlTypeId = '#Address_AddressType option[value="' + cbAddrType + '"]';
                            var text = $(ddlTypeId).html();
                            swal("", $settingsResources.prefSetToAdd.strFormat(text, text));
                            $.personalinfo.initGrid();
                            valid = false;
                        }
                    }
                }
            } else {
                /*validate save action*/
                if (addrType == "1") {
                    valid = true;
                } else {
                    allData = $('#grid').data("kendoGrid").dataSource.data();
                    var addrTypefilterData = $.grep(allData, function (n, i) {
                        return n.AddressTypeID == addrType && n.IsPrimary;
                    });

                    if (addrTypefilterData.length == 0) {

                        var AddrDdlTypeId = '#Address_AddressType option[value="' + addrType + '"]';
                        var addrText = $(AddrDdlTypeId).html();
                        swal("", $settingsResources.prefSetToAdd.strFormat(addrText, addrText));

                        valid = false;
                    }
                }
            }
            return valid;
        },
        validateDeleteContactAddress: function (dataItem) {
            var valid = true;
            var addrType = $('#Address_AddressType').val();

            if (dataItem != null) {
                var itemAddrType = dataItem.AddressTypeID;

                if (itemAddrType == "1") { /* Login email */
                    var newPrimaryEmailAddID = $('#AddressDdlPrimaryEmail option:selected').val();
                    var isPrimary = newPrimaryEmailAddID == dataItem.AddressID;
                    if (isPrimary) {
                        swal($settingsResources.swal.delError, $settingsResources.swal.delLoginEmail.strFormat(dataItem.DisplayAddress), "error");
                        valid = false;
                    }
                } else if (addrType == itemAddrType) { /* Prefer Address Type */
                    var allData = $('#grid').data("kendoGrid").dataSource.data();

                    var filterData;

                    if (addrType == itemAddrType) {
                        filterData = $.grep(allData, function (n, i) {
                            return n.AddressTypeID == itemAddrType && n.IsPrimary && n.AddressID != dataItem.AddressID;
                        });

                        if (filterData.length == 0) {
                            var ddlTypeId = '#Address_AddressType option[value="' + itemAddrType + '"]';
                            var text = $(ddlTypeId).html();
                            swal($settingsResources.swal.delError, $settingsResources.swal.delPriAddr.strFormat(text, dataItem.DisplayAddress), "error");
                            valid = false;
                        }
                    }
                }
            }
            return valid;
        },
        DeleteAddresses: function (e) {
            $(e).on('click', function () {
                $(this).blur();
                var grid = $("#grid").data("kendoGrid");
                var dataValue = [];
                var valid = true;

                var selectedItem = grid.select();
                for (i = 0; i < selectedItem.length; i++) {
                    var item = grid.dataItem(selectedItem[i]);
                    valid = $.personalinfo.validateDeleteContactAddress(item);

                    if (valid) {
                        if (item.AddressID !== "0" && item.AddressID !== 0) {
                            item.AddressID.IsRemoved = true;
                            var rownumber = parseInt(item.rowNumber);
                            rownumber = rownumber - 1;
                            grid.dataSource.data()[rownumber].IsRemoved = true;
                        }
                    }
                    else {
                        break;
                    }
                }
                var selectTion = $("#grid").data("kendoGrid").select().length;
                if (selectTion === 0) {
                    swal("", $areaResources.swal.noAddrrSelected);
                    return false;
                } else {
                    if (valid) {
                        swal({
                            title: "",
                            text: $settingsResources.questAddressDel,
                            type: "info",
                            showCancelButton: true,
                            closeOnConfirm: true,
                            reverseButtons: true,
                            showLoaderOnConfirm: false
                        }, function () {
                            $.personalinfo.Save(1, "delete");
                        });
                    }
                    else {
                        $.personalinfo.initGrid();
                    }
                }
            });
        },
        BindData: function (value) {
            var dataList = [];

            $.each(value, function (index, value) {
                dataList[index] = {
                    AddressID: value.AddressID,
                    AddressTypeID: value.AddressTypeID,
                    AddressTypeName: value.AddressTypeName,
                    CanonicalAddress: value.CanonicalAddress,
                    CompanyName: value.CompanyName,
                    ContactID: value.ContactID,
                    CrDate: value.CrDate,
                    /*Date: value.Date,*/
                    DisplayAddress: value.DisplayAddress,
                    DisplayName: value.DisplayName,
                    GroupContactID: value.GroupContactID,
                    GroupListID: value.GroupListID,
                    IsPrimary: value.IsPrimary,
                    IsRemoved: value.IsRemoved,
                    IsSync: value.IsSync,
                    NOR: value.NOR,
                    NOS: value.NOS,
                    NotifyAddress: value.NotifyAddress,
                    Sequence: value.Sequence,
                    IsPwdEncrypted: value.TxtPwdIsEncrypted
                };
            });

            return dataList;
        },
        savePasswordClickHandler: function (e) {
            $(e).on('click', function () {
                $('#form-ManagePassword').submit();
            });
        },
        SaveProfileButtonClickHandler: function (e) {
            $(e).on('click', function () {
                var selectedEmail = $('#AddressDdlPrimaryEmail option:selected').text().toLowerCase();
                var currentEmail = $('#UserPrimaryEmail').val().toLowerCase();
                if (selectedEmail != currentEmail) {
                    updateIdentityEmail = true;
                }
                $('#form-AddressProfile').submit();
            });
        },
        managePasswordClickHandler: function (e) {
            $('#form-ManagePassword').submit();
        },
        Save: function (e, action) {
            var model;
            var valid;

            if (e == 0 || e == 2) {
                valid = $.personalinfo.validateContactAddress();
            } else {
                valid = true;
            }

            if (valid) {
                switch (e) {
                    case 0:
                        model = $.personalinfo.constructmodel(0);
                        break;
                    case 1:
                        model = $.personalinfo.constructmodel(1);
                        break;
                    case 2:
                        model = $.personalinfo.constructmodel(2);
                        break;
                }

                fxcRequest.post('/User/UserProfile/SavePersonalInfo',
                    { 'personalinfo': model },
                    function (data) {
                        if (data.Result == 'true') {

                            if (e == 0 || e == 2) {
                                $.personalinfo.disabledGrid(false);
                                $.sectionproperties.HideElements("#profileInfo-View", false);
                                $.sectionproperties.HideElements("#profileEdit-View", true);
                                $.sectionproperties.HideElements(".faxcore-edit-action", false);
                                $.sectionproperties.HideElements(".faxcore-cancel-action", true);
                            }


                            if (e == 1) {
                                /*$.personalinfo.populateEmailData();*/
                            }
                            else {
                                $.personalinfo.populateValue();
                            }

                            $.personalinfo.initGrid();
                            $.personalinfo.resetFields();
                            $.toast({
                                heading: $globalMessages.toast.Success,
                                text: $areaResources.toast.table.update.text,
                                position: 'top-right',
                                loaderBg: '#ff6849',
                                icon: 'success',
                                hideAfter: 3500,
                                stack: 6
                            });

                            if (action == "delete") {
                                swal($globalMessages.swal.done, $settingsResources.addressDeleted, "success");
                            }

                            /* Only update primary email if user changes it */
                            if (updateIdentityEmail) {
                                $.personalinfo.updatePrimaryEmail(e);
                            }
                        }
                    }, function (error) {
                        $.personalinfo.populateValue();
                        $.personalinfo.initGrid();
                        if (!error.isResponseValidationErrors) {
                            swal($globalMessages.swal.error.title, error.statusText, "error");
                        }
                    }, false, null, null, function () {
                        $.personalinfo.initGrid();
                    });
            }
        },
        AddAsNew: function (e) {
            $(e).on('click', function () {

                $.personalinfo.resetFields();

                $('#BtnUpdateAddressDialog').hide();
                $('#AddressDialog-modal').modal('show');
                $('#form-AddressDialog').validate().resetForm();
            });
        },
        resetFields: function (e) {
            $('#HfAddressID').val(0);
            $('.btn-update-addressDialog').css("display", "none");
            $('#form-AddressDialog').trigger("reset");
            $('#AddressDialog_AddressType').change();
            var mobilePrefix = $('#HfMobilePrefix').val();
            $('#AddressDialog_Number').val(mobilePrefix);
            $('#AddressDialog_Number').attr("data-defaultTelco", mobilePrefix);

            var stateFormat = userPreferFileFormatHtml == 'PDF';
            $('#AddressDialog_Format').bootstrapSwitch('state', stateFormat);
        },
        AddRecords: function (e) {
            $(e).on('click', function (click) {
                $('#form-AddressDialog').submit();
            });
        },
        getAddrDialogData: function (e) {

            var formatVal = $('#AddressDialog_Format').prop('checked');
            var format;
            if (formatVal) {
                format = $('#AddressDialog_Format')[0].dataset.onText;
            } else {
                format = $('#AddressDialog_Format')[0].dataset.offText;
            }

            var printterName = "";

            if ($('#AddressDialog_AddressType').val() == "6") {
                var printterid = $('#AddressDialog_Printer').val();
                var ddlprintid = '#AddressDialog_Printer option[value="' + printterid + '"]';
                printterName = $(ddlprintid)[0].innerText;
            }

            var dialogData = {
                "AddressTypeID": $('#AddressDialog_AddressType').val(),
                "TxtEmail": $('#AddressDialog_Email').val(),
                "TxtAddr": $('#AddressDialog_Address').val(),
                "TxtUrl": $('#AddressDialog_AddressUrl').val(),
                "TxtTelco": $('#AddressDialog_Number').val(),
                "TxtSvr": $('#AddressDialog_Server').val(),
                "TxtPath": $('#AddressDialog_Path').val(),
                "TxtUid": $('#AddressDialog_LogonUID').val(),
                "TxtPwd": $('#AddressDialog_LogonPWD').val(),
                "TxtPwdIsEncrypted": $PassIsEncrypted,
                "DdlPrinterValue": printterid,
                "DdlPrinterName": printterName,
                "DdlFormat": format
            };
            return dialogData;
        },
        AddNewRecords: function (e) {
            var printertype = $('#AddressDialog_AddressType').val() == '6';
            var nonselectprinter = $('#AddressDialog_Printer').val() == '0';
            if (printertype && nonselectprinter) {
                swal($globalMessages.swal.error.title, $settingsResources.printerRequired, "error");
            } else {
                var grid = $("#grid").data("kendoGrid");
                var isprimary = false;

                var queryModel = {
                    "PersonalAddress": $.personalinfo.getAddrDialogData()
                };

                var addressID = 0;
                if (updateMode) {
                    addressID = $('#HfAddressID').val();
                }

                fxcRequest.post('/User/UserProfile/AddAddress',
                    queryModel,
                    function (data) {
                        if (closeDialog) {
                            $('#AddressDialog-modal').modal('hide');
                        }
                        var addressTypeID = data.AddressTypeID;
                        var canonicalAddress = data.CanonicalAddress;
                        var displayAddress = data.DisplayAddress;

                        var ddlid = '#AddressDialog_AddressType option[value="' + addressTypeID + '"]';
                        var addrTypeName = $(ddlid)[0].innerText;
                        var newAddr = {
                            NOR: $('#AddressDialog_ReceiveNotification').prop("checked"),
                            NOS: $('#AddressDialog_SendNotification').prop("checked"),
                            IsPrimary: isprimary,
                            AddressID: addressID,
                            AddressTypeName: addrTypeName.toUpperCase(),
                            DisplayAddress: displayAddress,
                            CanonicalAddress: canonicalAddress,
                            'AddressTypeID': addressTypeID,
                            'IsRemoved': false,
                            "TxtPwdIsEncrypted": false
                        };
                        
                        if (updateMode) {
                            var identityEmail = $('#AddressDdlPrimaryEmail option:selected').val();
                            if (identityEmail == tempdataItemAddress.AddressID) {
                                updateIdentityEmail = true;
                                updateFromGrid = true;
                            }

                            var dataItem = grid.dataSource.get(addressID);
                            dataItem.set("NOR", newAddr.NOR);
                            dataItem.set("NOS", newAddr.NOS);
                            dataItem.set("IsPrimary", tempdataItemAddress.IsPrimary);
                            dataItem.set("AddressTypeName", newAddr.AddressTypeName);
                            dataItem.set("DisplayAddress", newAddr.DisplayAddress);
                            dataItem.set("CanonicalAddress", newAddr.CanonicalAddress);
                            dataItem.set("AddressTypeID", newAddr.AddressTypeID);
                            dataItem.set("IsRemoved", newAddr.IsRemoved);
                            dataItem.set("TxtPwdIsEncrypted", newAddr.TxtPwdIsEncrypted);

                        } else {
                            grid.dataSource.add(newAddr);
                        }

                        $.personalinfo.Save(1, "New");
                    },
                    function (error) {
                        /*console.log(error);*/
                    }, false
                );
            }
        },
        GetAddress: function (Address) {
            var data = {
                'DisplayAddress': '',
                'AddressTypeID': ''
            };

            var value = Address.toUpperCase();
            switch (value) {
                case 'EMAIL':
                    data.DisplayAddress = $('#AddressDialog_Address').val();
                    data.AddressTypeID = 1;
                    break;
                case 'RAWFAX':
                    data.DisplayAddress = $('#AddressDialog_Address').val();
                    data.AddressTypeID = 9;
                    break;
                case 'FILE':
                    data.DisplayAddress = $('#AddressDialog_Path').val();
                    data.AddressTypeID = 5;
                    break;
                case 'FTP':
                    data.DisplayAddress = $('#AddressDialog_AddressUrl').val();
                    data.AddressTypeID = 4;
                    break;
                case 'HTTP':
                    data.DisplayAddress = $('#AddressDialog_AddressUrl').val();
                    data.AddressTypeID = 3;
                    break;
                case 'FAX':
                    data.DisplayAddress = $('#AddressDialog_Number').val();
                    data.AddressTypeID = 2;
                    break;
                case 'MOBILE':
                    data.DisplayAddress = $('#AddressDialog_Number').val();
                    data.AddressTypeID = 7;
                    break;
                case 'PHONE':
                    data.DisplayAddress = $('#AddressDialog_Number').val();
                    data.AddressTypeID = 10;
                    break;
                case 'PRINTER':
                    data.DisplayAddress = $('#AddressDialog_Printer').val();
                    data.AddressTypeID = 6;
                    break;
            }
            return data;
        },
        Helper_GetEmptyString: function (IDSubString, Model) {
            var DomElementID = IDSubString.split(',');
            for (i = 0; i < DomElementID.length; i++) {
                var Extension = DomElementID[i].split('/');

                if (Model == "" || Model == null) {
                    if (Extension[1] == 'lbl') {
                        $('#' + Extension[0]).html("-");
                    }
                    if (Extension[1] == 'txt') {
                        $('#' + Extension[0]).val("");
                    }
                } else {
                    if (Extension[1] == 'lbl') {
                        $('#' + Extension[0]).html(Model);
                    }
                    if (Extension[1] == 'txt') {
                        $('#' + Extension[0]).val(Model);
                    }
                }
            }
        },
        populateEmailData: function (e) {
            var allData = e;
            var emailData = $.grep(allData, function (n, i) {
                return n.AddressTypeID.toString() == "1" && n.IsPrimary.toString() == "true";
            });

            $('#AddressDdlPrimaryEmail').empty();
            var primaryEmail = $('#UserPrimaryEmail').val().trim();
            $.each(emailData, function (index, value) {
                var displayAddress = value.DisplayAddress.trim();
                if (primaryEmail === displayAddress) {
                    $('#AddressDdlPrimaryEmail').append("<option value='" + value.AddressID + "' selected>" + value.DisplayAddress + "</option>");
                } else {
                    $('#AddressDdlPrimaryEmail').append("<option value='" + value.AddressID + "'>" + value.DisplayAddress + "</option>");
                }

            });
        },
        updatePrimaryEmail: function (e) {
            var newPrimaryEmail = $('#AddressDdlPrimaryEmail option:selected').text().trim();
            var newPrimaryEmailAddressID = $('#AddressDdlPrimaryEmail option:selected').val().trim();

            if (updateFromGrid) {
                newPrimaryEmail = tempdataItemAddress.DisplayAddress;
                newPrimaryEmailAddressID = tempdataItemAddress.AddressID;
            }

            fxcRequest.post('/User/UserProfile/UpdatePrimaryEmail',
                { 'newPrimaryEmail': newPrimaryEmail },
                function (data) {
                    $('#UserPrimaryEmail').val(newPrimaryEmail);
                    $('#AddressDdlPrimaryEmail').val(newPrimaryEmailAddressID);
                    $.personalinfo.Helper_GetEmptyString('PreferEmaillbl/lbl', $('#UserPrimaryEmail').val().trim());

                    updateIdentityEmail = false;
                    updateFromGrid = false;

                    fxcUserConn.onUpdateLoginEmail($('#FxcUserId').val());
                },
                function (error) {
                    /*console.log(error);*/
                },
                false
            );
        },
        disabledGrid: function (value) {
            if (value) {
                console.log("Disabled Grid");
                $(".gridOverlay").addClass("show");
                $(".btnNew").attr("disabled", true);
                $(".btn-delete").attr("disabled", true);
            }
            else {
                console.log("Enabled Grid");
                $(".gridOverlay").removeClass("show");
                $(".btnNew").attr("disabled", false);
                $(".btn-delete").attr("disabled", false);
            }
        },
        applyFileFormatButtonClickHandler: function (e) {
            $(e).on('click', function (x) {
                $(this).blur();
                $.personalinfo.applyFileFormat(this);
            });
        },
        applyFileFormat: function (e) {
            var grid = $("#grid").data("kendoGrid");
            var selectedItem = grid.select();
            if (selectedItem.length === 0) {
                swal("", $areaResources.swal.noAddrrSelected);
                $(e).attr("disabled", false);
                return false;
            }

            $.fileFormat.reset();
        },
    };

    $.fileFormat = {
        init: function (e) {
            /*Btn Action*/
            $.fileFormat.applyButtonClickHandler($('#applyClose-profileFileFormat'));
        },

        /*Btn Action*/
        applyButtonClickHandler: function (e) {
            $(e).on('click', function () {
                $.fileFormat.applyallContactClick();
            });
        },
        resetButtonClickHandler: function (e) {
            $(e).on('click', function () {
                $.fileFormat.reset();
            });
        },
        /*End Btn Action*/
        /* Logic */
        reset: function (e) {
            $("#modalFileFormat").modal('show');

            $("#formModalFileFormat").trigger("reset");
            $("#formModalFileFormat").validate().resetForm();

            var stateFormat = userPreferFileFormatHtml == 'PDF';
            $('#contactaddress_Format').bootstrapSwitch('state', stateFormat);

        },
        applyallContactClick: function () {
            swal({
                title: $globalMessages.swal.warningTitle,
                text: $settingsResources.swal.applyToAllContactWarning,
                type: "warning",
                showConfirmButton: true,
                showCancelButton: true,
                closeOnConfirm: false
            }, function (isConfirmed) {
                if (isConfirmed) {
                    $.fileFormat.applyallContact();
                }
            });
        },
        applyallContact: function (e) {
            var fileType = "PDF";
            if ($('#contactaddress_Format').bootstrapSwitch('state') == false) {
                fileType = "TIF";
            }

            var grid = $("#grid").data("kendoGrid");
            var selectedItem = grid.select();

            for (i = 0; i < selectedItem.length; i++) {
                for (j = 0; j < grid.dataSource.data().length; j++) {
                    var gridSource = grid.dataSource.at(j);
                    if (gridSource.uid == selectedItem[i].dataset.uid) {
                        console.log("Yeahh");
                        switch (Number(gridSource.AddressTypeID)) {
                            case 1: /*email*/
                            case 3: /*http*/
                            case 4: /*ftp*/
                            case 5: /*file*/
                                console.log("Hoorah");
                                gridSource.CanonicalAddress = gridSource.CanonicalAddress.replace(gridSource.DdlFormat, fileType.toUpperCase());
                                gridSource.DdlFormat = fileType.toUpperCase();
                                break;
                        }
                    }
                }
            }
            swal.close();
            $.personalinfo.Save(1, "");

            $("#modalFileFormat").modal('hide');
        }
        /* End Logic */
    };
})(window.jQuery);